/*M!999999\- enable the sandbox mode */ 

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`),
  KEY `account_transactions_type_index` (`type`),
  KEY `account_transactions_sub_type_index` (`sub_type`),
  KEY `account_transactions_operation_date_index` (`operation_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `parent_account_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`),
  KEY `account_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_acc_trans_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_acc_trans_mappings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `ref_no` varchar(100) NOT NULL,
  `type` varchar(100) NOT NULL,
  `created_by` int(11) NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_acc_trans_mappings` WRITE;
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_account_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `account_primary_type` varchar(191) DEFAULT NULL,
  `account_type` varchar(191) DEFAULT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `show_balance` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=155 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_account_types` WRITE;
/*!40000 ALTER TABLE `accounting_account_types` DISABLE KEYS */;
INSERT INTO `accounting_account_types` VALUES
(1,'accounts_receivable',NULL,NULL,'asset','sub_type',NULL,NULL,0,NULL,NULL),
(2,'current_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),
(3,'cash_and_cash_equivalents',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),
(4,'fixed_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),
(5,'non_current_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),
(6,'accounts_payable',NULL,NULL,'liability','sub_type',NULL,NULL,0,NULL,NULL),
(7,'credit_card',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),
(8,'current_liabilities',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),
(9,'non_current_liabilities',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),
(10,'owners_equity',NULL,NULL,'equity','sub_type',NULL,NULL,1,NULL,NULL),
(11,'income',NULL,NULL,'income','sub_type',NULL,NULL,0,NULL,NULL),
(12,'other_income',NULL,NULL,'income','sub_type',NULL,NULL,0,NULL,NULL),
(13,'cost_of_sale',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),
(14,'expenses',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),
(15,'other_expense',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),
(16,'accounts_receivable',NULL,NULL,NULL,'detail_type',1,'',1,NULL,NULL),
(17,'allowance_for_bad_debts',NULL,NULL,NULL,'detail_type',2,'allowance_for_bad_debts_desc',1,NULL,NULL),
(18,'assets_available_for_sale',NULL,NULL,NULL,'detail_type',2,'assets_available_for_sale_desc',1,NULL,NULL),
(19,'development_costs',NULL,NULL,NULL,'detail_type',2,'development_costs_desc',1,NULL,NULL),
(20,'employee_cash_advances',NULL,NULL,NULL,'detail_type',2,'employee_cash_advances_desc',1,NULL,NULL),
(21,'inventory',NULL,NULL,NULL,'detail_type',2,'inventory_desc',1,NULL,NULL),
(22,'investments_-_other',NULL,NULL,NULL,'detail_type',2,'investments_-_other_desc',1,NULL,NULL),
(23,'loans_to_officers',NULL,NULL,NULL,'detail_type',2,'loans_to_officers_desc',1,NULL,NULL),
(24,'loans_to_others',NULL,NULL,NULL,'detail_type',2,'loans_to_others_desc',1,NULL,NULL),
(25,'loans_to_shareholders',NULL,NULL,NULL,'detail_type',2,'loans_to_shareholders_desc',1,NULL,NULL),
(26,'other_current_assets',NULL,NULL,NULL,'detail_type',2,'other_current_assets_desc',1,NULL,NULL),
(27,'prepaid_expenses',NULL,NULL,NULL,'detail_type',2,'prepaid_expenses_desc',1,NULL,NULL),
(28,'retainage',NULL,NULL,NULL,'detail_type',2,'retainage_desc',1,NULL,NULL),
(29,'undeposited_funds',NULL,NULL,NULL,'detail_type',2,'undeposited_funds_desc',1,NULL,NULL),
(30,'bank',NULL,NULL,NULL,'detail_type',3,'bank_desc',1,NULL,NULL),
(31,'cash_and_cash_equivalents',NULL,NULL,NULL,'detail_type',3,'cash_and_cash_equivalents_desc',1,NULL,NULL),
(32,'cash_on_hand',NULL,NULL,NULL,'detail_type',3,'cash_on_hand_desc',1,NULL,NULL),
(33,'client_trust_account',NULL,NULL,NULL,'detail_type',3,'client_trust_account_desc',1,NULL,NULL),
(34,'money_market',NULL,NULL,NULL,'detail_type',3,'money_market_desc',1,NULL,NULL),
(35,'rents_held_in_trust',NULL,NULL,NULL,'detail_type',3,'rents_held_in_trust_desc',1,NULL,NULL),
(36,'savings',NULL,NULL,NULL,'detail_type',3,'savings_desc',1,NULL,NULL),
(37,'accumulated_depletion',NULL,NULL,NULL,'detail_type',4,'accumulated_depletion_desc',1,NULL,NULL),
(38,'accumulated_depreciation_on_property,_plant_and_equipment',NULL,NULL,NULL,'detail_type',4,'accumulated_depreciation_on_property,_plant_and_equipment_desc',1,NULL,NULL),
(39,'buildings',NULL,NULL,NULL,'detail_type',4,'buildings_desc',1,NULL,NULL),
(40,'depletable_assets',NULL,NULL,NULL,'detail_type',4,'depletable_assets_desc',1,NULL,NULL),
(41,'furniture_and_fixtures',NULL,NULL,NULL,'detail_type',4,'furniture_and_fixtures_desc',1,NULL,NULL),
(42,'land',NULL,NULL,NULL,'detail_type',4,'land_desc',1,NULL,NULL),
(43,'leasehold_improvements',NULL,NULL,NULL,'detail_type',4,'leasehold_improvements_desc',1,NULL,NULL),
(44,'machinery_and_equipment',NULL,NULL,NULL,'detail_type',4,'machinery_and_equipment_desc',1,NULL,NULL),
(45,'other_fixed_assets',NULL,NULL,NULL,'detail_type',4,'other_fixed_assets_desc',1,NULL,NULL),
(46,'vehicles',NULL,NULL,NULL,'detail_type',4,'vehicles_desc',1,NULL,NULL),
(47,'accumulated_amortisation_of_non-current_assets',NULL,NULL,NULL,'detail_type',5,'accumulated_amortisation_of_non-current_assets_desc',1,NULL,NULL),
(48,'assets_held_for_sale',NULL,NULL,NULL,'detail_type',5,'assets_held_for_sale_desc',1,NULL,NULL),
(49,'deferred_tax',NULL,NULL,NULL,'detail_type',5,'deferred_tax_desc',1,NULL,NULL),
(50,'goodwill',NULL,NULL,NULL,'detail_type',5,'goodwill_desc',1,NULL,NULL),
(51,'intangible_assets',NULL,NULL,NULL,'detail_type',5,'intangible_assets_desc',1,NULL,NULL),
(52,'lease_buyout',NULL,NULL,NULL,'detail_type',5,'lease_buyout_desc',1,NULL,NULL),
(53,'licences',NULL,NULL,NULL,'detail_type',5,'licences_desc',1,NULL,NULL),
(54,'long-term_investments',NULL,NULL,NULL,'detail_type',5,'long-term_investments_desc',1,NULL,NULL),
(55,'organisational_costs',NULL,NULL,NULL,'detail_type',5,'organisational_costs_desc',1,NULL,NULL),
(56,'other_non-current_assets',NULL,NULL,NULL,'detail_type',5,'other_non-current_assets_desc',1,NULL,NULL),
(57,'security_deposits',NULL,NULL,NULL,'detail_type',5,'security_deposits_desc',1,NULL,NULL),
(58,'accounts_payable_(a/p)',NULL,NULL,NULL,'detail_type',6,'accounts_payable_(a/p)_desc',1,NULL,NULL),
(59,'credit_card',NULL,NULL,NULL,'detail_type',7,'credit_card_desc',1,NULL,NULL),
(60,'accrued_liabilities',NULL,NULL,NULL,'detail_type',8,'accrued_liabilities_desc',1,NULL,NULL),
(61,'client_trust_accounts_-_liabilities',NULL,NULL,NULL,'detail_type',8,'client_trust_accounts_-_liabilities_desc',1,NULL,NULL),
(62,'current_tax_liability',NULL,NULL,NULL,'detail_type',8,'current_tax_liability_desc',1,NULL,NULL),
(63,'current_portion_of_obligations_under_finance_leases',NULL,NULL,NULL,'detail_type',8,'current_portion_of_obligations_under_finance_leases_desc',1,NULL,NULL),
(64,'dividends_payable',NULL,NULL,NULL,'detail_type',8,'dividends_payable_desc',1,NULL,NULL),
(65,'income_tax_payable',NULL,NULL,NULL,'detail_type',8,'income_tax_payable_desc',1,NULL,NULL),
(66,'insurance_payable',NULL,NULL,NULL,'detail_type',8,'insurance_payable_desc',1,NULL,NULL),
(67,'line_of_credit',NULL,NULL,NULL,'detail_type',8,'line_of_credit_desc',1,NULL,NULL),
(68,'loan_payable',NULL,NULL,NULL,'detail_type',8,'loan_payable_desc',1,NULL,NULL),
(69,'other_current_liabilities',NULL,NULL,NULL,'detail_type',8,'other_current_liabilities_desc',1,NULL,NULL),
(70,'payroll_clearing',NULL,NULL,NULL,'detail_type',8,'payroll_clearing_desc',1,NULL,NULL),
(71,'payroll_liabilities',NULL,NULL,NULL,'detail_type',8,'payroll_liabilities_desc',1,NULL,NULL),
(72,'prepaid_expenses_payable',NULL,NULL,NULL,'detail_type',8,'prepaid_expenses_payable_desc',1,NULL,NULL),
(73,'rents_in_trust_-_liability',NULL,NULL,NULL,'detail_type',8,'rents_in_trust_-_liability_desc',1,NULL,NULL),
(74,'sales_and_service_tax_payable',NULL,NULL,NULL,'detail_type',8,'sales_and_service_tax_payable_desc',1,NULL,NULL),
(75,'accrued_holiday_payable',NULL,NULL,NULL,'detail_type',9,'accrued_holiday_payable_desc',1,NULL,NULL),
(76,'accrued_non-current_liabilities',NULL,NULL,NULL,'detail_type',9,'accrued_non-current_liabilities_desc',1,NULL,NULL),
(77,'liabilities_related_to_assets_held_for_sale',NULL,NULL,NULL,'detail_type',9,'liabilities_related_to_assets_held_for_sale_desc',1,NULL,NULL),
(78,'long-term_debt',NULL,NULL,NULL,'detail_type',9,'long-term_debt_desc',1,NULL,NULL),
(79,'notes_payable',NULL,NULL,NULL,'detail_type',9,'notes_payable_desc',1,NULL,NULL),
(80,'other_non-current_liabilities',NULL,NULL,NULL,'detail_type',9,'other_non-current_liabilities_desc',1,NULL,NULL),
(81,'shareholder_notes_payable',NULL,NULL,NULL,'detail_type',9,'shareholder_notes_payable_desc',1,NULL,NULL),
(82,'accumulated_adjustment',NULL,NULL,NULL,'detail_type',10,'accumulated_adjustment_desc',1,NULL,NULL),
(83,'dividend_disbursed',NULL,NULL,NULL,'detail_type',10,'dividend_disbursed_desc',1,NULL,NULL),
(84,'equity_in_earnings_of_subsidiaries',NULL,NULL,NULL,'detail_type',10,'equity_in_earnings_of_subsidiaries_desc',1,NULL,NULL),
(85,'opening_balance_equity',NULL,NULL,NULL,'detail_type',10,'opening_balance_equity_desc',1,NULL,NULL),
(86,'ordinary_shares',NULL,NULL,NULL,'detail_type',10,'ordinary_shares_desc',1,NULL,NULL),
(87,'other_comprehensive_income',NULL,NULL,NULL,'detail_type',10,'other_comprehensive_income_desc',1,NULL,NULL),
(88,'owner\'s_equity',NULL,NULL,NULL,'detail_type',10,'owner\'s_equity_desc',1,NULL,NULL),
(89,'paid-in_capital_or_surplus',NULL,NULL,NULL,'detail_type',10,'paid-in_capital_or_surplus_desc',1,NULL,NULL),
(90,'partner_contributions',NULL,NULL,NULL,'detail_type',10,'partner_contributions_desc',1,NULL,NULL),
(91,'partner_distributions',NULL,NULL,NULL,'detail_type',10,'partner_distributions_desc',1,NULL,NULL),
(92,'partner\'s_equity',NULL,NULL,NULL,'detail_type',10,'partner\'s_equity_desc',1,NULL,NULL),
(93,'preferred_shares',NULL,NULL,NULL,'detail_type',10,'preferred_shares_desc',1,NULL,NULL),
(94,'retained_earnings',NULL,NULL,NULL,'detail_type',10,'retained_earnings_desc',1,NULL,NULL),
(95,'share_capital',NULL,NULL,NULL,'detail_type',10,'share_capital_desc',1,NULL,NULL),
(96,'treasury_shares',NULL,NULL,NULL,'detail_type',10,'treasury_shares_desc',1,NULL,NULL),
(97,'discounts/refunds_given',NULL,NULL,NULL,'detail_type',11,'discounts/refunds_given_desc',1,NULL,NULL),
(98,'non-profit_income',NULL,NULL,NULL,'detail_type',11,'non-profit_income_desc',1,NULL,NULL),
(99,'other_primary_income',NULL,NULL,NULL,'detail_type',11,'other_primary_income_desc',1,NULL,NULL),
(100,'revenue_-_general',NULL,NULL,NULL,'detail_type',11,'revenue_-_general_desc',1,NULL,NULL),
(101,'sales_-_retail',NULL,NULL,NULL,'detail_type',11,'sales_-_retail_desc',1,NULL,NULL),
(102,'sales_-_wholesale',NULL,NULL,NULL,'detail_type',11,'sales_-_wholesale_desc',1,NULL,NULL),
(103,'sales_of_product_income',NULL,NULL,NULL,'detail_type',11,'sales_of_product_income_desc',1,NULL,NULL),
(104,'service/fee_income',NULL,NULL,NULL,'detail_type',11,'service/fee_income_desc',1,NULL,NULL),
(105,'unapplied_cash_payment_income',NULL,NULL,NULL,'detail_type',11,'unapplied_cash_payment_income_desc',1,NULL,NULL),
(106,'dividend_income',NULL,NULL,NULL,'detail_type',12,'dividend_income_desc',1,NULL,NULL),
(107,'interest_earned',NULL,NULL,NULL,'detail_type',12,'interest_earned_desc',1,NULL,NULL),
(108,'loss_on_disposal_of_assets',NULL,NULL,NULL,'detail_type',12,'loss_on_disposal_of_assets_desc',1,NULL,NULL),
(109,'other_investment_income',NULL,NULL,NULL,'detail_type',12,'other_investment_income_desc',1,NULL,NULL),
(110,'other_miscellaneous_income',NULL,NULL,NULL,'detail_type',12,'other_miscellaneous_income_desc',1,NULL,NULL),
(111,'other_operating_income',NULL,NULL,NULL,'detail_type',12,'other_operating_income_desc',1,NULL,NULL),
(112,'tax-exempt_interest',NULL,NULL,NULL,'detail_type',12,'tax-exempt_interest_desc',1,NULL,NULL),
(113,'unrealised_loss_on_securities,_net_of_tax',NULL,NULL,NULL,'detail_type',12,'unrealised_loss_on_securities,_net_of_tax_desc',1,NULL,NULL),
(114,'cost_of_labour_-_cos',NULL,NULL,NULL,'detail_type',13,'cost_of_labour_-_cos_desc',1,NULL,NULL),
(115,'equipment_rental_-_cos',NULL,NULL,NULL,'detail_type',13,'equipment_rental_-_cos_desc',1,NULL,NULL),
(116,'freight_and_delivery_-_cos',NULL,NULL,NULL,'detail_type',13,'freight_and_delivery_-_cos_desc',1,NULL,NULL),
(117,'other_costs_of_sales_-_cos',NULL,NULL,NULL,'detail_type',13,'other_costs_of_sales_-_cos_desc',1,NULL,NULL),
(118,'supplies_and_materials_-_cos',NULL,NULL,NULL,'detail_type',13,'supplies_and_materials_-_cos_desc',1,NULL,NULL),
(119,'advertising/promotional',NULL,NULL,NULL,'detail_type',14,'advertising/promotional_desc',1,NULL,NULL),
(120,'amortisation_expense',NULL,NULL,NULL,'detail_type',14,'amortisation_expense_desc',1,NULL,NULL),
(121,'auto',NULL,NULL,NULL,'detail_type',14,'auto_desc',1,NULL,NULL),
(122,'bad_debts',NULL,NULL,NULL,'detail_type',14,'bad_debts_desc',1,NULL,NULL),
(123,'bank_charges',NULL,NULL,NULL,'detail_type',14,'bank_charges_desc',1,NULL,NULL),
(124,'charitable_contributions',NULL,NULL,NULL,'detail_type',14,'charitable_contributions_desc',1,NULL,NULL),
(125,'commissions_and_fees',NULL,NULL,NULL,'detail_type',14,'commissions_and_fees_desc',1,NULL,NULL),
(126,'cost_of_labour',NULL,NULL,NULL,'detail_type',14,'cost_of_labour_desc',1,NULL,NULL),
(127,'dues_and_subscriptions',NULL,NULL,NULL,'detail_type',14,'dues_and_subscriptions_desc',1,NULL,NULL),
(128,'equipment_rental',NULL,NULL,NULL,'detail_type',14,'equipment_rental_desc',1,NULL,NULL),
(129,'finance_costs',NULL,NULL,NULL,'detail_type',14,'finance_costs_desc',1,NULL,NULL),
(130,'income_tax_expense',NULL,NULL,NULL,'detail_type',14,'income_tax_expense_desc',1,NULL,NULL),
(131,'insurance',NULL,NULL,NULL,'detail_type',14,'insurance_desc',1,NULL,NULL),
(132,'interest_paid',NULL,NULL,NULL,'detail_type',14,'interest_paid_desc',1,NULL,NULL),
(133,'legal_and_professional_fees',NULL,NULL,NULL,'detail_type',14,'legal_and_professional_fees_desc',1,NULL,NULL),
(134,'loss_on_discontinued_operations,_net_of_tax',NULL,NULL,NULL,'detail_type',14,'loss_on_discontinued_operations,_net_of_tax_desc',1,NULL,NULL),
(135,'management_compensation',NULL,NULL,NULL,'detail_type',14,'management_compensation_desc',1,NULL,NULL),
(136,'meals_and_entertainment',NULL,NULL,NULL,'detail_type',14,'meals_and_entertainment_desc',1,NULL,NULL),
(137,'office/general_administrative_expenses',NULL,NULL,NULL,'detail_type',14,'office/general_administrative_expenses_desc',1,NULL,NULL),
(138,'other_miscellaneous_service_cost',NULL,NULL,NULL,'detail_type',14,'other_miscellaneous_service_cost_desc',1,NULL,NULL),
(139,'other_selling_expenses',NULL,NULL,NULL,'detail_type',14,'other_selling_expenses_desc',1,NULL,NULL),
(140,'payroll_expenses',NULL,NULL,NULL,'detail_type',14,'payroll_expenses_desc',1,NULL,NULL),
(141,'rent_or_lease_of_buildings',NULL,NULL,NULL,'detail_type',14,'rent_or_lease_of_buildings_desc',1,NULL,NULL),
(142,'repair_and_maintenance',NULL,NULL,NULL,'detail_type',14,'repair_and_maintenance_desc',1,NULL,NULL),
(143,'shipping_and_delivery_expense',NULL,NULL,NULL,'detail_type',14,'shipping_and_delivery_expense_desc',1,NULL,NULL),
(144,'supplies_and_materials',NULL,NULL,NULL,'detail_type',14,'supplies_and_materials_desc',1,NULL,NULL),
(145,'taxes_paid',NULL,NULL,NULL,'detail_type',14,'taxes_paid_desc',1,NULL,NULL),
(146,'travel_expenses_-_general_and_admin_expenses',NULL,NULL,NULL,'detail_type',14,'travel_expenses_-_general_and_admin_expenses_desc',1,NULL,NULL),
(147,'travel_expenses_-_selling_expense',NULL,NULL,NULL,'detail_type',14,'travel_expenses_-_selling_expense_desc',1,NULL,NULL),
(148,'unapplied_cash_bill_payment_expense',NULL,NULL,NULL,'detail_type',14,'unapplied_cash_bill_payment_expense_desc',1,NULL,NULL),
(149,'utilities',NULL,NULL,NULL,'detail_type',14,'utilities_desc',1,NULL,NULL),
(150,'amortisation',NULL,NULL,NULL,'detail_type',15,'amortisation_desc',1,NULL,NULL),
(151,'depreciation',NULL,NULL,NULL,'detail_type',15,'depreciation_desc',1,NULL,NULL),
(152,'exchange_gain_or_loss',NULL,NULL,NULL,'detail_type',15,'exchange_gain_or_loss_desc',1,NULL,NULL),
(153,'other_expense',NULL,NULL,NULL,'detail_type',15,'other_expense_desc',1,NULL,NULL),
(154,'penalties_and_settlements',NULL,NULL,NULL,'detail_type',15,'penalties_and_settlements_desc',1,NULL,NULL);
/*!40000 ALTER TABLE `accounting_account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `gl_code` varchar(191) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `account_primary_type` varchar(191) DEFAULT NULL,
  `account_sub_type_id` bigint(20) DEFAULT NULL,
  `detail_type_id` bigint(20) DEFAULT NULL,
  `parent_account_id` bigint(20) DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=700 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts` WRITE;
/*!40000 ALTER TABLE `accounting_accounts` DISABLE KEYS */;
INSERT INTO `accounting_accounts` VALUES
(1,'Accounts Payable (A/P)',NULL,3,'liability',6,58,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(2,'Credit Card',NULL,3,'liability',7,59,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(3,'Wage expenses',NULL,3,'expenses',14,140,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(4,'Utilities',NULL,3,'expenses',14,149,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(5,'Unrealised loss on securities, net of tax',NULL,3,'income',12,113,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(6,'Undeposited Funds',NULL,3,'asset',2,29,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(7,'Uncategorised Income',NULL,3,'income',11,103,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(8,'Uncategorised Expense',NULL,3,'expenses',14,138,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(9,'Uncategorised Asset',NULL,3,'asset',2,26,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(10,'Unapplied Cash Payment Income',NULL,3,'income',11,105,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(11,'Travel expenses - selling expense',NULL,3,'expenses',14,147,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(12,'Travel expenses - general and admin expenses',NULL,3,'expenses',14,146,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(13,'Supplies',NULL,3,'expenses',14,145,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(14,'Subcontractors - COS',NULL,3,'expenses',13,114,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(15,'Stationery and printing',NULL,3,'expenses',14,137,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(16,'Short-term debit',NULL,3,'liability',8,69,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(17,'Shipping and delivery expense',NULL,3,'expenses',14,143,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(18,'Share capital',NULL,3,'equity',10,95,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(19,'Sales of Product Income',NULL,3,'income',11,103,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(20,'Sales - wholesale',NULL,3,'income',11,102,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(21,'Sales - retail',NULL,3,'income',11,101,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(22,'Sales',NULL,3,'income',11,103,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(23,'Revenue - General',NULL,3,'income',11,100,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(24,'Retained Earnings',NULL,3,'equity',10,94,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(25,'Repair and maintenance',NULL,3,'expenses',14,142,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(26,'Rent or lease payments',NULL,3,'expenses',14,141,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(27,'Reconciliation Discrepancies',NULL,3,'expenses',15,153,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(28,'Purchases',NULL,3,'expenses',14,144,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(29,'Property, plant and equipment',NULL,3,'asset',4,42,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(30,'Prepaid Expenses',NULL,3,'asset',2,27,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(31,'Payroll liabilities',NULL,3,'liability',8,71,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(32,'Payroll Expenses',NULL,3,'expenses',14,140,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(33,'Payroll Clearing',NULL,3,'liability',8,70,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(34,'Overhead - COS',NULL,3,'expenses',13,114,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(35,'Other Types of Expenses-Advertising Expenses',NULL,3,'expenses',14,119,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(36,'Other selling expenses',NULL,3,'expenses',14,139,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(37,'Other operating income (expenses)',NULL,3,'income',12,111,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(38,'Other general and administrative expenses',NULL,3,'expenses',14,137,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(39,'Other comprehensive income',NULL,3,'equity',10,87,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(40,'Other - COS',NULL,3,'expenses',13,114,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(41,'Office expenses',NULL,3,'expenses',14,137,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(42,'Meals and entertainment',NULL,3,'expenses',14,137,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(43,'Materials - COS',NULL,3,'expenses',13,114,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(44,'Management compensation',NULL,3,'expenses',14,135,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(45,'Loss on disposal of assets',NULL,3,'income',12,108,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(46,'Loss on discontinued operations, net of tax',NULL,3,'expenses',14,134,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(47,'Long-term investments',NULL,3,'asset',5,54,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(48,'Long-term debt',NULL,3,'liability',9,78,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(49,'Liabilities related to assets held for sale',NULL,3,'liability',9,77,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(50,'Legal and professional fees',NULL,3,'expenses',14,133,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(51,'Inventory Asset',NULL,3,'asset',2,21,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(52,'Inventory',NULL,3,'asset',2,21,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(53,'Interest income',NULL,3,'income',12,107,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(54,'Interest expense',NULL,3,'expenses',14,132,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(55,'Intangibles',NULL,3,'asset',5,51,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(56,'Insurance - Liability',NULL,3,'expenses',14,131,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(57,'Insurance - General',NULL,3,'expenses',14,131,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(58,'Insurance - Disability',NULL,3,'expenses',14,131,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(59,'Income tax payable',NULL,3,'liability',8,65,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(60,'Income tax expense',NULL,3,'expenses',14,130,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(61,'Goodwill',NULL,3,'asset',5,50,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(62,'Freight and delivery - COS',NULL,3,'expenses',13,114,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(63,'Equity in earnings of subsidiaries',NULL,3,'equity',10,84,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(64,'Equipment rental',NULL,3,'expenses',14,128,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(65,'Dues and Subscriptions',NULL,3,'expenses',14,127,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(66,'Dividends payable',NULL,3,'liability',8,64,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(67,'Dividend income',NULL,3,'income',12,106,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(68,'Dividend disbursed',NULL,3,'equity',10,83,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(69,'Discounts given - COS',NULL,3,'expenses',13,114,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(70,'Direct labour - COS',NULL,3,'expenses',13,114,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(71,'Deferred tax assets',NULL,3,'asset',5,49,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(72,'Cost of sales',NULL,3,'expenses',13,118,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(73,'Commissions and fees',NULL,3,'expenses',14,125,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(74,'Change in inventory - COS',NULL,3,'expenses',13,114,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(75,'Cash and cash equivalents',NULL,3,'asset',3,31,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(76,'Billable Expense Income',NULL,3,'income',11,103,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(77,'Bank charges',NULL,3,'expenses',14,123,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(78,'Bad debts',NULL,3,'expenses',14,122,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(79,'Available for sale assets (short-term)',NULL,3,'asset',2,18,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(80,'Assets held for sale',NULL,3,'asset',5,48,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(81,'Amortisation expense',NULL,3,'expenses',14,120,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(82,'Allowance for bad debts',NULL,3,'asset',2,17,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(83,'Accumulated depreciation on property, plant and equipment',NULL,3,'asset',4,38,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(84,'Accrued non-current liabilities',NULL,3,'liability',9,76,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(85,'Accrued liabilities',NULL,3,'liability',8,60,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(86,'Accrued holiday payable',NULL,3,'liability',9,75,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(87,'Accounts Receivable (A/R)',NULL,3,'asset',1,16,NULL,NULL,'active',3,'2024-08-24 16:23:32','2024-08-24 16:23:32'),
(88,'Accounts Payable (A/P)',NULL,2,'liability',6,58,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(89,'Credit Card',NULL,2,'liability',7,59,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(90,'Wage expenses',NULL,2,'expenses',14,140,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(91,'Utilities',NULL,2,'expenses',14,149,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(92,'Unrealised loss on securities, net of tax',NULL,2,'income',12,113,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(93,'Undeposited Funds',NULL,2,'asset',2,29,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(94,'Uncategorised Income',NULL,2,'income',11,103,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(95,'Uncategorised Expense',NULL,2,'expenses',14,138,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(96,'Uncategorised Asset',NULL,2,'asset',2,26,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(97,'Unapplied Cash Payment Income',NULL,2,'income',11,105,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(98,'Travel expenses - selling expense',NULL,2,'expenses',14,147,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(99,'Travel expenses - general and admin expenses',NULL,2,'expenses',14,146,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(100,'Supplies',NULL,2,'expenses',14,145,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(101,'Subcontractors - COS',NULL,2,'expenses',13,114,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(102,'Stationery and printing',NULL,2,'expenses',14,137,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(103,'Short-term debit',NULL,2,'liability',8,69,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(104,'Shipping and delivery expense',NULL,2,'expenses',14,143,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(105,'Share capital',NULL,2,'equity',10,95,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(106,'Sales of Product Income',NULL,2,'income',11,103,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(107,'Sales - wholesale',NULL,2,'income',11,102,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(108,'Sales - retail',NULL,2,'income',11,101,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(109,'Sales',NULL,2,'income',11,103,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(110,'Revenue - General',NULL,2,'income',11,100,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(111,'Retained Earnings',NULL,2,'equity',10,94,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(112,'Repair and maintenance',NULL,2,'expenses',14,142,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(113,'Rent or lease payments',NULL,2,'expenses',14,141,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(114,'Reconciliation Discrepancies',NULL,2,'expenses',15,153,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(115,'Purchases',NULL,2,'expenses',14,144,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(116,'Property, plant and equipment',NULL,2,'asset',4,42,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(117,'Prepaid Expenses',NULL,2,'asset',2,27,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(118,'Payroll liabilities',NULL,2,'liability',8,71,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(119,'Payroll Expenses',NULL,2,'expenses',14,140,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(120,'Payroll Clearing',NULL,2,'liability',8,70,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(121,'Overhead - COS',NULL,2,'expenses',13,114,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(122,'Other Types of Expenses-Advertising Expenses',NULL,2,'expenses',14,119,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(123,'Other selling expenses',NULL,2,'expenses',14,139,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(124,'Other operating income (expenses)',NULL,2,'income',12,111,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(125,'Other general and administrative expenses',NULL,2,'expenses',14,137,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(126,'Other comprehensive income',NULL,2,'equity',10,87,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(127,'Other - COS',NULL,2,'expenses',13,114,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(128,'Office expenses',NULL,2,'expenses',14,137,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(129,'Meals and entertainment',NULL,2,'expenses',14,137,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(130,'Materials - COS',NULL,2,'expenses',13,114,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(131,'Management compensation',NULL,2,'expenses',14,135,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(132,'Loss on disposal of assets',NULL,2,'income',12,108,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(133,'Loss on discontinued operations, net of tax',NULL,2,'expenses',14,134,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(134,'Long-term investments',NULL,2,'asset',5,54,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(135,'Long-term debt',NULL,2,'liability',9,78,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(136,'Liabilities related to assets held for sale',NULL,2,'liability',9,77,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(137,'Legal and professional fees',NULL,2,'expenses',14,133,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(138,'Inventory Asset',NULL,2,'asset',2,21,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(139,'Inventory',NULL,2,'asset',2,21,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(140,'Interest income',NULL,2,'income',12,107,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(141,'Interest expense',NULL,2,'expenses',14,132,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(142,'Intangibles',NULL,2,'asset',5,51,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(143,'Insurance - Liability',NULL,2,'expenses',14,131,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(144,'Insurance - General',NULL,2,'expenses',14,131,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(145,'Insurance - Disability',NULL,2,'expenses',14,131,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(146,'Income tax payable',NULL,2,'liability',8,65,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(147,'Income tax expense',NULL,2,'expenses',14,130,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(148,'Goodwill',NULL,2,'asset',5,50,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(149,'Freight and delivery - COS',NULL,2,'expenses',13,114,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(150,'Equity in earnings of subsidiaries',NULL,2,'equity',10,84,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(151,'Equipment rental',NULL,2,'expenses',14,128,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(152,'Dues and Subscriptions',NULL,2,'expenses',14,127,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(153,'Dividends payable',NULL,2,'liability',8,64,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(154,'Dividend income',NULL,2,'income',12,106,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(155,'Dividend disbursed',NULL,2,'equity',10,83,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(156,'Discounts given - COS',NULL,2,'expenses',13,114,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(157,'Direct labour - COS',NULL,2,'expenses',13,114,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(158,'Deferred tax assets',NULL,2,'asset',5,49,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(159,'Cost of sales',NULL,2,'expenses',13,118,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(160,'Commissions and fees',NULL,2,'expenses',14,125,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(161,'Change in inventory - COS',NULL,2,'expenses',13,114,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(162,'Cash and cash equivalents',NULL,2,'asset',3,31,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(163,'Billable Expense Income',NULL,2,'income',11,103,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(164,'Bank charges',NULL,2,'expenses',14,123,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(165,'Bad debts',NULL,2,'expenses',14,122,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(166,'Available for sale assets (short-term)',NULL,2,'asset',2,18,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(167,'Assets held for sale',NULL,2,'asset',5,48,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(168,'Amortisation expense',NULL,2,'expenses',14,120,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(169,'Allowance for bad debts',NULL,2,'asset',2,17,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(170,'Accumulated depreciation on property, plant and equipment',NULL,2,'asset',4,38,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(171,'Accrued non-current liabilities',NULL,2,'liability',9,76,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(172,'Accrued liabilities',NULL,2,'liability',8,60,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(173,'Accrued holiday payable',NULL,2,'liability',9,75,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(174,'Accounts Receivable (A/R)',NULL,2,'asset',1,16,NULL,NULL,'active',2,'2024-08-25 01:30:57','2024-08-25 01:30:57'),
(175,'Accounts Payable (A/P)',NULL,1,'liability',6,58,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(176,'Credit Card',NULL,1,'liability',7,59,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(177,'Wage expenses',NULL,1,'expenses',14,140,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(178,'Utilities',NULL,1,'expenses',14,149,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(179,'Unrealised loss on securities, net of tax',NULL,1,'income',12,113,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(180,'Undeposited Funds',NULL,1,'asset',2,29,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(181,'Uncategorised Income',NULL,1,'income',11,103,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(182,'Uncategorised Expense',NULL,1,'expenses',14,138,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(183,'Uncategorised Asset',NULL,1,'asset',2,26,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(184,'Unapplied Cash Payment Income',NULL,1,'income',11,105,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(185,'Travel expenses - selling expense',NULL,1,'expenses',14,147,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(186,'Travel expenses - general and admin expenses',NULL,1,'expenses',14,146,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(187,'Supplies',NULL,1,'expenses',14,145,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(188,'Subcontractors - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(189,'Stationery and printing',NULL,1,'expenses',14,137,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(190,'Short-term debit',NULL,1,'liability',8,69,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(191,'Shipping and delivery expense',NULL,1,'expenses',14,143,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(192,'Share capital',NULL,1,'equity',10,95,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(193,'Sales of Product Income',NULL,1,'income',11,103,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(194,'Sales - wholesale',NULL,1,'income',11,102,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(195,'Sales - retail',NULL,1,'income',11,101,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(196,'Sales',NULL,1,'income',11,103,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(197,'Revenue - General',NULL,1,'income',11,100,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(198,'Retained Earnings',NULL,1,'equity',10,94,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(199,'Repair and maintenance',NULL,1,'expenses',14,142,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(200,'Rent or lease payments',NULL,1,'expenses',14,141,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(201,'Reconciliation Discrepancies',NULL,1,'expenses',15,153,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(202,'Purchases',NULL,1,'expenses',14,144,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(203,'Property, plant and equipment',NULL,1,'asset',4,42,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(204,'Prepaid Expenses',NULL,1,'asset',2,27,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(205,'Payroll liabilities',NULL,1,'liability',8,71,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(206,'Payroll Expenses',NULL,1,'expenses',14,140,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(207,'Payroll Clearing',NULL,1,'liability',8,70,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(208,'Overhead - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(209,'Other Types of Expenses-Advertising Expenses',NULL,1,'expenses',14,119,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(210,'Other selling expenses',NULL,1,'expenses',14,139,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(211,'Other operating income (expenses)',NULL,1,'income',12,111,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(212,'Other general and administrative expenses',NULL,1,'expenses',14,137,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(213,'Other comprehensive income',NULL,1,'equity',10,87,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(214,'Other - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(215,'Office expenses',NULL,1,'expenses',14,137,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(216,'Meals and entertainment',NULL,1,'expenses',14,137,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(217,'Materials - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(218,'Management compensation',NULL,1,'expenses',14,135,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(219,'Loss on disposal of assets',NULL,1,'income',12,108,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(220,'Loss on discontinued operations, net of tax',NULL,1,'expenses',14,134,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(221,'Long-term investments',NULL,1,'asset',5,54,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(222,'Long-term debt',NULL,1,'liability',9,78,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(223,'Liabilities related to assets held for sale',NULL,1,'liability',9,77,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(224,'Legal and professional fees',NULL,1,'expenses',14,133,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(225,'Inventory Asset',NULL,1,'asset',2,21,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(226,'Inventory',NULL,1,'asset',2,21,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(227,'Interest income',NULL,1,'income',12,107,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(228,'Interest expense',NULL,1,'expenses',14,132,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(229,'Intangibles',NULL,1,'asset',5,51,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(230,'Insurance - Liability',NULL,1,'expenses',14,131,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(231,'Insurance - General',NULL,1,'expenses',14,131,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(232,'Insurance - Disability',NULL,1,'expenses',14,131,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(233,'Income tax payable',NULL,1,'liability',8,65,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(234,'Income tax expense',NULL,1,'expenses',14,130,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(235,'Goodwill',NULL,1,'asset',5,50,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(236,'Freight and delivery - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(237,'Equity in earnings of subsidiaries',NULL,1,'equity',10,84,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(238,'Equipment rental',NULL,1,'expenses',14,128,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(239,'Dues and Subscriptions',NULL,1,'expenses',14,127,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(240,'Dividends payable',NULL,1,'liability',8,64,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(241,'Dividend income',NULL,1,'income',12,106,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(242,'Dividend disbursed',NULL,1,'equity',10,83,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(243,'Discounts given - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(244,'Direct labour - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(245,'Deferred tax assets',NULL,1,'asset',5,49,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(246,'Cost of sales',NULL,1,'expenses',13,118,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(247,'Commissions and fees',NULL,1,'expenses',14,125,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(248,'Change in inventory - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(249,'Cash and cash equivalents',NULL,1,'asset',3,31,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(250,'Billable Expense Income',NULL,1,'income',11,103,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(251,'Bank charges',NULL,1,'expenses',14,123,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(252,'Bad debts',NULL,1,'expenses',14,122,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(253,'Available for sale assets (short-term)',NULL,1,'asset',2,18,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(254,'Assets held for sale',NULL,1,'asset',5,48,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(255,'Amortisation expense',NULL,1,'expenses',14,120,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(256,'Allowance for bad debts',NULL,1,'asset',2,17,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(257,'Accumulated depreciation on property, plant and equipment',NULL,1,'asset',4,38,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(258,'Accrued non-current liabilities',NULL,1,'liability',9,76,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(259,'Accrued liabilities',NULL,1,'liability',8,60,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(260,'Accrued holiday payable',NULL,1,'liability',9,75,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(261,'Accounts Receivable (A/R)',NULL,1,'asset',1,16,NULL,NULL,'active',1,'2025-02-04 03:28:44','2025-02-04 03:28:44'),
(262,'Accounts Payable (A/P)',NULL,11,'liability',6,58,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(263,'Credit Card',NULL,11,'liability',7,59,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(264,'Wage expenses',NULL,11,'expenses',14,140,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(265,'Utilities',NULL,11,'expenses',14,149,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(266,'Unrealised loss on securities, net of tax',NULL,11,'income',12,113,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(267,'Undeposited Funds',NULL,11,'asset',2,29,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(268,'Uncategorised Income',NULL,11,'income',11,103,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(269,'Uncategorised Expense',NULL,11,'expenses',14,138,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(270,'Uncategorised Asset',NULL,11,'asset',2,26,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(271,'Unapplied Cash Payment Income',NULL,11,'income',11,105,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(272,'Travel expenses - selling expense',NULL,11,'expenses',14,147,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(273,'Travel expenses - general and admin expenses',NULL,11,'expenses',14,146,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(274,'Supplies',NULL,11,'expenses',14,145,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(275,'Subcontractors - COS',NULL,11,'expenses',13,114,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(276,'Stationery and printing',NULL,11,'expenses',14,137,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(277,'Short-term debit',NULL,11,'liability',8,69,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(278,'Shipping and delivery expense',NULL,11,'expenses',14,143,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(279,'Share capital',NULL,11,'equity',10,95,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(280,'Sales of Product Income',NULL,11,'income',11,103,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(281,'Sales - wholesale',NULL,11,'income',11,102,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(282,'Sales - retail',NULL,11,'income',11,101,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(283,'Sales',NULL,11,'income',11,103,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(284,'Revenue - General',NULL,11,'income',11,100,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(285,'Retained Earnings',NULL,11,'equity',10,94,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(286,'Repair and maintenance',NULL,11,'expenses',14,142,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(287,'Rent or lease payments',NULL,11,'expenses',14,141,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(288,'Reconciliation Discrepancies',NULL,11,'expenses',15,153,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(289,'Purchases',NULL,11,'expenses',14,144,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(290,'Property, plant and equipment',NULL,11,'asset',4,42,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(291,'Prepaid Expenses',NULL,11,'asset',2,27,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(292,'Payroll liabilities',NULL,11,'liability',8,71,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(293,'Payroll Expenses',NULL,11,'expenses',14,140,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(294,'Payroll Clearing',NULL,11,'liability',8,70,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(295,'Overhead - COS',NULL,11,'expenses',13,114,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(296,'Other Types of Expenses-Advertising Expenses',NULL,11,'expenses',14,119,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(297,'Other selling expenses',NULL,11,'expenses',14,139,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(298,'Other operating income (expenses)',NULL,11,'income',12,111,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(299,'Other general and administrative expenses',NULL,11,'expenses',14,137,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(300,'Other comprehensive income',NULL,11,'equity',10,87,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(301,'Other - COS',NULL,11,'expenses',13,114,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(302,'Office expenses',NULL,11,'expenses',14,137,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(303,'Meals and entertainment',NULL,11,'expenses',14,137,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(304,'Materials - COS',NULL,11,'expenses',13,114,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(305,'Management compensation',NULL,11,'expenses',14,135,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(306,'Loss on disposal of assets',NULL,11,'income',12,108,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(307,'Loss on discontinued operations, net of tax',NULL,11,'expenses',14,134,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(308,'Long-term investments',NULL,11,'asset',5,54,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(309,'Long-term debt',NULL,11,'liability',9,78,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(310,'Liabilities related to assets held for sale',NULL,11,'liability',9,77,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(311,'Legal and professional fees',NULL,11,'expenses',14,133,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(312,'Inventory Asset',NULL,11,'asset',2,21,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(313,'Inventory',NULL,11,'asset',2,21,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(314,'Interest income',NULL,11,'income',12,107,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(315,'Interest expense',NULL,11,'expenses',14,132,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(316,'Intangibles',NULL,11,'asset',5,51,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(317,'Insurance - Liability',NULL,11,'expenses',14,131,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(318,'Insurance - General',NULL,11,'expenses',14,131,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(319,'Insurance - Disability',NULL,11,'expenses',14,131,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(320,'Income tax payable',NULL,11,'liability',8,65,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(321,'Income tax expense',NULL,11,'expenses',14,130,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(322,'Goodwill',NULL,11,'asset',5,50,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(323,'Freight and delivery - COS',NULL,11,'expenses',13,114,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(324,'Equity in earnings of subsidiaries',NULL,11,'equity',10,84,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(325,'Equipment rental',NULL,11,'expenses',14,128,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(326,'Dues and Subscriptions',NULL,11,'expenses',14,127,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(327,'Dividends payable',NULL,11,'liability',8,64,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(328,'Dividend income',NULL,11,'income',12,106,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(329,'Dividend disbursed',NULL,11,'equity',10,83,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(330,'Discounts given - COS',NULL,11,'expenses',13,114,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(331,'Direct labour - COS',NULL,11,'expenses',13,114,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(332,'Deferred tax assets',NULL,11,'asset',5,49,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(333,'Cost of sales',NULL,11,'expenses',13,118,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(334,'Commissions and fees',NULL,11,'expenses',14,125,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(335,'Change in inventory - COS',NULL,11,'expenses',13,114,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(336,'Cash and cash equivalents',NULL,11,'asset',3,31,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(337,'Billable Expense Income',NULL,11,'income',11,103,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(338,'Bank charges',NULL,11,'expenses',14,123,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(339,'Bad debts',NULL,11,'expenses',14,122,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(340,'Available for sale assets (short-term)',NULL,11,'asset',2,18,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(341,'Assets held for sale',NULL,11,'asset',5,48,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(342,'Amortisation expense',NULL,11,'expenses',14,120,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(343,'Allowance for bad debts',NULL,11,'asset',2,17,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(344,'Accumulated depreciation on property, plant and equipment',NULL,11,'asset',4,38,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(345,'Accrued non-current liabilities',NULL,11,'liability',9,76,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(346,'Accrued liabilities',NULL,11,'liability',8,60,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(347,'Accrued holiday payable',NULL,11,'liability',9,75,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(348,'Accounts Receivable (A/R)',NULL,11,'asset',1,16,NULL,NULL,'active',22,'2025-06-22 21:55:13','2025-06-22 21:55:13'),
(349,'Accounts Payable (A/P)',NULL,16,'liability',6,58,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(350,'Credit Card',NULL,16,'liability',7,59,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(351,'Wage expenses',NULL,16,'expenses',14,140,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(352,'Utilities',NULL,16,'expenses',14,149,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(353,'Unrealised loss on securities, net of tax',NULL,16,'income',12,113,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(354,'Undeposited Funds',NULL,16,'asset',2,29,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(355,'Uncategorised Income',NULL,16,'income',11,103,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(356,'Uncategorised Expense',NULL,16,'expenses',14,138,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(357,'Uncategorised Asset',NULL,16,'asset',2,26,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(358,'Unapplied Cash Payment Income',NULL,16,'income',11,105,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(359,'Travel expenses - selling expense',NULL,16,'expenses',14,147,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(360,'Travel expenses - general and admin expenses',NULL,16,'expenses',14,146,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(361,'Supplies',NULL,16,'expenses',14,145,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(362,'Subcontractors - COS',NULL,16,'expenses',13,114,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(363,'Stationery and printing',NULL,16,'expenses',14,137,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(364,'Short-term debit',NULL,16,'liability',8,69,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(365,'Shipping and delivery expense',NULL,16,'expenses',14,143,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(366,'Share capital',NULL,16,'equity',10,95,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(367,'Sales of Product Income',NULL,16,'income',11,103,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(368,'Sales - wholesale',NULL,16,'income',11,102,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(369,'Sales - retail',NULL,16,'income',11,101,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(370,'Sales',NULL,16,'income',11,103,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(371,'Revenue - General',NULL,16,'income',11,100,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(372,'Retained Earnings',NULL,16,'equity',10,94,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(373,'Repair and maintenance',NULL,16,'expenses',14,142,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(374,'Rent or lease payments',NULL,16,'expenses',14,141,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(375,'Reconciliation Discrepancies',NULL,16,'expenses',15,153,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(376,'Purchases',NULL,16,'expenses',14,144,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(377,'Property, plant and equipment',NULL,16,'asset',4,42,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(378,'Prepaid Expenses',NULL,16,'asset',2,27,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(379,'Payroll liabilities',NULL,16,'liability',8,71,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(380,'Payroll Expenses',NULL,16,'expenses',14,140,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(381,'Payroll Clearing',NULL,16,'liability',8,70,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(382,'Overhead - COS',NULL,16,'expenses',13,114,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(383,'Other Types of Expenses-Advertising Expenses',NULL,16,'expenses',14,119,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(384,'Other selling expenses',NULL,16,'expenses',14,139,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(385,'Other operating income (expenses)',NULL,16,'income',12,111,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(386,'Other general and administrative expenses',NULL,16,'expenses',14,137,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(387,'Other comprehensive income',NULL,16,'equity',10,87,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(388,'Other - COS',NULL,16,'expenses',13,114,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(389,'Office expenses',NULL,16,'expenses',14,137,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(390,'Meals and entertainment',NULL,16,'expenses',14,137,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(391,'Materials - COS',NULL,16,'expenses',13,114,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(392,'Management compensation',NULL,16,'expenses',14,135,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(393,'Loss on disposal of assets',NULL,16,'income',12,108,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(394,'Loss on discontinued operations, net of tax',NULL,16,'expenses',14,134,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(395,'Long-term investments',NULL,16,'asset',5,54,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(396,'Long-term debt',NULL,16,'liability',9,78,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(397,'Liabilities related to assets held for sale',NULL,16,'liability',9,77,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(398,'Legal and professional fees',NULL,16,'expenses',14,133,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(399,'Inventory Asset',NULL,16,'asset',2,21,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(400,'Inventory',NULL,16,'asset',2,21,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(401,'Interest income',NULL,16,'income',12,107,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(402,'Interest expense',NULL,16,'expenses',14,132,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(403,'Intangibles',NULL,16,'asset',5,51,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(404,'Insurance - Liability',NULL,16,'expenses',14,131,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(405,'Insurance - General',NULL,16,'expenses',14,131,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(406,'Insurance - Disability',NULL,16,'expenses',14,131,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(407,'Income tax payable',NULL,16,'liability',8,65,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(408,'Income tax expense',NULL,16,'expenses',14,130,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(409,'Goodwill',NULL,16,'asset',5,50,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(410,'Freight and delivery - COS',NULL,16,'expenses',13,114,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(411,'Equity in earnings of subsidiaries',NULL,16,'equity',10,84,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(412,'Equipment rental',NULL,16,'expenses',14,128,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(413,'Dues and Subscriptions',NULL,16,'expenses',14,127,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(414,'Dividends payable',NULL,16,'liability',8,64,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(415,'Dividend income',NULL,16,'income',12,106,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(416,'Dividend disbursed',NULL,16,'equity',10,83,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(417,'Discounts given - COS',NULL,16,'expenses',13,114,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(418,'Direct labour - COS',NULL,16,'expenses',13,114,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(419,'Deferred tax assets',NULL,16,'asset',5,49,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(420,'Cost of sales',NULL,16,'expenses',13,118,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(421,'Commissions and fees',NULL,16,'expenses',14,125,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(422,'Change in inventory - COS',NULL,16,'expenses',13,114,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(423,'Cash and cash equivalents',NULL,16,'asset',3,31,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(424,'Billable Expense Income',NULL,16,'income',11,103,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(425,'Bank charges',NULL,16,'expenses',14,123,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(426,'Bad debts',NULL,16,'expenses',14,122,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(427,'Available for sale assets (short-term)',NULL,16,'asset',2,18,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(428,'Assets held for sale',NULL,16,'asset',5,48,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(429,'Amortisation expense',NULL,16,'expenses',14,120,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(430,'Allowance for bad debts',NULL,16,'asset',2,17,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(431,'Accumulated depreciation on property, plant and equipment',NULL,16,'asset',4,38,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(432,'Accrued non-current liabilities',NULL,16,'liability',9,76,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(433,'Accrued liabilities',NULL,16,'liability',8,60,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(434,'Accrued holiday payable',NULL,16,'liability',9,75,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(435,'Accounts Receivable (A/R)',NULL,16,'asset',1,16,NULL,NULL,'active',34,'2025-07-13 17:07:57','2025-07-13 17:07:57'),
(523,'Accounts Payable (A/P)',NULL,13,'liability',6,58,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(524,'Credit Card',NULL,13,'liability',7,59,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(525,'Wage expenses',NULL,13,'expenses',14,140,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(526,'Utilities',NULL,13,'expenses',14,149,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(527,'Unrealised loss on securities, net of tax',NULL,13,'income',12,113,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(528,'Undeposited Funds',NULL,13,'asset',2,29,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(529,'Uncategorised Income',NULL,13,'income',11,103,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(530,'Uncategorised Expense',NULL,13,'expenses',14,138,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(531,'Uncategorised Asset',NULL,13,'asset',2,26,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(532,'Unapplied Cash Payment Income',NULL,13,'income',11,105,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(533,'Travel expenses - selling expense',NULL,13,'expenses',14,147,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(534,'Travel expenses - general and admin expenses',NULL,13,'expenses',14,146,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(535,'Supplies',NULL,13,'expenses',14,145,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(536,'Subcontractors - COS',NULL,13,'expenses',13,114,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(537,'Stationery and printing',NULL,13,'expenses',14,137,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(538,'Short-term debit',NULL,13,'liability',8,69,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(539,'Shipping and delivery expense',NULL,13,'expenses',14,143,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(540,'Share capital',NULL,13,'equity',10,95,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(541,'Sales of Product Income',NULL,13,'income',11,103,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(542,'Sales - wholesale',NULL,13,'income',11,102,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(543,'Sales - retail',NULL,13,'income',11,101,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(544,'Sales',NULL,13,'income',11,103,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(545,'Revenue - General',NULL,13,'income',11,100,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(546,'Retained Earnings',NULL,13,'equity',10,94,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(547,'Repair and maintenance',NULL,13,'expenses',14,142,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(548,'Rent or lease payments',NULL,13,'expenses',14,141,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(549,'Reconciliation Discrepancies',NULL,13,'expenses',15,153,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(550,'Purchases',NULL,13,'expenses',14,144,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(551,'Property, plant and equipment',NULL,13,'asset',4,42,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(552,'Prepaid Expenses',NULL,13,'asset',2,27,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(553,'Payroll liabilities',NULL,13,'liability',8,71,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(554,'Payroll Expenses',NULL,13,'expenses',14,140,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(555,'Payroll Clearing',NULL,13,'liability',8,70,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(556,'Overhead - COS',NULL,13,'expenses',13,114,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(557,'Other Types of Expenses-Advertising Expenses',NULL,13,'expenses',14,119,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(558,'Other selling expenses',NULL,13,'expenses',14,139,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(559,'Other operating income (expenses)',NULL,13,'income',12,111,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(560,'Other general and administrative expenses',NULL,13,'expenses',14,137,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(561,'Other comprehensive income',NULL,13,'equity',10,87,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(562,'Other - COS',NULL,13,'expenses',13,114,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(563,'Office expenses',NULL,13,'expenses',14,137,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(564,'Meals and entertainment',NULL,13,'expenses',14,137,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(565,'Materials - COS',NULL,13,'expenses',13,114,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(566,'Management compensation',NULL,13,'expenses',14,135,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(567,'Loss on disposal of assets',NULL,13,'income',12,108,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(568,'Loss on discontinued operations, net of tax',NULL,13,'expenses',14,134,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(569,'Long-term investments',NULL,13,'asset',5,54,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(570,'Long-term debt',NULL,13,'liability',9,78,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(571,'Liabilities related to assets held for sale',NULL,13,'liability',9,77,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(572,'Legal and professional fees',NULL,13,'expenses',14,133,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(573,'Inventory Asset',NULL,13,'asset',2,21,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(574,'Inventory',NULL,13,'asset',2,21,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(575,'Interest income',NULL,13,'income',12,107,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(576,'Interest expense',NULL,13,'expenses',14,132,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(577,'Intangibles',NULL,13,'asset',5,51,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(578,'Insurance - Liability',NULL,13,'expenses',14,131,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(579,'Insurance - General',NULL,13,'expenses',14,131,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(580,'Insurance - Disability',NULL,13,'expenses',14,131,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(581,'Income tax payable',NULL,13,'liability',8,65,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(582,'Income tax expense',NULL,13,'expenses',14,130,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(583,'Goodwill',NULL,13,'asset',5,50,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(584,'Freight and delivery - COS',NULL,13,'expenses',13,114,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(585,'Equity in earnings of subsidiaries',NULL,13,'equity',10,84,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(586,'Equipment rental',NULL,13,'expenses',14,128,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(587,'Dues and Subscriptions',NULL,13,'expenses',14,127,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(588,'Dividends payable',NULL,13,'liability',8,64,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(589,'Dividend income',NULL,13,'income',12,106,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(590,'Dividend disbursed',NULL,13,'equity',10,83,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(591,'Discounts given - COS',NULL,13,'expenses',13,114,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(592,'Direct labour - COS',NULL,13,'expenses',13,114,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(593,'Deferred tax assets',NULL,13,'asset',5,49,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(594,'Cost of sales',NULL,13,'expenses',13,118,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(595,'Commissions and fees',NULL,13,'expenses',14,125,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(596,'Change in inventory - COS',NULL,13,'expenses',13,114,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(597,'Cash and cash equivalents',NULL,13,'asset',3,31,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(598,'Billable Expense Income',NULL,13,'income',11,103,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(599,'Bank charges',NULL,13,'expenses',14,123,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(600,'Bad debts',NULL,13,'expenses',14,122,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(601,'Available for sale assets (short-term)',NULL,13,'asset',2,18,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(602,'Assets held for sale',NULL,13,'asset',5,48,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(603,'Amortisation expense',NULL,13,'expenses',14,120,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(604,'Allowance for bad debts',NULL,13,'asset',2,17,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(605,'Accumulated depreciation on property, plant and equipment',NULL,13,'asset',4,38,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(606,'Accrued non-current liabilities',NULL,13,'liability',9,76,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(607,'Accrued liabilities',NULL,13,'liability',8,60,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(608,'Accrued holiday payable',NULL,13,'liability',9,75,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(609,'Accounts Receivable (A/R)',NULL,13,'asset',1,16,NULL,NULL,'active',29,'2025-07-20 12:12:56','2025-07-20 12:12:56'),
(610,'Accounts Payable (A/P)',NULL,8,'liability',6,58,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(611,'Credit Card',NULL,8,'liability',7,59,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(612,'Wage expenses',NULL,8,'expenses',14,140,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(613,'Utilities',NULL,8,'expenses',14,149,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(614,'Unrealised loss on securities, net of tax',NULL,8,'income',12,113,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(615,'Undeposited Funds',NULL,8,'asset',2,29,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(616,'Uncategorised Income',NULL,8,'income',11,103,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(617,'Uncategorised Expense',NULL,8,'expenses',14,138,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(618,'Uncategorised Asset',NULL,8,'asset',2,26,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(619,'Unapplied Cash Payment Income',NULL,8,'income',11,105,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(620,'Travel expenses - selling expense',NULL,8,'expenses',14,147,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(621,'Travel expenses - general and admin expenses',NULL,8,'expenses',14,146,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(622,'Supplies',NULL,8,'expenses',14,145,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(623,'Subcontractors - COS',NULL,8,'expenses',13,114,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(624,'Stationery and printing',NULL,8,'expenses',14,137,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(625,'Short-term debit',NULL,8,'liability',8,69,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(626,'Shipping and delivery expense',NULL,8,'expenses',14,143,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(627,'Share capital',NULL,8,'equity',10,95,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(628,'Sales of Product Income',NULL,8,'income',11,103,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(629,'Sales - wholesale',NULL,8,'income',11,102,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(630,'Sales - retail',NULL,8,'income',11,101,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(631,'Sales',NULL,8,'income',11,103,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(632,'Revenue - General',NULL,8,'income',11,100,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(633,'Retained Earnings',NULL,8,'equity',10,94,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(634,'Repair and maintenance',NULL,8,'expenses',14,142,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(635,'Rent or lease payments',NULL,8,'expenses',14,141,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(636,'Reconciliation Discrepancies',NULL,8,'expenses',15,153,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(637,'Purchases',NULL,8,'expenses',14,144,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(638,'Property, plant and equipment',NULL,8,'asset',4,42,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(639,'Prepaid Expenses',NULL,8,'asset',2,27,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(640,'Payroll liabilities',NULL,8,'liability',8,71,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(641,'Payroll Expenses',NULL,8,'expenses',14,140,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(642,'Payroll Clearing',NULL,8,'liability',8,70,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(643,'Overhead - COS',NULL,8,'expenses',13,114,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(644,'Other Types of Expenses-Advertising Expenses',NULL,8,'expenses',14,119,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(645,'Other selling expenses',NULL,8,'expenses',14,139,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(646,'Other operating income (expenses)',NULL,8,'income',12,111,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(647,'Other general and administrative expenses',NULL,8,'expenses',14,137,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(648,'Other comprehensive income',NULL,8,'equity',10,87,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(649,'Other - COS',NULL,8,'expenses',13,114,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(650,'Office expenses',NULL,8,'expenses',14,137,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(651,'Meals and entertainment',NULL,8,'expenses',14,137,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(652,'Materials - COS',NULL,8,'expenses',13,114,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(653,'Management compensation',NULL,8,'expenses',14,135,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(654,'Loss on disposal of assets',NULL,8,'income',12,108,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(655,'Loss on discontinued operations, net of tax',NULL,8,'expenses',14,134,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(656,'Long-term investments',NULL,8,'asset',5,54,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(657,'Long-term debt',NULL,8,'liability',9,78,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(658,'Liabilities related to assets held for sale',NULL,8,'liability',9,77,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(659,'Legal and professional fees',NULL,8,'expenses',14,133,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(660,'Inventory Asset',NULL,8,'asset',2,21,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(661,'Inventory',NULL,8,'asset',2,21,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(662,'Interest income',NULL,8,'income',12,107,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(663,'Interest expense',NULL,8,'expenses',14,132,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(664,'Intangibles',NULL,8,'asset',5,51,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(665,'Insurance - Liability',NULL,8,'expenses',14,131,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(666,'Insurance - General',NULL,8,'expenses',14,131,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(667,'Insurance - Disability',NULL,8,'expenses',14,131,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(668,'Income tax payable',NULL,8,'liability',8,65,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(669,'Income tax expense',NULL,8,'expenses',14,130,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(670,'Goodwill',NULL,8,'asset',5,50,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(671,'Freight and delivery - COS',NULL,8,'expenses',13,114,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(672,'Equity in earnings of subsidiaries',NULL,8,'equity',10,84,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(673,'Equipment rental',NULL,8,'expenses',14,128,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(674,'Dues and Subscriptions',NULL,8,'expenses',14,127,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(675,'Dividends payable',NULL,8,'liability',8,64,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(676,'Dividend income',NULL,8,'income',12,106,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(677,'Dividend disbursed',NULL,8,'equity',10,83,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(678,'Discounts given - COS',NULL,8,'expenses',13,114,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(679,'Direct labour - COS',NULL,8,'expenses',13,114,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(680,'Deferred tax assets',NULL,8,'asset',5,49,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(681,'Cost of sales',NULL,8,'expenses',13,118,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(682,'Commissions and fees',NULL,8,'expenses',14,125,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(683,'Change in inventory - COS',NULL,8,'expenses',13,114,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(684,'Cash and cash equivalents',NULL,8,'asset',3,31,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(685,'Billable Expense Income',NULL,8,'income',11,103,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(686,'Bank charges',NULL,8,'expenses',14,123,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(687,'Bad debts',NULL,8,'expenses',14,122,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(688,'Available for sale assets (short-term)',NULL,8,'asset',2,18,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(689,'Assets held for sale',NULL,8,'asset',5,48,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(690,'Amortisation expense',NULL,8,'expenses',14,120,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(691,'Allowance for bad debts',NULL,8,'asset',2,17,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(692,'Accumulated depreciation on property, plant and equipment',NULL,8,'asset',4,38,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(693,'Accrued non-current liabilities',NULL,8,'liability',9,76,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(694,'Accrued liabilities',NULL,8,'liability',8,60,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(695,'Accrued holiday payable',NULL,8,'liability',9,75,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(696,'Accounts Receivable (A/R)',NULL,8,'asset',1,16,NULL,NULL,'active',35,'2025-07-21 12:55:30','2025-07-21 12:55:30'),
(697,'cash on hand',NULL,8,'asset',3,32,684,NULL,'active',35,'2025-07-21 13:05:43','2025-07-21 13:05:43'),
(698,'BANK',NULL,8,'asset',3,30,NULL,NULL,'active',35,'2025-07-21 13:10:11','2025-07-21 13:10:41'),
(699,'QNB',NULL,8,'asset',3,30,698,NULL,'active',35,'2025-07-21 13:11:35','2025-07-21 13:11:35');
/*!40000 ALTER TABLE `accounting_accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_accounts_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint(20) unsigned NOT NULL,
  `acc_trans_mapping_id` int(11) DEFAULT NULL COMMENT 'id form accounting_acc_trans_mapping table',
  `transaction_id` int(11) DEFAULT NULL COMMENT 'id form transactions table',
  `transaction_payment_id` int(11) DEFAULT NULL COMMENT 'id form transaction_payments table',
  `amount` decimal(22,4) NOT NULL,
  `type` varchar(100) NOT NULL COMMENT 'debit, credit etc',
  `sub_type` varchar(100) NOT NULL,
  `map_type` varchar(100) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounting_accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounting_accounts_transactions` VALUES
(1,19,NULL,8,NULL,7200.0000,'credit','sell','payment_account',3,'2024-08-24 19:51:38',NULL,'2024-08-25 00:47:13','2024-08-25 00:51:38'),
(2,75,NULL,8,NULL,7200.0000,'debit','sell','deposit_to',3,'2024-08-24 19:51:38',NULL,'2024-08-25 00:47:13','2024-08-25 00:51:38'),
(3,1,NULL,5,NULL,6000.0000,'credit','sell','payment_account',3,'2024-08-24 19:47:30',NULL,'2024-08-25 00:47:30','2024-08-25 00:47:30'),
(4,75,NULL,5,NULL,6000.0000,'debit','sell','deposit_to',3,'2024-08-24 19:47:30',NULL,'2024-08-25 00:47:30','2024-08-25 00:47:30'),
(7,88,NULL,NULL,5,5200.0000,'credit','purchase_payment','payment_account',2,'2024-08-24 20:34:21',NULL,'2024-08-25 01:34:21','2024-08-25 01:34:21'),
(8,162,NULL,NULL,5,5200.0000,'debit','purchase_payment','deposit_to',2,'2024-08-24 20:34:21',NULL,'2024-08-25 01:34:21','2024-08-25 01:34:21'),
(9,262,NULL,1158,NULL,14.0000,'credit','sell','payment_account',22,'2025-06-22 23:59:08',NULL,'2025-06-22 21:59:08','2025-06-22 21:59:08'),
(10,280,NULL,1158,NULL,14.0000,'debit','sell','deposit_to',22,'2025-06-22 23:59:08',NULL,'2025-06-22 21:59:08','2025-06-22 21:59:08'),
(15,544,NULL,1150,NULL,100.5600,'credit','sell','payment_account',29,'2025-07-20 14:17:40',NULL,'2025-07-20 12:17:40','2025-07-20 12:17:40'),
(16,597,NULL,1150,NULL,100.5600,'debit','sell','deposit_to',29,'2025-07-20 14:17:40',NULL,'2025-07-20 12:17:40','2025-07-20 12:17:40'),
(17,609,NULL,NULL,233,132.5000,'credit','sell_payment','payment_account',29,'2025-07-20 14:26:02',NULL,'2025-07-20 12:26:02','2025-07-20 12:26:02'),
(18,597,NULL,NULL,233,132.5000,'debit','sell_payment','deposit_to',29,'2025-07-20 14:26:02',NULL,'2025-07-20 12:26:02','2025-07-20 12:26:02'),
(19,544,NULL,1244,NULL,132.5000,'credit','sell','payment_account',29,'2025-07-20 14:26:02',NULL,'2025-07-20 12:26:02','2025-07-20 12:26:02'),
(20,609,NULL,1244,NULL,132.5000,'debit','sell','deposit_to',29,'2025-07-20 14:26:02',NULL,'2025-07-20 12:26:02','2025-07-20 12:26:02'),
(21,609,NULL,NULL,235,50.9600,'credit','sell_payment','payment_account',29,'2025-08-02 14:10:44',NULL,'2025-08-02 12:10:44','2025-08-02 12:10:44'),
(22,597,NULL,NULL,235,50.9600,'debit','sell_payment','deposit_to',29,'2025-08-02 14:10:44',NULL,'2025-08-02 12:10:44','2025-08-02 12:10:44'),
(23,544,NULL,1254,NULL,50.9600,'credit','sell','payment_account',29,'2025-08-02 14:10:45',NULL,'2025-08-02 12:10:45','2025-08-02 12:10:45'),
(24,609,NULL,1254,NULL,50.9600,'debit','sell','deposit_to',29,'2025-08-02 14:10:45',NULL,'2025-08-02 12:10:45','2025-08-02 12:10:45'),
(25,609,NULL,NULL,236,25.8200,'credit','sell_payment','payment_account',29,'2025-08-02 14:11:30',NULL,'2025-08-02 12:11:30','2025-08-02 12:11:30'),
(26,597,NULL,NULL,236,25.8200,'debit','sell_payment','deposit_to',29,'2025-08-02 14:11:30',NULL,'2025-08-02 12:11:30','2025-08-02 12:11:30'),
(27,544,NULL,1255,NULL,25.8200,'credit','sell','payment_account',29,'2025-08-02 14:11:31',NULL,'2025-08-02 12:11:31','2025-08-02 12:11:31'),
(28,609,NULL,1255,NULL,25.8200,'debit','sell','deposit_to',29,'2025-08-02 14:11:31',NULL,'2025-08-02 12:11:31','2025-08-02 12:11:31'),
(29,609,NULL,NULL,237,25.8200,'credit','sell_payment','payment_account',29,'2025-08-02 14:12:57',NULL,'2025-08-02 12:12:33','2025-08-02 12:12:57'),
(30,597,NULL,NULL,237,25.8200,'debit','sell_payment','deposit_to',29,'2025-08-02 14:12:57',NULL,'2025-08-02 12:12:33','2025-08-02 12:12:57'),
(31,544,NULL,1256,NULL,25.8200,'credit','sell','payment_account',29,'2025-08-02 14:12:57',NULL,'2025-08-02 12:12:33','2025-08-02 12:12:57'),
(32,609,NULL,1256,NULL,25.8200,'debit','sell','deposit_to',29,'2025-08-02 14:12:57',NULL,'2025-08-02 12:12:33','2025-08-02 12:12:57'),
(33,609,NULL,NULL,238,13.2500,'credit','sell_payment','payment_account',29,'2025-08-02 14:16:32',NULL,'2025-08-02 12:16:32','2025-08-02 12:16:32'),
(34,597,NULL,NULL,238,13.2500,'debit','sell_payment','deposit_to',29,'2025-08-02 14:16:32',NULL,'2025-08-02 12:16:32','2025-08-02 12:16:32'),
(35,544,NULL,1257,NULL,13.2500,'credit','sell','payment_account',29,'2025-08-02 14:16:32',NULL,'2025-08-02 12:16:32','2025-08-02 12:16:32'),
(36,609,NULL,1257,NULL,13.2500,'debit','sell','deposit_to',29,'2025-08-02 14:16:32',NULL,'2025-08-02 12:16:32','2025-08-02 12:16:32'),
(37,609,NULL,NULL,239,50.2800,'credit','sell_payment','payment_account',29,'2025-08-02 14:17:27',NULL,'2025-08-02 12:16:51','2025-08-02 12:17:27'),
(38,597,NULL,NULL,239,50.2800,'debit','sell_payment','deposit_to',29,'2025-08-02 14:17:27',NULL,'2025-08-02 12:16:51','2025-08-02 12:17:27'),
(39,544,NULL,1258,NULL,50.2800,'credit','sell','payment_account',29,'2025-08-02 14:17:27',NULL,'2025-08-02 12:16:51','2025-08-02 12:17:27'),
(40,609,NULL,1258,NULL,50.2800,'debit','sell','deposit_to',29,'2025-08-02 14:17:27',NULL,'2025-08-02 12:16:51','2025-08-02 12:17:27'),
(41,544,NULL,1259,NULL,13.2500,'credit','sell','payment_account',29,'2025-08-02 14:19:04',NULL,'2025-08-02 12:19:04','2025-08-02 12:19:04'),
(42,609,NULL,1259,NULL,13.2500,'debit','sell','deposit_to',29,'2025-08-02 14:19:04',NULL,'2025-08-02 12:19:04','2025-08-02 12:19:04'),
(43,544,NULL,1260,NULL,13.2500,'credit','sell','payment_account',29,'2025-08-02 14:24:38',NULL,'2025-08-02 12:24:38','2025-08-02 12:24:38'),
(44,609,NULL,1260,NULL,13.2500,'debit','sell','deposit_to',29,'2025-08-02 14:24:38',NULL,'2025-08-02 12:24:38','2025-08-02 12:24:38'),
(45,544,NULL,1261,NULL,25.8200,'credit','sell','payment_account',29,'2025-08-02 14:29:05',NULL,'2025-08-02 12:29:05','2025-08-02 12:29:05'),
(46,609,NULL,1261,NULL,25.8200,'debit','sell','deposit_to',29,'2025-08-02 14:29:05',NULL,'2025-08-02 12:29:05','2025-08-02 12:29:05'),
(47,609,NULL,NULL,324,500.0000,'credit','sell_payment','payment_account',29,'2025-08-05 17:15:53',NULL,'2025-08-05 15:15:53','2025-08-05 15:15:53'),
(48,597,NULL,NULL,324,500.0000,'debit','sell_payment','deposit_to',29,'2025-08-05 17:15:53',NULL,'2025-08-05 15:15:53','2025-08-05 15:15:53'),
(49,609,NULL,NULL,325,460.9300,'credit','sell_payment','payment_account',29,'2025-08-05 17:15:53',NULL,'2025-08-05 15:15:53','2025-08-05 15:15:53'),
(50,597,NULL,NULL,325,460.9300,'debit','sell_payment','deposit_to',29,'2025-08-05 17:15:53',NULL,'2025-08-05 15:15:53','2025-08-05 15:15:53'),
(51,544,NULL,1347,NULL,39.0700,'credit','sell','payment_account',29,'2025-08-05 17:15:53',NULL,'2025-08-05 15:15:53','2025-08-05 15:15:53'),
(52,609,NULL,1347,NULL,39.0700,'debit','sell','deposit_to',29,'2025-08-05 17:15:53',NULL,'2025-08-05 15:15:53','2025-08-05 15:15:53'),
(53,609,NULL,NULL,1050,25.8200,'credit','sell_payment','payment_account',29,'2025-08-08 21:49:26',NULL,'2025-08-08 19:49:26','2025-08-08 19:49:26'),
(54,597,NULL,NULL,1050,25.8200,'debit','sell_payment','deposit_to',29,'2025-08-08 21:49:26',NULL,'2025-08-08 19:49:26','2025-08-08 19:49:26'),
(55,544,NULL,2096,NULL,25.8200,'credit','sell','payment_account',29,'2025-08-08 21:49:26',NULL,'2025-08-08 19:49:26','2025-08-08 19:49:26'),
(56,609,NULL,2096,NULL,25.8200,'debit','sell','deposit_to',29,'2025-08-08 21:49:26',NULL,'2025-08-08 19:49:26','2025-08-08 19:49:26'),
(57,609,NULL,NULL,1051,63.5300,'credit','sell_payment','payment_account',29,'2025-08-08 21:50:01',NULL,'2025-08-08 19:50:01','2025-08-08 19:50:01'),
(58,597,NULL,NULL,1051,63.5300,'debit','sell_payment','deposit_to',29,'2025-08-08 21:50:01',NULL,'2025-08-08 19:50:01','2025-08-08 19:50:01'),
(59,544,NULL,2097,NULL,63.5300,'credit','sell','payment_account',29,'2025-08-08 21:50:01',NULL,'2025-08-08 19:50:01','2025-08-08 19:50:01'),
(60,609,NULL,2097,NULL,63.5300,'debit','sell','deposit_to',29,'2025-08-08 21:50:01',NULL,'2025-08-08 19:50:01','2025-08-08 19:50:01'),
(61,609,NULL,NULL,1057,25.8200,'credit','sell_payment','payment_account',29,'2025-08-08 21:55:00',NULL,'2025-08-08 19:55:00','2025-08-08 19:55:00'),
(62,597,NULL,NULL,1057,25.8200,'debit','sell_payment','deposit_to',29,'2025-08-08 21:55:00',NULL,'2025-08-08 19:55:00','2025-08-08 19:55:00'),
(63,544,NULL,2103,NULL,25.8200,'credit','sell','payment_account',29,'2025-08-08 21:55:00',NULL,'2025-08-08 19:55:00','2025-08-08 19:55:00'),
(64,609,NULL,2103,NULL,25.8200,'debit','sell','deposit_to',29,'2025-08-08 21:55:00',NULL,'2025-08-08 19:55:00','2025-08-08 19:55:00'),
(65,609,NULL,NULL,1187,25.8200,'credit','sell_payment','payment_account',29,'2025-08-09 16:11:51',NULL,'2025-08-09 14:11:51','2025-08-09 14:11:51'),
(66,597,NULL,NULL,1187,25.8200,'debit','sell_payment','deposit_to',29,'2025-08-09 16:11:51',NULL,'2025-08-09 14:11:51','2025-08-09 14:11:51'),
(67,544,NULL,2241,NULL,25.8200,'credit','sell','payment_account',29,'2025-08-09 16:11:51',NULL,'2025-08-09 14:11:51','2025-08-09 14:11:51'),
(68,609,NULL,2241,NULL,25.8200,'debit','sell','deposit_to',29,'2025-08-09 16:11:51',NULL,'2025-08-09 14:11:51','2025-08-09 14:11:51');
/*!40000 ALTER TABLE `accounting_accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_budgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_budgets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint(20) unsigned NOT NULL,
  `financial_year` int(11) NOT NULL,
  `jan` decimal(22,4) DEFAULT NULL,
  `feb` decimal(22,4) DEFAULT NULL,
  `mar` decimal(22,4) DEFAULT NULL,
  `apr` decimal(22,4) DEFAULT NULL,
  `may` decimal(22,4) DEFAULT NULL,
  `jun` decimal(22,4) DEFAULT NULL,
  `jul` decimal(22,4) DEFAULT NULL,
  `aug` decimal(22,4) DEFAULT NULL,
  `sep` decimal(22,4) DEFAULT NULL,
  `oct` decimal(22,4) DEFAULT NULL,
  `nov` decimal(22,4) DEFAULT NULL,
  `dec` decimal(22,4) DEFAULT NULL,
  `quarter_1` decimal(22,4) DEFAULT NULL,
  `quarter_2` decimal(22,4) DEFAULT NULL,
  `quarter_3` decimal(22,4) DEFAULT NULL,
  `quarter_4` decimal(22,4) DEFAULT NULL,
  `yearly` decimal(22,4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_budgets` WRITE;
/*!40000 ALTER TABLE `accounting_budgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_budgets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `account_number` varchar(191) NOT NULL,
  `account_details` text DEFAULT NULL,
  `account_type_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_business_id_index` (`business_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`),
  KEY `accounts_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) DEFAULT NULL,
  `description` text NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) DEFAULT NULL,
  `event` varchar(191) DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) DEFAULT NULL,
  `properties` text DEFAULT NULL,
  `batch_uuid` char(36) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=3244 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES
(1,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-23 16:15:39','2024-08-23 16:15:39'),
(2,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-23 17:19:43','2024-08-23 17:19:43'),
(3,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-23 17:29:25','2024-08-23 17:29:25'),
(4,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-08-23 19:49:17','2024-08-23 19:49:17'),
(5,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-08-23 20:14:49','2024-08-23 20:14:49'),
(6,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-08-23 21:13:17','2024-08-23 21:13:17'),
(7,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-24 07:59:29','2024-08-24 07:59:29'),
(8,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-24 14:12:45','2024-08-24 14:12:45'),
(9,'default','added',4,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":2700}}',NULL,'2024-08-24 16:45:18','2024-08-24 16:45:18'),
(10,'default','added',5,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2024-08-24 16:48:37','2024-08-24 16:48:37'),
(11,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2024-08-24 20:23:00','2024-08-24 20:23:00'),
(12,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-24 18:23:08','2024-08-24 18:23:08'),
(13,'default','added',6,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":6000}}',NULL,'2024-08-24 20:27:05','2024-08-24 20:27:05'),
(14,'default','added',7,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":2000}}',NULL,'2024-08-24 20:30:06','2024-08-24 20:30:06'),
(15,'default','edited',7,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"proforma\",\"final_total\":\"2000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":\"2000.0000\"}}',NULL,'2024-08-24 20:30:41','2024-08-24 20:30:41'),
(16,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-24 22:32:00','2024-08-24 22:32:00'),
(17,'default','added',8,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7200}}',NULL,'2024-08-25 00:38:29','2024-08-25 00:38:29'),
(18,'default','added',4,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2024-08-25 01:10:03','2024-08-25 01:10:03'),
(19,'default','added',9,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1220}}',NULL,'2024-08-25 01:14:12','2024-08-25 01:14:12'),
(20,'default','payment_edited',9,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1220.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"partial\",\"final_total\":\"1220.0000\"}}',NULL,'2024-08-25 01:15:30','2024-08-25 01:15:30'),
(21,'default','added',10,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":5200}}',NULL,'2024-08-25 01:26:33','2024-08-25 01:26:33'),
(22,'default','added',11,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":48400}}',NULL,'2024-08-25 01:40:11','2024-08-25 01:40:11'),
(23,'default','added',12,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2024-08-25 01:47:13','2024-08-25 01:47:13'),
(24,'default','payment_edited',12,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"partial\"}}',NULL,'2024-08-25 01:49:31','2024-08-25 01:49:31'),
(25,'default','payment_edited',12,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"payment_status\":\"partial\"},\"old\":{\"payment_status\":\"paid\"}}',NULL,'2024-08-25 01:50:04','2024-08-25 01:50:04'),
(26,'default','payment_deleted',7,'App\\TransactionPayment',NULL,2,2,'App\\User','{\"id\":7,\"ref_no\":\"2024\\/0001\"}',NULL,'2024-08-25 01:50:04','2024-08-25 01:50:04'),
(27,'default','added',5,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2024-08-25 02:00:51','2024-08-25 02:00:51'),
(28,'default','added',13,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":5250}}',NULL,'2024-08-25 02:03:54','2024-08-25 02:03:54'),
(29,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-25 02:12:19','2024-08-25 02:12:19'),
(30,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-25 07:29:40','2024-08-25 07:29:40'),
(31,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-25 08:02:40','2024-08-25 08:02:40'),
(32,'default','added',6,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2024-08-25 10:08:38','2024-08-25 10:08:38'),
(33,'default','added',14,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":100}}',NULL,'2024-08-25 10:15:01','2024-08-25 10:15:01'),
(34,'default','edited',14,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":3925},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"100.0000\"}}',NULL,'2024-08-25 10:16:59','2024-08-25 10:16:59'),
(35,'default','edited',11,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1600},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"48400.0000\"}}',NULL,'2024-08-25 10:22:29','2024-08-25 10:22:29'),
(36,'default','added',17,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":28000}}',NULL,'2024-08-25 10:30:46','2024-08-25 10:30:46'),
(37,'default','edited',17,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":17500},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":\"28000.0000\"}}',NULL,'2024-08-25 10:32:06','2024-08-25 10:32:06'),
(38,'default','shipping_edited',17,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"shipped\",\"payment_status\":\"due\",\"final_total\":\"17500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"17500.0000\"}}',NULL,'2024-08-25 10:35:44','2024-08-25 10:35:44'),
(39,'default','shipping_edited',17,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"17500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"shipped\",\"payment_status\":\"due\",\"final_total\":\"17500.0000\"}}',NULL,'2024-08-25 10:36:40','2024-08-25 10:36:40'),
(40,'default','added',18,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":3500}}',NULL,'2024-08-25 10:37:49','2024-08-25 10:37:49'),
(41,'default','edited',18,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":3500},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3500.0000\"}}',NULL,'2024-08-25 10:38:03','2024-08-25 10:38:03'),
(42,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-25 10:42:03','2024-08-25 10:42:03'),
(43,'default','added',5,'App\\User',NULL,1,1,'App\\User','{\"name\":\"Mr Waiter S\"}',NULL,'2024-08-25 10:55:38','2024-08-25 10:55:38'),
(44,'default','login',5,'App\\User',NULL,1,5,'App\\User','[]',NULL,'2024-08-25 10:56:35','2024-08-25 10:56:35'),
(45,'default','sms_notification_sent',1,'App\\Transaction',NULL,4,4,'App\\User','[]',NULL,'2024-08-25 14:54:25','2024-08-25 14:54:25'),
(46,'default','added',6,'App\\User',NULL,4,4,'App\\User','{\"name\":\"Mr Teacher M|\"}',NULL,'2024-08-25 16:58:10','2024-08-25 16:58:10'),
(47,'default','login',6,'App\\User',NULL,4,6,'App\\User','[]',NULL,'2024-08-25 16:58:38','2024-08-25 16:58:38'),
(48,'default','edited',6,'App\\User',NULL,4,4,'App\\User','{\"name\":\"Mr Teacher M|\"}',NULL,'2024-08-25 17:00:41','2024-08-25 17:00:41'),
(49,'default','added',19,'App\\Transaction',NULL,4,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":105}}',NULL,'2024-08-25 17:01:50','2024-08-25 17:01:50'),
(50,'default','added',20,'App\\Transaction',NULL,4,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":420}}',NULL,'2024-08-25 17:05:57','2024-08-25 17:05:57'),
(51,'default','added',21,'App\\Transaction',NULL,4,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":155}}',NULL,'2024-08-25 17:08:31','2024-08-25 17:08:31'),
(52,'default','added',22,'App\\Transaction',NULL,4,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2024-08-25 17:12:39','2024-08-25 17:12:39'),
(53,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-26 18:40:55','2024-08-26 18:40:55'),
(54,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-26 19:13:06','2024-08-26 19:13:06'),
(55,'default','edited',13,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":5250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"5250.0000\"}}',NULL,'2024-08-26 21:24:11','2024-08-26 21:24:11'),
(56,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-27 10:33:20','2024-08-27 10:33:20'),
(57,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-08-28 10:54:09','2024-08-28 10:54:09'),
(58,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-08-30 10:04:26','2024-08-30 10:04:26'),
(59,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-09 13:58:02','2024-09-09 13:58:02'),
(60,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-10 10:16:24','2024-09-10 10:16:24'),
(61,'default','login',7,'App\\User',NULL,5,7,'App\\User','[]',NULL,'2024-09-16 10:45:20','2024-09-16 10:45:20'),
(62,'default','login',8,'App\\User',NULL,6,8,'App\\User','[]',NULL,'2024-09-26 16:38:43','2024-09-26 16:38:43'),
(63,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-09-29 20:21:18','2024-09-29 20:21:18'),
(64,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-09-30 21:31:57','2024-09-30 21:31:57'),
(65,'default','added',24,'App\\Transaction',NULL,7,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2024-10-02 04:52:42','2024-10-02 04:52:42'),
(66,'default','edited',24,'App\\Transaction',NULL,7,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"paid\",\"final_total\":1500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"}}',NULL,'2024-10-02 04:59:22','2024-10-02 04:59:22'),
(67,'default','added',11,'App\\Contact',NULL,7,9,'App\\User','[]',NULL,'2024-10-02 05:00:22','2024-10-02 05:00:22'),
(68,'default','added',25,'App\\Transaction',NULL,7,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2024-10-02 05:00:47','2024-10-02 05:00:47'),
(69,'default','shipping_edited',25,'App\\Transaction',NULL,7,9,'App\\User','{\"update_note\":\"test\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"shipped\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"}}',NULL,'2024-10-02 05:02:07','2024-10-02 05:02:07'),
(70,'default','shipping_edited',25,'App\\Transaction',NULL,7,9,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"shipped\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"}}',NULL,'2024-10-02 05:02:16','2024-10-02 05:02:16'),
(71,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-02 14:25:50','2024-10-02 14:25:50'),
(72,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-02 14:47:10','2024-10-02 14:47:10'),
(73,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-02 12:47:44','2024-10-02 12:47:44'),
(74,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-03 01:58:30','2024-10-03 01:58:30'),
(75,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-06 13:55:38','2024-10-06 13:55:38'),
(76,'default','added',10,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Miss Salma Attaf\"}',NULL,'2024-10-06 16:00:20','2024-10-06 16:00:20'),
(77,'default','purchase_deleted',14,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"3925.0000\"}}',NULL,'2024-10-06 16:07:42','2024-10-06 16:07:42'),
(78,'default','purchase_deleted',11,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"1600.0000\"}}',NULL,'2024-10-06 16:07:46','2024-10-06 16:07:46'),
(80,'default','purchase_deleted',9,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"1220.0000\"}}',NULL,'2024-10-06 16:08:08','2024-10-06 16:08:08'),
(82,'default','edited',18,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3500.0000\"}}',NULL,'2024-10-06 16:09:01','2024-10-06 16:09:01'),
(83,'default','sell_deleted',13,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":13,\"invoice_no\":\"0001\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"5250.0000\"}}',NULL,'2024-10-06 16:09:34','2024-10-06 16:09:34'),
(84,'default','sell_deleted',17,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":17,\"invoice_no\":\"2024\\/0001\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"17500.0000\"}}',NULL,'2024-10-06 16:09:53','2024-10-06 16:09:53'),
(85,'default','purchase_deleted',10,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"5200.0000\"}}',NULL,'2024-10-06 16:10:15','2024-10-06 16:10:15'),
(86,'default','login',10,'App\\User',NULL,2,10,'App\\User','[]',NULL,'2024-10-06 16:15:56','2024-10-06 16:15:56'),
(87,'default','login',10,'App\\User',NULL,2,10,'App\\User','[]',NULL,'2024-10-06 16:26:07','2024-10-06 16:26:07'),
(88,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-06 21:47:16','2024-10-06 21:47:16'),
(89,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-07 16:40:28','2024-10-07 16:40:28'),
(90,'default','added',28,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":1353.799999999999954525264911353588104248046875}}',NULL,'2024-10-07 16:52:32','2024-10-07 16:52:32'),
(91,'default','edited',28,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"proforma\",\"final_total\":\"1353.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":\"1353.8000\"}}',NULL,'2024-10-07 16:53:08','2024-10-07 16:53:08'),
(92,'default','edited',28,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1353.799999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"proforma\",\"final_total\":\"1353.8000\"}}',NULL,'2024-10-07 16:53:49','2024-10-07 16:53:49'),
(93,'default','added',30,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1398.59999999999990905052982270717620849609375}}',NULL,'2024-10-07 17:03:09','2024-10-07 17:03:09'),
(94,'default','payment_edited',30,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1398.6000\"}}',NULL,'2024-10-07 17:03:26','2024-10-07 17:03:26'),
(95,'default','payment_deleted',14,'App\\TransactionPayment',NULL,2,2,'App\\User','{\"id\":14,\"ref_no\":\"SP2024\\/0002\"}',NULL,'2024-10-07 17:03:26','2024-10-07 17:03:26'),
(96,'default','edited',30,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2097.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"}}',NULL,'2024-10-07 17:04:16','2024-10-07 17:04:16'),
(97,'default','edited',28,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1353.799999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2024-10-07 17:04:44','2024-10-07 17:04:44'),
(98,'default','edited',30,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2097.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2097.9000\"}}',NULL,'2024-10-07 17:05:11','2024-10-07 17:05:11'),
(99,'default','added',32,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":441}}',NULL,'2024-10-07 17:19:49','2024-10-07 17:19:49'),
(100,'default','edited',30,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2097.9000\"}}',NULL,'2024-10-07 17:20:19','2024-10-07 17:20:19'),
(101,'default','edited',32,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":441},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"}}',NULL,'2024-10-07 17:21:09','2024-10-07 17:21:09'),
(102,'default','edited',30,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-10-07 17:21:54','2024-10-07 17:21:54'),
(103,'default','added',34,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-07 17:27:49','2024-10-07 17:27:49'),
(104,'default','edited',34,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-07 17:30:02','2024-10-07 17:30:02'),
(105,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-07 20:28:07','2024-10-07 20:28:07'),
(106,'default','added',36,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":693}}',NULL,'2024-10-07 20:48:56','2024-10-07 20:48:56'),
(107,'default','edited',36,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":693},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"}}',NULL,'2024-10-07 20:49:17','2024-10-07 20:49:17'),
(108,'default','added',40,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2608.90000000000009094947017729282379150390625}}',NULL,'2024-10-07 21:01:13','2024-10-07 21:01:13'),
(109,'default','added',42,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-10-07 21:11:50','2024-10-07 21:11:50'),
(110,'default','edited',42,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-10-07 21:12:41','2024-10-07 21:12:41'),
(111,'default','login',10,'App\\User',NULL,2,10,'App\\User','[]',NULL,'2024-10-07 21:15:27','2024-10-07 21:15:27'),
(112,'default','added',44,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-07 21:40:30','2024-10-07 21:40:30'),
(113,'default','added',46,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-07 21:59:52','2024-10-07 21:59:52'),
(114,'default','edited',44,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-07 22:01:13','2024-10-07 22:01:13'),
(115,'default','added',48,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2024-10-07 22:13:47','2024-10-07 22:13:47'),
(116,'default','added',50,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":913.5}}',NULL,'2024-10-07 22:19:22','2024-10-07 22:19:22'),
(117,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-08 00:37:04','2024-10-08 00:37:04'),
(118,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-08 14:20:25','2024-10-08 14:20:25'),
(119,'default','edited',28,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1353.799999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2024-10-08 14:47:07','2024-10-08 14:47:07'),
(120,'default','edited',40,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2608.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2608.9000\"}}',NULL,'2024-10-08 14:48:59','2024-10-08 14:48:59'),
(121,'default','edited',48,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-10-08 14:51:54','2024-10-08 14:51:54'),
(122,'default','edited',44,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-08 14:56:33','2024-10-08 14:56:33'),
(123,'default','edited',48,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1398.59999999999990905052982270717620849609375},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-10-08 14:57:23','2024-10-08 14:57:23'),
(124,'default','added',53,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1133.299999999999954525264911353588104248046875}}',NULL,'2024-10-08 15:13:50','2024-10-08 15:13:50'),
(125,'default','edited',50,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":913.5},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2024-10-08 15:14:59','2024-10-08 15:14:59'),
(126,'default','edited',46,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-08 15:18:11','2024-10-08 15:18:11'),
(127,'default','edited',53,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2487.09999999999990905052982270717620849609375},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1133.3000\"}}',NULL,'2024-10-08 15:29:36','2024-10-08 15:29:36'),
(128,'default','edited',53,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2487.09999999999990905052982270717620849609375},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2487.1000\"}}',NULL,'2024-10-08 15:34:03','2024-10-08 15:34:03'),
(129,'default','edited',53,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2487.09999999999990905052982270717620849609375},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2487.1000\"}}',NULL,'2024-10-08 15:35:40','2024-10-08 15:35:40'),
(130,'default','edited',53,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2487.09999999999990905052982270717620849609375},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2487.1000\"}}',NULL,'2024-10-08 15:42:59','2024-10-08 15:42:59'),
(131,'default','edited',40,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2608.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2608.9000\"}}',NULL,'2024-10-08 15:47:44','2024-10-08 15:47:44'),
(132,'default','edited',50,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":913.5},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2024-10-08 15:59:54','2024-10-08 15:59:54'),
(133,'default','edited',48,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1398.59999999999990905052982270717620849609375},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"}}',NULL,'2024-10-08 16:00:39','2024-10-08 16:00:39'),
(134,'default','edited',46,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-08 16:01:15','2024-10-08 16:01:15'),
(135,'default','edited',44,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-08 16:01:57','2024-10-08 16:01:57'),
(136,'default','edited',42,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-10-08 16:02:21','2024-10-08 16:02:21'),
(137,'default','edited',36,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":693},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"}}',NULL,'2024-10-08 16:02:58','2024-10-08 16:02:58'),
(138,'default','edited',34,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-08 16:03:27','2024-10-08 16:03:27'),
(139,'default','edited',32,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":441},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"}}',NULL,'2024-10-08 16:04:06','2024-10-08 16:04:06'),
(140,'default','edited',30,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-10-08 16:04:34','2024-10-08 16:04:34'),
(141,'default','edited',28,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1353.799999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2024-10-08 16:05:02','2024-10-08 16:05:02'),
(142,'default','added',56,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1243.90000000000009094947017729282379150390625}}',NULL,'2024-10-08 16:48:40','2024-10-08 16:48:40'),
(143,'default','added',58,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-08 16:55:08','2024-10-08 16:55:08'),
(144,'default','sell_deleted',58,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":58,\"invoice_no\":\"0016\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-08 17:50:43','2024-10-08 17:50:43'),
(145,'default','sell_deleted',56,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":56,\"invoice_no\":\"0015\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1243.9000\"}}',NULL,'2024-10-08 17:50:54','2024-10-08 17:50:54'),
(146,'default','sell_deleted',53,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":53,\"invoice_no\":\"0014\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2487.1000\"}}',NULL,'2024-10-08 17:50:59','2024-10-08 17:50:59'),
(147,'default','sell_deleted',50,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":50,\"invoice_no\":\"0013\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2024-10-08 17:51:04','2024-10-08 17:51:04'),
(148,'default','sell_deleted',48,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":48,\"invoice_no\":\"0012\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"}}',NULL,'2024-10-08 17:51:20','2024-10-08 17:51:20'),
(149,'default','sell_deleted',46,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":46,\"invoice_no\":\"0011\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-08 17:51:33','2024-10-08 17:51:33'),
(150,'default','sell_deleted',44,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":44,\"invoice_no\":\"0010\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-08 17:51:46','2024-10-08 17:51:46'),
(151,'default','sell_deleted',42,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":42,\"invoice_no\":\"0009\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-10-08 17:51:54','2024-10-08 17:51:54'),
(152,'default','sell_deleted',40,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":40,\"invoice_no\":\"0008\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2608.9000\"}}',NULL,'2024-10-08 17:51:58','2024-10-08 17:51:58'),
(153,'default','sell_deleted',36,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":36,\"invoice_no\":\"0007\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"}}',NULL,'2024-10-08 17:52:02','2024-10-08 17:52:02'),
(154,'default','sell_deleted',34,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":34,\"invoice_no\":\"0006\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-08 17:52:05','2024-10-08 17:52:05'),
(155,'default','sell_deleted',32,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":32,\"invoice_no\":\"0005\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"}}',NULL,'2024-10-08 17:52:09','2024-10-08 17:52:09'),
(156,'default','sell_deleted',30,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":30,\"invoice_no\":\"0004\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-10-08 17:52:12','2024-10-08 17:52:12'),
(157,'default','sell_deleted',28,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":28,\"invoice_no\":\"2024\\/0002\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2024-10-08 17:52:16','2024-10-08 17:52:16'),
(158,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-08 18:24:32','2024-10-08 18:24:32'),
(159,'default','added',239,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4061.40000000000009094947017729282379150390625}}',NULL,'2024-10-08 19:52:47','2024-10-08 19:52:47'),
(160,'default','edited',239,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4061.40000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4061.4000\"}}',NULL,'2024-10-08 19:53:17','2024-10-08 19:53:17'),
(161,'default','edited',239,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4061.40000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4061.4000\"}}',NULL,'2024-10-08 19:53:50','2024-10-08 19:53:50'),
(162,'default','added',240,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2024-10-08 19:57:12','2024-10-08 19:57:12'),
(163,'default','added',241,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":441}}',NULL,'2024-10-08 19:58:31','2024-10-08 19:58:31'),
(164,'default','edited',239,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4061.40000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4061.4000\"}}',NULL,'2024-10-08 19:59:25','2024-10-08 19:59:25'),
(165,'default','added',242,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-08 20:02:27','2024-10-08 20:02:27'),
(166,'default','added',243,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":693}}',NULL,'2024-10-08 20:03:43','2024-10-08 20:03:43'),
(167,'default','added',244,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2608.90000000000009094947017729282379150390625}}',NULL,'2024-10-08 20:05:48','2024-10-08 20:05:48'),
(168,'default','added',245,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-08 20:08:07','2024-10-08 20:08:07'),
(169,'default','added',246,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-10-08 20:09:13','2024-10-08 20:09:13'),
(170,'default','added',247,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-08 20:11:03','2024-10-08 20:11:03'),
(171,'default','added',248,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1398.59999999999990905052982270717620849609375}}',NULL,'2024-10-08 20:14:43','2024-10-08 20:14:43'),
(172,'default','added',249,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":913.5}}',NULL,'2024-10-08 20:17:39','2024-10-08 20:17:39'),
(173,'default','added',250,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2487.09999999999990905052982270717620849609375}}',NULL,'2024-10-08 20:21:28','2024-10-08 20:21:28'),
(174,'default','edited',239,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1353.799999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4061.4000\"}}',NULL,'2024-10-08 20:23:50','2024-10-08 20:23:50'),
(175,'default','sell_deleted',239,'App\\Transaction',NULL,2,10,'App\\User','{\"id\":239,\"invoice_no\":\"0017\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2024-10-08 20:27:39','2024-10-08 20:27:39'),
(176,'default','added',251,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1353.799999999999954525264911353588104248046875}}',NULL,'2024-10-08 20:32:12','2024-10-08 20:32:12'),
(177,'default','added',252,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2024-10-08 20:36:38','2024-10-08 20:36:38'),
(178,'default','added',253,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1243.90000000000009094947017729282379150390625}}',NULL,'2024-10-08 20:37:49','2024-10-08 20:37:49'),
(179,'default','added',254,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-08 20:42:28','2024-10-08 20:42:28'),
(180,'default','added',255,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2078.3000000000001818989403545856475830078125}}',NULL,'2024-10-08 20:43:47','2024-10-08 20:43:47'),
(181,'default','added',256,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2739.8000000000001818989403545856475830078125}}',NULL,'2024-10-08 20:45:43','2024-10-08 20:45:43'),
(182,'default','added',257,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":535.5}}',NULL,'2024-10-08 20:47:00','2024-10-08 20:47:00'),
(183,'default','added',258,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-10-08 21:40:44','2024-10-08 21:40:44'),
(184,'default','added',259,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-10-08 21:42:42','2024-10-08 21:42:42'),
(185,'default','added',260,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2232.3000000000001818989403545856475830078125}}',NULL,'2024-10-08 21:45:20','2024-10-08 21:45:20'),
(186,'default','added',261,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":598.5}}',NULL,'2024-10-08 21:46:48','2024-10-08 21:46:48'),
(187,'default','added',262,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1007.299999999999954525264911353588104248046875}}',NULL,'2024-10-08 21:49:51','2024-10-08 21:49:51'),
(188,'default','added',263,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2024-10-08 21:51:39','2024-10-08 21:51:39'),
(189,'default','added',264,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875}}',NULL,'2024-10-08 21:54:03','2024-10-08 21:54:03'),
(190,'default','added',265,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-08 21:57:43','2024-10-08 21:57:43'),
(191,'default','added',266,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":913.5}}',NULL,'2024-10-08 22:00:05','2024-10-08 22:00:05'),
(192,'default','added',267,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2141.3000000000001818989403545856475830078125}}',NULL,'2024-10-08 22:01:58','2024-10-08 22:01:58'),
(193,'default','added',268,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1398.59999999999990905052982270717620849609375}}',NULL,'2024-10-08 22:04:09','2024-10-08 22:04:09'),
(194,'default','added',269,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1133.299999999999954525264911353588104248046875}}',NULL,'2024-10-08 22:06:27','2024-10-08 22:06:27'),
(195,'default','added',270,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-08 22:08:04','2024-10-08 22:08:04'),
(196,'default','added',271,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-10-08 22:10:34','2024-10-08 22:10:34'),
(197,'default','added',272,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-10-08 22:12:00','2024-10-08 22:12:00'),
(198,'default','added',273,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":497.69999999999998863131622783839702606201171875}}',NULL,'2024-10-08 22:13:44','2024-10-08 22:13:44'),
(199,'default','added',274,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":598.5}}',NULL,'2024-10-08 22:15:09','2024-10-08 22:15:09'),
(200,'default','added',275,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-08 22:16:57','2024-10-08 22:16:57'),
(201,'default','added',276,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1858.5}}',NULL,'2024-10-08 22:19:54','2024-10-08 22:19:54'),
(202,'default','added',277,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2963.09999999999990905052982270717620849609375}}',NULL,'2024-10-08 22:22:21','2024-10-08 22:22:21'),
(203,'default','added',278,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2098.59999999999990905052982270717620849609375}}',NULL,'2024-10-08 22:26:06','2024-10-08 22:26:06'),
(204,'default','added',279,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1225}}',NULL,'2024-10-08 22:27:50','2024-10-08 22:27:50'),
(205,'default','added',280,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1399.299999999999954525264911353588104248046875}}',NULL,'2024-10-09 01:44:46','2024-10-09 01:44:46'),
(206,'default','added',281,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2898}}',NULL,'2024-10-09 01:46:37','2024-10-09 01:46:37'),
(207,'default','added',282,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-10-09 01:49:29','2024-10-09 01:49:29'),
(208,'default','added',283,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1007.299999999999954525264911353588104248046875}}',NULL,'2024-10-09 01:50:44','2024-10-09 01:50:44'),
(209,'default','added',284,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-09 01:52:31','2024-10-09 01:52:31'),
(210,'default','added',285,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-10-09 01:54:18','2024-10-09 01:54:18'),
(211,'default','added',286,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-10-09 01:56:00','2024-10-09 01:56:00'),
(212,'default','added',287,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2266.59999999999990905052982270717620849609375}}',NULL,'2024-10-09 01:57:33','2024-10-09 01:57:33'),
(213,'default','added',288,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-10-09 01:59:19','2024-10-09 01:59:19'),
(214,'default','added',289,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-09 02:00:50','2024-10-09 02:00:50'),
(215,'default','added',290,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-10-09 02:02:05','2024-10-09 02:02:05'),
(216,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-09 02:52:33','2024-10-09 02:52:33'),
(217,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-09 11:45:12','2024-10-09 11:45:12'),
(218,'default','edited',5,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2024-10-09 12:31:38','2024-10-09 12:31:38'),
(219,'default','shipping_edited',290,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-10-09 12:32:21','2024-10-09 12:32:21'),
(220,'default','shipping_edited',289,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":\"48952\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-09 12:35:23','2024-10-09 12:35:23'),
(221,'default','shipping_edited',290,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":\"48965\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-10-09 12:35:50','2024-10-09 12:35:50'),
(222,'default','shipping_edited',288,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-10-09 17:16:55','2024-10-09 17:16:55'),
(223,'default','shipping_edited',287,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2266.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2266.6000\"}}',NULL,'2024-10-09 17:17:36','2024-10-09 17:17:36'),
(224,'default','shipping_edited',286,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-10-09 17:31:59','2024-10-09 17:31:59'),
(225,'default','shipping_edited',285,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"shipped\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-10-09 17:32:20','2024-10-09 17:32:20'),
(226,'default','shipping_edited',285,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"shipped\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-10-09 17:32:38','2024-10-09 17:32:38'),
(227,'default','shipping_edited',283,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"}}',NULL,'2024-10-09 17:33:03','2024-10-09 17:33:03'),
(228,'default','shipping_edited',284,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-09 17:33:34','2024-10-09 17:33:34'),
(229,'default','shipping_edited',282,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-10-09 17:33:52','2024-10-09 17:33:52'),
(230,'default','shipping_edited',281,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2898.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2898.0000\"}}',NULL,'2024-10-09 17:34:10','2024-10-09 17:34:10'),
(231,'default','shipping_edited',280,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1399.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1399.3000\"}}',NULL,'2024-10-09 17:34:33','2024-10-09 17:34:33'),
(232,'default','shipping_edited',279,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1225.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1225.0000\"}}',NULL,'2024-10-09 17:50:10','2024-10-09 17:50:10'),
(233,'default','shipping_edited',278,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2098.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2098.6000\"}}',NULL,'2024-10-09 17:50:40','2024-10-09 17:50:40'),
(234,'default','shipping_edited',277,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2963.1000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2963.1000\"}}',NULL,'2024-10-09 17:51:05','2024-10-09 17:51:05'),
(235,'default','shipping_edited',276,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1858.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1858.5000\"}}',NULL,'2024-10-09 17:51:33','2024-10-09 17:51:33'),
(236,'default','shipping_edited',275,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-09 17:51:51','2024-10-09 17:51:51'),
(237,'default','shipping_edited',274,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"598.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"598.5000\"}}',NULL,'2024-10-09 17:52:13','2024-10-09 17:52:13'),
(238,'default','shipping_edited',273,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"497.7000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"497.7000\"}}',NULL,'2024-10-09 17:52:35','2024-10-09 17:52:35'),
(239,'default','shipping_edited',272,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-10-09 17:52:55','2024-10-09 17:52:55'),
(240,'default','shipping_edited',271,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-10-09 17:53:27','2024-10-09 17:53:27'),
(241,'default','shipping_edited',270,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-09 17:54:00','2024-10-09 17:54:00'),
(242,'default','shipping_edited',269,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1133.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1133.3000\"}}',NULL,'2024-10-09 17:54:27','2024-10-09 17:54:27'),
(243,'default','shipping_edited',268,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"}}',NULL,'2024-10-09 17:54:46','2024-10-09 17:54:46'),
(244,'default','shipping_edited',267,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2024-10-09 17:55:13','2024-10-09 17:55:13'),
(245,'default','shipping_edited',266,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2024-10-09 17:55:37','2024-10-09 17:55:37'),
(246,'default','shipping_edited',265,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-09 17:56:35','2024-10-09 17:56:35'),
(247,'default','shipping_edited',264,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2024-10-09 17:57:04','2024-10-09 17:57:04'),
(248,'default','shipping_edited',263,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-10-09 17:57:44','2024-10-09 17:57:44'),
(249,'default','shipping_edited',262,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"}}',NULL,'2024-10-09 17:58:11','2024-10-09 17:58:11'),
(250,'default','shipping_edited',261,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"598.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"598.5000\"}}',NULL,'2024-10-09 17:58:31','2024-10-09 17:58:31'),
(251,'default','shipping_edited',260,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2232.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2232.3000\"}}',NULL,'2024-10-09 17:59:14','2024-10-09 17:59:14'),
(252,'default','shipping_edited',259,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-10-09 17:59:36','2024-10-09 17:59:36'),
(253,'default','shipping_edited',258,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-10-09 18:00:09','2024-10-09 18:00:09'),
(254,'default','shipping_edited',257,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"535.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"535.5000\"}}',NULL,'2024-10-09 18:07:56','2024-10-09 18:07:56'),
(255,'default','shipping_edited',256,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2739.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2739.8000\"}}',NULL,'2024-10-09 18:08:17','2024-10-09 18:08:17'),
(256,'default','shipping_edited',255,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2078.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2078.3000\"}}',NULL,'2024-10-09 18:08:38','2024-10-09 18:08:38'),
(257,'default','shipping_edited',254,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-09 18:09:24','2024-10-09 18:09:24'),
(258,'default','shipping_edited',253,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1243.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1243.9000\"}}',NULL,'2024-10-09 18:09:55','2024-10-09 18:09:55'),
(259,'default','shipping_edited',252,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-10-09 18:10:19','2024-10-09 18:10:19'),
(260,'default','shipping_edited',250,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2487.1000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2487.1000\"}}',NULL,'2024-10-09 18:10:36','2024-10-09 18:10:36'),
(261,'default','shipping_edited',251,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2024-10-09 18:10:57','2024-10-09 18:10:57'),
(262,'default','shipping_edited',249,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2024-10-09 18:11:18','2024-10-09 18:11:18'),
(263,'default','shipping_edited',248,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"}}',NULL,'2024-10-09 18:11:37','2024-10-09 18:11:37'),
(264,'default','shipping_edited',247,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-09 18:12:28','2024-10-09 18:12:28'),
(265,'default','shipping_edited',246,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-10-09 18:12:44','2024-10-09 18:12:44'),
(266,'default','shipping_edited',245,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-09 18:13:09','2024-10-09 18:13:09'),
(267,'default','shipping_edited',244,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2608.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2608.9000\"}}',NULL,'2024-10-09 18:13:31','2024-10-09 18:13:31'),
(268,'default','shipping_edited',243,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"}}',NULL,'2024-10-09 18:13:48','2024-10-09 18:13:48'),
(269,'default','shipping_edited',242,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-10-09 18:14:04','2024-10-09 18:14:04'),
(270,'default','shipping_edited',241,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"}}',NULL,'2024-10-09 18:14:27','2024-10-09 18:14:27'),
(271,'default','shipping_edited',240,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-10-09 18:14:46','2024-10-09 18:14:46'),
(272,'default','added',291,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2042.59999999999990905052982270717620849609375}}',NULL,'2024-10-09 18:19:00','2024-10-09 18:19:00'),
(273,'default','shipping_edited',290,'App\\Transaction',NULL,2,10,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-10-09 18:19:48','2024-10-09 18:19:48'),
(274,'default','added',292,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2141.3000000000001818989403545856475830078125}}',NULL,'2024-10-09 18:30:47','2024-10-09 18:30:47'),
(275,'default','added',293,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-10-09 18:32:56','2024-10-09 18:32:56'),
(276,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-09 20:24:45','2024-10-09 20:24:45'),
(277,'default','added',294,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2024-10-10 19:03:00','2024-10-10 19:03:00'),
(278,'default','added',295,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":525}}',NULL,'2024-10-10 19:05:45','2024-10-10 19:05:45'),
(279,'default','added',296,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-10-10 19:07:17','2024-10-10 19:07:17'),
(280,'default','added',297,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1133.299999999999954525264911353588104248046875}}',NULL,'2024-10-10 19:08:24','2024-10-10 19:08:24'),
(281,'default','added',298,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-10-10 19:10:38','2024-10-10 19:10:38'),
(282,'default','added',299,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-10-10 19:11:56','2024-10-10 19:11:56'),
(283,'default','added',300,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-10 19:14:11','2024-10-10 19:14:11'),
(284,'default','added',301,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2024-10-10 19:15:44','2024-10-10 19:15:44'),
(285,'default','added',302,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-10-10 19:17:09','2024-10-10 19:17:09'),
(286,'default','added',303,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-10-10 19:19:03','2024-10-10 19:19:03'),
(287,'default','added',304,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2024-10-10 19:20:49','2024-10-10 19:20:49'),
(288,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-10-12 00:48:55','2024-10-12 00:48:55'),
(289,'default','added',305,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2024-10-12 16:29:30','2024-10-12 16:29:30'),
(290,'default','added',306,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2024-10-12 16:30:57','2024-10-12 16:30:57'),
(291,'default','added',307,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":441}}',NULL,'2024-10-12 16:33:04','2024-10-12 16:33:04'),
(292,'default','added',308,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2024-10-12 16:34:30','2024-10-12 16:34:30'),
(293,'default','added',309,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-12 16:36:17','2024-10-12 16:36:17'),
(294,'default','added',310,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875}}',NULL,'2024-10-12 16:38:30','2024-10-12 16:38:30'),
(295,'default','added',311,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-12 16:40:00','2024-10-12 16:40:00'),
(296,'default','added',312,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-10-12 16:41:45','2024-10-12 16:41:45'),
(297,'default','added',313,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-13 19:10:26','2024-10-13 19:10:26'),
(298,'default','added',314,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":598.5}}',NULL,'2024-10-13 19:11:48','2024-10-13 19:11:48'),
(299,'default','added',315,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1398.59999999999990905052982270717620849609375}}',NULL,'2024-10-13 19:13:29','2024-10-13 19:13:29'),
(300,'default','added',316,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-10-13 19:15:10','2024-10-13 19:15:10'),
(301,'default','added',317,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1133.299999999999954525264911353588104248046875}}',NULL,'2024-10-13 19:17:41','2024-10-13 19:17:41'),
(302,'default','added',318,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":441}}',NULL,'2024-10-14 21:01:09','2024-10-14 21:01:09'),
(303,'default','added',319,'App\\Transaction',NULL,2,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1858.5}}',NULL,'2024-10-14 21:02:58','2024-10-14 21:02:58'),
(304,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-28 08:00:59','2024-10-28 08:00:59'),
(305,'default','added',320,'App\\Transaction',NULL,4,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":105}}',NULL,'2024-10-28 11:04:09','2024-10-28 11:04:09'),
(306,'default','added',321,'App\\Transaction',NULL,4,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":210}}',NULL,'2024-10-28 11:05:57','2024-10-28 11:05:57'),
(307,'default','added',322,'App\\Transaction',NULL,4,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":105}}',NULL,'2024-10-28 11:06:20','2024-10-28 11:06:20'),
(308,'default','sell_deleted',322,'App\\Transaction',NULL,4,4,'App\\User','{\"id\":322,\"invoice_no\":\"0006\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"105.0000\"}}',NULL,'2024-10-28 11:07:37','2024-10-28 11:07:37'),
(309,'default','sell_deleted',321,'App\\Transaction',NULL,4,4,'App\\User','{\"id\":321,\"invoice_no\":\"0005\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"210.0000\"}}',NULL,'2024-10-28 11:07:41','2024-10-28 11:07:41'),
(310,'default','edited',7,'App\\Contact',NULL,4,4,'App\\User','[]',NULL,'2024-10-28 11:10:47','2024-10-28 11:10:47'),
(311,'default','edited',13,'App\\Contact',NULL,8,11,'App\\User','[]',NULL,'2024-10-28 12:06:30','2024-10-28 12:06:30'),
(312,'default','added',323,'App\\Transaction',NULL,8,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":195}}',NULL,'2024-10-28 12:06:49','2024-10-28 12:06:49'),
(313,'default','edited',323,'App\\Transaction',NULL,8,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":195},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"195.0000\"}}',NULL,'2024-10-28 12:09:30','2024-10-28 12:09:30'),
(314,'default','added',12,'App\\User',NULL,8,11,'App\\User','{\"name\":\"Mr Waiter 1\"}',NULL,'2024-10-28 12:48:18','2024-10-28 12:48:18'),
(315,'default','edited',12,'App\\User',NULL,8,11,'App\\User','{\"name\":\"Mr Waiter 1\"}',NULL,'2024-10-28 12:53:52','2024-10-28 12:53:52'),
(316,'default','logout',11,'App\\User',NULL,8,11,'App\\User','[]',NULL,'2024-10-28 12:54:00','2024-10-28 12:54:00'),
(317,'default','login',12,'App\\User',NULL,8,12,'App\\User','[]',NULL,'2024-10-28 12:54:05','2024-10-28 12:54:05'),
(318,'default','logout',12,'App\\User',NULL,8,12,'App\\User','[]',NULL,'2024-10-28 12:54:41','2024-10-28 12:54:41'),
(319,'default','login',11,'App\\User',NULL,8,11,'App\\User','[]',NULL,'2024-10-28 12:54:50','2024-10-28 12:54:50'),
(320,'default','added',324,'App\\Transaction',NULL,8,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":81}}',NULL,'2024-10-28 12:56:18','2024-10-28 12:56:18'),
(321,'default','logout',11,'App\\User',NULL,8,11,'App\\User','[]',NULL,'2024-10-28 12:57:04','2024-10-28 12:57:05'),
(322,'default','login',12,'App\\User',NULL,8,12,'App\\User','[]',NULL,'2024-10-28 12:57:09','2024-10-28 12:57:09'),
(323,'default','logout',12,'App\\User',NULL,8,12,'App\\User','[]',NULL,'2024-10-28 12:59:32','2024-10-28 12:59:32'),
(324,'default','login',12,'App\\User',NULL,8,12,'App\\User','[]',NULL,'2024-10-28 12:59:40','2024-10-28 12:59:40'),
(325,'default','logout',12,'App\\User',NULL,8,12,'App\\User','[]',NULL,'2024-10-28 13:00:55','2024-10-28 13:00:55'),
(326,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-03 14:03:59','2024-11-03 14:03:59'),
(327,'default','added',325,'App\\Transaction',NULL,8,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":71}}',NULL,'2024-11-03 17:27:18','2024-11-03 17:27:18'),
(328,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-12-18 14:06:42','2024-12-18 14:06:42'),
(329,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-12-18 20:51:04','2024-12-18 20:51:04'),
(330,'default','payment_edited',240,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-12-18 20:52:20','2024-12-18 20:52:20'),
(331,'default','payment_edited',241,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"441.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"}}',NULL,'2024-12-18 20:52:20','2024-12-18 20:52:20'),
(332,'default','payment_edited',242,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-18 20:52:20','2024-12-18 20:52:20'),
(333,'default','payment_edited',243,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"693.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"}}',NULL,'2024-12-18 20:52:20','2024-12-18 20:52:20'),
(334,'default','payment_edited',244,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"2608.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2608.9000\"}}',NULL,'2024-12-18 20:52:20','2024-12-18 20:52:20'),
(335,'default','payment_edited',245,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-18 20:52:20','2024-12-18 20:52:20'),
(336,'default','payment_edited',246,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-12-18 20:52:20','2024-12-18 20:52:20'),
(337,'default','payment_edited',247,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(338,'default','payment_edited',248,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1398.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(339,'default','payment_edited',249,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"913.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(340,'default','payment_edited',251,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1353.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(341,'default','payment_edited',250,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"2487.1000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2487.1000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(342,'default','payment_edited',252,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(343,'default','payment_edited',253,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1243.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1243.9000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(344,'default','payment_edited',254,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(345,'default','payment_edited',255,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"2078.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2078.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(346,'default','payment_edited',256,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"2739.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2739.8000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(347,'default','payment_edited',257,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"535.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"535.5000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(348,'default','payment_edited',258,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(349,'default','payment_edited',259,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(350,'default','payment_edited',260,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"2232.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2232.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(351,'default','payment_edited',261,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"598.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"598.5000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(352,'default','payment_edited',262,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1007.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(353,'default','payment_edited',263,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(354,'default','payment_edited',264,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(355,'default','payment_edited',265,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(356,'default','payment_edited',266,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"913.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(357,'default','payment_edited',267,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(358,'default','payment_edited',268,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1398.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(359,'default','payment_edited',269,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1133.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1133.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(360,'default','payment_edited',270,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(361,'default','payment_edited',271,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(362,'default','payment_edited',272,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(363,'default','payment_edited',273,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"497.7000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"497.7000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(364,'default','payment_edited',274,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"598.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"598.5000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(365,'default','payment_edited',275,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(366,'default','payment_edited',276,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1858.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1858.5000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(367,'default','payment_edited',277,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"2963.1000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2963.1000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(368,'default','payment_edited',278,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"2098.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2098.6000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(369,'default','payment_edited',279,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1225.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1225.0000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(370,'default','payment_edited',280,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1399.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1399.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(371,'default','payment_edited',281,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"2898.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2898.0000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(372,'default','payment_edited',282,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(373,'default','payment_edited',284,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(374,'default','payment_edited',283,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1007.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(375,'default','payment_edited',285,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(376,'default','payment_edited',286,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(377,'default','payment_edited',287,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"2266.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2266.6000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(378,'default','payment_edited',288,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(379,'default','payment_edited',289,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(380,'default','payment_edited',290,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(381,'default','payment_edited',291,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"2042.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2042.6000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(382,'default','payment_edited',292,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(383,'default','payment_edited',293,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(384,'default','payment_edited',294,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(385,'default','payment_edited',295,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"525.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(386,'default','payment_edited',296,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(387,'default','payment_edited',297,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1133.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1133.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(388,'default','payment_edited',298,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(389,'default','payment_edited',299,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(390,'default','payment_edited',300,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(391,'default','payment_edited',301,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(392,'default','payment_edited',302,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-18 20:52:21','2024-12-18 20:52:21'),
(393,'default','payment_edited',303,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-18 20:52:22','2024-12-18 20:52:22'),
(394,'default','payment_edited',304,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-12-18 20:52:22','2024-12-18 20:52:22'),
(395,'default','payment_edited',305,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-12-18 20:52:22','2024-12-18 20:52:22'),
(396,'default','payment_edited',306,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-12-18 20:52:22','2024-12-18 20:52:22'),
(397,'default','payment_edited',307,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"441.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"}}',NULL,'2024-12-18 20:52:22','2024-12-18 20:52:22'),
(398,'default','payment_edited',308,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-12-18 20:52:22','2024-12-18 20:52:22'),
(399,'default','payment_edited',309,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-18 20:52:22','2024-12-18 20:52:22'),
(400,'default','payment_edited',310,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2024-12-18 20:52:22','2024-12-18 20:52:22'),
(401,'default','payment_edited',311,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-18 20:52:22','2024-12-18 20:52:22'),
(402,'default','payment_edited',312,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-18 20:52:22','2024-12-18 20:52:22'),
(403,'default','payment_edited',313,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-18 20:52:22','2024-12-18 20:52:22'),
(404,'default','payment_edited',314,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"598.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"598.5000\"}}',NULL,'2024-12-18 20:52:22','2024-12-18 20:52:22'),
(405,'default','payment_edited',315,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1398.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"}}',NULL,'2024-12-18 20:52:22','2024-12-18 20:52:22'),
(406,'default','payment_edited',316,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-18 20:52:22','2024-12-18 20:52:22'),
(407,'default','payment_edited',317,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1133.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1133.3000\"}}',NULL,'2024-12-18 20:52:22','2024-12-18 20:52:22'),
(408,'default','payment_edited',318,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"441.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"}}',NULL,'2024-12-18 20:52:22','2024-12-18 20:52:22'),
(409,'default','payment_edited',319,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"partial\",\"final_total\":\"1858.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1858.5000\"}}',NULL,'2024-12-18 20:52:22','2024-12-18 20:52:22'),
(410,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-12-19 05:18:47','2024-12-19 05:18:47'),
(411,'default','added',334,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-19 06:09:43','2024-12-19 06:09:43'),
(412,'default','edited',334,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-19 06:14:14','2024-12-19 06:14:14'),
(413,'default','added',335,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-19 06:15:51','2024-12-19 06:15:51'),
(414,'default','edited',335,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-19 06:17:15','2024-12-19 06:17:15'),
(415,'default','edited',334,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-19 06:17:48','2024-12-19 06:17:48'),
(416,'default','added',336,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-12-19 06:19:13','2024-12-19 06:19:13'),
(417,'default','edited',335,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-19 06:19:28','2024-12-19 06:19:28'),
(418,'default','added',337,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2078.3000000000001818989403545856475830078125}}',NULL,'2024-12-19 06:21:03','2024-12-19 06:21:03'),
(419,'default','edited',335,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"proforma\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-19 06:22:33','2024-12-19 06:22:33'),
(420,'default','edited',335,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"proforma\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-19 06:23:25','2024-12-19 06:23:25'),
(421,'default','edited',335,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-19 06:23:42','2024-12-19 06:23:42'),
(422,'default','edited',335,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-19 06:46:31','2024-12-19 06:46:31'),
(423,'default','edited',337,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2078.3000000000001818989403545856475830078125},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2078.3000\"}}',NULL,'2024-12-19 06:49:48','2024-12-19 06:49:48'),
(424,'default','edited',334,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-19 06:50:21','2024-12-19 06:50:21'),
(425,'default','edited',334,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-19 06:50:37','2024-12-19 06:50:37'),
(426,'default','edited',336,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-12-19 06:51:13','2024-12-19 06:51:13'),
(427,'default','added',338,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-19 06:54:39','2024-12-19 06:54:39'),
(428,'default','added',339,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875}}',NULL,'2024-12-19 07:15:05','2024-12-19 07:15:05'),
(429,'default','added',340,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-19 07:16:19','2024-12-19 07:16:19'),
(430,'default','added',341,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2141.3000000000001818989403545856475830078125}}',NULL,'2024-12-19 07:17:39','2024-12-19 07:17:39'),
(431,'default','added',342,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":648.8999999999999772626324556767940521240234375}}',NULL,'2024-12-19 07:18:47','2024-12-19 07:18:47'),
(432,'default','added',343,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-12-19 07:19:53','2024-12-19 07:19:53'),
(433,'default','added',344,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.799999999999954525264911353588104248046875}}',NULL,'2024-12-19 07:22:06','2024-12-19 07:22:06'),
(434,'default','added',345,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1228.5}}',NULL,'2024-12-19 07:23:01','2024-12-19 07:23:01'),
(435,'default','edited',340,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-19 07:23:18','2024-12-19 07:23:18'),
(436,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-12-20 09:39:22','2024-12-20 09:39:22'),
(437,'default','added',346,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11020.100000000000363797880709171295166015625}}',NULL,'2024-12-20 10:55:28','2024-12-20 10:55:28'),
(438,'default','added',347,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2898}}',NULL,'2024-12-20 11:03:03','2024-12-20 11:03:03'),
(439,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-12-20 13:38:21','2024-12-20 13:38:21'),
(440,'default','edited',346,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11020.100000000000363797880709171295166015625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"11020.1000\"}}',NULL,'2024-12-20 13:39:45','2024-12-20 13:39:45'),
(441,'default','edited',346,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1243.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"11020.1000\"}}',NULL,'2024-12-20 13:44:22','2024-12-20 13:44:22'),
(442,'default','sell_deleted',347,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":347,\"invoice_no\":\"0112\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2898.0000\"}}',NULL,'2024-12-20 13:45:39','2024-12-20 13:45:39'),
(443,'default','sell_deleted',346,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":346,\"invoice_no\":\"P55129\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1243.9000\"}}',NULL,'2024-12-20 13:45:53','2024-12-20 13:45:53'),
(444,'default','edited',345,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1228.5},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1228.5000\"}}',NULL,'2024-12-20 13:46:12','2024-12-20 13:46:12'),
(445,'default','sell_deleted',330,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":330,\"invoice_no\":\"P54945\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 13:46:55','2024-12-20 13:46:55'),
(446,'default','sell_deleted',331,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":331,\"invoice_no\":\"P54990\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 13:46:55','2024-12-20 13:46:55'),
(447,'default','sell_deleted',332,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":332,\"invoice_no\":\"P54972\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 13:46:55','2024-12-20 13:46:55'),
(448,'default','sell_deleted',333,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":333,\"invoice_no\":\"P54970\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 13:46:55','2024-12-20 13:46:55'),
(449,'default','sell_deleted',326,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":326,\"invoice_no\":\"P54945\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 13:47:02','2024-12-20 13:47:02'),
(450,'default','sell_deleted',327,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":327,\"invoice_no\":\"P54990\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 13:47:02','2024-12-20 13:47:02'),
(451,'default','sell_deleted',328,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":328,\"invoice_no\":\"P54972\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 13:47:02','2024-12-20 13:47:02'),
(452,'default','sell_deleted',329,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":329,\"invoice_no\":\"P54970\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 13:47:02','2024-12-20 13:47:02'),
(453,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-12-20 14:04:10','2024-12-20 14:04:10'),
(454,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-20 12:04:29','2024-12-20 12:04:29'),
(455,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-12-20 14:07:07','2024-12-20 14:07:07'),
(456,'default','sell_deleted',348,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":348,\"invoice_no\":\"P55243\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"}}',NULL,'2024-12-20 14:08:32','2024-12-20 14:08:32'),
(457,'default','sell_deleted',349,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":349,\"invoice_no\":\"P55247\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"}}',NULL,'2024-12-20 14:08:32','2024-12-20 14:08:32'),
(458,'default','sell_deleted',350,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":350,\"invoice_no\":\"P55243\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"}}',NULL,'2024-12-20 14:14:14','2024-12-20 14:14:14'),
(459,'default','sell_deleted',351,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":351,\"invoice_no\":\"P55247\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"}}',NULL,'2024-12-20 14:14:14','2024-12-20 14:14:14'),
(460,'default','edited',352,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1449},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:18:21','2024-12-20 14:18:21'),
(461,'default','edited',352,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1449},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"}}',NULL,'2024-12-20 14:18:49','2024-12-20 14:18:49'),
(462,'default','edited',353,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1449},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:19:27','2024-12-20 14:19:27'),
(463,'default','sell_deleted',354,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":354,\"invoice_no\":\"P55129\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:37:43','2024-12-20 14:37:43'),
(464,'default','sell_deleted',355,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":355,\"invoice_no\":\"P55207\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:37:43','2024-12-20 14:37:43'),
(465,'default','sell_deleted',356,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":356,\"invoice_no\":\"P55193\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:37:43','2024-12-20 14:37:43'),
(466,'default','sell_deleted',357,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":357,\"invoice_no\":\"P55182\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:37:43','2024-12-20 14:37:43'),
(467,'default','sell_deleted',358,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":358,\"invoice_no\":\"P55196\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:37:43','2024-12-20 14:37:43'),
(468,'default','sell_deleted',359,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":359,\"invoice_no\":\"P55148\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:37:43','2024-12-20 14:37:43'),
(469,'default','sell_deleted',360,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":360,\"invoice_no\":\"P55113\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:37:43','2024-12-20 14:37:43'),
(470,'default','sell_deleted',361,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":361,\"invoice_no\":\"P55165\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:37:43','2024-12-20 14:37:43'),
(471,'default','sell_deleted',362,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":362,\"invoice_no\":\" P55417 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:47:05','2024-12-20 14:47:05'),
(472,'default','sell_deleted',363,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":363,\"invoice_no\":\" P55342 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:47:05','2024-12-20 14:47:05'),
(473,'default','sell_deleted',364,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":364,\"invoice_no\":\" P55329 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:47:05','2024-12-20 14:47:05'),
(474,'default','sell_deleted',365,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":365,\"invoice_no\":\" P55380 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:47:05','2024-12-20 14:47:05'),
(475,'default','sell_deleted',366,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":366,\"invoice_no\":\" P55304 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:47:05','2024-12-20 14:47:05'),
(476,'default','sell_deleted',367,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":367,\"invoice_no\":\" P55373 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:47:05','2024-12-20 14:47:05'),
(477,'default','sell_deleted',368,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":368,\"invoice_no\":\" P55426 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:47:05','2024-12-20 14:47:05'),
(478,'default','sell_deleted',369,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":369,\"invoice_no\":\" P55393 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:47:05','2024-12-20 14:47:05'),
(479,'default','sell_deleted',370,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":370,\"invoice_no\":\" P55394 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:47:05','2024-12-20 14:47:05'),
(480,'default','sell_deleted',371,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":371,\"invoice_no\":\" P55308 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:47:05','2024-12-20 14:47:05'),
(481,'default','sell_deleted',372,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":372,\"invoice_no\":\" P55364 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:47:05','2024-12-20 14:47:05'),
(482,'default','sell_deleted',373,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":373,\"invoice_no\":\" P55417 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:19','2024-12-20 14:54:19'),
(483,'default','sell_deleted',374,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":374,\"invoice_no\":\" P55342 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:19','2024-12-20 14:54:19'),
(484,'default','sell_deleted',375,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":375,\"invoice_no\":\" P55329 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:19','2024-12-20 14:54:19'),
(485,'default','sell_deleted',376,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":376,\"invoice_no\":\" P55380 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:19','2024-12-20 14:54:19'),
(486,'default','sell_deleted',377,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":377,\"invoice_no\":\" P55304 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:19','2024-12-20 14:54:19'),
(487,'default','sell_deleted',378,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":378,\"invoice_no\":\" P55373 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:19','2024-12-20 14:54:19'),
(488,'default','sell_deleted',379,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":379,\"invoice_no\":\" P55426 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:19','2024-12-20 14:54:19'),
(489,'default','sell_deleted',380,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":380,\"invoice_no\":\" P55393 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:19','2024-12-20 14:54:19'),
(490,'default','sell_deleted',381,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":381,\"invoice_no\":\" P55394 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:19','2024-12-20 14:54:19'),
(491,'default','sell_deleted',382,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":382,\"invoice_no\":\" P55308 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:19','2024-12-20 14:54:19'),
(492,'default','sell_deleted',383,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":383,\"invoice_no\":\" P55364 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:19','2024-12-20 14:54:19'),
(493,'default','sell_deleted',386,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":386,\"invoice_no\":\" P55417 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:23','2024-12-20 14:54:23'),
(494,'default','sell_deleted',387,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":387,\"invoice_no\":\" P55342 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:23','2024-12-20 14:54:23'),
(495,'default','sell_deleted',388,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":388,\"invoice_no\":\" P55329 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:23','2024-12-20 14:54:23'),
(496,'default','sell_deleted',389,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":389,\"invoice_no\":\" P55380 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:23','2024-12-20 14:54:23'),
(497,'default','sell_deleted',390,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":390,\"invoice_no\":\" P55304 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:23','2024-12-20 14:54:23'),
(498,'default','sell_deleted',391,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":391,\"invoice_no\":\" P55373 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:23','2024-12-20 14:54:23'),
(499,'default','sell_deleted',392,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":392,\"invoice_no\":\" P55426 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:23','2024-12-20 14:54:24'),
(500,'default','sell_deleted',393,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":393,\"invoice_no\":\" P55393 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:24','2024-12-20 14:54:24'),
(501,'default','sell_deleted',394,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":394,\"invoice_no\":\" P55394 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:24','2024-12-20 14:54:24'),
(502,'default','sell_deleted',395,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":395,\"invoice_no\":\" P55308 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:24','2024-12-20 14:54:24'),
(503,'default','sell_deleted',396,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":396,\"invoice_no\":\" P55364 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:54:24','2024-12-20 14:54:24'),
(504,'default','sell_deleted',397,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":397,\"invoice_no\":\" P55417 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:56:02','2024-12-20 14:56:02'),
(505,'default','sell_deleted',398,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":398,\"invoice_no\":\" P55342 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:56:02','2024-12-20 14:56:02'),
(506,'default','sell_deleted',399,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":399,\"invoice_no\":\" P55329 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:56:02','2024-12-20 14:56:02'),
(507,'default','sell_deleted',400,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":400,\"invoice_no\":\" P55380 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:56:02','2024-12-20 14:56:02'),
(508,'default','sell_deleted',401,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":401,\"invoice_no\":\" P55304 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:56:02','2024-12-20 14:56:02'),
(509,'default','sell_deleted',402,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":402,\"invoice_no\":\" P55373 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:56:02','2024-12-20 14:56:02'),
(510,'default','sell_deleted',403,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":403,\"invoice_no\":\" P55426 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:56:02','2024-12-20 14:56:02'),
(511,'default','sell_deleted',404,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":404,\"invoice_no\":\" P55393 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:56:02','2024-12-20 14:56:02'),
(512,'default','sell_deleted',405,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":405,\"invoice_no\":\" P55394 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:56:02','2024-12-20 14:56:02'),
(513,'default','sell_deleted',406,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":406,\"invoice_no\":\" P55308 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:56:02','2024-12-20 14:56:02'),
(514,'default','sell_deleted',407,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":407,\"invoice_no\":\" P55364 \",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-20 14:56:02','2024-12-20 14:56:02'),
(515,'default','added',419,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-12-20 15:33:50','2024-12-20 15:33:50'),
(516,'default','added',420,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2024-12-20 15:34:43','2024-12-20 15:34:43'),
(517,'default','edited',420,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":3812.1999999999998181010596454143524169921875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-12-20 15:36:56','2024-12-20 15:36:56'),
(518,'default','added',421,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2141.3000000000001818989403545856475830078125}}',NULL,'2024-12-20 15:37:46','2024-12-20 15:37:46'),
(519,'default','added',422,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":648.8999999999999772626324556767940521240234375}}',NULL,'2024-12-20 15:38:39','2024-12-20 15:38:39'),
(520,'default','added',423,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2046.09999999999990905052982270717620849609375}}',NULL,'2024-12-20 15:40:01','2024-12-20 15:40:01'),
(521,'default','added',424,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":441}}',NULL,'2024-12-20 15:40:49','2024-12-20 15:40:49'),
(522,'default','added',425,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1365}}',NULL,'2024-12-20 15:41:36','2024-12-20 15:41:36'),
(523,'default','added',426,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1449}}',NULL,'2024-12-20 15:42:53','2024-12-20 15:42:53'),
(524,'default','added',427,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":598.5}}',NULL,'2024-12-20 16:04:30','2024-12-20 16:04:30'),
(525,'default','edited',427,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":598.5},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"598.5000\"}}',NULL,'2024-12-20 16:04:45','2024-12-20 16:04:45'),
(526,'default','added',428,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-20 16:05:45','2024-12-20 16:05:45'),
(527,'default','added',429,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-20 16:06:31','2024-12-20 16:06:31'),
(528,'default','added',430,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1243.90000000000009094947017729282379150390625}}',NULL,'2024-12-20 16:10:26','2024-12-20 16:10:26'),
(529,'default','added',431,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":497.69999999999998863131622783839702606201171875}}',NULL,'2024-12-20 16:11:20','2024-12-20 16:11:20'),
(530,'default','added',432,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2024-12-20 16:12:02','2024-12-20 16:12:02'),
(531,'default','added',433,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-12-20 16:12:57','2024-12-20 16:12:57'),
(532,'default','added',434,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1827}}',NULL,'2024-12-20 16:13:57','2024-12-20 16:13:57'),
(533,'default','edited',424,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":441},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"441.0000\"}}',NULL,'2024-12-20 16:14:16','2024-12-20 16:14:16'),
(534,'default','edited',425,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1365},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1365.0000\"}}',NULL,'2024-12-20 16:14:57','2024-12-20 16:14:57'),
(535,'default','added',435,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.799999999999954525264911353588104248046875}}',NULL,'2024-12-20 16:16:44','2024-12-20 16:16:44'),
(536,'default','added',436,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1399.299999999999954525264911353588104248046875}}',NULL,'2024-12-20 16:17:54','2024-12-20 16:17:54'),
(537,'default','added',437,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-20 16:18:54','2024-12-20 16:18:54'),
(538,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-12-21 11:14:52','2024-12-21 11:14:52'),
(539,'default','added',438,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1449}}',NULL,'2024-12-21 11:19:26','2024-12-21 11:19:26'),
(540,'default','added',439,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.799999999999954525264911353588104248046875}}',NULL,'2024-12-21 11:20:40','2024-12-21 11:20:40'),
(541,'default','added',440,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-21 11:22:34','2024-12-21 11:22:34'),
(542,'default','added',441,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1795.5}}',NULL,'2024-12-21 11:24:02','2024-12-21 11:24:02'),
(543,'default','added',442,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.799999999999954525264911353588104248046875}}',NULL,'2024-12-21 11:24:50','2024-12-21 11:24:50'),
(544,'default','edited',442,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.799999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2024-12-21 11:25:36','2024-12-21 11:25:36'),
(545,'default','added',443,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-21 11:26:50','2024-12-21 11:26:50'),
(546,'default','added',444,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1133.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 11:27:29','2024-12-21 11:27:29'),
(547,'default','added',445,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":1007.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 11:28:50','2024-12-21 11:28:50'),
(548,'default','edited',445,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1007.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1007.3000\"}}',NULL,'2024-12-21 11:29:03','2024-12-21 11:29:03'),
(549,'default','edited',444,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1133.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1133.3000\"}}',NULL,'2024-12-21 11:29:23','2024-12-21 11:29:23'),
(550,'default','added',446,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 11:30:15','2024-12-21 11:30:15'),
(551,'default','added',447,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1070.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 11:30:51','2024-12-21 11:30:51'),
(552,'default','added',448,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1070.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 11:31:49','2024-12-21 11:31:49'),
(553,'default','added',449,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2024-12-21 11:35:23','2024-12-21 11:35:23'),
(554,'default','added',450,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 11:41:48','2024-12-21 11:41:48'),
(555,'default','added',451,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2419.90000000000009094947017729282379150390625}}',NULL,'2024-12-21 11:45:55','2024-12-21 11:45:55'),
(556,'default','added',452,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-21 11:46:59','2024-12-21 11:46:59'),
(557,'default','added',453,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 11:47:46','2024-12-21 11:47:46'),
(558,'default','edited',449,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1.0000\"}}',NULL,'2024-12-21 11:49:41','2024-12-21 11:49:41'),
(559,'default','edited',453,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-21 11:50:47','2024-12-21 11:50:47'),
(560,'default','added',454,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1050}}',NULL,'2024-12-21 11:52:44','2024-12-21 11:52:44'),
(561,'default','added',455,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2312.8000000000001818989403545856475830078125}}',NULL,'2024-12-21 11:54:52','2024-12-21 11:54:52'),
(562,'default','added',456,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":692.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 11:56:40','2024-12-21 11:56:40'),
(563,'default','edited',456,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"692.3000\"}}',NULL,'2024-12-21 11:56:59','2024-12-21 11:56:59'),
(564,'default','added',457,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":497.69999999999998863131622783839702606201171875}}',NULL,'2024-12-21 11:58:08','2024-12-21 11:58:08'),
(565,'default','added',458,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":913.5}}',NULL,'2024-12-21 11:59:44','2024-12-21 11:59:44'),
(566,'default','added',459,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-21 12:00:25','2024-12-21 12:00:25'),
(567,'default','added',460,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-21 12:01:06','2024-12-21 12:01:06'),
(568,'default','added',461,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-21 12:02:16','2024-12-21 12:02:16'),
(569,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-12-21 14:33:39','2024-12-21 14:33:39'),
(570,'default','added',462,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 14:42:33','2024-12-21 14:42:33'),
(571,'default','added',463,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1795.5}}',NULL,'2024-12-21 14:43:48','2024-12-21 14:43:48'),
(572,'default','added',464,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.799999999999954525264911353588104248046875}}',NULL,'2024-12-21 14:45:10','2024-12-21 14:45:10'),
(573,'default','added',465,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2141.3000000000001818989403545856475830078125}}',NULL,'2024-12-21 14:45:57','2024-12-21 14:45:57'),
(574,'default','added',466,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-21 14:48:21','2024-12-21 14:48:21'),
(575,'default','added',467,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 14:49:12','2024-12-21 14:49:12'),
(576,'default','added',468,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2196.09999999999990905052982270717620849609375}}',NULL,'2024-12-21 14:52:08','2024-12-21 14:52:08'),
(577,'default','added',469,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1795.5}}',NULL,'2024-12-21 14:55:38','2024-12-21 14:55:38'),
(578,'default','added',470,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2141.3000000000001818989403545856475830078125}}',NULL,'2024-12-21 15:02:25','2024-12-21 15:02:25'),
(579,'default','contact_deleted',14,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2024-12-21 15:03:02','2024-12-21 15:03:02'),
(580,'default','added',471,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-21 15:04:11','2024-12-21 15:04:11'),
(581,'default','added',472,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1050}}',NULL,'2024-12-21 15:08:17','2024-12-21 15:08:17'),
(582,'default','added',473,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1449}}',NULL,'2024-12-21 15:09:33','2024-12-21 15:09:33'),
(583,'default','added',474,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2424.09999999999990905052982270717620849609375}}',NULL,'2024-12-21 15:13:08','2024-12-21 15:13:08'),
(584,'default','added',475,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2141.3000000000001818989403545856475830078125}}',NULL,'2024-12-21 15:14:02','2024-12-21 15:14:02'),
(585,'default','added',476,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1399.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 15:15:39','2024-12-21 15:15:39'),
(586,'default','added',477,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 15:16:28','2024-12-21 15:16:28'),
(587,'default','added',478,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":913.5}}',NULL,'2024-12-21 15:25:22','2024-12-21 15:25:22'),
(588,'default','added',479,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 15:26:26','2024-12-21 15:26:26'),
(589,'default','added',480,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-21 15:27:43','2024-12-21 15:27:43'),
(590,'default','added',481,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":913.5}}',NULL,'2024-12-21 15:28:33','2024-12-21 15:28:33'),
(591,'default','edited',477,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-12-21 15:29:03','2024-12-21 15:29:03'),
(592,'default','added',482,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 15:30:25','2024-12-21 15:30:25'),
(593,'default','added',483,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-21 15:32:10','2024-12-21 15:32:10'),
(594,'default','added',484,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2141.3000000000001818989403545856475830078125}}',NULL,'2024-12-21 15:33:02','2024-12-21 15:33:02'),
(595,'default','added',485,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1133.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 15:34:14','2024-12-21 15:34:14'),
(596,'default','added',486,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-21 15:35:44','2024-12-21 15:35:44'),
(597,'default','added',487,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1764}}',NULL,'2024-12-21 15:37:58','2024-12-21 15:37:58'),
(598,'default','added',488,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":525}}',NULL,'2024-12-21 15:39:16','2024-12-21 15:39:16'),
(599,'default','added',489,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 15:40:43','2024-12-21 15:40:43'),
(600,'default','edited',334,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 16:46:04','2024-12-21 16:46:04'),
(601,'default','edited',341,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2141.3000000000001818989403545856475830078125},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2024-12-21 16:47:07','2024-12-21 16:47:07'),
(602,'default','edited',339,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2024-12-21 16:47:23','2024-12-21 16:47:23'),
(603,'default','edited',340,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 16:47:26','2024-12-21 16:47:26'),
(604,'default','edited',338,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 16:47:41','2024-12-21 16:47:41'),
(605,'default','edited',337,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2078.3000000000001818989403545856475830078125},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2078.3000\"}}',NULL,'2024-12-21 16:47:50','2024-12-21 16:47:50'),
(606,'default','edited',336,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-12-21 16:48:15','2024-12-21 16:48:15'),
(607,'default','edited',335,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 16:48:23','2024-12-21 16:48:23'),
(608,'default','edited',342,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":648.8999999999999772626324556767940521240234375},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"648.9000\"}}',NULL,'2024-12-21 16:48:39','2024-12-21 16:48:39'),
(609,'default','edited',343,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-21 16:49:17','2024-12-21 16:49:17'),
(610,'default','edited',344,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.799999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2024-12-21 16:49:21','2024-12-21 16:49:21'),
(611,'default','added',490,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 16:55:32','2024-12-21 16:55:32'),
(612,'default','added',491,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1818.59999999999990905052982270717620849609375}}',NULL,'2024-12-21 16:58:08','2024-12-21 16:58:08'),
(613,'default','added',492,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1071}}',NULL,'2024-12-21 16:59:25','2024-12-21 16:59:25'),
(614,'default','added',493,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 17:00:28','2024-12-21 17:00:28'),
(615,'default','added',494,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":525}}',NULL,'2024-12-21 17:01:46','2024-12-21 17:01:46'),
(616,'default','added',495,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":525}}',NULL,'2024-12-21 17:03:06','2024-12-21 17:03:06'),
(617,'default','added',496,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":6423.899999999999636202119290828704833984375}}',NULL,'2024-12-21 17:04:07','2024-12-21 17:04:07'),
(618,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-12-21 17:49:55','2024-12-21 17:49:55'),
(619,'default','shipping_edited',438,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"}}',NULL,'2024-12-21 17:53:36','2024-12-21 17:53:36'),
(620,'default','shipping_edited',444,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1133.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1133.3000\"}}',NULL,'2024-12-21 17:54:35','2024-12-21 17:54:35'),
(621,'default','shipping_edited',456,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2024-12-21 17:55:27','2024-12-21 17:55:27'),
(622,'default','shipping_edited',450,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-12-21 17:55:56','2024-12-21 17:55:56'),
(623,'default','shipping_edited',429,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 17:56:27','2024-12-21 17:56:27'),
(624,'default','shipping_edited',443,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 17:56:44','2024-12-21 17:56:44'),
(625,'default','shipping_edited',428,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 17:56:59','2024-12-21 17:56:59'),
(626,'default','shipping_edited',426,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"}}',NULL,'2024-12-21 17:57:18','2024-12-21 17:57:18'),
(627,'default','shipping_edited',439,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2024-12-21 17:57:35','2024-12-21 17:57:35'),
(628,'default','shipping_edited',445,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"}}',NULL,'2024-12-21 17:57:52','2024-12-21 17:57:52'),
(629,'default','shipping_edited',419,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-12-21 18:10:29','2024-12-21 18:10:29'),
(630,'default','shipping_edited',455,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2312.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2312.8000\"}}',NULL,'2024-12-21 18:12:03','2024-12-21 18:12:03'),
(631,'default','shipping_edited',427,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"598.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"598.5000\"}}',NULL,'2024-12-21 18:12:23','2024-12-21 18:12:23'),
(632,'default','shipping_edited',338,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 18:14:01','2024-12-21 18:14:01'),
(633,'default','shipping_edited',425,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1365.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1365.0000\"}}',NULL,'2024-12-21 18:15:37','2024-12-21 18:15:37'),
(634,'default','shipping_edited',423,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2046.1000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2046.1000\"}}',NULL,'2024-12-21 18:15:54','2024-12-21 18:15:54'),
(635,'default','shipping_edited',442,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2024-12-21 18:31:41','2024-12-21 18:31:41'),
(636,'default','edited',420,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":4721.5},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"3812.2000\"}}',NULL,'2024-12-21 18:36:15','2024-12-21 18:36:15'),
(637,'default','edited',423,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":2046.09999999999990905052982270717620849609375},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2046.1000\"}}',NULL,'2024-12-21 18:39:43','2024-12-21 18:39:43'),
(638,'default','edited',425,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":1365},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1365.0000\"}}',NULL,'2024-12-21 18:39:47','2024-12-21 18:39:47'),
(639,'default','edited',425,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":1365},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1365.0000\"}}',NULL,'2024-12-21 18:41:09','2024-12-21 18:41:09'),
(640,'default','shipping_edited',446,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-21 18:42:37','2024-12-21 18:42:37'),
(641,'default','sell_deleted',447,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":447,\"invoice_no\":\"P55453\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1070.3000\"}}',NULL,'2024-12-21 18:43:53','2024-12-21 18:43:53'),
(642,'default','shipping_edited',448,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1070.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1070.3000\"}}',NULL,'2024-12-21 18:44:30','2024-12-21 18:44:30'),
(643,'default','shipping_edited',422,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"648.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"648.9000\"}}',NULL,'2024-12-21 18:45:08','2024-12-21 18:45:08'),
(644,'default','shipping_edited',424,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"}}',NULL,'2024-12-21 18:46:45','2024-12-21 18:46:45'),
(645,'default','shipping_edited',338,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 18:49:33','2024-12-21 18:49:33'),
(646,'default','edited',437,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":2739.8000000000001818989403545856475830078125},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 18:52:43','2024-12-21 18:52:43'),
(647,'default','shipping_edited',453,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"shipped\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-21 18:55:23','2024-12-21 18:55:23'),
(648,'default','shipping_edited',421,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2024-12-21 18:55:37','2024-12-21 18:55:37'),
(649,'default','shipping_edited',431,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"497.7000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"497.7000\"}}',NULL,'2024-12-21 18:56:40','2024-12-21 18:56:40'),
(650,'default','shipping_edited',467,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2024-12-21 18:57:07','2024-12-21 18:57:07'),
(651,'default','shipping_edited',477,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-12-21 18:57:31','2024-12-21 18:57:31'),
(652,'default','shipping_edited',453,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"shipped\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-21 18:57:43','2024-12-21 18:57:43'),
(653,'default','shipping_edited',462,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-12-21 18:58:04','2024-12-21 18:58:04'),
(654,'default','shipping_edited',343,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"packed\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-21 18:58:08','2024-12-21 18:58:08'),
(655,'default','shipping_edited',342,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"packed\",\"payment_status\":\"due\",\"final_total\":\"648.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"648.9000\"}}',NULL,'2024-12-21 18:58:19','2024-12-21 18:58:19'),
(656,'default','shipping_edited',468,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2196.1000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2196.1000\"}}',NULL,'2024-12-21 19:01:05','2024-12-21 19:01:05'),
(657,'default','shipping_edited',464,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2024-12-21 19:01:32','2024-12-21 19:01:32'),
(658,'default','shipping_edited',474,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2424.1000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2424.1000\"}}',NULL,'2024-12-21 19:02:39','2024-12-21 19:02:39'),
(659,'default','shipping_edited',473,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"}}',NULL,'2024-12-21 19:03:06','2024-12-21 19:03:06'),
(660,'default','shipping_edited',465,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2024-12-21 19:03:21','2024-12-21 19:03:21'),
(661,'default','shipping_edited',476,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1399.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1399.3000\"}}',NULL,'2024-12-21 19:03:39','2024-12-21 19:03:39'),
(662,'default','shipping_edited',470,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2024-12-21 19:04:04','2024-12-21 19:04:04'),
(663,'default','shipping_edited',343,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"packed\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-21 19:04:21','2024-12-21 19:04:21'),
(664,'default','shipping_edited',475,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2024-12-21 19:04:22','2024-12-21 19:04:22'),
(665,'default','shipping_edited',480,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 19:04:38','2024-12-21 19:04:38'),
(666,'default','shipping_edited',486,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 19:04:58','2024-12-21 19:04:58'),
(667,'default','shipping_edited',466,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 19:05:14','2024-12-21 19:05:14'),
(668,'default','shipping_edited',340,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 19:06:11','2024-12-21 19:06:11'),
(669,'default','shipping_edited',342,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"648.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"packed\",\"payment_status\":\"due\",\"final_total\":\"648.9000\"}}',NULL,'2024-12-21 19:06:32','2024-12-21 19:06:32'),
(670,'default','shipping_edited',432,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-12-21 19:07:19','2024-12-21 19:07:19'),
(671,'default','shipping_edited',353,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"}}',NULL,'2024-12-21 19:08:52','2024-12-21 19:08:52'),
(672,'default','shipping_edited',352,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"}}',NULL,'2024-12-21 19:09:29','2024-12-21 19:09:29'),
(673,'default','shipping_edited',352,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"}}',NULL,'2024-12-21 19:09:53','2024-12-21 19:09:53'),
(674,'default','shipping_edited',436,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1399.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1399.3000\"}}',NULL,'2024-12-21 19:11:00','2024-12-21 19:11:00'),
(675,'default','shipping_edited',435,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2024-12-21 19:11:15','2024-12-21 19:11:15'),
(676,'default','shipping_edited',345,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1228.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1228.5000\"}}',NULL,'2024-12-21 19:11:29','2024-12-21 19:11:29'),
(677,'default','shipping_edited',339,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2024-12-21 19:11:50','2024-12-21 19:11:50'),
(678,'default','shipping_edited',433,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-21 19:12:09','2024-12-21 19:12:09'),
(679,'default','shipping_edited',430,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1243.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1243.9000\"}}',NULL,'2024-12-21 19:12:28','2024-12-21 19:12:28'),
(680,'default','shipping_edited',343,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-21 19:12:46','2024-12-21 19:12:46'),
(681,'default','shipping_edited',341,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2024-12-21 19:14:42','2024-12-21 19:14:42'),
(682,'default','edited',437,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":2739.8000000000001818989403545856475830078125},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2739.8000\"}}',NULL,'2024-12-21 19:16:42','2024-12-21 19:16:42'),
(683,'default','added',497,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 19:47:43','2024-12-21 19:47:43'),
(684,'default','added',498,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1102.5}}',NULL,'2024-12-21 19:50:04','2024-12-21 19:50:04'),
(685,'default','added',499,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 19:54:34','2024-12-21 19:54:34'),
(686,'default','added',500,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":6423.899999999999636202119290828704833984375}}',NULL,'2024-12-21 19:55:47','2024-12-21 19:55:47'),
(687,'default','added',501,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-21 19:56:38','2024-12-21 19:56:38'),
(688,'default','added',502,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":535.5}}',NULL,'2024-12-21 19:57:43','2024-12-21 19:57:43'),
(689,'default','added',503,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 19:58:31','2024-12-21 19:58:31'),
(690,'default','shipping_edited',478,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2024-12-21 19:58:39','2024-12-21 19:58:39'),
(691,'default','shipping_edited',479,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-12-21 19:59:06','2024-12-21 19:59:06'),
(692,'default','added',504,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1763.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 19:59:22','2024-12-21 19:59:22'),
(693,'default','shipping_edited',482,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-12-21 19:59:30','2024-12-21 19:59:30'),
(694,'default','shipping_edited',485,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1133.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1133.3000\"}}',NULL,'2024-12-21 19:59:47','2024-12-21 19:59:47'),
(695,'default','shipping_edited',484,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2024-12-21 20:00:13','2024-12-21 20:00:13'),
(696,'default','shipping_edited',459,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 20:01:34','2024-12-21 20:01:34'),
(697,'default','shipping_edited',460,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 20:02:03','2024-12-21 20:02:03'),
(698,'default','shipping_edited',461,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 20:02:19','2024-12-21 20:02:19'),
(699,'default','shipping_edited',471,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 20:02:33','2024-12-21 20:02:33'),
(700,'default','shipping_edited',452,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 20:04:46','2024-12-21 20:04:46'),
(701,'default','added',505,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":805}}',NULL,'2024-12-21 20:05:39','2024-12-21 20:05:39'),
(702,'default','shipping_edited',471,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 20:06:26','2024-12-21 20:06:26'),
(703,'default','shipping_edited',461,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 20:06:42','2024-12-21 20:06:42'),
(704,'default','shipping_edited',460,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 20:06:49','2024-12-21 20:06:49'),
(705,'default','shipping_edited',459,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 20:06:58','2024-12-21 20:06:58'),
(706,'default','shipping_edited',440,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-21 20:07:16','2024-12-21 20:07:16'),
(707,'default','added',506,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2024-12-21 20:08:11','2024-12-21 20:08:11'),
(708,'default','added',507,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":535.5}}',NULL,'2024-12-21 20:18:39','2024-12-21 20:18:39'),
(709,'default','edited',427,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":805},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"598.5000\"}}',NULL,'2024-12-21 20:34:55','2024-12-21 20:34:55'),
(710,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-12-22 15:39:33','2024-12-22 15:39:33'),
(711,'default','shipping_edited',507,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"535.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"535.5000\"}}',NULL,'2024-12-22 15:40:09','2024-12-22 15:40:09'),
(712,'default','shipping_edited',502,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"535.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"535.5000\"}}',NULL,'2024-12-22 15:40:35','2024-12-22 15:40:35'),
(713,'default','shipping_edited',498,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1102.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1102.5000\"}}',NULL,'2024-12-22 15:41:09','2024-12-22 15:41:09'),
(714,'default','shipping_edited',501,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-22 15:42:39','2024-12-22 15:42:39'),
(715,'default','shipping_edited',334,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-22 15:42:54','2024-12-22 15:42:54'),
(716,'default','shipping_edited',335,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-22 15:43:10','2024-12-22 15:43:10'),
(717,'default','shipping_edited',505,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"805.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"805.0000\"}}',NULL,'2024-12-22 15:43:35','2024-12-22 15:43:35'),
(718,'default','shipping_edited',500,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"6423.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"6423.9000\"}}',NULL,'2024-12-22 15:44:27','2024-12-22 15:44:27'),
(719,'default','shipping_edited',506,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-22 15:46:24','2024-12-22 15:46:24'),
(720,'default','shipping_edited',499,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-22 15:46:43','2024-12-22 15:46:43'),
(721,'default','shipping_edited',497,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-22 15:47:03','2024-12-22 15:47:03'),
(722,'default','shipping_edited',503,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2024-12-22 15:48:16','2024-12-22 15:48:16'),
(723,'default','shipping_edited',336,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-12-22 15:49:22','2024-12-22 15:49:22'),
(724,'default','shipping_edited',337,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2078.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2078.3000\"}}',NULL,'2024-12-22 15:49:38','2024-12-22 15:49:38'),
(725,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-12-25 16:07:34','2024-12-25 16:07:34'),
(726,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-26 21:27:47','2024-12-26 21:27:47'),
(727,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-29 11:19:29','2024-12-29 11:19:29'),
(728,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-12-30 18:49:55','2024-12-30 18:49:55'),
(729,'default','edited',10,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Miss Reem Islam\"}',NULL,'2024-12-30 18:53:03','2024-12-30 18:53:03'),
(730,'default','deleted',10,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Miss Reem Islam\",\"id\":10}',NULL,'2024-12-30 18:54:26','2024-12-30 18:54:26'),
(731,'default','added',13,'App\\User',NULL,2,2,'App\\User','{\"name\":\" Reem Islam\"}',NULL,'2024-12-30 18:55:30','2024-12-30 18:55:30'),
(732,'default','login',13,'App\\User',NULL,2,13,'App\\User','[]',NULL,'2024-12-30 19:06:46','2024-12-30 19:06:46'),
(733,'default','added',508,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 19:34:36','2024-12-30 19:34:36'),
(734,'default','added',509,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-12-30 19:38:19','2024-12-30 19:38:19'),
(735,'default','added',510,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 19:39:45','2024-12-30 19:39:45'),
(736,'default','added',511,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 19:42:27','2024-12-30 19:42:27'),
(737,'default','edited',511,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-30 19:42:51','2024-12-30 19:42:51'),
(738,'default','added',512,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2141.3000000000001818989403545856475830078125}}',NULL,'2024-12-30 19:44:28','2024-12-30 19:44:28'),
(739,'default','added',513,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 19:45:36','2024-12-30 19:45:36'),
(740,'default','added',514,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1365}}',NULL,'2024-12-30 19:46:52','2024-12-30 19:46:52'),
(741,'default','added',515,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 19:49:37','2024-12-30 19:49:37'),
(742,'default','added',516,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":525}}',NULL,'2024-12-30 19:51:52','2024-12-30 19:51:52'),
(743,'default','added',517,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1398.59999999999990905052982270717620849609375}}',NULL,'2024-12-30 19:53:25','2024-12-30 19:53:25'),
(744,'default','added',518,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 20:00:04','2024-12-30 20:00:04'),
(745,'default','added',519,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 20:01:27','2024-12-30 20:01:27'),
(746,'default','added',520,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1958.59999999999990905052982270717620849609375}}',NULL,'2024-12-30 20:02:48','2024-12-30 20:02:48'),
(747,'default','added',521,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":535.5}}',NULL,'2024-12-30 20:04:59','2024-12-30 20:04:59'),
(748,'default','added',522,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 20:06:08','2024-12-30 20:06:08'),
(749,'default','added',523,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 20:07:49','2024-12-30 20:07:49'),
(750,'default','added',524,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 20:09:06','2024-12-30 20:09:06'),
(751,'default','added',525,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 20:10:18','2024-12-30 20:10:18'),
(752,'default','added',526,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1050}}',NULL,'2024-12-30 20:11:55','2024-12-30 20:11:55'),
(753,'default','added',527,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 20:13:48','2024-12-30 20:13:48'),
(754,'default','added',528,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2024-12-30 20:15:21','2024-12-30 20:15:21'),
(755,'default','added',529,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":913.5}}',NULL,'2024-12-30 20:21:21','2024-12-30 20:21:21'),
(756,'default','added',530,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-12-30 20:22:59','2024-12-30 20:22:59'),
(757,'default','added',531,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 20:27:48','2024-12-30 20:27:48'),
(758,'default','added',532,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 20:29:15','2024-12-30 20:29:15'),
(759,'default','added',533,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2798.59999999999990905052982270717620849609375}}',NULL,'2024-12-30 20:31:10','2024-12-30 20:31:10'),
(760,'default','added',534,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2333.09999999999990905052982270717620849609375}}',NULL,'2024-12-30 20:33:37','2024-12-30 20:33:37'),
(761,'default','added',535,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 20:35:07','2024-12-30 20:35:07'),
(762,'default','added',536,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 20:36:14','2024-12-30 20:36:14'),
(763,'default','added',537,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 20:37:59','2024-12-30 20:37:59'),
(764,'default','added',538,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 20:39:18','2024-12-30 20:39:18'),
(765,'default','added',539,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":805}}',NULL,'2024-12-30 20:40:31','2024-12-30 20:40:31'),
(766,'default','added',540,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 20:45:57','2024-12-30 20:45:57'),
(767,'default','added',541,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 20:48:50','2024-12-30 20:48:50'),
(768,'default','added',542,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875}}',NULL,'2024-12-30 20:49:45','2024-12-30 20:49:45'),
(769,'default','added',543,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-12-30 20:50:41','2024-12-30 20:50:41'),
(770,'default','added',544,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":4109.6999999999998181010596454143524169921875}}',NULL,'2024-12-30 20:55:07','2024-12-30 20:55:07'),
(771,'default','added',545,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 20:56:21','2024-12-30 20:56:21'),
(772,'default','added',546,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875}}',NULL,'2024-12-30 20:57:42','2024-12-30 20:57:42'),
(773,'default','added',547,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-30 20:59:26','2024-12-30 20:59:26'),
(774,'default','added',548,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":525}}',NULL,'2024-12-30 21:02:31','2024-12-30 21:02:31'),
(775,'default','added',549,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":150}}',NULL,'2024-12-30 21:09:04','2024-12-30 21:09:04'),
(776,'default','sell_deleted',543,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":543,\"invoice_no\":\"P57264\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-12-30 21:17:07','2024-12-30 21:17:07'),
(777,'default','added',550,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1070.299999999999954525264911353588104248046875}}',NULL,'2024-12-30 21:23:33','2024-12-30 21:23:33'),
(778,'default','edited',550,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1070.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1070.3000\"}}',NULL,'2024-12-30 21:37:10','2024-12-30 21:37:10'),
(779,'default','edited',549,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":150},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"150.0000\"}}',NULL,'2024-12-30 21:37:28','2024-12-30 21:37:28'),
(780,'default','edited',548,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":525},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"}}',NULL,'2024-12-30 21:37:40','2024-12-30 21:37:40'),
(781,'default','edited',547,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-30 21:38:04','2024-12-30 21:38:04'),
(782,'default','edited',546,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2024-12-30 21:38:24','2024-12-30 21:38:24'),
(783,'default','edited',545,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-30 21:38:41','2024-12-30 21:38:41'),
(784,'default','edited',544,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":4109.6999999999998181010596454143524169921875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"4109.7000\"}}',NULL,'2024-12-30 21:39:19','2024-12-30 21:39:19'),
(785,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-31 13:18:32','2024-12-31 13:18:32'),
(786,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-31 13:18:38','2024-12-31 13:18:38'),
(787,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-12-31 15:19:08','2024-12-31 15:19:08'),
(788,'default','edited',5,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2024-12-31 15:19:49','2024-12-31 15:19:49'),
(789,'default','added',551,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-31 17:27:14','2024-12-31 17:27:14'),
(790,'default','added',552,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-31 17:33:08','2024-12-31 17:33:08'),
(791,'default','added',553,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":497.69999999999998863131622783839702606201171875}}',NULL,'2024-12-31 17:37:43','2024-12-31 17:37:43'),
(792,'default','added',554,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":535.5}}',NULL,'2024-12-31 17:40:45','2024-12-31 17:40:45'),
(793,'default','added',555,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-31 17:42:03','2024-12-31 17:42:03'),
(794,'default','added',556,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1133.299999999999954525264911353588104248046875}}',NULL,'2024-12-31 17:43:35','2024-12-31 17:43:35'),
(795,'default','edited',550,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1070.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1070.3000\"}}',NULL,'2024-12-31 17:44:29','2024-12-31 17:44:29'),
(796,'default','added',557,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2141.3000000000001818989403545856475830078125}}',NULL,'2024-12-31 17:47:04','2024-12-31 17:47:04'),
(797,'default','added',558,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-31 17:58:52','2024-12-31 17:58:52'),
(798,'default','added',559,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":913.5}}',NULL,'2024-12-31 18:00:43','2024-12-31 18:00:43'),
(799,'default','added',560,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":525}}',NULL,'2024-12-31 18:02:37','2024-12-31 18:02:37'),
(800,'default','added',561,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":805}}',NULL,'2024-12-31 18:03:40','2024-12-31 18:03:40'),
(801,'default','added',562,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":805}}',NULL,'2024-12-31 18:04:58','2024-12-31 18:04:58'),
(802,'default','edited',544,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":4109.6999999999998181010596454143524169921875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"4109.7000\"}}',NULL,'2024-12-31 18:11:27','2024-12-31 18:11:27'),
(803,'default','edited',545,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 18:40:51','2024-12-31 18:40:51'),
(804,'default','edited',546,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2024-12-31 18:41:41','2024-12-31 18:41:41'),
(805,'default','edited',547,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 18:42:21','2024-12-31 18:42:21'),
(806,'default','edited',551,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 18:43:40','2024-12-31 18:43:40'),
(807,'default','edited',548,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":525},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"}}',NULL,'2024-12-31 18:44:30','2024-12-31 18:44:30'),
(808,'default','edited',553,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":497.69999999999998863131622783839702606201171875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"497.7000\"}}',NULL,'2024-12-31 18:45:37','2024-12-31 18:45:37'),
(809,'default','edited',549,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":150},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"150.0000\"}}',NULL,'2024-12-31 18:47:34','2024-12-31 18:47:34'),
(810,'default','shipping_edited',556,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1133.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1133.3000\"}}',NULL,'2024-12-31 18:52:50','2024-12-31 18:52:50'),
(811,'default','shipping_edited',538,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 18:55:24','2024-12-31 18:55:25'),
(812,'default','shipping_edited',538,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 18:55:35','2024-12-31 18:55:35'),
(813,'default','shipping_edited',537,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 18:56:35','2024-12-31 18:56:35'),
(814,'default','shipping_edited',539,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"805.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"805.0000\"}}',NULL,'2024-12-31 18:57:11','2024-12-31 18:57:11'),
(815,'default','shipping_edited',540,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 18:57:49','2024-12-31 18:57:49'),
(816,'default','shipping_edited',541,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 19:00:03','2024-12-31 19:00:03'),
(817,'default','shipping_edited',542,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2024-12-31 19:01:11','2024-12-31 19:01:11'),
(818,'default','shipping_edited',545,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 19:03:57','2024-12-31 19:03:57'),
(819,'default','shipping_edited',555,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 19:06:21','2024-12-31 19:06:21'),
(820,'default','shipping_edited',552,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 19:08:55','2024-12-31 19:08:55'),
(821,'default','shipping_edited',557,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2024-12-31 19:10:07','2024-12-31 19:10:07'),
(822,'default','shipping_edited',548,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"}}',NULL,'2024-12-31 19:11:39','2024-12-31 19:11:39'),
(823,'default','shipping_edited',561,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"805.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"805.0000\"}}',NULL,'2024-12-31 21:47:40','2024-12-31 21:47:40'),
(824,'default','shipping_edited',550,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1070.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1070.3000\"}}',NULL,'2024-12-31 21:48:07','2024-12-31 21:48:07'),
(825,'default','added',563,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2208.5}}',NULL,'2024-12-31 21:56:10','2024-12-31 21:56:10'),
(826,'default','added',564,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-31 21:57:02','2024-12-31 21:57:02'),
(827,'default','added',565,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-31 21:59:35','2024-12-31 21:59:35'),
(828,'default','added',566,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":913.5}}',NULL,'2024-12-31 22:00:42','2024-12-31 22:00:42'),
(829,'default','added',567,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2518.59999999999990905052982270717620849609375}}',NULL,'2024-12-31 22:01:48','2024-12-31 22:01:48'),
(830,'default','added',568,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.799999999999954525264911353588104248046875}}',NULL,'2024-12-31 22:03:15','2024-12-31 22:03:15'),
(831,'default','added',569,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1007.299999999999954525264911353588104248046875}}',NULL,'2024-12-31 22:05:31','2024-12-31 22:05:31'),
(832,'default','added',570,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":535.5}}',NULL,'2024-12-31 22:06:21','2024-12-31 22:06:21'),
(833,'default','added',571,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2024-12-31 22:17:48','2024-12-31 22:17:48'),
(834,'default','added',572,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":909.299999999999954525264911353588104248046875}}',NULL,'2024-12-31 22:18:32','2024-12-31 22:18:32'),
(835,'default','added',573,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1070.299999999999954525264911353588104248046875}}',NULL,'2024-12-31 22:19:18','2024-12-31 22:19:18'),
(836,'default','added',574,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1228.5}}',NULL,'2024-12-31 22:20:25','2024-12-31 22:20:25'),
(837,'default','added',575,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1706.59999999999990905052982270717620849609375}}',NULL,'2024-12-31 22:21:28','2024-12-31 22:21:28'),
(838,'default','added',576,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875}}',NULL,'2024-12-31 22:22:13','2024-12-31 22:22:13'),
(839,'default','added',577,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1609.299999999999954525264911353588104248046875}}',NULL,'2024-12-31 22:23:35','2024-12-31 22:23:35'),
(840,'default','shipping_edited',488,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"}}',NULL,'2024-12-31 22:30:09','2024-12-31 22:30:09'),
(841,'default','shipping_edited',562,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"805.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"805.0000\"}}',NULL,'2024-12-31 22:31:32','2024-12-31 22:31:32'),
(842,'default','shipping_edited',546,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2024-12-31 22:33:16','2024-12-31 22:33:16'),
(843,'default','shipping_edited',544,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"4109.7000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"4109.7000\"}}',NULL,'2024-12-31 22:34:04','2024-12-31 22:34:04'),
(844,'default','edited',544,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":4109.6999999999998181010596454143524169921875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"4109.7000\"}}',NULL,'2024-12-31 22:34:57','2024-12-31 22:34:57'),
(845,'default','shipping_edited',487,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1764.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1764.0000\"}}',NULL,'2024-12-31 22:36:20','2024-12-31 22:36:20'),
(846,'default','shipping_edited',534,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2333.1000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2333.1000\"}}',NULL,'2024-12-31 22:37:51','2024-12-31 22:37:51'),
(847,'default','shipping_edited',535,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 22:38:40','2024-12-31 22:38:40'),
(848,'default','shipping_edited',536,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 22:39:12','2024-12-31 22:39:12'),
(849,'default','shipping_edited',454,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1050.0000\"}}',NULL,'2024-12-31 22:41:29','2024-12-31 22:41:29'),
(850,'default','shipping_edited',451,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2419.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2419.9000\"}}',NULL,'2024-12-31 22:42:00','2024-12-31 22:42:00'),
(851,'default','shipping_edited',458,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2024-12-31 22:42:48','2024-12-31 22:42:48'),
(852,'default','shipping_edited',463,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1795.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1795.5000\"}}',NULL,'2024-12-31 22:43:42','2024-12-31 22:43:42'),
(853,'default','shipping_edited',472,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1050.0000\"}}',NULL,'2024-12-31 22:44:19','2024-12-31 22:44:19'),
(854,'default','shipping_edited',481,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2024-12-31 22:44:52','2024-12-31 22:44:52'),
(855,'default','shipping_edited',494,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"}}',NULL,'2024-12-31 22:45:29','2024-12-31 22:45:29'),
(856,'default','shipping_edited',514,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1365.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1365.0000\"}}',NULL,'2024-12-31 22:46:18','2024-12-31 22:46:18'),
(857,'default','shipping_edited',526,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1050.0000\"}}',NULL,'2024-12-31 22:46:48','2024-12-31 22:46:48'),
(858,'default','shipping_edited',521,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"535.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"535.5000\"}}',NULL,'2024-12-31 22:47:19','2024-12-31 22:47:19'),
(859,'default','shipping_edited',531,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 22:53:46','2024-12-31 22:53:46'),
(860,'default','shipping_edited',532,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 22:54:31','2024-12-31 22:54:31'),
(861,'default','shipping_edited',533,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2798.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2798.6000\"}}',NULL,'2024-12-31 22:55:21','2024-12-31 22:55:21'),
(862,'default','shipping_edited',575,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1706.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1706.6000\"}}',NULL,'2024-12-31 22:57:00','2024-12-31 22:57:00'),
(863,'default','shipping_edited',571,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 22:57:33','2024-12-31 22:57:33'),
(864,'default','shipping_edited',573,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1070.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1070.3000\"}}',NULL,'2024-12-31 22:58:02','2024-12-31 22:58:02'),
(865,'default','shipping_edited',576,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2024-12-31 22:58:36','2024-12-31 22:58:36'),
(866,'default','shipping_edited',568,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2024-12-31 22:59:04','2024-12-31 22:59:04'),
(867,'default','shipping_edited',567,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2518.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2518.6000\"}}',NULL,'2024-12-31 22:59:43','2024-12-31 22:59:43'),
(868,'default','shipping_edited',491,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1818.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1818.6000\"}}',NULL,'2024-12-31 23:05:45','2024-12-31 23:05:45'),
(869,'default','shipping_edited',493,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-12-31 23:06:14','2024-12-31 23:06:14'),
(870,'default','shipping_edited',517,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"}}',NULL,'2024-12-31 23:07:05','2024-12-31 23:07:05'),
(871,'default','shipping_edited',512,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2024-12-31 23:07:58','2024-12-31 23:07:58'),
(872,'default','shipping_edited',489,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2024-12-31 23:08:27','2024-12-31 23:08:27'),
(873,'default','shipping_edited',496,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"6423.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"6423.9000\"}}',NULL,'2024-12-31 23:09:03','2024-12-31 23:09:04'),
(874,'default','shipping_edited',441,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1795.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1795.5000\"}}',NULL,'2024-12-31 23:09:36','2024-12-31 23:09:36'),
(875,'default','shipping_edited',434,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1827.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1827.0000\"}}',NULL,'2024-12-31 23:10:36','2024-12-31 23:10:36'),
(876,'default','shipping_edited',523,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 23:11:08','2024-12-31 23:11:08'),
(877,'default','shipping_edited',519,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 23:11:36','2024-12-31 23:11:36'),
(878,'default','shipping_edited',522,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 23:12:06','2024-12-31 23:12:06'),
(879,'default','shipping_edited',525,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 23:12:38','2024-12-31 23:12:38'),
(880,'default','shipping_edited',524,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 23:12:55','2024-12-31 23:12:55'),
(881,'default','shipping_edited',518,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 23:13:25','2024-12-31 23:13:26'),
(882,'default','shipping_edited',527,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 23:14:06','2024-12-31 23:14:06'),
(883,'default','shipping_edited',513,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 23:14:40','2024-12-31 23:14:40'),
(884,'default','shipping_edited',511,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 23:15:08','2024-12-31 23:15:08'),
(885,'default','shipping_edited',510,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 23:15:31','2024-12-31 23:15:31'),
(886,'default','shipping_edited',515,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 23:16:53','2024-12-31 23:16:53'),
(887,'default','shipping_edited',508,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2024-12-31 23:18:17','2024-12-31 23:18:17'),
(888,'default','shipping_edited',495,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"}}',NULL,'2024-12-31 23:18:38','2024-12-31 23:18:38'),
(889,'default','shipping_edited',528,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2024-12-31 23:19:39','2024-12-31 23:19:39'),
(890,'default','shipping_edited',520,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1958.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1958.6000\"}}',NULL,'2024-12-31 23:20:18','2024-12-31 23:20:18'),
(891,'default','shipping_edited',490,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2024-12-31 23:20:55','2024-12-31 23:20:55'),
(892,'default','added',578,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":5144.3000000000001818989403545856475830078125}}',NULL,'2025-01-01 20:04:05','2025-01-01 20:04:05'),
(893,'default','added',579,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2025-01-01 20:05:34','2025-01-01 20:05:34'),
(894,'default','added',580,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2025-01-01 20:06:19','2025-01-01 20:06:19'),
(895,'default','added',581,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875}}',NULL,'2025-01-01 20:07:11','2025-01-01 20:07:11'),
(896,'default','added',582,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875}}',NULL,'2025-01-01 20:07:57','2025-01-01 20:07:57'),
(897,'default','added',583,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":979.299999999999954525264911353588104248046875}}',NULL,'2025-01-01 20:09:58','2025-01-01 20:09:58'),
(898,'default','edited',582,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-01-01 20:10:24','2025-01-01 20:10:24'),
(899,'default','shipping_edited',509,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2025-01-01 20:11:44','2025-01-01 20:11:44'),
(900,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-01-02 00:24:03','2025-01-02 00:24:03'),
(901,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-01-02 16:14:00','2025-01-02 16:14:00'),
(902,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-01-02 17:09:09','2025-01-02 17:09:09'),
(903,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-01-02 17:53:34','2025-01-02 17:53:34'),
(904,'default','login',13,'App\\User',NULL,2,13,'App\\User','[]',NULL,'2025-01-04 11:01:01','2025-01-04 11:01:01'),
(905,'default','sell_deleted',584,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":584,\"invoice_no\":\"P58081\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:05:13','2025-01-04 11:05:13'),
(906,'default','sell_deleted',585,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":585,\"invoice_no\":\"P58081\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:44','2025-01-04 11:31:44'),
(907,'default','sell_deleted',586,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":586,\"invoice_no\":\"P58061\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:44','2025-01-04 11:31:44'),
(908,'default','sell_deleted',587,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":587,\"invoice_no\":\"P58060\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:44','2025-01-04 11:31:44'),
(909,'default','sell_deleted',588,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":588,\"invoice_no\":\"P58015\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:44','2025-01-04 11:31:44'),
(910,'default','sell_deleted',589,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":589,\"invoice_no\":\"P58013\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:44','2025-01-04 11:31:44'),
(911,'default','sell_deleted',590,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":590,\"invoice_no\":\"P58010\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:44','2025-01-04 11:31:44'),
(912,'default','sell_deleted',591,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":591,\"invoice_no\":\"P58005\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:44','2025-01-04 11:31:44'),
(913,'default','sell_deleted',592,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":592,\"invoice_no\":\"P57980\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:44','2025-01-04 11:31:44'),
(914,'default','sell_deleted',593,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":593,\"invoice_no\":\"P57969\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:44','2025-01-04 11:31:44'),
(915,'default','sell_deleted',594,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":594,\"invoice_no\":\"P57947\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:44','2025-01-04 11:31:44'),
(916,'default','sell_deleted',595,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":595,\"invoice_no\":\"P57897\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:44','2025-01-04 11:31:44'),
(917,'default','sell_deleted',596,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":596,\"invoice_no\":\"P57853\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:44','2025-01-04 11:31:44'),
(918,'default','sell_deleted',597,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":597,\"invoice_no\":\"P57870\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:44','2025-01-04 11:31:44'),
(919,'default','sell_deleted',598,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":598,\"invoice_no\":\"P57877\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:44','2025-01-04 11:31:44'),
(920,'default','sell_deleted',599,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":599,\"invoice_no\":\"P57832\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:44','2025-01-04 11:31:44'),
(921,'default','sell_deleted',600,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":600,\"invoice_no\":\"P57894\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:44','2025-01-04 11:31:44'),
(922,'default','sell_deleted',601,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":601,\"invoice_no\":\"P57830\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:45','2025-01-04 11:31:45'),
(923,'default','sell_deleted',602,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":602,\"invoice_no\":\"P57931\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-04 11:31:45','2025-01-04 11:31:45'),
(924,'default','added',603,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2025-01-04 16:44:41','2025-01-04 16:44:41'),
(925,'default','added',604,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2025-01-04 16:46:02','2025-01-04 16:46:02'),
(926,'default','sell_deleted',603,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":603,\"invoice_no\":\"P54515\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-04 16:47:10','2025-01-04 16:47:10'),
(927,'default','added',605,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2025-01-04 16:47:55','2025-01-04 16:47:55'),
(928,'default','added',606,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":3716.3000000000001818989403545856475830078125}}',NULL,'2025-01-04 16:51:17','2025-01-04 16:51:17'),
(929,'default','added',607,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":525}}',NULL,'2025-01-04 16:52:14','2025-01-04 16:52:14'),
(930,'default','added',608,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":535.5}}',NULL,'2025-01-04 16:56:47','2025-01-04 16:56:47'),
(931,'default','added',609,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2518.59999999999990905052982270717620849609375}}',NULL,'2025-01-04 16:58:03','2025-01-04 16:58:03'),
(932,'default','added',610,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2025-01-04 16:59:08','2025-01-04 16:59:08'),
(933,'default','added',611,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2141.3000000000001818989403545856475830078125}}',NULL,'2025-01-04 17:00:24','2025-01-04 17:00:24'),
(934,'default','added',612,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2025-01-04 17:01:45','2025-01-04 17:01:45'),
(935,'default','added',613,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":1102.5}}',NULL,'2025-01-04 17:02:38','2025-01-04 17:02:38'),
(936,'default','added',614,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2025-01-04 17:03:32','2025-01-04 17:03:32'),
(937,'default','sell_deleted',614,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":614,\"invoice_no\":\"P54534\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-01-04 17:04:18','2025-01-04 17:04:18'),
(938,'default','added',615,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":2518.59999999999990905052982270717620849609375}}',NULL,'2025-01-04 17:05:13','2025-01-04 17:05:13'),
(939,'default','added',616,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":1007.299999999999954525264911353588104248046875}}',NULL,'2025-01-04 17:06:08','2025-01-04 17:06:08'),
(940,'default','added',617,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":2141.3000000000001818989403545856475830078125}}',NULL,'2025-01-04 17:07:15','2025-01-04 17:07:15'),
(941,'default','shipping_edited',605,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-04 17:09:21','2025-01-04 17:09:21'),
(942,'default','shipping_edited',604,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-04 17:10:03','2025-01-04 17:10:03'),
(943,'default','shipping_edited',606,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"3716.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"3716.3000\"}}',NULL,'2025-01-04 17:10:35','2025-01-04 17:10:35'),
(944,'default','shipping_edited',607,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"}}',NULL,'2025-01-04 17:10:56','2025-01-04 17:10:56'),
(945,'default','sell_deleted',608,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":608,\"invoice_no\":\"P54610\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"535.5000\"}}',NULL,'2025-01-04 17:11:23','2025-01-04 17:11:23'),
(946,'default','shipping_edited',609,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2518.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2518.6000\"}}',NULL,'2025-01-04 17:11:58','2025-01-04 17:11:58'),
(947,'default','shipping_edited',610,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-01-04 17:12:26','2025-01-04 17:12:26'),
(948,'default','shipping_edited',611,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2025-01-04 17:12:57','2025-01-04 17:12:57'),
(949,'default','shipping_edited',612,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-04 17:13:20','2025-01-04 17:13:20'),
(950,'default','shipping_edited',613,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1102.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1102.5000\"}}',NULL,'2025-01-04 17:13:46','2025-01-04 17:13:46'),
(951,'default','shipping_edited',615,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2518.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2518.6000\"}}',NULL,'2025-01-04 17:14:08','2025-01-04 17:14:08'),
(952,'default','shipping_edited',616,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"}}',NULL,'2025-01-04 17:14:34','2025-01-04 17:14:34'),
(953,'default','shipping_edited',617,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2025-01-04 17:15:00','2025-01-04 17:15:00'),
(954,'default','added',618,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":1365}}',NULL,'2025-01-04 17:17:24','2025-01-04 17:17:24'),
(955,'default','added',619,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"shipped\",\"payment_status\":\"due\",\"final_total\":1365}}',NULL,'2025-01-04 17:18:29','2025-01-04 17:18:29'),
(956,'default','added',620,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":648.8999999999999772626324556767940521240234375}}',NULL,'2025-01-04 17:19:52','2025-01-04 17:19:52'),
(957,'default','added',621,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":525}}',NULL,'2025-01-04 18:04:08','2025-01-04 18:04:08'),
(958,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-01-04 18:25:02','2025-01-04 18:25:02'),
(959,'default','shipping_edited',569,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"}}',NULL,'2025-01-04 18:33:20','2025-01-04 18:33:20'),
(960,'default','added',622,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2025-01-04 18:35:01','2025-01-04 18:35:01'),
(961,'default','added',623,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":2629.1999999999998181010596454143524169921875}}',NULL,'2025-01-04 18:37:06','2025-01-04 18:37:06'),
(962,'default','added',624,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":525}}',NULL,'2025-01-04 18:43:44','2025-01-04 18:43:44'),
(963,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-01-05 13:31:52','2025-01-05 13:31:52'),
(964,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-01-05 17:41:37','2025-01-05 17:41:37'),
(965,'default','added',625,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.299999999999954525264911353588104248046875}}',NULL,'2025-01-05 18:46:56','2025-01-05 18:46:56'),
(966,'default','added',626,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1243.90000000000009094947017729282379150390625}}',NULL,'2025-01-05 18:48:07','2025-01-05 18:48:07'),
(967,'default','added',627,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1609.299999999999954525264911353588104248046875}}',NULL,'2025-01-05 18:49:59','2025-01-05 18:49:59'),
(968,'default','added',628,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1399.299999999999954525264911353588104248046875}}',NULL,'2025-01-05 18:51:12','2025-01-05 18:51:12'),
(969,'default','added',629,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2025-01-05 18:53:26','2025-01-05 18:53:26'),
(970,'default','added',630,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.799999999999954525264911353588104248046875}}',NULL,'2025-01-05 18:54:40','2025-01-05 18:54:40'),
(971,'default','added',631,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":150}}',NULL,'2025-01-05 18:57:17','2025-01-05 18:57:17'),
(972,'default','added',632,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.299999999999954525264911353588104248046875}}',NULL,'2025-01-05 18:59:39','2025-01-05 18:59:39'),
(973,'default','added',633,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875}}',NULL,'2025-01-05 19:03:14','2025-01-05 19:03:14'),
(974,'default','added',634,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":693}}',NULL,'2025-01-05 19:04:19','2025-01-05 19:04:19'),
(975,'default','added',635,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875}}',NULL,'2025-01-05 19:05:06','2025-01-05 19:05:06'),
(976,'default','added',636,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":693}}',NULL,'2025-01-05 19:06:21','2025-01-05 19:06:21'),
(977,'default','added',637,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":648.8999999999999772626324556767940521240234375}}',NULL,'2025-01-05 19:07:51','2025-01-05 19:07:51'),
(978,'default','added',638,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1832.59999999999990905052982270717620849609375}}',NULL,'2025-01-05 19:09:17','2025-01-05 19:09:17'),
(979,'default','added',639,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2148.3000000000001818989403545856475830078125}}',NULL,'2025-01-05 19:10:36','2025-01-05 19:10:36'),
(980,'default','added',640,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.299999999999954525264911353588104248046875}}',NULL,'2025-01-05 19:25:00','2025-01-05 19:25:00'),
(981,'default','added',641,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":3119.90000000000009094947017729282379150390625}}',NULL,'2025-01-05 19:27:41','2025-01-05 19:27:41'),
(982,'default','added',642,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.799999999999954525264911353588104248046875}}',NULL,'2025-01-05 19:30:17','2025-01-05 19:30:17'),
(983,'default','added',643,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1858.5}}',NULL,'2025-01-05 19:34:44','2025-01-05 19:34:44'),
(984,'default','added',644,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1225}}',NULL,'2025-01-05 19:35:37','2025-01-05 19:35:37'),
(985,'default','added',645,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.90000000000009094947017729282379150390625}}',NULL,'2025-01-05 19:37:37','2025-01-05 19:37:37'),
(986,'default','added',646,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2078.3000000000001818989403545856475830078125}}',NULL,'2025-01-05 19:38:26','2025-01-05 19:38:26'),
(987,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-01-06 20:58:55','2025-01-06 20:58:55'),
(988,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-01-07 21:47:18','2025-01-07 21:47:18'),
(989,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-01-13 10:30:35','2025-01-13 10:30:35'),
(990,'default','added',647,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2069.2}}',NULL,'2025-01-13 10:51:04','2025-01-13 10:51:04'),
(991,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-01-13 12:35:26','2025-01-13 12:35:26'),
(992,'default','sell_deleted',672,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":672,\"invoice_no\":\"0113\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-13 12:49:54','2025-01-13 12:49:54'),
(993,'default','sell_deleted',673,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":673,\"invoice_no\":\"0114\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-13 12:49:54','2025-01-13 12:49:54'),
(994,'default','sell_deleted',674,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":674,\"invoice_no\":\"0115\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-13 12:49:54','2025-01-13 12:49:54'),
(995,'default','sell_deleted',675,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":675,\"invoice_no\":\"0116\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-13 12:49:54','2025-01-13 12:49:54'),
(996,'default','sell_deleted',676,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":676,\"invoice_no\":\"0117\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-13 12:49:54','2025-01-13 12:49:54'),
(997,'default','sell_deleted',677,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":677,\"invoice_no\":\"0118\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-13 12:49:54','2025-01-13 12:49:54'),
(998,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-01-13 13:15:53','2025-01-13 13:15:53'),
(999,'default','edited',685,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2069.2},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-13 13:18:06','2025-01-13 13:18:06'),
(1000,'default','edited',685,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2069.2},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2069.2000\"}}',NULL,'2025-01-13 13:18:42','2025-01-13 13:18:42'),
(1001,'default','sell_deleted',685,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":685,\"invoice_no\":\"P58360\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2069.2000\"}}',NULL,'2025-01-13 13:19:21','2025-01-13 13:19:21'),
(1002,'default','sell_deleted',686,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":686,\"invoice_no\":\"P58353\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-13 13:19:21','2025-01-13 13:19:21'),
(1003,'default','sell_deleted',687,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":687,\"invoice_no\":\"P58342\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-13 13:19:21','2025-01-13 13:19:21'),
(1004,'default','sell_deleted',688,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":688,\"invoice_no\":\"P58341\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-13 13:19:21','2025-01-13 13:19:21'),
(1005,'default','sell_deleted',689,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":689,\"invoice_no\":\"P58305\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-13 13:19:21','2025-01-13 13:19:21'),
(1006,'default','sell_deleted',690,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":690,\"invoice_no\":\"P58297\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-13 13:19:21','2025-01-13 13:19:21'),
(1007,'default','sell_deleted',691,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":691,\"invoice_no\":\"P58289\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-13 13:19:21','2025-01-13 13:19:21'),
(1008,'default','sell_deleted',692,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":692,\"invoice_no\":\"P58282\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-13 13:19:21','2025-01-13 13:19:21'),
(1009,'default','sell_deleted',693,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":693,\"invoice_no\":\"P58277\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-13 13:19:21','2025-01-13 13:19:21'),
(1010,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-01-14 04:47:42','2025-01-14 04:47:42'),
(1011,'default','sell_deleted',647,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":647,\"invoice_no\":\"P58360\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2069.2000\"}}',NULL,'2025-01-14 04:48:52','2025-01-14 04:48:52'),
(1012,'default','edited',730,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2069.2},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-14 04:53:35','2025-01-14 04:53:35'),
(1013,'default','edited',733,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1398.6},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-14 04:54:05','2025-01-14 04:54:05'),
(1014,'default','edited',732,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.9},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-14 04:54:08','2025-01-14 04:54:08'),
(1015,'default','edited',731,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":805},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-14 04:54:29','2025-01-14 04:54:29'),
(1016,'default','edited',738,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1795.5},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-14 04:55:34','2025-01-14 04:55:34'),
(1017,'default','edited',737,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1353.8},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-14 04:55:39','2025-01-14 04:55:39'),
(1018,'default','edited',736,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1007.3},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-14 04:55:44','2025-01-14 04:55:44'),
(1019,'default','edited',735,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.9},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-14 04:55:48','2025-01-14 04:55:48'),
(1020,'default','edited',734,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1369.9},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-01-14 04:55:53','2025-01-14 04:55:53'),
(1021,'default','shipping_edited',730,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2069.2000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2069.2000\"}}',NULL,'2025-01-14 04:56:24','2025-01-14 04:56:24'),
(1022,'default','shipping_edited',731,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"805.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"805.0000\"}}',NULL,'2025-01-14 04:57:01','2025-01-14 04:57:01'),
(1023,'default','shipping_edited',732,'App\\Transaction',NULL,2,2,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-14 04:57:10','2025-01-14 04:57:10'),
(1024,'default','edited',733,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"payment_status\":\"due\",\"final_total\":1398.6},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"}}',NULL,'2025-01-14 04:57:31','2025-01-14 04:57:31'),
(1025,'default','edited',733,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1398.6},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"}}',NULL,'2025-01-14 04:57:36','2025-01-14 04:57:36'),
(1026,'default','edited',733,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1398.6},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"}}',NULL,'2025-01-14 04:57:54','2025-01-14 04:57:54'),
(1027,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-01-14 06:56:33','2025-01-14 06:56:33'),
(1028,'default','added',18,'App\\Contact',NULL,9,14,'App\\User','[]',NULL,'2025-01-14 10:26:14','2025-01-14 10:26:14'),
(1029,'default','added',739,'App\\Transaction',NULL,9,14,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":4250}}',NULL,'2025-01-14 10:26:33','2025-01-14 10:26:33'),
(1030,'default','edited',739,'App\\Transaction',NULL,9,14,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":4350},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"4250.0000\"}}',NULL,'2025-01-14 10:44:46','2025-01-14 10:44:46'),
(1031,'default','added',742,'App\\Transaction',NULL,9,14,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":129.5}}',NULL,'2025-01-14 10:48:47','2025-01-14 10:48:47'),
(1032,'default','sell_deleted',742,'App\\Transaction',NULL,9,14,'App\\User','{\"id\":742,\"invoice_no\":\"2025\\/0001\",\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":\"129.5000\"}}',NULL,'2025-01-14 10:51:27','2025-01-14 10:51:27'),
(1033,'default','added',743,'App\\Transaction',NULL,9,14,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":11050}}',NULL,'2025-01-14 10:57:53','2025-01-14 10:57:53'),
(1034,'default','added',746,'App\\Transaction',NULL,9,14,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0.86}}',NULL,'2025-01-14 11:16:06','2025-01-14 11:16:06'),
(1035,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-01-14 10:16:28','2025-01-14 10:16:28'),
(1036,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-01-14 10:16:53','2025-01-14 10:16:53'),
(1037,'default','login',14,'App\\User',NULL,9,14,'App\\User','[]',NULL,'2025-01-14 11:17:26','2025-01-14 11:17:26'),
(1038,'default','added',747,'App\\Transaction',NULL,9,14,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43}}',NULL,'2025-01-14 11:17:58','2025-01-14 11:17:58'),
(1039,'default','added',748,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1398.6}}',NULL,'2025-01-14 19:23:12','2025-01-14 19:23:12'),
(1040,'default','added',749,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-14 19:27:40','2025-01-14 19:27:40'),
(1041,'default','added',750,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-14 19:29:18','2025-01-14 19:29:18'),
(1042,'default','added',751,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":882}}',NULL,'2025-01-14 19:30:40','2025-01-14 19:30:40'),
(1043,'default','added',752,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2141.3}}',NULL,'2025-01-14 19:32:17','2025-01-14 19:32:17'),
(1044,'default','added',753,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-14 19:33:12','2025-01-14 19:33:12'),
(1045,'default','added',754,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.3}}',NULL,'2025-01-14 19:34:07','2025-01-14 19:34:07'),
(1046,'default','added',755,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-14 19:35:11','2025-01-14 19:35:11'),
(1047,'default','added',756,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-14 19:36:08','2025-01-14 19:36:08'),
(1048,'default','added',757,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-14 19:36:57','2025-01-14 19:36:57'),
(1049,'default','added',758,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-14 19:39:30','2025-01-14 19:39:30'),
(1050,'default','added',759,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.3}}',NULL,'2025-01-14 19:41:44','2025-01-14 19:41:44'),
(1051,'default','added',760,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-14 19:47:46','2025-01-14 19:47:46'),
(1052,'default','added',761,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2141.3}}',NULL,'2025-01-14 19:48:33','2025-01-14 19:48:33'),
(1053,'default','added',762,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":559}}',NULL,'2025-01-14 19:49:34','2025-01-14 19:49:34'),
(1054,'default','added',763,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.3}}',NULL,'2025-01-14 19:50:35','2025-01-14 19:50:35'),
(1055,'default','added',764,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.8}}',NULL,'2025-01-14 19:51:23','2025-01-14 19:51:23'),
(1056,'default','added',765,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":5796}}',NULL,'2025-01-14 19:57:14','2025-01-14 19:57:14'),
(1057,'default','added',766,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-14 19:58:08','2025-01-14 19:58:08'),
(1058,'default','login',13,'App\\User',NULL,2,13,'App\\User','[]',NULL,'2025-01-28 11:54:57','2025-01-28 11:54:57'),
(1059,'default','added',767,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2898}}',NULL,'2025-01-28 12:10:27','2025-01-28 12:10:27'),
(1060,'default','added',768,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-28 12:15:52','2025-01-28 12:15:52'),
(1061,'default','added',769,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-28 12:17:08','2025-01-28 12:17:08'),
(1062,'default','added',770,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-28 12:21:16','2025-01-28 12:21:16'),
(1063,'default','added',771,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.3}}',NULL,'2025-01-28 12:22:52','2025-01-28 12:22:52'),
(1064,'default','added',772,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.3}}',NULL,'2025-01-28 12:23:42','2025-01-28 12:23:42'),
(1065,'default','added',773,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1449}}',NULL,'2025-01-28 12:24:39','2025-01-28 12:24:39'),
(1066,'default','added',774,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.8}}',NULL,'2025-01-28 12:25:32','2025-01-28 12:25:32'),
(1067,'default','edited',774,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.8},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2025-01-28 12:29:12','2025-01-28 12:29:12'),
(1068,'default','added',775,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":4125.8}}',NULL,'2025-01-28 12:30:56','2025-01-28 12:30:56'),
(1069,'default','added',776,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-28 12:31:51','2025-01-28 12:31:51'),
(1070,'default','added',777,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-28 12:33:07','2025-01-28 12:33:07'),
(1071,'default','added',778,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-28 12:34:53','2025-01-28 12:34:53'),
(1072,'default','added',779,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2140.6}}',NULL,'2025-01-28 12:36:04','2025-01-28 12:36:04'),
(1073,'default','added',780,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":441}}',NULL,'2025-01-28 12:37:13','2025-01-28 12:37:13'),
(1074,'default','added',781,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-28 12:38:11','2025-01-28 12:38:11'),
(1075,'default','added',782,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-28 12:39:24','2025-01-28 12:39:24'),
(1076,'default','added',783,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.3}}',NULL,'2025-01-28 12:40:32','2025-01-28 12:40:32'),
(1077,'default','edited',580,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"cancelled\",\"payment_status\":\"due\",\"final_total\":1369.9},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-28 12:42:11','2025-01-28 12:42:11'),
(1078,'default','shipping_edited',631,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"150.0000\"}}',NULL,'2025-01-28 12:46:02','2025-01-28 12:46:02'),
(1079,'default','shipping_edited',759,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-01-28 12:46:28','2025-01-28 12:46:28'),
(1080,'default','shipping_edited',752,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2025-01-28 12:47:03','2025-01-28 12:47:03'),
(1081,'default','shipping_edited',492,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1071.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1071.0000\"}}',NULL,'2025-01-28 12:47:27','2025-01-28 12:47:27'),
(1082,'default','shipping_edited',570,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"535.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"535.5000\"}}',NULL,'2025-01-28 12:47:56','2025-01-28 12:47:56'),
(1083,'default','shipping_edited',554,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"535.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"535.5000\"}}',NULL,'2025-01-28 12:48:33','2025-01-28 12:48:33'),
(1084,'default','shipping_edited',645,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-28 12:48:58','2025-01-28 12:48:58'),
(1085,'default','shipping_edited',564,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-28 12:49:38','2025-01-28 12:49:38'),
(1086,'default','shipping_edited',551,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-28 12:50:19','2025-01-28 12:50:19'),
(1087,'default','shipping_edited',565,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-28 12:50:42','2025-01-28 12:50:42'),
(1088,'default','shipping_edited',547,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-28 12:51:02','2025-01-28 12:51:02'),
(1089,'default','shipping_edited',734,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-28 12:51:33','2025-01-28 12:51:33'),
(1090,'default','shipping_edited',732,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-28 12:52:12','2025-01-28 12:52:12'),
(1091,'default','shipping_edited',735,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-28 12:53:09','2025-01-28 12:53:09'),
(1092,'default','shipping_edited',730,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2069.2000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2069.2000\"}}',NULL,'2025-01-28 12:54:13','2025-01-28 12:54:13'),
(1093,'default','shipping_edited',737,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2025-01-28 12:54:42','2025-01-28 12:54:42'),
(1094,'default','shipping_edited',756,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-28 12:56:11','2025-01-28 12:56:11'),
(1095,'default','shipping_edited',755,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-28 12:56:33','2025-01-28 12:56:33'),
(1096,'default','shipping_edited',753,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-28 12:58:01','2025-01-28 12:58:01'),
(1097,'default','shipping_edited',754,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-01-28 12:58:28','2025-01-28 12:58:28'),
(1098,'default','shipping_edited',758,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-28 12:58:51','2025-01-28 12:58:51'),
(1099,'default','shipping_edited',749,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-28 12:59:14','2025-01-28 12:59:14'),
(1100,'default','shipping_edited',750,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-28 12:59:42','2025-01-28 12:59:42'),
(1101,'default','shipping_edited',751,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"882.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"882.0000\"}}',NULL,'2025-01-28 13:00:10','2025-01-28 13:00:10'),
(1102,'default','shipping_edited',644,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1225.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1225.0000\"}}',NULL,'2025-01-28 13:00:36','2025-01-28 13:00:36'),
(1103,'default','shipping_edited',635,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-01-28 13:01:00','2025-01-28 13:01:00'),
(1104,'default','shipping_edited',581,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-01-28 13:01:24','2025-01-28 13:01:24'),
(1105,'default','shipping_edited',582,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-01-28 13:01:54','2025-01-28 13:01:54'),
(1106,'default','shipping_edited',633,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-01-28 13:02:30','2025-01-28 13:02:30'),
(1107,'default','shipping_edited',731,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"805.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"805.0000\"}}',NULL,'2025-01-28 13:02:59','2025-01-28 13:02:59'),
(1108,'default','shipping_edited',748,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"}}',NULL,'2025-01-28 13:03:32','2025-01-28 13:03:32'),
(1109,'default','shipping_edited',736,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"}}',NULL,'2025-01-28 13:04:16','2025-01-28 13:04:16'),
(1110,'default','shipping_edited',646,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2078.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2078.3000\"}}',NULL,'2025-01-28 13:04:38','2025-01-28 13:04:38'),
(1111,'default','added',784,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1449}}',NULL,'2025-01-28 20:24:13','2025-01-28 20:24:13'),
(1112,'default','added',785,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1896.3}}',NULL,'2025-01-28 20:26:59','2025-01-28 20:26:59'),
(1113,'default','added',786,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1070.3}}',NULL,'2025-01-28 20:28:07','2025-01-28 20:28:07'),
(1114,'default','added',787,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-28 20:31:56','2025-01-28 20:31:56'),
(1115,'default','added',788,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-28 20:35:30','2025-01-28 20:35:30'),
(1116,'default','added',789,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-28 20:37:17','2025-01-28 20:37:17'),
(1117,'default','added',790,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1398.6}}',NULL,'2025-01-28 20:41:24','2025-01-28 20:41:24'),
(1118,'default','added',791,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-28 20:43:01','2025-01-28 20:43:01'),
(1119,'default','added',792,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-28 20:48:19','2025-01-28 20:48:19'),
(1120,'default','added',793,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.3}}',NULL,'2025-01-28 20:49:27','2025-01-28 20:49:27'),
(1121,'default','added',794,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2487.8}}',NULL,'2025-01-28 20:51:53','2025-01-28 20:51:53'),
(1122,'default','added',795,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-28 20:53:20','2025-01-28 20:53:20'),
(1123,'default','added',796,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-28 20:54:33','2025-01-28 20:54:33'),
(1124,'default','added',797,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2141.3}}',NULL,'2025-01-28 20:56:16','2025-01-28 20:56:16'),
(1125,'default','added',798,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-28 20:57:21','2025-01-28 20:57:21'),
(1126,'default','added',799,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.3}}',NULL,'2025-01-28 20:58:28','2025-01-28 20:58:28'),
(1127,'default','added',800,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.3}}',NULL,'2025-01-28 20:59:23','2025-01-28 20:59:23'),
(1128,'default','edited',800,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.3},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-01-28 20:59:58','2025-01-28 20:59:58'),
(1129,'default','added',801,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-28 21:04:52','2025-01-28 21:04:52'),
(1130,'default','added',802,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":5796}}',NULL,'2025-01-28 21:06:29','2025-01-28 21:06:29'),
(1131,'default','added',803,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1399.3}}',NULL,'2025-01-28 21:07:52','2025-01-28 21:07:52'),
(1132,'default','added',804,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":913.5}}',NULL,'2025-01-28 21:12:38','2025-01-28 21:12:38'),
(1133,'default','added',805,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.8}}',NULL,'2025-01-28 21:13:52','2025-01-28 21:13:52'),
(1134,'default','added',806,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-28 21:14:45','2025-01-28 21:14:45'),
(1135,'default','added',807,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":4645.9}}',NULL,'2025-01-28 21:16:35','2025-01-28 21:16:35'),
(1136,'default','added',808,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-28 21:17:37','2025-01-28 21:17:37'),
(1137,'default','added',809,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-28 21:18:42','2025-01-28 21:18:42'),
(1138,'default','added',810,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-28 21:20:04','2025-01-28 21:20:04'),
(1139,'default','added',811,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-28 21:21:21','2025-01-28 21:21:21'),
(1140,'default','added',812,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1007.3}}',NULL,'2025-01-28 21:23:44','2025-01-28 21:23:44'),
(1141,'default','added',813,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-28 21:25:09','2025-01-28 21:25:09'),
(1142,'default','added',814,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2141.3}}',NULL,'2025-01-28 21:26:02','2025-01-28 21:26:02'),
(1143,'default','added',815,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":441}}',NULL,'2025-01-28 21:40:12','2025-01-28 21:40:12'),
(1144,'default','added',816,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2518.6}}',NULL,'2025-01-28 21:42:26','2025-01-28 21:42:26'),
(1145,'default','added',817,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":913.5}}',NULL,'2025-01-28 21:43:45','2025-01-28 21:43:45'),
(1146,'default','added',818,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":913.5}}',NULL,'2025-01-28 21:45:02','2025-01-28 21:45:02'),
(1147,'default','added',819,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":693}}',NULL,'2025-01-28 21:46:00','2025-01-28 21:46:00'),
(1148,'default','added',820,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-28 21:47:17','2025-01-28 21:47:17'),
(1149,'default','added',821,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":805}}',NULL,'2025-01-28 21:48:19','2025-01-28 21:48:19'),
(1150,'default','added',822,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-28 21:49:33','2025-01-28 21:49:33'),
(1151,'default','added',823,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-28 21:50:42','2025-01-28 21:50:42'),
(1152,'default','added',824,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1243.9}}',NULL,'2025-01-28 21:51:30','2025-01-28 21:51:30'),
(1153,'default','added',825,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-28 21:52:38','2025-01-28 21:52:38'),
(1154,'default','added',826,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2643.2}}',NULL,'2025-01-28 21:55:58','2025-01-28 21:55:58'),
(1155,'default','added',827,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1228.5}}',NULL,'2025-01-28 21:56:55','2025-01-28 21:56:55'),
(1156,'default','added',828,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.3}}',NULL,'2025-01-28 21:57:56','2025-01-28 21:57:56'),
(1157,'default','added',829,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":1369.9}}',NULL,'2025-01-28 21:59:05','2025-01-28 21:59:05'),
(1158,'default','edited',829,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"paid\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-28 21:59:22','2025-01-28 21:59:22'),
(1159,'default','added',830,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-28 22:00:45','2025-01-28 22:00:45'),
(1160,'default','added',831,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.3}}',NULL,'2025-01-28 22:01:43','2025-01-28 22:01:43'),
(1161,'default','added',832,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.3}}',NULL,'2025-01-28 22:05:22','2025-01-28 22:05:22'),
(1162,'default','added',833,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-28 22:06:05','2025-01-28 22:06:05'),
(1163,'default','added',834,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1449}}',NULL,'2025-01-28 22:07:04','2025-01-28 22:07:04'),
(1164,'default','added',835,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1399.3}}',NULL,'2025-01-28 22:07:56','2025-01-28 22:07:56'),
(1165,'default','added',836,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1225}}',NULL,'2025-01-28 22:09:24','2025-01-28 22:09:24'),
(1166,'default','added',837,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-28 22:10:50','2025-01-28 22:10:50'),
(1167,'default','added',838,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-29 18:59:34','2025-01-29 18:59:34'),
(1168,'default','added',839,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1398.6}}',NULL,'2025-01-29 19:01:00','2025-01-29 19:01:00'),
(1169,'default','added',840,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2518.6}}',NULL,'2025-01-29 19:02:18','2025-01-29 19:02:18'),
(1170,'default','added',841,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.8}}',NULL,'2025-01-29 19:03:22','2025-01-29 19:03:22'),
(1171,'default','added',842,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2141.3}}',NULL,'2025-01-29 19:04:55','2025-01-29 19:04:55'),
(1172,'default','added',843,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2266.6}}',NULL,'2025-01-29 19:06:01','2025-01-29 19:06:01'),
(1173,'default','added',844,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":693}}',NULL,'2025-01-29 19:07:18','2025-01-29 19:07:18'),
(1174,'default','added',845,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-29 19:08:27','2025-01-29 19:08:27'),
(1175,'default','added',846,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-29 19:09:44','2025-01-29 19:09:44'),
(1176,'default','added',847,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2141.3}}',NULL,'2025-01-29 19:10:57','2025-01-29 19:10:57'),
(1177,'default','added',848,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1070.3}}',NULL,'2025-01-29 19:12:02','2025-01-29 19:12:02'),
(1178,'default','added',849,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-29 19:12:47','2025-01-29 19:12:47'),
(1179,'default','added',850,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":525}}',NULL,'2025-01-30 10:25:41','2025-01-30 10:25:41'),
(1180,'default','added',851,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":693}}',NULL,'2025-01-30 10:26:52','2025-01-30 10:26:52'),
(1181,'default','added',852,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-01-30 10:27:58','2025-01-30 10:27:58'),
(1182,'default','added',853,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":6360.9}}',NULL,'2025-01-30 10:29:21','2025-01-30 10:29:21'),
(1183,'default','shipping_edited',766,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 10:40:23','2025-01-30 10:40:23'),
(1184,'default','shipping_edited',769,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 10:40:48','2025-01-30 10:40:48'),
(1185,'default','shipping_edited',765,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"5796.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"5796.0000\"}}',NULL,'2025-01-30 10:41:34','2025-01-30 10:41:34'),
(1186,'default','shipping_edited',549,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"150.0000\"}}',NULL,'2025-01-30 10:42:08','2025-01-30 10:42:08'),
(1187,'default','shipping_edited',760,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 10:42:43','2025-01-30 10:42:43'),
(1188,'default','shipping_edited',762,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"559.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"559.0000\"}}',NULL,'2025-01-30 10:43:32','2025-01-30 10:43:32'),
(1189,'default','shipping_edited',768,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 10:44:48','2025-01-30 10:44:48'),
(1190,'default','shipping_edited',764,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2025-01-30 10:45:22','2025-01-30 10:45:22'),
(1191,'default','shipping_edited',767,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2898.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2898.0000\"}}',NULL,'2025-01-30 10:46:04','2025-01-30 10:46:04'),
(1192,'default','shipping_edited',771,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-01-30 10:46:41','2025-01-30 10:46:41'),
(1193,'default','shipping_edited',772,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-01-30 10:47:34','2025-01-30 10:47:34'),
(1194,'default','shipping_edited',763,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-01-30 10:48:02','2025-01-30 10:48:02'),
(1195,'default','shipping_edited',761,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2025-01-30 10:48:28','2025-01-30 10:48:28'),
(1196,'default','shipping_edited',780,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"}}',NULL,'2025-01-30 10:55:39','2025-01-30 10:55:39'),
(1197,'default','shipping_edited',783,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-01-30 10:56:07','2025-01-30 10:56:07'),
(1198,'default','shipping_edited',783,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-01-30 10:56:20','2025-01-30 10:56:20'),
(1199,'default','shipping_edited',782,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 10:56:48','2025-01-30 10:56:48'),
(1200,'default','shipping_edited',782,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 10:57:09','2025-01-30 10:57:09'),
(1201,'default','shipping_edited',781,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 10:57:30','2025-01-30 10:57:30'),
(1202,'default','shipping_edited',778,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 10:58:45','2025-01-30 10:58:45'),
(1203,'default','shipping_edited',770,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 10:59:09','2025-01-30 10:59:09'),
(1204,'default','shipping_edited',779,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2140.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2140.6000\"}}',NULL,'2025-01-30 10:59:29','2025-01-30 10:59:29'),
(1205,'default','shipping_edited',774,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2025-01-30 11:00:29','2025-01-30 11:00:29'),
(1206,'default','shipping_edited',773,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"}}',NULL,'2025-01-30 11:00:52','2025-01-30 11:00:52'),
(1207,'default','shipping_edited',632,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-01-30 11:01:24','2025-01-30 11:01:24'),
(1208,'default','shipping_edited',643,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1858.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1858.5000\"}}',NULL,'2025-01-30 11:01:52','2025-01-30 11:01:52'),
(1209,'default','shipping_edited',776,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 11:02:17','2025-01-30 11:02:17'),
(1210,'default','shipping_edited',777,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 11:02:43','2025-01-30 11:02:43'),
(1211,'default','shipping_edited',775,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"4125.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"4125.8000\"}}',NULL,'2025-01-30 11:03:52','2025-01-30 11:03:52'),
(1212,'default','added',854,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-30 11:14:04','2025-01-30 11:14:04'),
(1213,'default','added',855,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":1398.6}}',NULL,'2025-01-30 11:15:28','2025-01-30 11:15:28'),
(1214,'default','shipping_edited',854,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 11:15:47','2025-01-30 11:15:47'),
(1215,'default','added',856,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-30 11:17:01','2025-01-30 11:17:01'),
(1216,'default','added',857,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.3}}',NULL,'2025-01-30 11:20:03','2025-01-30 11:20:03'),
(1217,'default','added',858,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":1449}}',NULL,'2025-01-30 11:21:32','2025-01-30 11:21:32'),
(1218,'default','added',859,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":979.3}}',NULL,'2025-01-30 11:22:56','2025-01-30 11:22:56'),
(1219,'default','added',860,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-30 11:35:15','2025-01-30 11:35:15'),
(1220,'default','added',861,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-30 11:40:34','2025-01-30 11:40:34'),
(1221,'default','added',862,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-01-30 11:42:21','2025-01-30 11:42:21'),
(1222,'default','added',863,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1243.9}}',NULL,'2025-01-30 11:44:08','2025-01-30 11:44:08'),
(1223,'default','shipping_edited',813,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 11:47:02','2025-01-30 11:47:02'),
(1224,'default','shipping_edited',820,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 11:48:15','2025-01-30 11:48:15'),
(1225,'default','shipping_edited',821,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"805.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"805.0000\"}}',NULL,'2025-01-30 11:49:37','2025-01-30 11:49:37'),
(1226,'default','shipping_edited',823,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 11:49:55','2025-01-30 11:49:55'),
(1227,'default','shipping_edited',811,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 11:50:11','2025-01-30 11:50:11'),
(1228,'default','shipping_edited',808,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 11:50:56','2025-01-30 11:50:56'),
(1229,'default','shipping_edited',804,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2025-01-30 11:51:20','2025-01-30 11:51:20'),
(1230,'default','shipping_edited',829,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 11:51:42','2025-01-30 11:51:42'),
(1231,'default','shipping_edited',830,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 11:51:59','2025-01-30 11:51:59'),
(1232,'default','shipping_edited',819,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"}}',NULL,'2025-01-30 11:52:19','2025-01-30 11:52:19'),
(1233,'default','shipping_edited',803,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1399.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1399.3000\"}}',NULL,'2025-01-30 11:52:46','2025-01-30 11:52:46'),
(1234,'default','shipping_edited',827,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1228.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1228.5000\"}}',NULL,'2025-01-30 11:53:00','2025-01-30 11:53:00'),
(1235,'default','shipping_edited',817,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2025-01-30 11:53:15','2025-01-30 11:53:15'),
(1236,'default','shipping_edited',818,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2025-01-30 11:53:38','2025-01-30 11:53:38'),
(1237,'default','shipping_edited',815,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"}}',NULL,'2025-01-30 11:53:51','2025-01-30 11:53:51'),
(1238,'default','shipping_edited',825,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 11:54:06','2025-01-30 11:54:06'),
(1239,'default','shipping_edited',822,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 11:54:26','2025-01-30 11:54:26'),
(1240,'default','shipping_edited',810,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 11:54:53','2025-01-30 11:54:53'),
(1241,'default','shipping_edited',806,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 11:55:13','2025-01-30 11:55:13'),
(1242,'default','shipping_edited',802,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"5796.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"5796.0000\"}}',NULL,'2025-01-30 11:55:34','2025-01-30 11:55:34'),
(1243,'default','shipping_edited',814,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2025-01-30 11:55:52','2025-01-30 11:55:52'),
(1244,'default','shipping_edited',816,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2518.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2518.6000\"}}',NULL,'2025-01-30 11:56:17','2025-01-30 11:56:17'),
(1245,'default','shipping_edited',826,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2643.2000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2643.2000\"}}',NULL,'2025-01-30 11:56:39','2025-01-30 11:56:39'),
(1246,'default','shipping_edited',824,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1243.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1243.9000\"}}',NULL,'2025-01-30 11:57:03','2025-01-30 11:57:03'),
(1247,'default','shipping_edited',805,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2025-01-30 11:57:21','2025-01-30 11:57:21'),
(1248,'default','shipping_edited',812,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"}}',NULL,'2025-01-30 11:57:57','2025-01-30 11:57:57'),
(1249,'default','shipping_edited',757,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 12:01:02','2025-01-30 12:01:02'),
(1250,'default','shipping_edited',863,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1243.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1243.9000\"}}',NULL,'2025-01-30 15:59:52','2025-01-30 15:59:52'),
(1251,'default','shipping_edited',640,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-01-30 16:00:18','2025-01-30 16:00:18'),
(1252,'default','shipping_edited',860,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 16:01:29','2025-01-30 16:01:29'),
(1253,'default','sell_deleted',861,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":861,\"invoice_no\":\"P58397\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 16:01:57','2025-01-30 16:01:57'),
(1254,'default','shipping_edited',862,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 16:02:19','2025-01-30 16:02:19'),
(1255,'default','shipping_edited',857,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"cancelled\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-01-30 16:15:26','2025-01-30 16:15:26'),
(1256,'default','shipping_edited',558,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"cancelled\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 16:16:17','2025-01-30 16:16:17'),
(1257,'default','shipping_edited',642,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2025-01-30 16:22:48','2025-01-30 16:22:48'),
(1258,'default','shipping_edited',639,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2148.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2148.3000\"}}',NULL,'2025-01-30 16:23:14','2025-01-30 16:23:14'),
(1259,'default','shipping_edited',637,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"648.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"648.9000\"}}',NULL,'2025-01-30 16:23:32','2025-01-30 16:23:32'),
(1260,'default','shipping_edited',641,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"3119.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"3119.9000\"}}',NULL,'2025-01-30 16:23:51','2025-01-30 16:23:51'),
(1261,'default','shipping_edited',638,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1832.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1832.6000\"}}',NULL,'2025-01-30 16:24:12','2025-01-30 16:24:12'),
(1262,'default','shipping_edited',636,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"}}',NULL,'2025-01-30 16:24:32','2025-01-30 16:24:32'),
(1263,'default','shipping_edited',625,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 16:24:55','2025-01-30 16:24:55'),
(1264,'default','shipping_edited',634,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"}}',NULL,'2025-01-30 16:25:16','2025-01-30 16:25:16'),
(1265,'default','shipping_edited',630,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2025-01-30 16:26:24','2025-01-30 16:26:24'),
(1266,'default','shipping_edited',578,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"5144.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"5144.3000\"}}',NULL,'2025-01-30 16:28:04','2025-01-30 16:28:04'),
(1267,'default','shipping_edited',628,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1399.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1399.3000\"}}',NULL,'2025-01-30 16:28:23','2025-01-30 16:28:23'),
(1268,'default','shipping_edited',577,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1609.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1609.3000\"}}',NULL,'2025-01-30 16:28:39','2025-01-30 16:28:39'),
(1269,'default','shipping_edited',627,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1609.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1609.3000\"}}',NULL,'2025-01-30 16:28:58','2025-01-30 16:28:58'),
(1270,'default','shipping_edited',626,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1243.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1243.9000\"}}',NULL,'2025-01-30 16:29:29','2025-01-30 16:29:29'),
(1271,'default','shipping_edited',629,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-01-30 16:29:43','2025-01-30 16:29:43'),
(1272,'default','shipping_edited',579,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 16:29:58','2025-01-30 16:29:58'),
(1273,'default','shipping_edited',560,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"}}',NULL,'2025-01-30 16:30:49','2025-01-30 16:30:49'),
(1274,'default','shipping_edited',563,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2208.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2208.5000\"}}',NULL,'2025-01-30 16:31:12','2025-01-30 16:31:12'),
(1275,'default','shipping_edited',566,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2025-01-30 16:31:38','2025-01-30 16:31:38'),
(1276,'default','shipping_edited',559,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2025-01-30 16:32:01','2025-01-30 16:32:01'),
(1277,'default','shipping_edited',529,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2025-01-30 16:32:23','2025-01-30 16:32:23'),
(1278,'default','shipping_edited',583,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"979.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"979.3000\"}}',NULL,'2025-01-30 16:32:41','2025-01-30 16:32:41'),
(1279,'default','shipping_edited',574,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1228.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1228.5000\"}}',NULL,'2025-01-30 16:33:01','2025-01-30 16:33:01'),
(1280,'default','shipping_edited',572,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2025-01-30 16:33:22','2025-01-30 16:33:22'),
(1281,'default','shipping_edited',845,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 19:31:52','2025-01-30 19:31:52'),
(1282,'default','shipping_edited',846,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 19:32:21','2025-01-30 19:32:21'),
(1283,'default','shipping_edited',832,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-01-30 19:32:59','2025-01-30 19:32:59'),
(1284,'default','shipping_edited',844,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"}}',NULL,'2025-01-30 19:35:06','2025-01-30 19:35:06'),
(1285,'default','shipping_edited',836,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1225.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1225.0000\"}}',NULL,'2025-01-30 19:35:37','2025-01-30 19:35:37'),
(1286,'default','shipping_edited',853,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"6360.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"6360.9000\"}}',NULL,'2025-01-30 19:36:10','2025-01-30 19:36:10'),
(1287,'default','shipping_edited',852,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 19:36:34','2025-01-30 19:36:34'),
(1288,'default','shipping_edited',851,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"}}',NULL,'2025-01-30 19:37:26','2025-01-30 19:37:26'),
(1289,'default','shipping_edited',850,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"}}',NULL,'2025-01-30 19:37:42','2025-01-30 19:37:42'),
(1290,'default','shipping_edited',849,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-01-30 19:38:00','2025-01-30 19:38:00'),
(1291,'default','shipping_edited',840,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2518.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2518.6000\"}}',NULL,'2025-01-30 19:38:19','2025-01-30 19:38:19'),
(1292,'default','shipping_edited',843,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2266.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2266.6000\"}}',NULL,'2025-01-30 19:38:35','2025-01-30 19:38:35'),
(1293,'default','shipping_edited',842,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2025-01-30 19:38:55','2025-01-30 19:38:55'),
(1294,'default','shipping_edited',835,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1399.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1399.3000\"}}',NULL,'2025-01-30 19:39:16','2025-01-30 19:39:16'),
(1295,'default','shipping_edited',834,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"}}',NULL,'2025-01-30 19:39:33','2025-01-30 19:39:33'),
(1296,'default','shipping_edited',847,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2141.3000\"}}',NULL,'2025-01-30 19:39:52','2025-01-30 19:39:52'),
(1297,'default','shipping_edited',828,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-01-30 19:40:12','2025-01-30 19:40:12'),
(1298,'default','shipping_edited',848,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1070.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1070.3000\"}}',NULL,'2025-01-30 19:40:42','2025-01-30 19:40:42'),
(1299,'default','shipping_edited',841,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2025-01-30 19:40:58','2025-01-30 19:40:58'),
(1300,'default','shipping_edited',837,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 19:41:15','2025-01-30 19:41:15'),
(1301,'default','shipping_edited',838,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 19:41:40','2025-01-30 19:41:40'),
(1302,'default','shipping_edited',839,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"}}',NULL,'2025-01-30 19:42:17','2025-01-30 19:42:17'),
(1303,'default','shipping_edited',833,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-01-30 19:42:33','2025-01-30 19:42:33'),
(1304,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-02 04:42:31','2025-02-02 04:42:31'),
(1305,'default','added',864,'App\\Transaction',NULL,9,14,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":0}}',NULL,'2025-02-02 07:43:36','2025-02-02 07:43:36'),
(1306,'default','edited',864,'App\\Transaction',NULL,9,14,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2025-02-02 07:43:37','2025-02-02 07:43:37'),
(1307,'default','added',865,'App\\Transaction',NULL,9,14,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":0}}',NULL,'2025-02-02 07:43:56','2025-02-02 07:43:56'),
(1308,'default','sell_deleted',747,'App\\Transaction',NULL,9,14,'App\\User','{\"id\":747,\"invoice_no\":\"0002\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"43.0000\"}}',NULL,'2025-02-02 07:45:48','2025-02-02 07:45:48'),
(1309,'default','sell_deleted',746,'App\\Transaction',NULL,9,14,'App\\User','{\"id\":746,\"invoice_no\":\"0001\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.8600\"}}',NULL,'2025-02-02 07:45:52','2025-02-02 07:45:52'),
(1313,'default','edited',743,'App\\Transaction',NULL,9,14,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":9750},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"11050.0000\"}}',NULL,'2025-02-02 07:49:58','2025-02-02 07:49:58'),
(1315,'default','edited',743,'App\\Transaction',NULL,9,14,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":156},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"9750.0000\"}}',NULL,'2025-02-02 07:50:44','2025-02-02 07:50:44'),
(1317,'default','added',866,'App\\Transaction',NULL,8,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":78}}',NULL,'2025-02-02 09:50:08','2025-02-02 09:50:08'),
(1318,'default','login',13,'App\\User',NULL,2,13,'App\\User','[]',NULL,'2025-02-02 10:28:18','2025-02-02 10:28:18'),
(1319,'default','added',867,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":913.5}}',NULL,'2025-02-02 10:33:41','2025-02-02 10:33:41'),
(1320,'default','added',868,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-02-02 10:34:30','2025-02-02 10:34:30'),
(1321,'default','added',869,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-02-02 10:35:43','2025-02-02 10:35:43'),
(1322,'default','added',870,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2266.6}}',NULL,'2025-02-02 10:36:37','2025-02-02 10:36:37'),
(1323,'default','added',871,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2157.4}}',NULL,'2025-02-02 10:37:49','2025-02-02 10:37:49'),
(1324,'default','added',872,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.3}}',NULL,'2025-02-02 10:38:42','2025-02-02 10:38:42'),
(1325,'default','added',873,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-02 10:41:02','2025-02-02 10:41:02'),
(1326,'default','added',874,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-02 10:41:46','2025-02-02 10:41:46'),
(1327,'default','added',875,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":4197.2}}',NULL,'2025-02-02 10:44:41','2025-02-02 10:44:41'),
(1328,'default','added',876,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1398.6}}',NULL,'2025-02-02 10:45:48','2025-02-02 10:45:48'),
(1329,'default','added',877,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1133.3}}',NULL,'2025-02-02 10:46:45','2025-02-02 10:46:45'),
(1330,'default','added',878,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":909.3}}',NULL,'2025-02-02 10:47:55','2025-02-02 10:47:55'),
(1331,'default','added',879,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2518.6}}',NULL,'2025-02-02 10:49:08','2025-02-02 10:49:08'),
(1332,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-02-02 16:18:46','2025-02-02 16:18:46'),
(1333,'default','login',13,'App\\User',NULL,2,13,'App\\User','[]',NULL,'2025-02-02 18:06:51','2025-02-02 18:06:51'),
(1334,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-04 03:27:15','2025-02-04 03:27:15'),
(1335,'default','added',897,'App\\Transaction',NULL,10,15,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":163}}',NULL,'2025-02-04 06:44:52','2025-02-04 06:44:52'),
(1336,'default','added',898,'App\\Transaction',NULL,10,15,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":65}}',NULL,'2025-02-04 06:45:43','2025-02-04 06:45:43'),
(1337,'default','sell_deleted',898,'App\\Transaction',NULL,10,15,'App\\User','{\"id\":898,\"invoice_no\":\"0002\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"65.0000\"}}',NULL,'2025-02-04 06:58:10','2025-02-04 06:58:10'),
(1338,'default','sell_deleted',897,'App\\Transaction',NULL,10,15,'App\\User','{\"id\":897,\"invoice_no\":\"0001\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"163.0000\"}}',NULL,'2025-02-04 06:58:14','2025-02-04 06:58:14'),
(1339,'default','added',899,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1398.6}}',NULL,'2025-02-04 13:49:54','2025-02-04 13:49:54'),
(1340,'default','added',900,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":441}}',NULL,'2025-02-04 13:51:04','2025-02-04 13:51:04'),
(1341,'default','added',901,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-04 13:52:06','2025-02-04 13:52:06'),
(1342,'default','added',902,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2629.2}}',NULL,'2025-02-04 13:53:16','2025-02-04 13:53:16'),
(1343,'default','added',903,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-04 13:54:11','2025-02-04 13:54:11'),
(1344,'default','added',904,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":913.5}}',NULL,'2025-02-04 13:56:05','2025-02-04 13:56:05'),
(1345,'default','added',905,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-04 13:57:25','2025-02-04 13:57:25'),
(1346,'default','added',906,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1225}}',NULL,'2025-02-04 13:58:12','2025-02-04 13:58:12'),
(1347,'default','added',907,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.3}}',NULL,'2025-02-04 13:59:17','2025-02-04 13:59:17'),
(1348,'default','added',908,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":693}}',NULL,'2025-02-04 14:00:26','2025-02-04 14:00:26'),
(1349,'default','sell_deleted',877,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":877,\"invoice_no\":\"P60435\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1133.3000\"}}',NULL,'2025-02-04 14:01:23','2025-02-04 14:01:23'),
(1350,'default','added',909,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":3770.2}}',NULL,'2025-02-04 14:06:52','2025-02-04 14:06:52'),
(1351,'default','added',910,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-04 14:07:31','2025-02-04 14:07:31'),
(1352,'default','added',911,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.3}}',NULL,'2025-02-04 14:08:19','2025-02-04 14:08:19'),
(1353,'default','added',912,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":693}}',NULL,'2025-02-04 14:09:15','2025-02-04 14:09:15'),
(1354,'default','added',913,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":497.7}}',NULL,'2025-02-04 14:10:08','2025-02-04 14:10:08'),
(1355,'default','added',914,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":525}}',NULL,'2025-02-04 14:10:54','2025-02-04 14:10:54'),
(1356,'default','added',915,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2518.6}}',NULL,'2025-02-04 14:11:41','2025-02-04 14:11:41'),
(1357,'default','shipping_edited',878,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2025-02-04 20:21:11','2025-02-04 20:21:11'),
(1358,'default','shipping_edited',872,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-02-04 20:21:32','2025-02-04 20:21:32'),
(1359,'default','shipping_edited',870,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2266.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2266.6000\"}}',NULL,'2025-02-04 20:22:04','2025-02-04 20:22:04'),
(1360,'default','shipping_edited',874,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-02-04 20:23:27','2025-02-04 20:23:27'),
(1361,'default','shipping_edited',873,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-02-04 20:25:17','2025-02-04 20:25:17'),
(1362,'default','shipping_edited',914,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"}}',NULL,'2025-02-04 20:25:41','2025-02-04 20:25:41'),
(1363,'default','shipping_edited',913,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"497.7000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"497.7000\"}}',NULL,'2025-02-04 20:25:57','2025-02-04 20:25:57'),
(1364,'default','shipping_edited',912,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"}}',NULL,'2025-02-04 20:26:17','2025-02-04 20:26:17'),
(1365,'default','shipping_edited',915,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2518.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2518.6000\"}}',NULL,'2025-02-04 20:26:30','2025-02-04 20:26:30'),
(1366,'default','shipping_edited',910,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-02-04 20:26:51','2025-02-04 20:26:51'),
(1367,'default','shipping_edited',909,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"3770.2000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"3770.2000\"}}',NULL,'2025-02-04 20:27:17','2025-02-04 20:27:17'),
(1368,'default','shipping_edited',911,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-02-04 20:27:33','2025-02-04 20:27:33'),
(1369,'default','shipping_edited',899,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"}}',NULL,'2025-02-04 20:27:51','2025-02-04 20:27:51'),
(1370,'default','shipping_edited',904,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2025-02-04 20:28:07','2025-02-04 20:28:07'),
(1371,'default','shipping_edited',900,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"}}',NULL,'2025-02-04 20:28:22','2025-02-04 20:28:22'),
(1372,'default','shipping_edited',908,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"693.0000\"}}',NULL,'2025-02-04 20:28:37','2025-02-04 20:28:37'),
(1373,'default','shipping_edited',902,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2629.2000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2629.2000\"}}',NULL,'2025-02-04 20:28:52','2025-02-04 20:28:52'),
(1374,'default','shipping_edited',907,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-02-04 20:29:09','2025-02-04 20:29:09'),
(1375,'default','shipping_edited',875,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"4197.2000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"4197.2000\"}}',NULL,'2025-02-04 20:29:32','2025-02-04 20:29:32'),
(1376,'default','shipping_edited',879,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2518.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2518.6000\"}}',NULL,'2025-02-04 20:29:51','2025-02-04 20:29:51'),
(1377,'default','shipping_edited',905,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-02-04 20:30:10','2025-02-04 20:30:10'),
(1378,'default','shipping_edited',903,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-02-04 20:30:54','2025-02-04 20:30:54'),
(1379,'default','shipping_edited',901,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-02-04 20:31:11','2025-02-04 20:31:11'),
(1380,'default','shipping_edited',868,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-02-04 20:31:37','2025-02-04 20:31:37'),
(1381,'default','shipping_edited',867,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2025-02-04 20:32:20','2025-02-04 20:32:20'),
(1382,'default','shipping_edited',871,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2157.4000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2157.4000\"}}',NULL,'2025-02-04 20:32:42','2025-02-04 20:32:42'),
(1383,'default','shipping_edited',876,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"}}',NULL,'2025-02-04 20:33:01','2025-02-04 20:33:01'),
(1384,'default','added',916,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-05 20:26:03','2025-02-05 20:26:03'),
(1385,'default','added',917,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-05 20:26:45','2025-02-05 20:26:45'),
(1386,'default','added',918,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-05 20:27:26','2025-02-05 20:27:26'),
(1387,'default','added',919,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.8}}',NULL,'2025-02-05 20:28:24','2025-02-05 20:28:24'),
(1388,'default','added',920,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-02-10 09:03:22','2025-02-10 09:03:22'),
(1389,'default','added',921,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2739.8}}',NULL,'2025-02-10 09:06:43','2025-02-10 09:06:43'),
(1390,'default','added',922,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.3}}',NULL,'2025-02-10 09:07:54','2025-02-10 09:07:54'),
(1391,'default','added',923,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.3}}',NULL,'2025-02-10 09:10:29','2025-02-10 09:10:29'),
(1392,'default','added',924,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1398.6}}',NULL,'2025-02-10 09:13:01','2025-02-10 09:13:01'),
(1393,'default','added',925,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-02-10 09:13:57','2025-02-10 09:13:57'),
(1394,'default','added',926,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":3762.5}}',NULL,'2025-02-10 09:27:20','2025-02-10 09:27:20'),
(1395,'default','added',927,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1855}}',NULL,'2025-02-10 09:28:40','2025-02-10 09:28:40'),
(1396,'default','added',928,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-10 09:29:53','2025-02-10 09:29:53'),
(1397,'default','added',929,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1007.3}}',NULL,'2025-02-10 09:30:45','2025-02-10 09:30:45'),
(1398,'default','added',930,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1827}}',NULL,'2025-02-10 09:32:01','2025-02-10 09:32:01'),
(1399,'default','added',931,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":441}}',NULL,'2025-02-10 09:33:04','2025-02-10 09:33:04'),
(1400,'default','edited',5,'App\\Contact',NULL,2,13,'App\\User','[]',NULL,'2025-02-10 09:41:28','2025-02-10 09:41:28'),
(1401,'default','added',932,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1398.6}}',NULL,'2025-02-10 09:42:44','2025-02-10 09:42:44'),
(1402,'default','added',933,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2761.5}}',NULL,'2025-02-10 09:50:53','2025-02-10 09:50:53'),
(1403,'default','added',934,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-10 09:52:16','2025-02-10 09:52:16'),
(1404,'default','added',935,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-10 09:53:34','2025-02-10 09:53:34'),
(1405,'default','added',936,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-10 09:54:33','2025-02-10 09:54:33'),
(1406,'default','added',937,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2657.9}}',NULL,'2025-02-10 09:55:52','2025-02-10 09:55:52'),
(1407,'default','edited',937,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2657.9},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2657.9000\"}}',NULL,'2025-02-10 09:56:12','2025-02-10 09:56:12'),
(1408,'default','added',938,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-10 09:57:09','2025-02-10 09:57:09'),
(1409,'default','added',939,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":805}}',NULL,'2025-02-10 09:58:18','2025-02-10 09:58:18'),
(1410,'default','added',940,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2648.8}}',NULL,'2025-02-10 09:59:56','2025-02-10 09:59:56'),
(1411,'default','added',941,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1384.6}}',NULL,'2025-02-12 10:23:37','2025-02-12 10:23:37'),
(1412,'default','added',942,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-12 10:24:32','2025-02-12 10:24:32'),
(1413,'default','added',943,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":979.3}}',NULL,'2025-02-12 10:25:49','2025-02-12 10:25:49'),
(1414,'default','added',944,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1225}}',NULL,'2025-02-12 10:28:21','2025-02-12 10:28:21'),
(1415,'default','added',945,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":3400.6}}',NULL,'2025-02-12 10:29:40','2025-02-12 10:29:40'),
(1416,'default','added',946,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.3}}',NULL,'2025-02-12 10:30:29','2025-02-12 10:30:29'),
(1417,'default','added',947,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.3}}',NULL,'2025-02-12 10:31:47','2025-02-12 10:31:47'),
(1418,'default','added',948,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2303}}',NULL,'2025-02-12 10:41:04','2025-02-12 10:41:04'),
(1419,'default','added',949,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.3}}',NULL,'2025-02-12 10:42:18','2025-02-12 10:42:18'),
(1420,'default','added',950,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.3}}',NULL,'2025-02-12 10:43:44','2025-02-12 10:43:44'),
(1421,'default','added',951,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-02-12 10:49:41','2025-02-12 10:49:41'),
(1422,'default','added',952,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.8}}',NULL,'2025-02-12 10:50:32','2025-02-12 10:50:32'),
(1423,'default','added',953,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.3}}',NULL,'2025-02-12 10:52:17','2025-02-12 10:52:17'),
(1424,'default','added',954,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-12 10:54:05','2025-02-12 10:54:05'),
(1425,'default','added',955,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.3}}',NULL,'2025-02-12 10:55:05','2025-02-12 10:55:05'),
(1426,'default','added',956,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":3777.9}}',NULL,'2025-02-12 10:56:04','2025-02-12 10:56:04'),
(1427,'default','added',957,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1007.3}}',NULL,'2025-02-12 10:57:33','2025-02-12 10:57:33'),
(1428,'default','added',958,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-12 10:59:58','2025-02-12 10:59:58'),
(1429,'default','added',959,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1353.8}}',NULL,'2025-02-12 11:00:47','2025-02-12 11:00:47'),
(1430,'default','added',960,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-12 11:01:44','2025-02-12 11:01:44'),
(1431,'default','added',961,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1259.3}}',NULL,'2025-02-12 11:03:25','2025-02-12 11:03:25'),
(1432,'default','added',962,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2174.9}}',NULL,'2025-02-12 11:04:45','2025-02-12 11:04:45'),
(1433,'default','added',963,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":692.3}}',NULL,'2025-02-12 11:05:32','2025-02-12 11:05:32'),
(1434,'default','added',964,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1295}}',NULL,'2025-02-12 11:06:26','2025-02-12 11:06:26'),
(1435,'default','added',965,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2174.9}}',NULL,'2025-02-12 11:08:08','2025-02-12 11:08:08'),
(1436,'default','shipping_edited',917,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-02-12 11:13:04','2025-02-12 11:13:04'),
(1437,'default','shipping_edited',918,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-02-12 11:13:47','2025-02-12 11:13:47'),
(1438,'default','shipping_edited',934,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-02-12 11:14:04','2025-02-12 11:14:04'),
(1439,'default','shipping_edited',920,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-02-12 11:14:49','2025-02-12 11:14:49'),
(1440,'default','shipping_edited',926,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"3762.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"3762.5000\"}}',NULL,'2025-02-12 11:15:10','2025-02-12 11:15:10'),
(1441,'default','shipping_edited',930,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1827.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1827.0000\"}}',NULL,'2025-02-12 11:15:27','2025-02-12 11:15:27'),
(1442,'default','shipping_edited',929,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"}}',NULL,'2025-02-12 11:15:45','2025-02-12 11:15:45'),
(1443,'default','shipping_edited',906,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1225.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1225.0000\"}}',NULL,'2025-02-12 11:16:03','2025-02-12 11:16:03'),
(1444,'default','shipping_edited',931,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"}}',NULL,'2025-02-12 11:16:29','2025-02-12 11:16:29'),
(1445,'default','shipping_edited',927,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1855.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1855.0000\"}}',NULL,'2025-02-12 11:16:51','2025-02-12 11:16:51'),
(1446,'default','shipping_edited',939,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"805.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"805.0000\"}}',NULL,'2025-02-12 11:17:10','2025-02-12 11:17:10'),
(1447,'default','shipping_edited',940,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2648.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2648.8000\"}}',NULL,'2025-02-12 11:17:32','2025-02-12 11:17:32'),
(1448,'default','shipping_edited',924,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1398.6000\"}}',NULL,'2025-02-12 11:17:54','2025-02-12 11:17:54'),
(1449,'default','shipping_edited',925,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-02-12 11:18:29','2025-02-12 11:18:29'),
(1450,'default','shipping_edited',919,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2025-02-12 11:18:53','2025-02-12 11:18:53'),
(1451,'default','shipping_edited',922,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-02-12 11:19:13','2025-02-12 11:19:13'),
(1452,'default','shipping_edited',923,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-02-12 11:19:36','2025-02-12 11:19:36'),
(1453,'default','shipping_edited',937,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2657.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2657.9000\"}}',NULL,'2025-02-12 11:20:02','2025-02-12 11:20:02'),
(1454,'default','shipping_edited',807,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"4645.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"4645.9000\"}}',NULL,'2025-02-12 11:20:32','2025-02-12 11:20:32'),
(1455,'default','shipping_edited',916,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-02-12 11:20:57','2025-02-12 11:20:57'),
(1456,'default','shipping_edited',938,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-02-12 11:21:17','2025-02-12 11:21:17'),
(1457,'default','shipping_edited',936,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-02-12 11:21:39','2025-02-12 11:21:39'),
(1458,'default','shipping_edited',935,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-02-12 11:21:55','2025-02-12 11:21:55'),
(1459,'default','shipping_edited',933,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"2761.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2761.5000\"}}',NULL,'2025-02-12 11:22:12','2025-02-12 11:22:12'),
(1460,'default','shipping_edited',928,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-02-12 11:22:35','2025-02-12 11:22:35'),
(1461,'default','login',13,'App\\User',NULL,2,13,'App\\User','[]',NULL,'2025-02-13 07:36:45','2025-02-13 07:36:45'),
(1462,'default','added',966,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":-8219.4}}',NULL,'2025-02-13 07:46:04','2025-02-13 07:46:04'),
(1463,'default','edited',966,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":-8219.4},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"-8219.4000\"}}',NULL,'2025-02-13 07:49:54','2025-02-13 07:49:54'),
(1464,'default','sell_deleted',966,'App\\Transaction',NULL,2,13,'App\\User','{\"id\":966,\"invoice_no\":\"0120\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"-8219.4000\"}}',NULL,'2025-02-13 07:50:31','2025-02-13 07:50:31'),
(1465,'default','logout',13,'App\\User',NULL,2,13,'App\\User','[]',NULL,'2025-02-13 07:57:48','2025-02-13 07:57:48'),
(1466,'default','login',13,'App\\User',NULL,2,13,'App\\User','[]',NULL,'2025-02-13 11:30:30','2025-02-13 11:30:30'),
(1467,'default','added',967,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":4195.8}}',NULL,'2025-02-13 11:37:57','2025-02-13 11:37:57'),
(1468,'default','added',968,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1369.9}}',NULL,'2025-02-13 11:38:47','2025-02-13 11:38:47'),
(1469,'default','added',969,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-02-13 11:39:56','2025-02-13 11:39:56'),
(1470,'default','added',970,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1706.6}}',NULL,'2025-02-13 12:05:44','2025-02-13 12:05:44'),
(1471,'default','added',971,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3}}',NULL,'2025-02-13 12:06:28','2025-02-13 12:06:28'),
(1472,'default','added',972,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1818.6}}',NULL,'2025-02-13 12:07:11','2025-02-13 12:07:11'),
(1473,'default','added',973,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1398.6}}',NULL,'2025-02-13 12:08:11','2025-02-13 12:08:11'),
(1474,'default','added',974,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":699.3}}',NULL,'2025-02-13 12:14:10','2025-02-13 12:14:10'),
(1475,'default','added',975,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":699.3}}',NULL,'2025-02-13 12:16:53','2025-02-13 12:16:53'),
(1476,'default','added',976,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":699.3}}',NULL,'2025-02-13 12:17:35','2025-02-13 12:17:35'),
(1477,'default','edited',970,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":1706.6},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1706.6000\"}}',NULL,'2025-02-13 12:25:00','2025-02-13 12:25:00'),
(1478,'default','edited',969,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":699.3},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-02-13 12:28:22','2025-02-13 12:28:22'),
(1479,'default','edited',976,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":699.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-02-13 12:30:42','2025-02-13 12:30:42'),
(1480,'default','edited',975,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":699.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-02-13 12:31:11','2025-02-13 12:31:11'),
(1481,'default','edited',974,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":699.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-02-13 12:31:31','2025-02-13 12:31:31'),
(1482,'default','shipping_edited',954,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1369.9000\"}}',NULL,'2025-02-14 11:09:36','2025-02-14 11:09:36'),
(1483,'default','shipping_edited',955,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-02-14 11:09:52','2025-02-14 11:09:52'),
(1484,'default','shipping_edited',956,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"3777.9000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"3777.9000\"}}',NULL,'2025-02-14 11:10:12','2025-02-14 11:10:12'),
(1485,'default','shipping_edited',949,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-02-14 11:10:27','2025-02-14 11:10:27'),
(1486,'default','shipping_edited',950,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-02-14 11:10:44','2025-02-14 11:10:44'),
(1487,'default','shipping_edited',946,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-02-14 11:10:58','2025-02-14 11:10:58'),
(1488,'default','shipping_edited',961,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-02-14 11:11:13','2025-02-14 11:11:13'),
(1489,'default','shipping_edited',953,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-02-14 11:11:27','2025-02-14 11:11:27'),
(1490,'default','shipping_edited',945,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"3400.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"3400.6000\"}}',NULL,'2025-02-14 11:11:39','2025-02-14 11:11:39'),
(1491,'default','shipping_edited',952,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2025-02-14 11:11:58','2025-02-14 11:11:58'),
(1492,'default','shipping_edited',951,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-02-14 11:12:35','2025-02-14 11:12:35'),
(1493,'default','shipping_edited',963,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-02-14 11:12:51','2025-02-14 11:12:51'),
(1494,'default','shipping_edited',941,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1384.6000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1384.6000\"}}',NULL,'2025-02-14 11:13:17','2025-02-14 11:13:17'),
(1495,'default','shipping_edited',943,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"979.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"979.3000\"}}',NULL,'2025-02-14 11:13:31','2025-02-14 11:13:31'),
(1496,'default','shipping_edited',957,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1007.3000\"}}',NULL,'2025-02-14 11:13:50','2025-02-14 11:13:50'),
(1497,'default','shipping_edited',944,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"1225.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"1225.0000\"}}',NULL,'2025-02-14 11:14:08','2025-02-14 11:14:08'),
(1498,'default','shipping_edited',947,'App\\Transaction',NULL,2,13,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-02-14 11:14:21','2025-02-14 11:14:21'),
(1499,'default','added',977,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1399.3}}',NULL,'2025-02-14 20:35:43','2025-02-14 20:35:43'),
(1500,'default','added',978,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1399.3}}',NULL,'2025-02-14 20:37:02','2025-02-14 20:37:02'),
(1501,'default','edited',978,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":1399.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1399.3000\"}}',NULL,'2025-02-14 20:41:51','2025-02-14 20:41:51'),
(1502,'default','edited',977,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":1399.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1399.3000\"}}',NULL,'2025-02-14 20:42:31','2025-02-14 20:42:31'),
(1503,'default','added',979,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":699.3}}',NULL,'2025-02-14 20:59:13','2025-02-14 20:59:13'),
(1504,'default','added',980,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":699.3}}',NULL,'2025-02-14 20:59:44','2025-02-14 20:59:44'),
(1505,'default','added',981,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":2078.3}}',NULL,'2025-02-14 21:12:26','2025-02-14 21:12:26'),
(1506,'default','added',982,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":913.5}}',NULL,'2025-02-14 21:13:46','2025-02-14 21:13:46'),
(1507,'default','added',983,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":441}}',NULL,'2025-02-14 21:15:12','2025-02-14 21:15:12'),
(1508,'default','added',984,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":559}}',NULL,'2025-02-14 21:17:25','2025-02-14 21:17:25'),
(1509,'default','added',985,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":692.3}}',NULL,'2025-02-14 21:18:51','2025-02-14 21:18:51'),
(1510,'default','added',986,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":692.3}}',NULL,'2025-02-14 21:20:16','2025-02-14 21:20:16'),
(1511,'default','added',987,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":692.3}}',NULL,'2025-02-14 21:21:15','2025-02-14 21:21:15'),
(1512,'default','added',988,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":535.5}}',NULL,'2025-02-14 21:22:21','2025-02-14 21:22:21'),
(1513,'default','added',989,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1449}}',NULL,'2025-02-14 21:24:07','2025-02-14 21:24:07'),
(1514,'default','added',990,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1449}}',NULL,'2025-02-14 21:24:40','2025-02-14 21:24:40'),
(1515,'default','edited',975,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":1769.6},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-02-17 13:51:08','2025-02-17 13:51:08'),
(1516,'default','added',991,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1070.3}}',NULL,'2025-02-17 13:53:21','2025-02-17 13:53:21'),
(1517,'default','added',992,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1259.3}}',NULL,'2025-02-17 13:54:46','2025-02-17 13:54:46'),
(1518,'default','edited',992,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":1259.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-02-17 13:54:46','2025-02-17 13:54:46'),
(1519,'default','added',993,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":909.3}}',NULL,'2025-02-17 13:56:16','2025-02-17 13:56:16'),
(1520,'default','added',994,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":979.3}}',NULL,'2025-02-17 13:58:43','2025-02-17 13:58:43'),
(1521,'default','added',995,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1365}}',NULL,'2025-02-17 13:59:33','2025-02-17 13:59:33'),
(1522,'default','added',996,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":909.3}}',NULL,'2025-02-17 14:00:17','2025-02-17 14:00:17'),
(1523,'default','added',997,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":699.3}}',NULL,'2025-02-17 14:01:20','2025-02-17 14:01:20'),
(1524,'default','added',998,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":525}}',NULL,'2025-02-17 14:02:03','2025-02-17 14:02:03'),
(1525,'default','added',999,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":525}}',NULL,'2025-02-17 14:02:32','2025-02-17 14:02:32'),
(1526,'default','added',1000,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1795.5}}',NULL,'2025-02-17 14:04:04','2025-02-17 14:04:04'),
(1527,'default','added',1001,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1764}}',NULL,'2025-02-17 14:07:26','2025-02-17 14:07:26'),
(1528,'default','added',1002,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1858.5}}',NULL,'2025-02-17 14:09:32','2025-02-17 14:09:32'),
(1529,'default','edited',975,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":2902.8999999999996},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1769.6000\"}}',NULL,'2025-02-17 14:10:56','2025-02-17 14:10:56'),
(1530,'default','added',1003,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":692.3}}',NULL,'2025-02-17 14:12:39','2025-02-17 14:12:39'),
(1531,'default','edited',1002,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":1858.5},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1858.5000\"}}',NULL,'2025-02-17 14:54:20','2025-02-17 14:54:20'),
(1532,'default','edited',979,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":699.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-02-17 14:55:02','2025-02-17 14:55:02'),
(1533,'default','edited',980,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":699.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-02-17 14:56:36','2025-02-17 14:56:36'),
(1534,'default','edited',1003,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":692.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-02-17 14:57:13','2025-02-17 14:57:13'),
(1535,'default','edited',1001,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":1764},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1764.0000\"}}',NULL,'2025-02-17 14:57:33','2025-02-17 14:57:33'),
(1536,'default','edited',1000,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":1795.5},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1795.5000\"}}',NULL,'2025-02-17 14:58:13','2025-02-17 14:58:13'),
(1537,'default','edited',999,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":525},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"}}',NULL,'2025-02-17 14:58:41','2025-02-17 14:58:41'),
(1538,'default','edited',997,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":699.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-02-17 14:59:06','2025-02-17 14:59:06'),
(1539,'default','edited',998,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":525},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"525.0000\"}}',NULL,'2025-02-17 14:59:32','2025-02-17 14:59:32'),
(1540,'default','edited',996,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":909.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2025-02-17 15:02:13','2025-02-17 15:02:13'),
(1541,'default','edited',995,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":1365},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1365.0000\"}}',NULL,'2025-02-17 15:02:35','2025-02-17 15:02:35'),
(1542,'default','edited',994,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":979.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"979.3000\"}}',NULL,'2025-02-17 15:02:57','2025-02-17 15:02:57'),
(1543,'default','edited',993,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":909.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2025-02-17 15:03:45','2025-02-17 15:03:45'),
(1544,'default','edited',992,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":1259.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1259.3000\"}}',NULL,'2025-02-17 15:04:11','2025-02-17 15:04:11'),
(1545,'default','edited',991,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":1070.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1070.3000\"}}',NULL,'2025-02-17 15:04:37','2025-02-17 15:04:37'),
(1546,'default','edited',990,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":1449},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"}}',NULL,'2025-02-17 15:04:56','2025-02-17 15:04:56'),
(1547,'default','edited',989,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":1449},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1449.0000\"}}',NULL,'2025-02-17 15:05:16','2025-02-17 15:05:16'),
(1548,'default','edited',988,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":535.5},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"535.5000\"}}',NULL,'2025-02-17 15:05:39','2025-02-17 15:05:39'),
(1549,'default','edited',987,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":692.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-02-17 15:06:03','2025-02-17 15:06:03'),
(1550,'default','edited',986,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":692.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-02-17 15:06:26','2025-02-17 15:06:26'),
(1551,'default','edited',985,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":692.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"692.3000\"}}',NULL,'2025-02-17 15:06:51','2025-02-17 15:06:51'),
(1552,'default','edited',984,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":559},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"559.0000\"}}',NULL,'2025-02-17 15:07:15','2025-02-17 15:07:15'),
(1553,'default','edited',983,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":441},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"441.0000\"}}',NULL,'2025-02-17 15:07:35','2025-02-17 15:07:35'),
(1554,'default','edited',982,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":913.5},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"913.5000\"}}',NULL,'2025-02-17 15:07:57','2025-02-17 15:07:57'),
(1555,'default','edited',981,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":2078.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"2078.3000\"}}',NULL,'2025-02-17 15:08:26','2025-02-17 15:08:26'),
(1556,'default','added',1004,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1858.5}}',NULL,'2025-02-17 15:12:02','2025-02-17 15:12:02'),
(1557,'default','added',1005,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":699.3}}',NULL,'2025-02-17 15:13:28','2025-02-17 15:13:28'),
(1558,'default','added',1006,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":909.3}}',NULL,'2025-02-17 15:24:13','2025-02-17 15:24:13'),
(1559,'default','edited',980,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":1398.6},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-02-17 15:29:15','2025-02-17 15:29:15'),
(1560,'default','edited',979,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"699.3000\"}}',NULL,'2025-02-17 15:31:45','2025-02-17 15:31:45'),
(1561,'default','added',1007,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":979.3}}',NULL,'2025-02-17 15:33:39','2025-02-17 15:33:39'),
(1562,'default','added',1008,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":979.3}}',NULL,'2025-02-17 15:34:54','2025-02-17 15:34:54'),
(1563,'default','edited',1007,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":979.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"979.3000\"}}',NULL,'2025-02-17 15:35:14','2025-02-17 15:35:14'),
(1564,'default','edited',1008,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":979.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"979.3000\"}}',NULL,'2025-02-17 15:35:26','2025-02-17 15:35:26'),
(1565,'default','added',1009,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":909.3}}',NULL,'2025-02-17 15:36:36','2025-02-17 15:36:36'),
(1566,'default','edited',1009,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":909.3},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"909.3000\"}}',NULL,'2025-02-17 15:36:56','2025-02-17 15:36:56'),
(1567,'default','added',1010,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1295}}',NULL,'2025-02-17 15:38:20','2025-02-17 15:38:20'),
(1568,'default','added',1011,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1228.5}}',NULL,'2025-02-17 15:39:50','2025-02-17 15:39:50'),
(1569,'default','added',1012,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1243.9}}',NULL,'2025-02-17 15:41:43','2025-02-17 15:41:43'),
(1570,'default','added',1013,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1353.8}}',NULL,'2025-02-17 19:50:21','2025-02-17 19:50:21'),
(1571,'default','added',1014,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1353.8}}',NULL,'2025-02-17 19:52:09','2025-02-17 19:52:09'),
(1572,'default','added',1015,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1070.3}}',NULL,'2025-02-17 19:53:43','2025-02-17 19:53:43'),
(1573,'default','added',1016,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1070.3}}',NULL,'2025-02-17 19:54:21','2025-02-17 19:54:21'),
(1574,'default','added',1017,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1070.3}}',NULL,'2025-02-17 19:55:09','2025-02-17 19:55:09'),
(1575,'default','edited',1014,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":1353.8},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2025-02-17 19:56:00','2025-02-17 19:56:00'),
(1576,'default','edited',1013,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":1353.8},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1353.8000\"}}',NULL,'2025-02-17 19:56:18','2025-02-17 19:56:18'),
(1577,'default','added',1018,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":2518.6}}',NULL,'2025-02-17 19:57:58','2025-02-17 19:57:58'),
(1578,'default','edited',1018,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":2518.6},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"2518.6000\"}}',NULL,'2025-02-17 19:58:14','2025-02-17 19:58:14'),
(1579,'default','added',1019,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1259.3}}',NULL,'2025-02-17 19:59:26','2025-02-17 19:59:26'),
(1580,'default','added',1020,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1259.3}}',NULL,'2025-02-17 20:00:21','2025-02-17 20:00:21'),
(1581,'default','added',1021,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1259.3}}',NULL,'2025-02-17 20:02:07','2025-02-17 20:02:07'),
(1582,'default','added',1022,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1259.3}}',NULL,'2025-02-17 20:02:47','2025-02-17 20:02:47'),
(1583,'default','added',1023,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1259.3}}',NULL,'2025-02-17 20:03:40','2025-02-17 20:03:40'),
(1584,'default','added',1024,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1050}}',NULL,'2025-02-17 20:07:14','2025-02-17 20:07:14'),
(1585,'default','added',1025,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1050}}',NULL,'2025-02-17 20:08:11','2025-02-17 20:08:11'),
(1586,'default','added',1026,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":525}}',NULL,'2025-02-17 20:09:50','2025-02-17 20:09:50'),
(1587,'default','added',1027,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":525}}',NULL,'2025-02-17 20:10:46','2025-02-17 20:10:46'),
(1588,'default','added',1028,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":805}}',NULL,'2025-02-17 20:11:57','2025-02-17 20:11:57'),
(1589,'default','added',1029,'App\\Transaction',NULL,2,13,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":805}}',NULL,'2025-02-17 20:12:33','2025-02-17 20:12:33'),
(1590,'default','added',17,'App\\User',NULL,11,16,'App\\User','{\"name\":\" POS Cashier\"}',NULL,'2025-02-23 20:43:35','2025-02-23 20:43:35'),
(1591,'default','added',18,'App\\User',NULL,11,16,'App\\User','{\"name\":\" POS Kitchen\"}',NULL,'2025-02-23 20:45:36','2025-02-23 20:45:36'),
(1592,'default','edited',17,'App\\User',NULL,11,16,'App\\User','{\"name\":\" POS Cashier\"}',NULL,'2025-02-23 22:02:14','2025-02-23 22:02:14'),
(1593,'default','login',18,'App\\User',NULL,11,18,'App\\User','[]',NULL,'2025-02-23 22:02:55','2025-02-23 22:02:55'),
(1594,'default','edited',17,'App\\User',NULL,11,16,'App\\User','{\"name\":\" POS Cashier\"}',NULL,'2025-02-23 22:03:25','2025-02-23 22:03:25'),
(1595,'default','edited',18,'App\\User',NULL,11,16,'App\\User','{\"name\":\" POS Kitchen\"}',NULL,'2025-02-23 22:03:43','2025-02-23 22:03:43'),
(1596,'default','login',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-02-23 22:15:27','2025-02-23 22:15:27'),
(1597,'default','added',1030,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-02-23 22:16:12','2025-02-23 22:16:12'),
(1598,'default','added',1031,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-02-23 22:16:46','2025-02-23 22:16:46'),
(1599,'default','logout',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-02-23 22:42:48','2025-02-23 22:42:48'),
(1600,'default','login',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-02-23 22:42:52','2025-02-23 22:42:52'),
(1601,'default','logout',18,'App\\User',NULL,11,18,'App\\User','[]',NULL,'2025-02-23 22:52:22','2025-02-23 22:52:22'),
(1602,'default','login',18,'App\\User',NULL,11,18,'App\\User','[]',NULL,'2025-02-23 22:52:25','2025-02-23 22:52:25'),
(1603,'default','added',19,'App\\User',NULL,11,16,'App\\User','{\"name\":\" POS Delivery\"}',NULL,'2025-02-23 22:56:52','2025-02-23 22:56:52'),
(1604,'default','logout',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-02-23 22:57:23','2025-02-23 22:57:23'),
(1605,'default','login',19,'App\\User',NULL,11,19,'App\\User','[]',NULL,'2025-02-23 22:57:41','2025-02-23 22:57:41'),
(1606,'default','added',1032,'App\\Transaction',NULL,11,16,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45}}',NULL,'2025-02-23 22:59:16','2025-02-23 22:59:16'),
(1607,'default','edited',19,'App\\User',NULL,11,16,'App\\User','{\"name\":\" POS Delivery\"}',NULL,'2025-02-23 23:01:03','2025-02-23 23:01:03'),
(1608,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-23 22:24:57','2025-02-23 22:24:57'),
(1609,'default','logout',19,'App\\User',NULL,11,19,'App\\User','[]',NULL,'2025-02-24 09:05:17','2025-02-24 09:05:17'),
(1610,'default','login',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-02-24 09:05:22','2025-02-24 09:05:22'),
(1611,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-24 06:29:09','2025-02-24 06:29:09'),
(1612,'default','edited',1033,'App\\Transaction',NULL,11,16,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":96},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"96.0000\"}}',NULL,'2025-02-24 09:56:49','2025-02-24 09:56:49'),
(1613,'default','added',1034,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":10}}',NULL,'2025-02-24 10:22:04','2025-02-24 10:22:04'),
(1614,'default','added',1035,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":74}}',NULL,'2025-02-24 10:22:21','2025-02-24 10:22:21'),
(1615,'default','logout',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-02-24 10:31:30','2025-02-24 10:31:30'),
(1616,'default','logout',18,'App\\User',NULL,11,18,'App\\User','[]',NULL,'2025-02-24 10:31:41','2025-02-24 10:31:41'),
(1617,'default','login',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-02-24 10:33:18','2025-02-24 10:33:18'),
(1618,'default','logout',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-02-24 10:37:12','2025-02-24 10:37:12'),
(1619,'default','login',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-02-24 10:37:20','2025-02-24 10:37:20'),
(1620,'default','logout',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-02-24 10:37:38','2025-02-24 10:37:38'),
(1621,'default','login',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-02-24 10:38:11','2025-02-24 10:38:11'),
(1622,'default','added',1036,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2025-02-24 10:42:48','2025-02-24 10:42:48'),
(1623,'default','login',18,'App\\User',NULL,11,18,'App\\User','[]',NULL,'2025-02-24 10:43:09','2025-02-24 10:43:09'),
(1624,'default','added',22,'App\\Contact',NULL,11,17,'App\\User','[]',NULL,'2025-02-24 10:48:51','2025-02-24 10:48:51'),
(1625,'default','logout',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-02-24 11:17:32','2025-02-24 11:17:32'),
(1626,'default','login',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-02-24 11:19:28','2025-02-24 11:19:28'),
(1627,'default','added',23,'App\\Contact',NULL,11,17,'App\\User','[]',NULL,'2025-02-24 11:22:31','2025-02-24 11:22:31'),
(1628,'default','added',1037,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":52}}',NULL,'2025-02-24 11:23:18','2025-02-24 11:23:18'),
(1629,'default','added',1038,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14}}',NULL,'2025-02-24 11:24:12','2025-02-24 11:24:12'),
(1630,'default','added',1039,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23}}',NULL,'2025-02-24 11:25:16','2025-02-24 11:25:16'),
(1631,'default','logout',18,'App\\User',NULL,11,18,'App\\User','[]',NULL,'2025-02-24 11:27:01','2025-02-24 11:27:01'),
(1632,'default','login',18,'App\\User',NULL,11,18,'App\\User','[]',NULL,'2025-02-24 11:27:06','2025-02-24 11:27:06'),
(1633,'default','logout',18,'App\\User',NULL,11,18,'App\\User','[]',NULL,'2025-02-24 11:28:15','2025-02-24 11:28:15'),
(1634,'default','logout',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-02-24 11:28:26','2025-02-24 11:28:26'),
(1635,'default','login',19,'App\\User',NULL,11,19,'App\\User','[]',NULL,'2025-02-24 11:28:38','2025-02-24 11:28:38'),
(1636,'default','logout',16,'App\\User',NULL,11,16,'App\\User','[]',NULL,'2025-02-24 12:35:27','2025-02-24 12:35:27'),
(1637,'default','login',16,'App\\User',NULL,11,16,'App\\User','[]',NULL,'2025-02-24 12:35:41','2025-02-24 12:35:41'),
(1638,'default','logout',16,'App\\User',NULL,11,16,'App\\User','[]',NULL,'2025-02-24 12:36:08','2025-02-24 12:36:08'),
(1639,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-24 09:36:25','2025-02-24 09:36:25'),
(1640,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-24 09:41:27','2025-02-24 09:41:27'),
(1641,'default','login',16,'App\\User',NULL,11,16,'App\\User','[]',NULL,'2025-02-24 12:41:46','2025-02-24 12:41:46'),
(1642,'default','added',20,'App\\User',NULL,11,16,'App\\User','{\"name\":\" ali kamal\"}',NULL,'2025-02-24 12:45:05','2025-02-24 12:45:05'),
(1643,'default','deleted',20,'App\\User',NULL,11,16,'App\\User','{\"name\":\" ali kamal\",\"id\":20}',NULL,'2025-02-24 13:01:08','2025-02-24 13:01:08'),
(1644,'default','added',21,'App\\User',NULL,11,16,'App\\User','{\"name\":\" ali kamel\"}',NULL,'2025-02-24 13:02:15','2025-02-24 13:02:15'),
(1645,'default','login',16,'App\\User',NULL,11,16,'App\\User','[]',NULL,'2025-02-25 10:56:58','2025-02-25 10:56:58'),
(1646,'default','deleted',21,'App\\User',NULL,11,16,'App\\User','{\"name\":\" ali kamel\",\"id\":21}',NULL,'2025-02-25 14:35:45','2025-02-25 14:35:45'),
(1647,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-02-27 12:34:27','2025-02-27 12:34:27'),
(1648,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-01 09:40:49','2025-03-01 09:40:49'),
(1649,'default','added',1040,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":88}}',NULL,'2025-03-01 12:49:15','2025-03-01 12:49:15'),
(1650,'default','edited',1040,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":116},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"88.0000\"}}',NULL,'2025-03-01 12:50:41','2025-03-01 12:50:41'),
(1651,'default','added',1041,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":116}}',NULL,'2025-03-01 12:51:57','2025-03-01 12:51:57'),
(1652,'default','edited',1041,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":116},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"116.0000\"}}',NULL,'2025-03-01 12:52:39','2025-03-01 12:52:39'),
(1653,'default','edited',1040,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":116},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"116.0000\"}}',NULL,'2025-03-01 12:55:15','2025-03-01 12:55:15'),
(1654,'default','added',1042,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":41}}',NULL,'2025-03-01 12:56:21','2025-03-01 12:56:21'),
(1655,'default','added',1043,'App\\Transaction',NULL,11,16,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14}}',NULL,'2025-03-01 13:02:15','2025-03-01 13:02:15'),
(1656,'default','edited',20,'App\\Contact',NULL,11,16,'App\\User','[]',NULL,'2025-03-01 13:03:43','2025-03-01 13:03:43'),
(1657,'default','added',1044,'App\\Transaction',NULL,11,16,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":124}}',NULL,'2025-03-01 13:04:42','2025-03-01 13:04:42'),
(1658,'default','payment_edited',1033,'App\\Transaction',NULL,11,16,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"payment_status\":\"due\",\"final_total\":\"96.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"payment_status\":\"paid\",\"final_total\":\"96.0000\"}}',NULL,'2025-03-01 13:08:08','2025-03-01 13:08:08'),
(1659,'default','payment_deleted',116,'App\\TransactionPayment',NULL,11,16,'App\\User','{\"id\":116,\"ref_no\":\"SP2025\\/0004\"}',NULL,'2025-03-01 13:08:08','2025-03-01 13:08:08'),
(1660,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-01 10:21:28','2025-03-01 10:21:28'),
(1661,'default','added',1045,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2025-03-01 13:23:43','2025-03-01 13:23:43'),
(1662,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-04 10:10:41','2025-03-04 10:10:41'),
(1663,'default','logout',16,'App\\User',NULL,11,16,'App\\User','[]',NULL,'2025-03-06 22:25:29','2025-03-06 22:25:29'),
(1664,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-06 19:32:10','2025-03-06 19:32:10'),
(1665,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-06 20:50:22','2025-03-06 20:50:22'),
(1666,'default','added',22,'App\\User',NULL,11,16,'App\\User','{\"name\":\" Super Admin\"}',NULL,'2025-03-08 00:56:18','2025-03-08 00:56:18'),
(1667,'default','deleted',16,'App\\User',NULL,11,16,'App\\User','{\"name\":\" Petra Restaurant\",\"id\":16}',NULL,'2025-03-08 00:57:56','2025-03-08 00:57:56'),
(1668,'default','added',23,'App\\User',NULL,11,22,'App\\User','{\"name\":\" Doha Branch Admin\"}',NULL,'2025-03-08 01:01:32','2025-03-08 01:01:32'),
(1669,'default','edited',23,'App\\User',NULL,11,22,'App\\User','{\"name\":\" Doha Branch Admin\"}',NULL,'2025-03-08 01:03:17','2025-03-08 01:03:17'),
(1670,'default','added',24,'App\\User',NULL,11,22,'App\\User','{\"name\":\" Wakrah Branch Admin\"}',NULL,'2025-03-08 01:03:53','2025-03-08 01:03:53'),
(1671,'default','deleted',23,'App\\User',NULL,11,22,'App\\User','{\"name\":\" Doha Branch Admin\",\"id\":23}',NULL,'2025-03-08 01:04:16','2025-03-08 01:04:16'),
(1672,'default','deleted',24,'App\\User',NULL,11,22,'App\\User','{\"name\":\" Wakrah Branch Admin\",\"id\":24}',NULL,'2025-03-08 01:04:19','2025-03-08 01:04:19'),
(1673,'default','login',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-03-08 01:09:45','2025-03-08 01:09:45'),
(1674,'default','logout',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-03-08 01:12:03','2025-03-08 01:12:03'),
(1675,'default','login',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-03-08 01:12:15','2025-03-08 01:12:15'),
(1676,'default','added',1084,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29}}',NULL,'2025-03-08 03:31:06','2025-03-08 03:31:06'),
(1677,'default','added',1085,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28}}',NULL,'2025-03-08 03:32:14','2025-03-08 03:32:14'),
(1678,'default','added',1086,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-03-08 03:35:15','2025-03-08 03:35:15'),
(1679,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-08 06:36:51','2025-03-08 06:36:51'),
(1680,'default','logout',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-03-08 09:57:03','2025-03-08 09:57:03'),
(1681,'default','login',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-03-08 09:57:13','2025-03-08 09:57:13'),
(1682,'default','login',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-03-08 11:14:58','2025-03-08 11:14:58'),
(1683,'default','added',1087,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2025-03-08 11:25:13','2025-03-08 11:25:13'),
(1684,'default','added',25,'App\\Contact',NULL,11,22,'App\\User','[]',NULL,'2025-03-08 11:44:48','2025-03-08 11:44:48'),
(1685,'default','added',26,'App\\Contact',NULL,11,22,'App\\User','[]',NULL,'2025-03-08 12:02:31','2025-03-08 12:02:31'),
(1686,'default','added',1088,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":6}}',NULL,'2025-03-08 12:06:45','2025-03-08 12:06:45'),
(1687,'default','logout',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-03-08 12:51:09','2025-03-08 12:51:09'),
(1688,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-03-15 13:09:13','2025-03-15 13:09:13'),
(1689,'default','added',1089,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":1000}}',NULL,'2025-03-15 14:17:37','2025-03-15 14:17:37'),
(1690,'default','edited',1089,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"proforma\",\"final_total\":\"1000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":\"1000.0000\"}}',NULL,'2025-03-15 14:18:42','2025-03-15 14:18:42'),
(1691,'default','edited',2,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2025-03-15 14:19:56','2025-03-15 14:19:56'),
(1692,'default','edited',1089,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"proforma\",\"payment_status\":\"due\",\"final_total\":1000},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"proforma\",\"final_total\":\"1000.0000\"}}',NULL,'2025-03-15 14:20:32','2025-03-15 14:20:32'),
(1693,'default','edited',1089,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1000},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"proforma\",\"payment_status\":\"due\",\"final_total\":\"1000.0000\"}}',NULL,'2025-03-15 14:20:49','2025-03-15 14:20:49'),
(1694,'default','login',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-03-16 20:48:00','2025-03-16 20:48:00'),
(1695,'default','added',1090,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":42}}',NULL,'2025-03-16 20:51:30','2025-03-16 20:51:30'),
(1696,'default','added',27,'App\\Contact',NULL,11,17,'App\\User','[]',NULL,'2025-03-16 20:53:36','2025-03-16 20:53:36'),
(1697,'default','added',1091,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":31}}',NULL,'2025-03-16 20:53:55','2025-03-16 20:53:55'),
(1698,'default','edited',1091,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":31},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"31.0000\"}}',NULL,'2025-03-16 20:55:40','2025-03-16 20:55:40'),
(1699,'default','added',1092,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-03-16 20:59:40','2025-03-16 20:59:40'),
(1700,'default','added',1093,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":106}}',NULL,'2025-03-16 20:59:54','2025-03-16 20:59:54'),
(1701,'default','added',1094,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-03-16 21:03:48','2025-03-16 21:03:48'),
(1702,'default','added',1095,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2025-03-16 21:07:47','2025-03-16 21:07:47'),
(1703,'default','logout',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-03-16 21:13:12','2025-03-16 21:13:12'),
(1704,'default','login',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-03-16 21:15:21','2025-03-16 21:15:21'),
(1705,'default','login',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-03-16 21:55:50','2025-03-16 21:55:50'),
(1706,'default','added',1096,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-03-16 21:56:24','2025-03-16 21:56:24'),
(1707,'default','added',28,'App\\Contact',NULL,11,17,'App\\User','[]',NULL,'2025-03-16 22:00:19','2025-03-16 22:00:19'),
(1708,'default','added',1097,'App\\Transaction',NULL,11,17,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-03-16 22:00:55','2025-03-16 22:00:55'),
(1709,'default','logout',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-03-16 22:02:11','2025-03-16 22:02:11'),
(1710,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-17 18:05:30','2025-03-17 18:05:30'),
(1711,'default','login',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-03-18 19:48:02','2025-03-18 19:48:02'),
(1712,'default','login',17,'App\\User',NULL,11,17,'App\\User','[]',NULL,'2025-03-18 19:59:09','2025-03-18 19:59:09'),
(1713,'default','login',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-03-23 20:40:00','2025-03-23 20:40:00'),
(1714,'default','added',29,'App\\Contact',NULL,11,22,'App\\User','[]',NULL,'2025-03-23 20:55:14','2025-03-23 20:55:14'),
(1715,'default','edited',29,'App\\Contact',NULL,11,22,'App\\User','[]',NULL,'2025-03-23 20:57:06','2025-03-23 20:57:06'),
(1716,'default','added',1098,'App\\Transaction',NULL,11,22,'App\\User','[]',NULL,'2025-03-23 21:01:48','2025-03-23 21:01:48'),
(1717,'default','status_updated',1098,'App\\Transaction',NULL,11,22,'App\\User','{\"from\":\"ordered\",\"to\":\"completed\"}',NULL,'2025-03-23 21:04:00','2025-03-23 21:04:00'),
(1718,'default','shipping_edited',1098,'App\\Transaction',NULL,11,22,'App\\User','{\"update_note\":null}',NULL,'2025-03-23 21:05:03','2025-03-23 21:05:03'),
(1719,'default','shipping_edited',1098,'App\\Transaction',NULL,11,22,'App\\User','{\"update_note\":null}',NULL,'2025-03-23 21:10:07','2025-03-23 21:10:07'),
(1720,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-03-25 15:22:16','2025-03-25 15:22:16'),
(1721,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-03-26 09:24:49','2025-03-26 09:24:49'),
(1722,'default','added',1099,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2739.8}}',NULL,'2025-03-26 10:37:56','2025-03-26 10:37:56'),
(1723,'default','sell_deleted',1099,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":1099,\"invoice_no\":\"62061P\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"2739.8000\"}}',NULL,'2025-03-26 10:39:08','2025-03-26 10:39:08'),
(1724,'default','added',1100,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":2503.2}}',NULL,'2025-03-26 10:42:55','2025-03-26 10:42:55'),
(1725,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-03-26 13:40:42','2025-03-26 13:40:42'),
(1726,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-04-05 17:25:20','2025-04-05 17:25:20'),
(1727,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-04-06 12:44:43','2025-04-06 12:44:43'),
(1728,'default','added',25,'App\\User',NULL,2,2,'App\\User','{\"name\":\" Mohamed Hossam\"}',NULL,'2025-04-06 12:51:17','2025-04-06 12:51:17'),
(1729,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-06 02:32:31','2025-05-06 02:32:31'),
(1730,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-05-08 11:42:00','2025-05-08 11:42:00'),
(1731,'default','added',30,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2025-05-08 11:43:56','2025-05-08 11:43:56'),
(1732,'default','added',31,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2025-05-08 11:44:50','2025-05-08 11:44:50'),
(1733,'default','added',32,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2025-05-08 11:45:37','2025-05-08 11:45:37'),
(1734,'default','added',33,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2025-05-08 11:46:32','2025-05-08 11:46:32'),
(1735,'default','added',34,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2025-05-08 11:47:11','2025-05-08 11:47:11'),
(1736,'default','added',1101,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":23496}}',NULL,'2025-05-08 11:55:40','2025-05-08 11:55:40'),
(1737,'default','added',1102,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":94340}}',NULL,'2025-05-08 12:08:10','2025-05-08 12:08:10'),
(1738,'default','purchase_deleted',1101,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"23496.0000\"}}',NULL,'2025-05-08 12:08:18','2025-05-08 12:08:18'),
(1739,'default','payment_edited',1102,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"94340.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"94340.0000\"}}',NULL,'2025-05-08 12:16:00','2025-05-08 12:16:00'),
(1740,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-05-08 14:45:08','2025-05-08 14:45:08'),
(1741,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-10 10:39:19','2025-05-10 10:39:19'),
(1742,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-12 14:51:47','2025-05-12 14:51:47'),
(1743,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-05-12 17:00:50','2025-05-12 17:00:50'),
(1744,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-05-13 12:13:53','2025-05-13 12:13:53'),
(1745,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-05-17 10:49:35','2025-05-17 10:49:35'),
(1746,'default','added',1103,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6292}}',NULL,'2025-05-17 10:50:40','2025-05-17 10:50:40'),
(1747,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-06-01 20:07:36','2025-06-01 20:07:36'),
(1748,'default','added',26,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr Ammar Gamal\"}',NULL,'2025-06-01 20:19:13','2025-06-01 20:19:13'),
(1749,'default','login',26,'App\\User',NULL,2,26,'App\\User','[]',NULL,'2025-06-01 20:19:32','2025-06-01 20:19:32'),
(1750,'default','added',1104,'App\\Transaction',NULL,2,26,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2025-06-01 20:23:47','2025-06-01 20:23:47'),
(1751,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-04 08:20:57','2025-06-04 08:20:57'),
(1752,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-04 08:42:11','2025-06-04 08:42:11'),
(1753,'default','added',1105,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-06-04 10:51:21','2025-06-04 10:51:21'),
(1754,'default','added',1106,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":10}}',NULL,'2025-06-04 10:54:10','2025-06-04 10:54:10'),
(1755,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-09 09:43:56','2025-06-09 09:43:56'),
(1756,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-06-10 12:12:04','2025-06-10 12:12:04'),
(1757,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-06-10 12:12:19','2025-06-10 12:12:19'),
(1758,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-06-10 12:14:52','2025-06-10 12:14:52'),
(1759,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-06-10 12:14:59','2025-06-10 12:14:59'),
(1760,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-06-10 12:16:57','2025-06-10 12:16:57'),
(1761,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-10 10:17:04','2025-06-10 10:17:04'),
(1762,'default','login',27,'App\\User',NULL,12,27,'App\\User','[]',NULL,'2025-06-10 12:22:31','2025-06-10 12:22:31'),
(1763,'default','deleted',26,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr Ammar Gamal\",\"id\":26}',NULL,'2025-06-10 12:25:22','2025-06-10 12:25:22'),
(1764,'default','added',28,'App\\User',NULL,12,27,'App\\User','{\"name\":\"Mr Amaar Gamal\"}',NULL,'2025-06-10 12:26:43','2025-06-10 12:26:43'),
(1765,'default','edited',28,'App\\User',NULL,12,27,'App\\User','{\"name\":\"Mr Amaar Gamal\"}',NULL,'2025-06-10 12:27:02','2025-06-10 12:27:02'),
(1766,'default','login',27,'App\\User',NULL,12,27,'App\\User','[]',NULL,'2025-06-10 13:37:35','2025-06-10 13:37:35'),
(1767,'default','login',28,'App\\User',NULL,12,28,'App\\User','[]',NULL,'2025-06-10 13:49:46','2025-06-10 13:49:46'),
(1768,'default','login',28,'App\\User',NULL,12,28,'App\\User','[]',NULL,'2025-06-11 21:26:19','2025-06-11 21:26:19'),
(1769,'default','login',28,'App\\User',NULL,12,28,'App\\User','[]',NULL,'2025-06-15 10:29:55','2025-06-15 10:29:55'),
(1770,'default','added',1109,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50.28}}',NULL,'2025-06-21 15:57:21','2025-06-21 15:57:21'),
(1771,'default','added',37,'App\\Contact',NULL,13,29,'App\\User','[]',NULL,'2025-06-21 16:36:08','2025-06-21 16:36:08'),
(1772,'default','added',1113,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":2500}}',NULL,'2025-06-21 16:36:12','2025-06-21 16:36:12'),
(1773,'default','added',1114,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1000}}',NULL,'2025-06-21 16:38:06','2025-06-21 16:38:06'),
(1774,'default','added',1115,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":200}}',NULL,'2025-06-21 16:39:31','2025-06-21 16:39:31'),
(1775,'default','edited',1113,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":16.67},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"}}',NULL,'2025-06-21 16:53:14','2025-06-21 16:53:14'),
(1776,'default','edited',1114,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":50},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"}}',NULL,'2025-06-21 16:53:59','2025-06-21 16:53:59'),
(1777,'default','added',1116,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12.75}}',NULL,'2025-06-21 16:58:35','2025-06-21 16:58:35'),
(1778,'default','edited',1113,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":30},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"16.6700\"}}',NULL,'2025-06-21 17:04:33','2025-06-21 17:04:33'),
(1779,'default','payment_edited',1113,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"30.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"30.0000\"}}',NULL,'2025-06-21 17:06:08','2025-06-21 17:06:08'),
(1780,'default','payment_deleted',166,'App\\TransactionPayment',NULL,13,29,'App\\User','{\"id\":166,\"ref_no\":\"PP2025\\/0001\"}',NULL,'2025-06-21 17:06:08','2025-06-21 17:06:08'),
(1781,'default','payment_edited',1114,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"50.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"50.0000\"}}',NULL,'2025-06-21 17:06:15','2025-06-21 17:06:15'),
(1782,'default','payment_deleted',167,'App\\TransactionPayment',NULL,13,29,'App\\User','{\"id\":167,\"ref_no\":\"PP2025\\/0002\"}',NULL,'2025-06-21 17:06:15','2025-06-21 17:06:15'),
(1783,'default','payment_edited',1115,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"200.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"200.0000\"}}',NULL,'2025-06-21 17:06:19','2025-06-21 17:06:19'),
(1784,'default','payment_deleted',168,'App\\TransactionPayment',NULL,13,29,'App\\User','{\"id\":168,\"ref_no\":\"PP2025\\/0003\"}',NULL,'2025-06-21 17:06:19','2025-06-21 17:06:19'),
(1785,'default','payment_edited',1115,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"200.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"200.0000\"}}',NULL,'2025-06-21 17:06:36','2025-06-21 17:06:36'),
(1786,'default','payment_edited',1114,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"50.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"50.0000\"}}',NULL,'2025-06-21 17:06:41','2025-06-21 17:06:41'),
(1787,'default','payment_edited',1113,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"30.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"30.0000\"}}',NULL,'2025-06-21 17:06:47','2025-06-21 17:06:47'),
(1788,'default','added',1117,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":63.75}}',NULL,'2025-06-21 17:08:13','2025-06-21 17:08:13'),
(1789,'default','added',1118,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":63.75}}',NULL,'2025-06-21 17:12:06','2025-06-21 17:12:06'),
(1790,'default','added',1119,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12.75}}',NULL,'2025-06-21 17:14:26','2025-06-21 17:14:26'),
(1791,'default','added',38,'App\\Contact',NULL,13,29,'App\\User','[]',NULL,'2025-06-21 17:27:06','2025-06-21 17:27:06'),
(1792,'default','edited',38,'App\\Contact',NULL,13,29,'App\\User','[]',NULL,'2025-06-21 17:28:18','2025-06-21 17:28:18'),
(1793,'default','login',29,'App\\User',NULL,13,29,'App\\User','[]',NULL,'2025-06-21 17:33:06','2025-06-21 17:33:06'),
(1794,'default','edited',37,'App\\Contact',NULL,13,29,'App\\User','[]',NULL,'2025-06-21 19:14:14','2025-06-21 19:14:14'),
(1795,'default','added',1122,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":37.89}}',NULL,'2025-06-22 01:35:14','2025-06-22 01:35:14'),
(1796,'default','added',1123,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":89.71}}',NULL,'2025-06-22 02:08:33','2025-06-22 02:08:33'),
(1797,'default','added',1124,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":25.14}}',NULL,'2025-06-22 02:10:44','2025-06-22 02:10:44'),
(1798,'default','payment_edited',1124,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"25.1400\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"25.1400\"}}',NULL,'2025-06-22 02:11:38','2025-06-22 02:11:38'),
(1799,'default','added',1125,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":63.53}}',NULL,'2025-06-22 09:35:13','2025-06-22 09:35:13'),
(1800,'default','added',1126,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50.96}}',NULL,'2025-06-22 09:41:48','2025-06-22 09:41:48'),
(1801,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-22 07:43:35','2025-06-22 07:43:35'),
(1802,'default','added',1127,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50.46}}',NULL,'2025-06-22 09:54:06','2025-06-22 09:54:06'),
(1803,'default','added',1128,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":90}}',NULL,'2025-06-22 10:19:20','2025-06-22 10:19:20'),
(1804,'default','payment_edited',1128,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"90.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"90.0000\"}}',NULL,'2025-06-22 10:19:28','2025-06-22 10:19:28'),
(1805,'default','added',1131,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":66.25}}',NULL,'2025-06-22 10:26:13','2025-06-22 10:26:13'),
(1806,'default','added',1132,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13.25}}',NULL,'2025-06-22 10:28:04','2025-06-22 10:28:04'),
(1807,'default','added',1133,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13.25}}',NULL,'2025-06-22 10:29:53','2025-06-22 10:29:53'),
(1808,'default','added',1134,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25.82}}',NULL,'2025-06-22 10:31:11','2025-06-22 10:31:11'),
(1809,'default','added',1137,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13.25}}',NULL,'2025-06-22 10:34:03','2025-06-22 10:34:03'),
(1810,'default','added',1142,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38.39}}',NULL,'2025-06-22 11:07:35','2025-06-22 11:07:35'),
(1811,'default','added',1144,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":630}}',NULL,'2025-06-22 11:21:05','2025-06-22 11:21:05'),
(1812,'default','payment_edited',1144,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"630.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"630.0000\"}}',NULL,'2025-06-22 11:21:10','2025-06-22 11:21:10'),
(1813,'default','added',1147,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50.28}}',NULL,'2025-06-22 11:25:15','2025-06-22 11:25:15'),
(1814,'default','added',1150,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100.56}}',NULL,'2025-06-22 11:27:28','2025-06-22 11:27:28'),
(1815,'default','added',39,'App\\Contact',NULL,11,22,'App\\User','[]',NULL,'2025-06-22 21:28:34','2025-06-22 21:28:34'),
(1816,'default','added',1151,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":46}}',NULL,'2025-06-22 21:29:13','2025-06-22 21:29:13'),
(1817,'default','added',1152,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":14}}',NULL,'2025-06-22 21:29:29','2025-06-22 21:29:29'),
(1818,'default','added',1153,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":91}}',NULL,'2025-06-22 21:29:58','2025-06-22 21:29:58'),
(1819,'default','added',1157,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14}}',NULL,'2025-06-22 21:44:10','2025-06-22 21:44:10'),
(1820,'default','added',1158,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":14}}',NULL,'2025-06-22 21:44:44','2025-06-22 21:44:44'),
(1821,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-23 02:20:13','2025-06-23 02:20:13'),
(1822,'default','login',30,'App\\User',NULL,14,30,'App\\User','[]',NULL,'2025-06-23 12:05:00','2025-06-23 12:05:00'),
(1823,'default','edited',28,'App\\Contact',NULL,11,22,'App\\User','[]',NULL,'2025-06-23 11:21:39','2025-06-23 11:21:39'),
(1824,'default','added',1177,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82}}',NULL,'2025-06-23 11:25:06','2025-06-23 11:25:06'),
(1825,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-24 07:49:27','2025-06-24 07:49:27'),
(1826,'default','login',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-06-24 10:06:51','2025-06-24 10:06:51'),
(1827,'default','added',32,'App\\User',NULL,11,22,'App\\User','{\"name\":\"Mr Mohamed M\"}',NULL,'2025-06-24 10:13:07','2025-06-24 10:13:07'),
(1828,'default','login',32,'App\\User',NULL,11,32,'App\\User','[]',NULL,'2025-06-24 10:13:41','2025-06-24 10:13:41'),
(1829,'default','created',1,'Modules\\Essentials\\Entities\\EssentialsLeave','created',NULL,22,'App\\User','{\"attributes\":{\"id\":1,\"essentials_leave_type_id\":\"1\",\"business_id\":\"11\",\"user_id\":\"32\",\"start_date\":\"2025-06-24\",\"end_date\":\"2025-06-27\",\"ref_no\":\"2025\\/0001\",\"status\":\"pending\",\"reason\":\"Very Sick\",\"status_note\":null,\"created_at\":\"2025-06-24T09:20:06.000000Z\",\"updated_at\":\"2025-06-24T09:20:06.000000Z\"}}',NULL,'2025-06-24 10:20:06','2025-06-24 10:20:06'),
(1830,'default','created',2,'Modules\\Essentials\\Entities\\EssentialsLeave','created',NULL,32,'App\\User','{\"attributes\":{\"id\":2,\"essentials_leave_type_id\":\"1\",\"business_id\":\"11\",\"user_id\":\"32\",\"start_date\":\"2025-06-24\",\"end_date\":\"2025-06-27\",\"ref_no\":\"2025\\/0002\",\"status\":\"pending\",\"reason\":\"Sick\",\"status_note\":null,\"created_at\":\"2025-06-24T09:21:23.000000Z\",\"updated_at\":\"2025-06-24T09:21:23.000000Z\"}}',NULL,'2025-06-24 10:21:23','2025-06-24 10:21:23'),
(1831,'default','updated',2,'Modules\\Essentials\\Entities\\EssentialsLeave','updated',NULL,22,'App\\User','{\"attributes\":{\"status\":\"approved\",\"updated_at\":\"2025-06-24T09:21:43.000000Z\"},\"old\":{\"status\":\"pending\",\"updated_at\":\"2025-06-24T09:21:23.000000Z\"}}',NULL,'2025-06-24 10:21:43','2025-06-24 10:21:43'),
(1832,'default','updated',2,'Modules\\Essentials\\Entities\\EssentialsLeave','updated',NULL,32,'App\\User','{\"attributes\":{\"status\":\"cancelled\",\"updated_at\":\"2025-06-24T09:22:02.000000Z\"},\"old\":{\"status\":\"approved\",\"updated_at\":\"2025-06-24T09:21:43.000000Z\"}}',NULL,'2025-06-24 10:22:02','2025-06-24 10:22:02'),
(1833,'default','updated',2,'Modules\\Essentials\\Entities\\EssentialsLeave','updated',NULL,32,'App\\User','{\"attributes\":{\"status\":\"approved\",\"updated_at\":\"2025-06-24T09:22:07.000000Z\"},\"old\":{\"status\":\"cancelled\",\"updated_at\":\"2025-06-24T09:22:02.000000Z\"}}',NULL,'2025-06-24 10:22:08','2025-06-24 10:22:08'),
(1834,'default','created',3,'Modules\\Essentials\\Entities\\EssentialsLeave','created',NULL,32,'App\\User','{\"attributes\":{\"id\":3,\"essentials_leave_type_id\":\"1\",\"business_id\":\"11\",\"user_id\":\"32\",\"start_date\":\"2025-07-01\",\"end_date\":\"2025-07-30\",\"ref_no\":\"2025\\/0003\",\"status\":\"pending\",\"reason\":\"Holiday\",\"status_note\":null,\"created_at\":\"2025-06-24T09:24:30.000000Z\",\"updated_at\":\"2025-06-24T09:24:30.000000Z\"}}',NULL,'2025-06-24 10:24:30','2025-06-24 10:24:30'),
(1835,'default','updated',3,'Modules\\Essentials\\Entities\\EssentialsLeave','updated',NULL,22,'App\\User','{\"attributes\":{\"status\":\"approved\",\"updated_at\":\"2025-06-24T09:25:04.000000Z\"},\"old\":{\"status\":\"pending\",\"updated_at\":\"2025-06-24T09:24:30.000000Z\"}}',NULL,'2025-06-24 10:25:04','2025-06-24 10:25:04'),
(1836,'default','updated',3,'Modules\\Essentials\\Entities\\EssentialsLeave','updated',NULL,22,'App\\User','{\"attributes\":{\"status\":\"cancelled\",\"updated_at\":\"2025-06-24T09:26:02.000000Z\"},\"old\":{\"status\":\"approved\",\"updated_at\":\"2025-06-24T09:25:04.000000Z\"}}',NULL,'2025-06-24 10:26:02','2025-06-24 10:26:02'),
(1837,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-24 08:36:21','2025-06-24 08:36:21'),
(1838,'default','login',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-06-24 10:36:28','2025-06-24 10:36:28'),
(1839,'default','updated',3,'Modules\\Essentials\\Entities\\EssentialsLeave','updated',NULL,22,'App\\User','{\"attributes\":{\"status\":\"approved\",\"updated_at\":\"2025-06-24T09:46:20.000000Z\"},\"old\":{\"status\":\"cancelled\",\"updated_at\":\"2025-06-24T09:26:02.000000Z\"}}',NULL,'2025-06-24 10:46:20','2025-06-24 10:46:20'),
(1840,'default','added',1202,'App\\Transaction',NULL,11,22,'App\\User','[]',NULL,'2025-06-24 11:59:11','2025-06-24 11:59:11'),
(1841,'default','added',1203,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"status\":\"pending\"}}',NULL,'2025-06-24 12:00:31','2025-06-24 12:00:31'),
(1842,'default','added',1205,'App\\Transaction',NULL,11,22,'App\\User','[]',NULL,'2025-06-24 12:04:31','2025-06-24 12:04:31'),
(1843,'default','shipping_edited',1205,'App\\Transaction',NULL,11,22,'App\\User','{\"update_note\":null}',NULL,'2025-06-24 12:05:31','2025-06-24 12:05:31'),
(1844,'default','status_updated',1205,'App\\Transaction',NULL,11,22,'App\\User','{\"from\":\"ordered\",\"to\":\"completed\"}',NULL,'2025-06-24 12:05:38','2025-06-24 12:05:38'),
(1845,'default','edited',1205,'App\\Transaction',NULL,11,22,'App\\User','[]',NULL,'2025-06-24 12:07:46','2025-06-24 12:07:46'),
(1846,'default','added',1206,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"pending\",\"payment_status\":\"due\",\"final_total\":2300}}',NULL,'2025-06-24 12:08:39','2025-06-24 12:08:39'),
(1847,'default','logout',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-06-24 12:32:01','2025-06-24 12:32:01'),
(1848,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-24 10:32:29','2025-06-24 10:32:29'),
(1849,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-06-24 12:35:03','2025-06-24 12:35:03'),
(1850,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-24 21:51:56','2025-06-24 21:51:56'),
(1851,'default','added',41,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-06-24 22:06:07','2025-06-24 22:06:07'),
(1852,'default','added',1208,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2025-06-24 22:06:11','2025-06-24 22:06:11'),
(1853,'default','added',1209,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2025-06-24 22:10:41','2025-06-24 22:10:41'),
(1854,'default','added',1210,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2025-06-24 22:11:54','2025-06-24 22:11:54'),
(1855,'default','created',1,'App\\DocumentAndNote','created',NULL,1,'App\\User','[]',NULL,'2025-06-24 22:12:47','2025-06-24 22:12:47'),
(1856,'default','email_notification_sent',1211,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2025-06-24 22:19:06','2025-06-24 22:19:06'),
(1857,'default','added',1211,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2025-06-24 22:19:06','2025-06-24 22:19:06'),
(1858,'default','email_notification_sent',1212,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2025-06-24 22:19:24','2025-06-24 22:19:24'),
(1859,'default','added',1212,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2025-06-24 22:19:24','2025-06-24 22:19:24'),
(1860,'default','edited',41,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-06-24 22:20:27','2025-06-24 22:20:27'),
(1861,'default','login',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-06-26 15:46:44','2025-06-26 15:46:44'),
(1862,'default','added',1213,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":66}}',NULL,'2025-06-26 16:13:39','2025-06-26 16:13:39'),
(1863,'default','added',1214,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":40}}',NULL,'2025-06-26 16:18:38','2025-06-26 16:18:38'),
(1864,'default','login',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-06-26 16:28:13','2025-06-26 16:28:13'),
(1865,'default','added',1215,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":40}}',NULL,'2025-06-26 16:31:51','2025-06-26 16:31:51'),
(1866,'default','added',1216,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10}}',NULL,'2025-06-26 16:37:23','2025-06-26 16:37:23'),
(1867,'default','edited',1216,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":10},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10.0000\"}}',NULL,'2025-06-26 16:37:44','2025-06-26 16:37:44'),
(1868,'default','edited',1216,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10.0000\"}}',NULL,'2025-06-26 16:38:43','2025-06-26 16:38:43'),
(1869,'default','logout',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-06-26 16:39:51','2025-06-26 16:39:51'),
(1870,'default','login',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-06-26 16:43:08','2025-06-26 16:43:08'),
(1871,'default','login',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-06-26 23:11:39','2025-06-26 23:11:39'),
(1872,'default','added',1217,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":28}}',NULL,'2025-06-26 23:15:15','2025-06-26 23:15:15'),
(1873,'default','edited',1217,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":28},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"28.0000\"}}',NULL,'2025-06-26 23:16:08','2025-06-26 23:16:08'),
(1874,'default','payment_edited',1217,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"28.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"28.0000\"}}',NULL,'2025-06-26 23:17:55','2025-06-26 23:17:55'),
(1875,'default','payment_edited',1217,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"28.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"28.0000\"}}',NULL,'2025-06-26 23:19:00','2025-06-26 23:19:00'),
(1876,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-26 21:20:56','2025-06-26 21:20:56'),
(1877,'default','email_notification_sent',1218,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2025-06-26 21:28:49','2025-06-26 21:28:49'),
(1878,'default','added',1218,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2025-06-26 21:28:49','2025-06-26 21:28:49'),
(1879,'default','logout',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-06-26 23:29:09','2025-06-26 23:29:09'),
(1880,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-26 21:29:16','2025-06-26 21:29:16'),
(1881,'default','added',1219,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2025-06-26 21:30:03','2025-06-26 21:30:03'),
(1882,'default','email_notification_sent',1220,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2025-06-26 21:42:46','2025-06-26 21:42:46'),
(1883,'default','sms_notification_sent',1220,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2025-06-26 21:42:46','2025-06-26 21:42:46'),
(1884,'default','added',1220,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2025-06-26 21:42:46','2025-06-26 21:42:46'),
(1885,'default','added',43,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-06-26 21:43:48','2025-06-26 21:43:48'),
(1886,'default','edited',43,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-06-26 21:46:48','2025-06-26 21:46:48'),
(1887,'default','email_notification_sent',1221,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2025-06-26 21:48:39','2025-06-26 21:48:39'),
(1888,'default','sms_notification_sent',1221,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2025-06-26 21:48:39','2025-06-26 21:48:39'),
(1889,'default','added',1221,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2025-06-26 21:48:39','2025-06-26 21:48:39'),
(1890,'default','login',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-07-01 10:16:59','2025-07-01 10:16:59'),
(1891,'default','logout',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-07-01 10:21:32','2025-07-01 10:21:32'),
(1892,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-07-01 08:21:44','2025-07-01 08:21:44'),
(1893,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-07-03 10:08:50','2025-07-03 10:08:50'),
(1894,'default','added',1222,'App\\Transaction',NULL,11,22,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":171}}',NULL,'2025-07-03 12:24:09','2025-07-03 12:24:09'),
(1895,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-07-05 05:13:57','2025-07-05 05:13:57'),
(1896,'default','login',22,'App\\User',NULL,11,22,'App\\User','[]',NULL,'2025-07-07 09:17:47','2025-07-07 09:17:47'),
(1897,'default','logout',29,'App\\User',NULL,13,29,'App\\User','[]',NULL,'2025-07-07 09:50:23','2025-07-07 09:50:23'),
(1898,'default','login',34,'App\\User',NULL,16,34,'App\\User','[]',NULL,'2025-07-07 09:50:31','2025-07-07 09:50:31'),
(1899,'default','login',34,'App\\User',NULL,16,34,'App\\User','[]',NULL,'2025-07-07 11:32:41','2025-07-07 11:32:41'),
(1900,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-07-07 17:57:00','2025-07-07 17:57:00'),
(1901,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-07-09 05:14:43','2025-07-09 05:14:43'),
(1902,'default','login',34,'App\\User',NULL,16,34,'App\\User','[]',NULL,'2025-07-09 07:46:29','2025-07-09 07:46:29'),
(1903,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-07-09 14:19:42','2025-07-09 14:19:42'),
(1904,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-07-09 14:20:34','2025-07-09 14:20:34'),
(1905,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-07-09 14:20:54','2025-07-09 14:20:54'),
(1906,'default','added',35,'App\\User',NULL,8,11,'App\\User','{\"name\":\"Mr Demo Man\"}',NULL,'2025-07-09 16:21:54','2025-07-09 16:21:54'),
(1907,'default','logout',11,'App\\User',NULL,8,11,'App\\User','[]',NULL,'2025-07-09 16:22:09','2025-07-09 16:22:09'),
(1908,'default','login',35,'App\\User',NULL,8,35,'App\\User','[]',NULL,'2025-07-09 16:22:19','2025-07-09 16:22:19'),
(1909,'default','edited',12,'App\\User',NULL,8,35,'App\\User','{\"name\":\"Mr Waiter 1\"}',NULL,'2025-07-09 16:25:18','2025-07-09 16:25:18'),
(1910,'default','added',1223,'App\\Transaction',NULL,8,35,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":136}}',NULL,'2025-07-09 16:26:19','2025-07-09 16:26:19'),
(1911,'default','added',1224,'App\\Transaction',NULL,8,35,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":30}}',NULL,'2025-07-09 16:27:00','2025-07-09 16:27:00'),
(1912,'default','edited',1223,'App\\Transaction',NULL,8,35,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":136},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"136.0000\"}}',NULL,'2025-07-09 16:27:37','2025-07-09 16:27:37'),
(1913,'default','login',35,'App\\User',NULL,8,35,'App\\User','[]',NULL,'2025-07-09 16:30:43','2025-07-09 16:30:43'),
(1914,'default','added',1225,'App\\Transaction',NULL,8,35,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":30}}',NULL,'2025-07-09 16:31:25','2025-07-09 16:31:25'),
(1915,'default','edited',12,'App\\User',NULL,8,35,'App\\User','{\"name\":\"Mr Waiter 1\"}',NULL,'2025-07-09 16:32:27','2025-07-09 16:32:27'),
(1916,'default','logout',35,'App\\User',NULL,8,35,'App\\User','[]',NULL,'2025-07-09 16:32:38','2025-07-09 16:32:38'),
(1917,'default','login',12,'App\\User',NULL,8,12,'App\\User','[]',NULL,'2025-07-09 16:32:45','2025-07-09 16:32:45'),
(1918,'default','edited',12,'App\\User',NULL,8,35,'App\\User','{\"name\":\"Mr Waiter 1\"}',NULL,'2025-07-09 16:35:04','2025-07-09 16:35:04'),
(1919,'default','edited',35,'App\\User',NULL,8,35,'App\\User','{\"name\":\"Mr Demo Man\"}',NULL,'2025-07-09 16:35:50','2025-07-09 16:35:50'),
(1920,'default','edited',11,'App\\User',NULL,8,35,'App\\User','{\"name\":\"Demo Restaurant \"}',NULL,'2025-07-09 16:36:44','2025-07-09 16:36:44'),
(1921,'default','login',34,'App\\User',NULL,16,34,'App\\User','[]',NULL,'2025-07-10 17:04:12','2025-07-10 17:04:12'),
(1922,'default','added',1226,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":75}}',NULL,'2025-07-10 17:29:40','2025-07-10 17:29:40'),
(1923,'default','edited',1226,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"75.0000\"}}',NULL,'2025-07-10 17:31:03','2025-07-10 17:31:03'),
(1924,'default','sell_deleted',1226,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1226,\"invoice_no\":\"0001\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"75.0000\"}}',NULL,'2025-07-10 17:32:10','2025-07-10 17:32:10'),
(1925,'default','added',1227,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":15}}',NULL,'2025-07-10 17:32:59','2025-07-10 17:32:59'),
(1926,'default','added',1228,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-07-10 17:39:12','2025-07-10 17:39:12'),
(1927,'default','added',1229,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-07-10 17:40:13','2025-07-10 17:40:13'),
(1928,'default','added',1230,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45}}',NULL,'2025-07-10 17:40:25','2025-07-10 17:40:25'),
(1929,'default','added',1231,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45}}',NULL,'2025-07-10 17:41:44','2025-07-10 17:41:44'),
(1930,'default','added',1232,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45}}',NULL,'2025-07-10 17:48:12','2025-07-10 17:48:12'),
(1931,'default','added',1233,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2025-07-10 17:51:26','2025-07-10 17:51:26'),
(1932,'default','added',1234,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-07-10 17:59:33','2025-07-10 17:59:33'),
(1933,'default','added',36,'App\\User',NULL,16,34,'App\\User','{\"name\":\"Mr Ahmed Mohamed\"}',NULL,'2025-07-10 18:04:15','2025-07-10 18:04:15'),
(1934,'default','added',37,'App\\User',NULL,16,34,'App\\User','{\"name\":\" HR Dep\"}',NULL,'2025-07-13 14:47:14','2025-07-13 14:47:14'),
(1935,'default','added',38,'App\\User',NULL,16,34,'App\\User','{\"name\":\" Accountant \"}',NULL,'2025-07-13 14:48:16','2025-07-13 14:48:16'),
(1936,'default','added',39,'App\\User',NULL,16,34,'App\\User','{\"name\":\" POS Cashier\"}',NULL,'2025-07-13 14:49:02','2025-07-13 14:49:02'),
(1937,'default','added',40,'App\\User',NULL,16,34,'App\\User','{\"name\":\" Alrayyan Cashier\"}',NULL,'2025-07-13 15:37:21','2025-07-13 15:37:21'),
(1938,'default','added',1236,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":15}}',NULL,'2025-07-13 17:03:45','2025-07-13 17:03:45'),
(1939,'default','added',1237,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2025-07-13 17:15:37','2025-07-13 17:15:37'),
(1940,'default','added',1238,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-07-13 17:29:43','2025-07-13 17:29:43'),
(1941,'default','added',1239,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-07-13 17:36:48','2025-07-13 17:36:48'),
(1942,'default','added',1240,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-07-13 17:38:56','2025-07-13 17:38:56'),
(1943,'default','login',35,'App\\User',NULL,8,35,'App\\User','[]',NULL,'2025-07-13 18:11:26','2025-07-13 18:11:26'),
(1944,'default','added',45,'App\\Contact',NULL,8,35,'App\\User','[]',NULL,'2025-07-13 18:14:28','2025-07-13 18:14:28'),
(1945,'default','added',1241,'App\\Transaction',NULL,8,35,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2025-07-13 18:22:20','2025-07-13 18:22:20'),
(1946,'default','edited',1241,'App\\Transaction',NULL,8,35,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}',NULL,'2025-07-13 18:26:34','2025-07-13 18:26:34'),
(1947,'default','payment_edited',1241,'App\\Transaction',NULL,8,35,'App\\User','{\"attributes\":{\"payment_status\":\"due\"},\"old\":{\"payment_status\":\"paid\"}}',NULL,'2025-07-13 18:27:08','2025-07-13 18:27:08'),
(1948,'default','payment_deleted',230,'App\\TransactionPayment',NULL,8,35,'App\\User','{\"id\":230,\"ref_no\":\"SP2025\\/0005\"}',NULL,'2025-07-13 18:27:08','2025-07-13 18:27:08'),
(1949,'default','login',35,'App\\User',NULL,8,35,'App\\User','[]',NULL,'2025-07-13 19:27:15','2025-07-13 19:27:15'),
(1950,'default','added',1242,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25.82}}',NULL,'2025-07-20 12:18:00','2025-07-20 12:18:00'),
(1951,'default','added',1243,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":201.12}}',NULL,'2025-07-20 12:19:43','2025-07-20 12:19:43'),
(1952,'default','added',1244,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":132.5}}',NULL,'2025-07-20 12:26:02','2025-07-20 12:26:02'),
(1953,'default','logout',34,'App\\User',NULL,16,34,'App\\User','[]',NULL,'2025-07-20 14:08:51','2025-07-20 14:08:51'),
(1954,'default','login',35,'App\\User',NULL,8,35,'App\\User','[]',NULL,'2025-07-20 14:09:25','2025-07-20 14:09:25'),
(1955,'default','login',35,'App\\User',NULL,8,35,'App\\User','[]',NULL,'2025-07-22 16:38:28','2025-07-22 16:38:28'),
(1956,'default','login',28,'App\\User',NULL,12,28,'App\\User','[]',NULL,'2025-07-23 14:57:01','2025-07-23 14:57:01'),
(1957,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-07-26 10:01:23','2025-07-26 10:01:23'),
(1958,'default','logout',35,'App\\User',NULL,8,35,'App\\User','[]',NULL,'2025-07-26 12:04:56','2025-07-26 12:04:56'),
(1959,'default','login',35,'App\\User',NULL,8,35,'App\\User','[]',NULL,'2025-07-26 12:05:51','2025-07-26 12:05:51'),
(1960,'default','added',46,'App\\Contact',NULL,8,35,'App\\User','[]',NULL,'2025-07-26 14:28:58','2025-07-26 14:28:58'),
(1961,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-07-27 06:12:12','2025-07-27 06:12:12'),
(1962,'default','added',1248,'App\\Transaction',NULL,8,35,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":60000}}',NULL,'2025-07-27 08:56:45','2025-07-27 08:56:45'),
(1963,'default','added',47,'App\\Contact',NULL,14,30,'App\\User','[]',NULL,'2025-07-31 15:53:31','2025-07-31 15:53:31'),
(1964,'default','added',1253,'App\\Transaction',NULL,14,30,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"shipping_status\":\"ordered\",\"final_total\":3807}}',NULL,'2025-07-31 16:01:22','2025-07-31 16:01:22'),
(1965,'default','edited',1253,'App\\Transaction',NULL,14,30,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":3807},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"shipping_status\":\"ordered\",\"final_total\":\"3807.0000\"}}',NULL,'2025-07-31 16:02:56','2025-07-31 16:02:56'),
(1966,'default','edited',1253,'App\\Transaction',NULL,14,30,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"proforma\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"3807.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"3807.0000\"}}',NULL,'2025-07-31 16:03:23','2025-07-31 16:03:23'),
(1967,'default','edited',1253,'App\\Transaction',NULL,14,30,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":3807},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"proforma\",\"shipping_status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"3807.0000\"}}',NULL,'2025-07-31 21:15:46','2025-07-31 21:15:46'),
(1968,'default','added',48,'App\\Contact',NULL,16,34,'App\\User','[]',NULL,'2025-07-31 21:00:07','2025-07-31 21:00:07'),
(1969,'default','login',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-02 08:46:16','2025-08-02 08:46:16'),
(1970,'default','login',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-02 11:54:08','2025-08-02 11:54:08'),
(1971,'default','logout',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-02 11:54:30','2025-08-02 11:54:30'),
(1972,'default','login',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-02 11:57:05','2025-08-02 11:57:05'),
(1973,'default','logout',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-02 11:57:16','2025-08-02 11:57:16'),
(1974,'default','login',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-02 11:57:58','2025-08-02 11:57:58'),
(1975,'default','logout',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-02 11:59:47','2025-08-02 11:59:47'),
(1976,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-08-02 10:00:49','2025-08-02 10:00:49'),
(1977,'default','added',1254,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50.96}}',NULL,'2025-08-02 12:10:44','2025-08-02 12:10:44'),
(1978,'default','added',1255,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25.82}}',NULL,'2025-08-02 12:11:30','2025-08-02 12:11:30'),
(1979,'default','added',1256,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25.82}}',NULL,'2025-08-02 12:12:33','2025-08-02 12:12:33'),
(1980,'default','edited',1256,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25.82},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"25.8200\"}}',NULL,'2025-08-02 12:12:57','2025-08-02 12:12:57'),
(1981,'default','added',1257,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13.25}}',NULL,'2025-08-02 12:16:32','2025-08-02 12:16:32'),
(1982,'default','added',1258,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50.28}}',NULL,'2025-08-02 12:16:51','2025-08-02 12:16:51'),
(1983,'default','edited',1258,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50.28},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"50.2800\"}}',NULL,'2025-08-02 12:17:27','2025-08-02 12:17:27'),
(1984,'default','added',1259,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":13.25}}',NULL,'2025-08-02 12:19:04','2025-08-02 12:19:04'),
(1985,'default','sell_deleted',1259,'App\\Transaction',NULL,13,29,'App\\User','{\"id\":1259,\"invoice_no\":\"0027\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"13.2500\"}}',NULL,'2025-08-02 12:20:19','2025-08-02 12:20:19'),
(1986,'default','edited',38,'App\\Contact',NULL,13,29,'App\\User','[]',NULL,'2025-08-02 12:24:04','2025-08-02 12:24:04'),
(1987,'default','added',1260,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":13.25}}',NULL,'2025-08-02 12:24:38','2025-08-02 12:24:38'),
(1988,'default','added',1261,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":25.82}}',NULL,'2025-08-02 12:29:05','2025-08-02 12:29:05'),
(1989,'default','login',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-02 15:20:25','2025-08-02 15:20:26'),
(1990,'default','login',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-03 14:39:42','2025-08-03 14:39:42'),
(1991,'default','added',1262,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2025-08-03 14:43:00','2025-08-03 14:43:00'),
(1992,'default','login',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-03 16:02:26','2025-08-03 16:02:26'),
(1993,'default','logout',35,'App\\User',NULL,8,35,'App\\User','[]',NULL,'2025-08-03 16:19:08','2025-08-03 16:19:08'),
(1994,'default','login',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-03 16:21:42','2025-08-03 16:21:43'),
(1995,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-08-03 14:32:29','2025-08-03 14:32:29'),
(1996,'default','added',1263,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":35}}',NULL,'2025-08-03 16:34:01','2025-08-03 16:34:01'),
(1997,'default','login',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-03 16:39:52','2025-08-03 16:39:52'),
(1998,'default','edited',39,'App\\User',NULL,16,34,'App\\User','{\"name\":\" POS Cashier\"}',NULL,'2025-08-03 16:41:39','2025-08-03 16:41:39'),
(1999,'default','logout',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-03 16:45:06','2025-08-03 16:45:06'),
(2000,'default','login',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-03 16:45:19','2025-08-03 16:45:19'),
(2001,'default','added',41,'App\\User',NULL,16,34,'App\\User','{\"name\":\" Rayyan Cashier\"}',NULL,'2025-08-03 16:47:40','2025-08-03 16:47:40'),
(2002,'default','logout',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-03 16:47:46','2025-08-03 16:47:46'),
(2003,'default','login',41,'App\\User',NULL,16,41,'App\\User','[]',NULL,'2025-08-03 16:47:53','2025-08-03 16:47:53'),
(2004,'default','logout',41,'App\\User',NULL,16,41,'App\\User','[]',NULL,'2025-08-03 16:51:23','2025-08-03 16:51:23'),
(2005,'default','edited',41,'App\\User',NULL,16,34,'App\\User','{\"name\":\" Rayyan Cashier\"}',NULL,'2025-08-03 16:55:12','2025-08-03 16:55:12'),
(2006,'default','login',41,'App\\User',NULL,16,41,'App\\User','[]',NULL,'2025-08-03 16:56:05','2025-08-03 16:56:05'),
(2007,'default','added',1264,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2025-08-03 17:01:44','2025-08-03 17:01:44'),
(2008,'default','added',1265,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":31}}',NULL,'2025-08-03 17:02:06','2025-08-03 17:02:06'),
(2009,'default','added',1266,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-03 17:03:13','2025-08-03 17:03:13'),
(2010,'default','added',1267,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43}}',NULL,'2025-08-03 17:03:27','2025-08-03 17:03:27'),
(2011,'default','added',1268,'App\\Transaction',NULL,16,41,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-03 17:04:22','2025-08-03 17:04:22'),
(2012,'default','added',1269,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-03 17:04:56','2025-08-03 17:04:56'),
(2013,'default','added',1270,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":57}}',NULL,'2025-08-03 17:07:33','2025-08-03 17:07:33'),
(2014,'default','added',1271,'App\\Transaction',NULL,16,41,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-03 17:07:36','2025-08-03 17:07:36'),
(2015,'default','login',41,'App\\User',NULL,16,41,'App\\User','[]',NULL,'2025-08-03 17:08:44','2025-08-03 17:08:44'),
(2016,'default','added',1272,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":53}}',NULL,'2025-08-03 17:08:47','2025-08-03 17:08:47'),
(2017,'default','added',1273,'App\\Transaction',NULL,16,41,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":56}}',NULL,'2025-08-03 17:08:51','2025-08-03 17:08:51'),
(2018,'default','login',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-03 17:09:56','2025-08-03 17:09:56'),
(2019,'default','added',1274,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-03 17:10:15','2025-08-03 17:10:15'),
(2020,'default','added',1275,'App\\Transaction',NULL,16,41,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2025-08-03 17:11:07','2025-08-03 17:11:07'),
(2021,'default','added',1276,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-03 17:13:42','2025-08-03 17:13:42'),
(2022,'default','added',1277,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-03 17:14:35','2025-08-03 17:14:35'),
(2023,'default','logout',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-03 17:20:26','2025-08-03 17:20:26'),
(2024,'default','login',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-03 17:21:43','2025-08-03 17:21:43'),
(2025,'default','added',1278,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-03 17:23:16','2025-08-03 17:23:16'),
(2026,'default','added',1279,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-03 17:24:25','2025-08-03 17:24:25'),
(2027,'default','login',41,'App\\User',NULL,16,41,'App\\User','[]',NULL,'2025-08-03 17:25:44','2025-08-03 17:25:44'),
(2028,'default','added',1280,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-03 17:29:50','2025-08-03 17:29:50'),
(2029,'default','logout',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-03 17:43:27','2025-08-03 17:43:27'),
(2030,'default','login',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-03 17:43:45','2025-08-03 17:43:45'),
(2031,'default','added',1281,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-03 18:11:55','2025-08-03 18:11:55'),
(2032,'default','added',1282,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2025-08-03 18:18:20','2025-08-03 18:18:20'),
(2033,'default','added',1283,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":118}}',NULL,'2025-08-03 18:19:32','2025-08-03 18:19:32'),
(2034,'default','added',1284,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-03 18:20:41','2025-08-03 18:20:41'),
(2035,'default','added',1285,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":56}}',NULL,'2025-08-03 18:25:33','2025-08-03 18:25:33'),
(2036,'default','added',1286,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":68}}',NULL,'2025-08-03 18:25:53','2025-08-03 18:25:53'),
(2037,'default','added',1287,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43}}',NULL,'2025-08-03 18:27:09','2025-08-03 18:27:09'),
(2038,'default','added',1288,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-03 18:29:14','2025-08-03 18:29:14'),
(2039,'default','added',1289,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":73}}',NULL,'2025-08-03 18:29:33','2025-08-03 18:29:33'),
(2040,'default','added',1290,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":95}}',NULL,'2025-08-03 18:33:01','2025-08-03 18:33:01'),
(2041,'default','added',1291,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-03 18:33:15','2025-08-03 18:33:15'),
(2042,'default','added',1292,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-03 18:34:54','2025-08-03 18:34:54'),
(2043,'default','added',1293,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-03 18:35:46','2025-08-03 18:35:46'),
(2044,'default','added',1294,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":35}}',NULL,'2025-08-03 18:35:47','2025-08-03 18:35:47'),
(2045,'default','added',1295,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-03 18:36:51','2025-08-03 18:36:51'),
(2046,'default','added',1296,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-03 18:46:38','2025-08-03 18:46:38'),
(2047,'default','added',1297,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2025-08-03 18:48:30','2025-08-03 18:48:30'),
(2048,'default','added',1298,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-03 18:49:10','2025-08-03 18:49:10'),
(2049,'default','added',1299,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-03 18:49:40','2025-08-03 18:49:40'),
(2050,'default','added',1300,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-03 18:54:30','2025-08-03 18:54:30'),
(2051,'default','added',1301,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-03 18:57:47','2025-08-03 18:57:47'),
(2052,'default','added',1302,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-03 18:59:12','2025-08-03 18:59:12'),
(2053,'default','added',1303,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":56}}',NULL,'2025-08-03 19:03:47','2025-08-03 19:03:47'),
(2054,'default','added',1304,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-03 19:04:27','2025-08-03 19:04:27'),
(2055,'default','added',1305,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2025-08-03 19:08:44','2025-08-03 19:08:44'),
(2056,'default','added',1306,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-03 19:12:19','2025-08-03 19:12:19'),
(2057,'default','added',1307,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-03 19:12:35','2025-08-03 19:12:35'),
(2058,'default','added',1308,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-03 19:13:41','2025-08-03 19:13:41'),
(2059,'default','added',1309,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-03 19:14:52','2025-08-03 19:14:52'),
(2060,'default','added',1310,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-03 19:15:19','2025-08-03 19:15:19'),
(2061,'default','added',1311,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-03 19:15:47','2025-08-03 19:15:47'),
(2062,'default','added',1312,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-03 19:16:36','2025-08-03 19:16:36'),
(2063,'default','added',1313,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-03 19:16:46','2025-08-03 19:16:46'),
(2064,'default','added',1314,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2025-08-04 06:07:46','2025-08-04 06:07:46'),
(2065,'default','added',1315,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-04 21:52:36','2025-08-04 21:52:36'),
(2066,'default','added',1316,'App\\Transaction',NULL,16,41,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36}}',NULL,'2025-08-04 22:06:27','2025-08-04 22:06:27'),
(2067,'default','added',1317,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":52}}',NULL,'2025-08-04 22:06:32','2025-08-04 22:06:32'),
(2068,'default','added',49,'App\\Contact',NULL,16,34,'App\\User','[]',NULL,'2025-08-04 22:43:15','2025-08-04 22:43:15'),
(2069,'default','added',50,'App\\Contact',NULL,16,34,'App\\User','[]',NULL,'2025-08-04 22:44:01','2025-08-04 22:44:01'),
(2070,'default','added',51,'App\\Contact',NULL,16,34,'App\\User','[]',NULL,'2025-08-04 22:44:31','2025-08-04 22:44:31'),
(2071,'default','added',52,'App\\Contact',NULL,16,34,'App\\User','[]',NULL,'2025-08-04 22:45:51','2025-08-04 22:45:51'),
(2072,'default','added',42,'App\\User',NULL,16,34,'App\\User','{\"name\":\" Samjna \"}',NULL,'2025-08-05 10:02:58','2025-08-05 10:02:58'),
(2073,'default','added',43,'App\\User',NULL,16,34,'App\\User','{\"name\":\" Jeneva \"}',NULL,'2025-08-05 10:04:18','2025-08-05 10:04:18'),
(2074,'default','added',1318,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-05 10:05:07','2025-08-05 10:05:07'),
(2075,'default','added',1319,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 10:06:44','2025-08-05 10:06:44'),
(2076,'default','edited',43,'App\\User',NULL,16,34,'App\\User','{\"name\":\" Jeneva \"}',NULL,'2025-08-05 10:14:51','2025-08-05 10:14:51'),
(2077,'default','edited',42,'App\\User',NULL,16,34,'App\\User','{\"name\":\" Samjna \"}',NULL,'2025-08-05 10:15:02','2025-08-05 10:15:02'),
(2078,'default','logout',41,'App\\User',NULL,16,41,'App\\User','[]',NULL,'2025-08-05 10:15:14','2025-08-05 10:15:14'),
(2079,'default','login',42,'App\\User',NULL,16,42,'App\\User','[]',NULL,'2025-08-05 10:15:25','2025-08-05 10:15:25'),
(2080,'default','added',1320,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-05 10:20:13','2025-08-05 10:20:13'),
(2081,'default','added',1321,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 10:28:52','2025-08-05 10:28:52'),
(2082,'default','added',1322,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 10:29:30','2025-08-05 10:29:30'),
(2083,'default','added',1323,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 10:29:49','2025-08-05 10:29:49'),
(2084,'default','added',1324,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 10:31:42','2025-08-05 10:31:42'),
(2085,'default','added',1325,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":77}}',NULL,'2025-08-05 10:45:03','2025-08-05 10:45:03'),
(2086,'default','added',1326,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2025-08-05 10:46:16','2025-08-05 10:46:16'),
(2087,'default','added',1327,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2025-08-05 10:47:46','2025-08-05 10:47:46'),
(2088,'default','added',1328,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-05 10:52:29','2025-08-05 10:52:29'),
(2089,'default','login',30,'App\\User',NULL,14,30,'App\\User','[]',NULL,'2025-08-05 13:35:26','2025-08-05 13:35:26'),
(2090,'default','added',1329,'App\\Transaction',NULL,14,30,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"proforma\",\"final_total\":180}}',NULL,'2025-08-05 13:55:31','2025-08-05 13:55:31'),
(2091,'default','added',1330,'App\\Transaction',NULL,14,30,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"proforma\",\"final_total\":180}}',NULL,'2025-08-05 14:03:55','2025-08-05 14:03:55'),
(2092,'default','logout',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-05 12:27:45','2025-08-05 12:27:45'),
(2093,'default','login',42,'App\\User',NULL,16,42,'App\\User','[]',NULL,'2025-08-05 12:28:18','2025-08-05 12:28:18'),
(2094,'default','logout',42,'App\\User',NULL,16,42,'App\\User','[]',NULL,'2025-08-05 12:30:20','2025-08-05 12:30:20'),
(2095,'default','login',42,'App\\User',NULL,16,42,'App\\User','[]',NULL,'2025-08-05 12:30:29','2025-08-05 12:30:29'),
(2096,'default','added',1331,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":52}}',NULL,'2025-08-05 12:56:15','2025-08-05 12:56:15'),
(2097,'default','added',1332,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-05 12:57:42','2025-08-05 12:57:42'),
(2098,'default','added',1333,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-05 13:00:58','2025-08-05 13:00:58'),
(2099,'default','added',1334,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":142}}',NULL,'2025-08-05 13:07:52','2025-08-05 13:07:52'),
(2100,'default','added',1335,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-05 13:13:45','2025-08-05 13:13:45'),
(2101,'default','logout',42,'App\\User',NULL,16,42,'App\\User','[]',NULL,'2025-08-05 13:17:18','2025-08-05 13:17:18'),
(2102,'default','login',34,'App\\User',NULL,16,34,'App\\User','[]',NULL,'2025-08-05 13:17:26','2025-08-05 13:17:26'),
(2103,'default','login',34,'App\\User',NULL,16,34,'App\\User','[]',NULL,'2025-08-05 13:19:39','2025-08-05 13:19:39'),
(2104,'default','logout',42,'App\\User',NULL,16,42,'App\\User','[]',NULL,'2025-08-05 13:22:47','2025-08-05 13:22:47'),
(2105,'default','login',42,'App\\User',NULL,16,42,'App\\User','[]',NULL,'2025-08-05 13:23:02','2025-08-05 13:23:02'),
(2106,'default','added',1336,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":88}}',NULL,'2025-08-05 13:24:29','2025-08-05 13:24:29'),
(2107,'default','logout',34,'App\\User',NULL,16,34,'App\\User','[]',NULL,'2025-08-05 13:28:25','2025-08-05 13:28:25'),
(2108,'default','login',42,'App\\User',NULL,16,42,'App\\User','[]',NULL,'2025-08-05 13:28:37','2025-08-05 13:28:37'),
(2109,'default','added',1337,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-05 13:30:53','2025-08-05 13:30:53'),
(2110,'default','logout',42,'App\\User',NULL,16,42,'App\\User','[]',NULL,'2025-08-05 13:36:40','2025-08-05 13:36:40'),
(2111,'default','added',44,'App\\User',NULL,16,34,'App\\User','{\"name\":\" Nu tin \"}',NULL,'2025-08-05 13:39:57','2025-08-05 13:39:57'),
(2112,'default','logout',42,'App\\User',NULL,16,42,'App\\User','[]',NULL,'2025-08-05 13:44:19','2025-08-05 13:44:19'),
(2113,'default','login',44,'App\\User',NULL,16,44,'App\\User','[]',NULL,'2025-08-05 13:45:17','2025-08-05 13:45:17'),
(2114,'default','sell_deleted',1337,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1337,\"invoice_no\":\"0086\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5.0000\"}}',NULL,'2025-08-05 13:54:36','2025-08-05 13:54:36'),
(2115,'default','sell_deleted',1336,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1336,\"invoice_no\":\"0085\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"88.0000\"}}',NULL,'2025-08-05 13:54:39','2025-08-05 13:54:39'),
(2116,'default','sell_deleted',1326,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1326,\"invoice_no\":\"0077\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"}}',NULL,'2025-08-05 13:54:48','2025-08-05 13:54:48'),
(2117,'default','sell_deleted',1335,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1335,\"invoice_no\":\"0084\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5.0000\"}}',NULL,'2025-08-05 13:54:53','2025-08-05 13:54:53'),
(2118,'default','sell_deleted',1334,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1334,\"invoice_no\":\"0083\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"142.0000\"}}',NULL,'2025-08-05 13:54:56','2025-08-05 13:54:56'),
(2119,'default','sell_deleted',1333,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1333,\"invoice_no\":\"0082\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"20.0000\"}}',NULL,'2025-08-05 13:55:04','2025-08-05 13:55:04'),
(2120,'default','sell_deleted',1332,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1332,\"invoice_no\":\"0081\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"30.0000\"}}',NULL,'2025-08-05 13:55:07','2025-08-05 13:55:07'),
(2121,'default','sell_deleted',1331,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1331,\"invoice_no\":\"0080\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"52.0000\"}}',NULL,'2025-08-05 13:55:10','2025-08-05 13:55:10'),
(2122,'default','sell_deleted',1328,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1328,\"invoice_no\":\"0079\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"30.0000\"}}',NULL,'2025-08-05 13:55:50','2025-08-05 13:55:50'),
(2123,'default','sell_deleted',1327,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1327,\"invoice_no\":\"0078\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"}}',NULL,'2025-08-05 13:55:53','2025-08-05 13:55:53'),
(2124,'default','sell_deleted',1325,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1325,\"invoice_no\":\"0076\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"77.0000\"}}',NULL,'2025-08-05 13:55:56','2025-08-05 13:55:56'),
(2125,'default','sell_deleted',1324,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1324,\"invoice_no\":\"0075\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"16.0000\"}}',NULL,'2025-08-05 13:55:58','2025-08-05 13:55:58'),
(2126,'default','sell_deleted',1323,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1323,\"invoice_no\":\"0074\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"16.0000\"}}',NULL,'2025-08-05 13:56:02','2025-08-05 13:56:02'),
(2127,'default','sell_deleted',1322,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1322,\"invoice_no\":\"0073\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"16.0000\"}}',NULL,'2025-08-05 13:56:06','2025-08-05 13:56:06'),
(2128,'default','sell_deleted',1321,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1321,\"invoice_no\":\"0072\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"16.0000\"}}',NULL,'2025-08-05 13:56:08','2025-08-05 13:56:08'),
(2129,'default','sell_deleted',1320,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1320,\"invoice_no\":\"0071\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5.0000\"}}',NULL,'2025-08-05 13:56:12','2025-08-05 13:56:12'),
(2130,'default','sell_deleted',1319,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1319,\"invoice_no\":\"0070\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"16.0000\"}}',NULL,'2025-08-05 13:56:15','2025-08-05 13:56:15'),
(2131,'default','sell_deleted',1318,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1318,\"invoice_no\":\"0069\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"32.0000\"}}',NULL,'2025-08-05 13:56:17','2025-08-05 13:56:17'),
(2132,'default','sell_deleted',1317,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1317,\"invoice_no\":\"0068\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"52.0000\"}}',NULL,'2025-08-05 13:56:20','2025-08-05 13:56:20'),
(2133,'default','sell_deleted',1316,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1316,\"invoice_no\":\"0067\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"36.0000\"}}',NULL,'2025-08-05 13:56:23','2025-08-05 13:56:23'),
(2134,'default','sell_deleted',1310,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1310,\"invoice_no\":\"0062\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13.0000\"}}',NULL,'2025-08-05 13:56:27','2025-08-05 13:56:27'),
(2135,'default','sell_deleted',1315,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1315,\"invoice_no\":\"0066\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10.0000\"}}',NULL,'2025-08-05 13:56:30','2025-08-05 13:56:30'),
(2136,'default','sell_deleted',1313,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1313,\"invoice_no\":\"0065\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"25.0000\"}}',NULL,'2025-08-05 13:56:33','2025-08-05 13:56:33'),
(2137,'default','sell_deleted',1312,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1312,\"invoice_no\":\"0064\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"25.0000\"}}',NULL,'2025-08-05 13:56:36','2025-08-05 13:56:36'),
(2138,'default','sell_deleted',1311,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1311,\"invoice_no\":\"0063\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"25.0000\"}}',NULL,'2025-08-05 13:56:38','2025-08-05 13:56:38'),
(2139,'default','logout',44,'App\\User',NULL,16,44,'App\\User','[]',NULL,'2025-08-05 13:56:39','2025-08-05 13:56:39'),
(2140,'default','sell_deleted',1309,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1309,\"invoice_no\":\"0061\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"25.0000\"}}',NULL,'2025-08-05 13:56:41','2025-08-05 13:56:41'),
(2141,'default','sell_deleted',1308,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1308,\"invoice_no\":\"0060\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13.0000\"}}',NULL,'2025-08-05 13:56:43','2025-08-05 13:56:43'),
(2142,'default','sell_deleted',1307,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1307,\"invoice_no\":\"0059\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"38.0000\"}}',NULL,'2025-08-05 13:56:46','2025-08-05 13:56:46'),
(2143,'default','login',42,'App\\User',NULL,16,42,'App\\User','[]',NULL,'2025-08-05 13:56:48','2025-08-05 13:56:48'),
(2144,'default','sell_deleted',1306,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1306,\"invoice_no\":\"0058\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"25.0000\"}}',NULL,'2025-08-05 13:56:48','2025-08-05 13:56:48'),
(2145,'default','sell_deleted',1305,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1305,\"invoice_no\":\"0057\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"50.0000\"}}',NULL,'2025-08-05 13:56:51','2025-08-05 13:56:51'),
(2146,'default','sell_deleted',1304,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1304,\"invoice_no\":\"0056\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"38.0000\"}}',NULL,'2025-08-05 13:56:59','2025-08-05 13:56:59'),
(2147,'default','sell_deleted',1303,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1303,\"invoice_no\":\"0055\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"56.0000\"}}',NULL,'2025-08-05 13:57:02','2025-08-05 13:57:02'),
(2148,'default','sell_deleted',1302,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1302,\"invoice_no\":\"0054\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15.0000\"}}',NULL,'2025-08-05 13:57:05','2025-08-05 13:57:05'),
(2149,'default','sell_deleted',1301,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1301,\"invoice_no\":\"0053\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"25.0000\"}}',NULL,'2025-08-05 13:57:44','2025-08-05 13:57:44'),
(2150,'default','sell_deleted',1300,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1300,\"invoice_no\":\"0052\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"38.0000\"}}',NULL,'2025-08-05 13:57:47','2025-08-05 13:57:47'),
(2151,'default','sell_deleted',1299,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1299,\"invoice_no\":\"0051\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"18.0000\"}}',NULL,'2025-08-05 13:57:50','2025-08-05 13:57:50'),
(2152,'default','sell_deleted',1298,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1298,\"invoice_no\":\"0050\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"25.0000\"}}',NULL,'2025-08-05 13:57:53','2025-08-05 13:57:53'),
(2153,'default','sell_deleted',1297,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1297,\"invoice_no\":\"0049\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"50.0000\"}}',NULL,'2025-08-05 13:57:56','2025-08-05 13:57:56'),
(2154,'default','sell_deleted',1296,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1296,\"invoice_no\":\"0048\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13.0000\"}}',NULL,'2025-08-05 13:57:58','2025-08-05 13:57:58'),
(2155,'default','sell_deleted',1295,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1295,\"invoice_no\":\"0047\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"38.0000\"}}',NULL,'2025-08-05 13:58:00','2025-08-05 13:58:00'),
(2156,'default','sell_deleted',1293,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1293,\"invoice_no\":\"0045\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"38.0000\"}}',NULL,'2025-08-05 13:58:03','2025-08-05 13:58:03'),
(2157,'default','sell_deleted',1294,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1294,\"invoice_no\":\"0046\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"35.0000\"}}',NULL,'2025-08-05 13:58:06','2025-08-05 13:58:06'),
(2158,'default','sell_deleted',1292,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1292,\"invoice_no\":\"0044\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"18.0000\"}}',NULL,'2025-08-05 13:58:09','2025-08-05 13:58:09'),
(2159,'default','sell_deleted',1291,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1291,\"invoice_no\":\"0043\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"25.0000\"}}',NULL,'2025-08-05 13:58:13','2025-08-05 13:58:13'),
(2160,'default','sell_deleted',1290,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1290,\"invoice_no\":\"0042\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"95.0000\"}}',NULL,'2025-08-05 13:58:15','2025-08-05 13:58:15'),
(2161,'default','sell_deleted',1289,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1289,\"invoice_no\":\"0041\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"73.0000\"}}',NULL,'2025-08-05 13:58:18','2025-08-05 13:58:18'),
(2162,'default','sell_deleted',1288,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1288,\"invoice_no\":\"0040\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"25.0000\"}}',NULL,'2025-08-05 13:58:20','2025-08-05 13:58:20'),
(2163,'default','added',1338,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2025-08-05 13:58:21','2025-08-05 13:58:21'),
(2164,'default','sell_deleted',1282,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1282,\"invoice_no\":\"0034\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"80.0000\"}}',NULL,'2025-08-05 13:58:26','2025-08-05 13:58:26'),
(2165,'default','sell_deleted',1338,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1338,\"invoice_no\":\"0087\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"50.0000\"}}',NULL,'2025-08-05 13:58:30','2025-08-05 13:58:30'),
(2166,'default','sell_deleted',1287,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1287,\"invoice_no\":\"0039\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"43.0000\"}}',NULL,'2025-08-05 13:58:33','2025-08-05 13:58:33'),
(2167,'default','sell_deleted',1286,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1286,\"invoice_no\":\"0038\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"68.0000\"}}',NULL,'2025-08-05 13:58:36','2025-08-05 13:58:36'),
(2168,'default','sell_deleted',1285,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1285,\"invoice_no\":\"0037\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"56.0000\"}}',NULL,'2025-08-05 13:58:39','2025-08-05 13:58:39'),
(2169,'default','sell_deleted',1284,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1284,\"invoice_no\":\"0036\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5.0000\"}}',NULL,'2025-08-05 13:58:41','2025-08-05 13:58:41'),
(2170,'default','sell_deleted',1283,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1283,\"invoice_no\":\"0035\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"118.0000\"}}',NULL,'2025-08-05 13:58:44','2025-08-05 13:58:44'),
(2171,'default','sell_deleted',1281,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1281,\"invoice_no\":\"0033\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"25.0000\"}}',NULL,'2025-08-05 13:58:46','2025-08-05 13:58:46'),
(2172,'default','sell_deleted',1280,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1280,\"invoice_no\":\"0032\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"18.0000\"}}',NULL,'2025-08-05 13:58:49','2025-08-05 13:58:49'),
(2173,'default','sell_deleted',1279,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1279,\"invoice_no\":\"0031\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"38.0000\"}}',NULL,'2025-08-05 13:58:51','2025-08-05 13:58:51'),
(2174,'default','sell_deleted',1278,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1278,\"invoice_no\":\"0030\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"18.0000\"}}',NULL,'2025-08-05 13:58:54','2025-08-05 13:58:54'),
(2175,'default','sell_deleted',1277,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1277,\"invoice_no\":\"0029\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"38.0000\"}}',NULL,'2025-08-05 13:58:57','2025-08-05 13:58:57'),
(2176,'default','sell_deleted',1276,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1276,\"invoice_no\":\"0028\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"30.0000\"}}',NULL,'2025-08-05 13:58:59','2025-08-05 13:58:59'),
(2177,'default','sell_deleted',1275,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1275,\"invoice_no\":\"0027\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"80.0000\"}}',NULL,'2025-08-05 13:59:02','2025-08-05 13:59:02'),
(2178,'default','sell_deleted',1274,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1274,\"invoice_no\":\"0026\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"38.0000\"}}',NULL,'2025-08-05 13:59:04','2025-08-05 13:59:04'),
(2179,'default','sell_deleted',1273,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1273,\"invoice_no\":\"0025\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"56.0000\"}}',NULL,'2025-08-05 13:59:07','2025-08-05 13:59:07'),
(2180,'default','sell_deleted',1272,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1272,\"invoice_no\":\"0024\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"53.0000\"}}',NULL,'2025-08-05 13:59:11','2025-08-05 13:59:11'),
(2181,'default','sell_deleted',1271,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1271,\"invoice_no\":\"0023\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"38.0000\"}}',NULL,'2025-08-05 13:59:13','2025-08-05 13:59:13'),
(2182,'default','sell_deleted',1270,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1270,\"invoice_no\":\"0022\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"57.0000\"}}',NULL,'2025-08-05 13:59:15','2025-08-05 13:59:15'),
(2183,'default','sell_deleted',1269,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1269,\"invoice_no\":\"0021\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"38.0000\"}}',NULL,'2025-08-05 13:59:18','2025-08-05 13:59:18'),
(2184,'default','sell_deleted',1268,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1268,\"invoice_no\":\"0020\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"38.0000\"}}',NULL,'2025-08-05 13:59:20','2025-08-05 13:59:20'),
(2185,'default','sell_deleted',1267,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1267,\"invoice_no\":\"0019\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"43.0000\"}}',NULL,'2025-08-05 13:59:23','2025-08-05 13:59:23'),
(2186,'default','sell_deleted',1266,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1266,\"invoice_no\":\"0018\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"38.0000\"}}',NULL,'2025-08-05 13:59:26','2025-08-05 13:59:26'),
(2187,'default','sell_deleted',1265,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1265,\"invoice_no\":\"0017\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"31.0000\"}}',NULL,'2025-08-05 13:59:28','2025-08-05 13:59:28'),
(2188,'default','sell_deleted',1264,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1264,\"invoice_no\":\"0016\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"50.0000\"}}',NULL,'2025-08-05 13:59:31','2025-08-05 13:59:31'),
(2189,'default','sell_deleted',1263,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1263,\"invoice_no\":\"0015\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"35.0000\"}}',NULL,'2025-08-05 13:59:34','2025-08-05 13:59:34'),
(2190,'default','sell_deleted',1262,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1262,\"invoice_no\":\"0014\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"80.0000\"}}',NULL,'2025-08-05 13:59:36','2025-08-05 13:59:36'),
(2191,'default','sell_deleted',1240,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1240,\"invoice_no\":\"0013\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15.0000\"}}',NULL,'2025-08-05 13:59:39','2025-08-05 13:59:39'),
(2192,'default','sell_deleted',1239,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1239,\"invoice_no\":\"0012\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15.0000\"}}',NULL,'2025-08-05 13:59:41','2025-08-05 13:59:41'),
(2193,'default','sell_deleted',1238,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1238,\"invoice_no\":\"0011\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15.0000\"}}',NULL,'2025-08-05 13:59:43','2025-08-05 13:59:43'),
(2194,'default','sell_deleted',1237,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1237,\"invoice_no\":\"0010\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"120.0000\"}}',NULL,'2025-08-05 13:59:45','2025-08-05 13:59:45'),
(2195,'default','sell_deleted',1233,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1233,\"invoice_no\":\"0008\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"60.0000\"}}',NULL,'2025-08-05 14:00:02','2025-08-05 14:00:02'),
(2196,'default','sell_deleted',1232,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1232,\"invoice_no\":\"0007\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"45.0000\"}}',NULL,'2025-08-05 14:00:09','2025-08-05 14:00:09'),
(2197,'default','sell_deleted',1231,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1231,\"invoice_no\":\"0006\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"45.0000\"}}',NULL,'2025-08-05 14:00:13','2025-08-05 14:00:13'),
(2198,'default','sell_deleted',1228,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1228,\"invoice_no\":\"0003\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15.0000\"}}',NULL,'2025-08-05 14:00:16','2025-08-05 14:00:16'),
(2199,'default','sell_deleted',1229,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1229,\"invoice_no\":\"0004\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15.0000\"}}',NULL,'2025-08-05 14:00:18','2025-08-05 14:00:18'),
(2200,'default','sell_deleted',1230,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1230,\"invoice_no\":\"0005\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"45.0000\"}}',NULL,'2025-08-05 14:00:21','2025-08-05 14:00:21'),
(2201,'default','sell_deleted',1227,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1227,\"invoice_no\":\"0002\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"15.0000\"}}',NULL,'2025-08-05 14:00:27','2025-08-05 14:00:27'),
(2202,'default','sell_deleted',1234,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1234,\"invoice_no\":\"0009\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15.0000\"}}',NULL,'2025-08-05 14:00:44','2025-08-05 14:00:44'),
(2203,'default','login',44,'App\\User',NULL,16,44,'App\\User','[]',NULL,'2025-08-05 14:04:57','2025-08-05 14:04:57'),
(2204,'default','added',1339,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":56}}',NULL,'2025-08-05 14:07:45','2025-08-05 14:07:45'),
(2205,'default','logout',42,'App\\User',NULL,16,42,'App\\User','[]',NULL,'2025-08-05 14:25:33','2025-08-05 14:25:33'),
(2206,'default','login',42,'App\\User',NULL,16,42,'App\\User','[]',NULL,'2025-08-05 14:25:43','2025-08-05 14:25:43'),
(2207,'default','added',1340,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-05 14:30:13','2025-08-05 14:30:13'),
(2208,'default','added',1341,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-05 14:32:50','2025-08-05 14:32:50'),
(2209,'default','added',1342,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-05 14:34:41','2025-08-05 14:34:41'),
(2210,'default','added',1343,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-05 14:40:23','2025-08-05 14:40:23'),
(2211,'default','added',1344,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-05 14:46:30','2025-08-05 14:46:30'),
(2212,'default','added',1345,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-05 14:50:34','2025-08-05 14:50:34'),
(2213,'default','added',1346,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-05 14:57:58','2025-08-05 14:57:58'),
(2214,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-08-05 13:13:06','2025-08-05 13:13:06'),
(2215,'default','added',1347,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39.07}}',NULL,'2025-08-05 15:15:53','2025-08-05 15:15:53'),
(2216,'default','added',1348,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14}}',NULL,'2025-08-05 15:18:10','2025-08-05 15:18:10'),
(2217,'default','added',1349,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43}}',NULL,'2025-08-05 15:20:37','2025-08-05 15:20:37'),
(2218,'default','added',1350,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":174}}',NULL,'2025-08-05 15:20:49','2025-08-05 15:20:49'),
(2219,'default','added',1351,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":67}}',NULL,'2025-08-05 15:21:49','2025-08-05 15:21:49'),
(2220,'default','added',1352,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":48}}',NULL,'2025-08-05 15:23:03','2025-08-05 15:23:03'),
(2221,'default','added',1353,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":74}}',NULL,'2025-08-05 15:23:18','2025-08-05 15:23:18'),
(2222,'default','added',1354,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-05 15:28:34','2025-08-05 15:28:34'),
(2223,'default','added',1355,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29}}',NULL,'2025-08-05 15:28:40','2025-08-05 15:28:40'),
(2224,'default','added',1356,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":14}}',NULL,'2025-08-05 15:31:04','2025-08-05 15:31:05'),
(2225,'default','added',1357,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 15:36:46','2025-08-05 15:36:46'),
(2226,'default','sell_deleted',1355,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1355,\"invoice_no\":\"0103\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"29.0000\"}}',NULL,'2025-08-05 15:37:56','2025-08-05 15:37:56'),
(2227,'default','sell_deleted',1353,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1353,\"invoice_no\":\"0101\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"74.0000\"}}',NULL,'2025-08-05 15:38:00','2025-08-05 15:38:00'),
(2228,'default','sell_deleted',1351,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1351,\"invoice_no\":\"0099\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"67.0000\"}}',NULL,'2025-08-05 15:38:03','2025-08-05 15:38:03'),
(2229,'default','sell_deleted',1350,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1350,\"invoice_no\":\"0098\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"174.0000\"}}',NULL,'2025-08-05 15:38:05','2025-08-05 15:38:05'),
(2230,'default','sell_deleted',1349,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1349,\"invoice_no\":\"0097\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"43.0000\"}}',NULL,'2025-08-05 15:38:08','2025-08-05 15:38:08'),
(2231,'default','sell_deleted',1339,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1339,\"invoice_no\":\"0088\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"56.0000\"}}',NULL,'2025-08-05 15:38:11','2025-08-05 15:38:11'),
(2232,'default','added',1358,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-05 15:38:40','2025-08-05 15:38:40'),
(2233,'default','added',1359,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-05 15:47:28','2025-08-05 15:47:28'),
(2234,'default','added',1360,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-05 15:59:10','2025-08-05 15:59:10'),
(2235,'default','added',1361,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":71}}',NULL,'2025-08-05 16:11:18','2025-08-05 16:11:18'),
(2236,'default','added',1362,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14}}',NULL,'2025-08-05 16:12:24','2025-08-05 16:12:24'),
(2237,'default','added',1363,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-05 16:18:41','2025-08-05 16:18:41'),
(2238,'default','added',1364,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-05 16:21:08','2025-08-05 16:21:08'),
(2239,'default','added',1365,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-05 16:28:30','2025-08-05 16:28:30'),
(2240,'default','added',1366,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-05 16:33:54','2025-08-05 16:33:54'),
(2241,'default','added',1367,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-05 16:43:00','2025-08-05 16:43:00'),
(2242,'default','added',1368,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-05 16:47:51','2025-08-05 16:47:51'),
(2243,'default','added',1369,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-05 16:56:03','2025-08-05 16:56:03'),
(2244,'default','added',1370,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 16:59:55','2025-08-05 16:59:55'),
(2245,'default','added',1371,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-05 17:03:15','2025-08-05 17:03:15'),
(2246,'default','added',1372,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-05 17:05:24','2025-08-05 17:05:24'),
(2247,'default','added',1373,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-05 17:07:02','2025-08-05 17:07:02'),
(2248,'default','added',1374,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-05 17:13:24','2025-08-05 17:13:24'),
(2249,'default','added',1375,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":48}}',NULL,'2025-08-05 17:16:00','2025-08-05 17:16:00'),
(2250,'default','added',1376,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29}}',NULL,'2025-08-05 17:18:20','2025-08-05 17:18:20'),
(2251,'default','added',1377,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-05 17:20:08','2025-08-05 17:20:08'),
(2252,'default','added',1378,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":66}}',NULL,'2025-08-05 17:29:22','2025-08-05 17:29:22'),
(2253,'default','added',1379,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":31}}',NULL,'2025-08-05 17:31:13','2025-08-05 17:31:13'),
(2254,'default','added',1380,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-05 17:33:32','2025-08-05 17:33:32'),
(2255,'default','added',1381,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-05 17:36:21','2025-08-05 17:36:21'),
(2256,'default','logout',42,'App\\User',NULL,16,42,'App\\User','[]',NULL,'2025-08-05 17:37:24','2025-08-05 17:37:24'),
(2257,'default','login',42,'App\\User',NULL,16,42,'App\\User','[]',NULL,'2025-08-05 17:37:33','2025-08-05 17:37:33'),
(2258,'default','added',1382,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-05 17:39:28','2025-08-05 17:39:28'),
(2259,'default','added',1383,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 17:44:12','2025-08-05 17:44:12'),
(2260,'default','added',1384,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-05 17:44:51','2025-08-05 17:44:51'),
(2261,'default','added',1385,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-05 17:50:07','2025-08-05 17:50:07'),
(2262,'default','added',1386,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":27}}',NULL,'2025-08-05 17:54:32','2025-08-05 17:54:32'),
(2263,'default','added',1387,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2025-08-05 18:09:52','2025-08-05 18:09:52'),
(2264,'default','added',1388,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}',NULL,'2025-08-05 18:21:14','2025-08-05 18:21:14'),
(2265,'default','added',1389,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":44}}',NULL,'2025-08-05 18:22:27','2025-08-05 18:22:27'),
(2266,'default','added',1390,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":55}}',NULL,'2025-08-05 18:25:30','2025-08-05 18:25:30'),
(2267,'default','logout',44,'App\\User',NULL,16,44,'App\\User','[]',NULL,'2025-08-05 18:26:22','2025-08-05 18:26:22'),
(2268,'default','login',44,'App\\User',NULL,16,44,'App\\User','[]',NULL,'2025-08-05 18:27:06','2025-08-05 18:27:06'),
(2269,'default','logout',44,'App\\User',NULL,16,44,'App\\User','[]',NULL,'2025-08-05 18:27:42','2025-08-05 18:27:42'),
(2270,'default','login',42,'App\\User',NULL,16,42,'App\\User','[]',NULL,'2025-08-05 18:28:07','2025-08-05 18:28:07'),
(2271,'default','added',1391,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":53}}',NULL,'2025-08-05 18:31:56','2025-08-05 18:31:56'),
(2272,'default','added',1392,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-05 18:35:18','2025-08-05 18:35:18'),
(2273,'default','added',1393,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-05 18:37:49','2025-08-05 18:37:49'),
(2274,'default','added',1394,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":34}}',NULL,'2025-08-05 18:39:20','2025-08-05 18:39:20'),
(2275,'default','added',1395,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":76}}',NULL,'2025-08-05 18:43:39','2025-08-05 18:43:39'),
(2276,'default','added',1396,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 18:44:50','2025-08-05 18:44:50'),
(2277,'default','added',1397,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-05 18:45:53','2025-08-05 18:45:53'),
(2278,'default','added',1398,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-05 18:46:53','2025-08-05 18:46:53'),
(2279,'default','added',1399,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12}}',NULL,'2025-08-05 18:47:25','2025-08-05 18:47:25'),
(2280,'default','added',1400,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-05 18:48:50','2025-08-05 18:48:50'),
(2281,'default','added',1401,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-05 18:49:38','2025-08-05 18:49:38'),
(2282,'default','added',1402,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":68}}',NULL,'2025-08-05 18:57:48','2025-08-05 18:57:48'),
(2283,'default','added',1403,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-05 18:58:22','2025-08-05 18:58:22'),
(2284,'default','added',1404,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-05 18:59:12','2025-08-05 18:59:12'),
(2285,'default','added',1405,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-05 18:59:54','2025-08-05 18:59:54'),
(2286,'default','added',1406,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":55}}',NULL,'2025-08-05 19:02:21','2025-08-05 19:02:21'),
(2287,'default','added',1407,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-05 19:04:46','2025-08-05 19:04:46'),
(2288,'default','added',1408,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39}}',NULL,'2025-08-05 19:06:32','2025-08-05 19:06:32'),
(2289,'default','added',1409,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":73}}',NULL,'2025-08-05 19:07:58','2025-08-05 19:07:58'),
(2290,'default','added',1410,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-05 19:11:13','2025-08-05 19:11:13'),
(2291,'default','added',1411,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-05 19:19:47','2025-08-05 19:19:47'),
(2292,'default','added',1412,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-05 19:20:17','2025-08-05 19:20:17'),
(2293,'default','added',1413,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 19:22:27','2025-08-05 19:22:27'),
(2294,'default','added',1414,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":42}}',NULL,'2025-08-05 19:26:54','2025-08-05 19:26:54'),
(2295,'default','added',1415,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2025-08-05 19:28:54','2025-08-05 19:28:54'),
(2296,'default','added',1416,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17}}',NULL,'2025-08-05 19:29:34','2025-08-05 19:29:34'),
(2297,'default','added',1417,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":35}}',NULL,'2025-08-05 19:31:56','2025-08-05 19:31:56'),
(2298,'default','added',1418,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-05 19:36:56','2025-08-05 19:36:56'),
(2299,'default','added',1419,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-05 19:37:26','2025-08-05 19:37:26'),
(2300,'default','added',1420,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":67}}',NULL,'2025-08-05 19:43:06','2025-08-05 19:43:06'),
(2301,'default','added',1421,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-05 19:45:31','2025-08-05 19:45:31'),
(2302,'default','added',1422,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 19:50:27','2025-08-05 19:50:27'),
(2303,'default','added',1423,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 19:51:07','2025-08-05 19:51:07'),
(2304,'default','added',1424,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-05 19:52:58','2025-08-05 19:52:58'),
(2305,'default','added',1425,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-05 19:54:32','2025-08-05 19:54:32'),
(2306,'default','added',1426,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14}}',NULL,'2025-08-05 19:55:09','2025-08-05 19:55:09'),
(2307,'default','added',1427,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":46}}',NULL,'2025-08-05 19:55:55','2025-08-05 19:55:55'),
(2308,'default','login',34,'App\\User',NULL,16,34,'App\\User','[]',NULL,'2025-08-05 20:00:31','2025-08-05 20:00:31'),
(2309,'default','added',1428,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 20:04:07','2025-08-05 20:04:07'),
(2310,'default','added',1429,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-05 20:05:22','2025-08-05 20:05:22'),
(2311,'default','added',1430,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-05 20:07:35','2025-08-05 20:07:35'),
(2312,'default','added',1431,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":31}}',NULL,'2025-08-05 20:10:43','2025-08-05 20:10:43'),
(2313,'default','added',1432,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28}}',NULL,'2025-08-05 20:12:51','2025-08-05 20:12:51'),
(2314,'default','added',1433,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9}}',NULL,'2025-08-05 20:16:06','2025-08-05 20:16:06'),
(2315,'default','added',1434,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 20:18:02','2025-08-05 20:18:02'),
(2316,'default','added',1435,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":55}}',NULL,'2025-08-05 20:23:08','2025-08-05 20:23:08'),
(2317,'default','added',1436,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-05 20:23:57','2025-08-05 20:23:57'),
(2318,'default','added',1437,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-05 20:24:53','2025-08-05 20:24:53'),
(2319,'default','added',1438,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45}}',NULL,'2025-08-05 20:27:36','2025-08-05 20:27:36'),
(2320,'default','added',1439,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14}}',NULL,'2025-08-05 20:29:32','2025-08-05 20:29:32'),
(2321,'default','added',1440,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-05 20:30:09','2025-08-05 20:30:09'),
(2322,'default','added',1441,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2025-08-05 20:45:04','2025-08-05 20:45:04'),
(2323,'default','added',1442,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2}}',NULL,'2025-08-05 20:46:14','2025-08-05 20:46:14'),
(2324,'default','added',1443,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 20:47:46','2025-08-05 20:47:46'),
(2325,'default','added',1444,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-05 20:48:19','2025-08-05 20:48:19'),
(2326,'default','added',1445,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23}}',NULL,'2025-08-05 20:51:54','2025-08-05 20:51:54'),
(2327,'default','added',1446,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-05 20:52:24','2025-08-05 20:52:24'),
(2328,'default','added',1447,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-05 20:53:42','2025-08-05 20:53:42'),
(2329,'default','added',1448,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 20:56:39','2025-08-05 20:56:39'),
(2330,'default','added',1449,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-05 20:59:32','2025-08-05 20:59:32'),
(2331,'default','added',1450,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-05 21:06:34','2025-08-05 21:06:34'),
(2332,'default','added',1451,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29}}',NULL,'2025-08-05 21:11:44','2025-08-05 21:11:44'),
(2333,'default','added',1452,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-05 21:15:02','2025-08-05 21:15:02'),
(2334,'default','added',1453,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-05 21:23:38','2025-08-05 21:23:38'),
(2335,'default','added',1454,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-05 21:25:59','2025-08-05 21:25:59'),
(2336,'default','added',1455,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-05 21:28:39','2025-08-05 21:28:39'),
(2337,'default','added',1456,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2025-08-05 21:35:53','2025-08-05 21:35:53'),
(2338,'default','added',1457,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17}}',NULL,'2025-08-05 21:38:21','2025-08-05 21:38:21'),
(2339,'default','added',1458,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":63}}',NULL,'2025-08-05 21:40:26','2025-08-05 21:40:26'),
(2340,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-08-05 19:42:45','2025-08-05 19:42:45'),
(2341,'default','added',1459,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33}}',NULL,'2025-08-05 21:43:23','2025-08-05 21:43:23'),
(2342,'default','added',1460,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":44}}',NULL,'2025-08-05 21:44:58','2025-08-05 21:44:58'),
(2343,'default','added',1461,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 21:46:08','2025-08-05 21:46:08'),
(2344,'default','logout',34,'App\\User',NULL,16,34,'App\\User','[]',NULL,'2025-08-05 21:46:49','2025-08-05 21:46:49'),
(2345,'default','added',1462,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-05 21:47:02','2025-08-05 21:47:02'),
(2346,'default','added',1463,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-05 21:47:41','2025-08-05 21:47:41'),
(2347,'default','added',1464,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-05 21:48:20','2025-08-05 21:48:20'),
(2348,'default','added',1465,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-05 21:49:04','2025-08-05 21:49:04'),
(2349,'default','added',1466,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45}}',NULL,'2025-08-05 21:50:57','2025-08-05 21:50:57'),
(2350,'default','added',1467,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7}}',NULL,'2025-08-05 21:51:54','2025-08-05 21:51:54'),
(2351,'default','sell_deleted',1426,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1426,\"invoice_no\":\"0173\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"14.0000\"}}',NULL,'2025-08-05 22:01:28','2025-08-05 22:01:28'),
(2352,'default','added',1468,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-05 22:07:28','2025-08-05 22:07:28'),
(2353,'default','added',45,'App\\User',NULL,16,34,'App\\User','{\"name\":\" Wessam \"}',NULL,'2025-08-05 22:21:45','2025-08-05 22:21:45'),
(2354,'default','logout',34,'App\\User',NULL,16,34,'App\\User','[]',NULL,'2025-08-05 22:21:55','2025-08-05 22:21:55'),
(2355,'default','login',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-05 22:22:05','2025-08-05 22:22:05'),
(2356,'default','added',1469,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2025-08-05 22:22:20','2025-08-05 22:22:20'),
(2357,'default','added',1470,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":52}}',NULL,'2025-08-05 22:27:31','2025-08-05 22:27:31'),
(2358,'default','added',46,'App\\User',NULL,16,34,'App\\User','{\"name\":\" Yash raj thakur \"}',NULL,'2025-08-05 22:34:15','2025-08-05 22:34:15'),
(2359,'default','added',1471,'App\\Transaction',NULL,16,42,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-05 22:38:10','2025-08-05 22:38:10'),
(2360,'default','logout',42,'App\\User',NULL,16,42,'App\\User','[]',NULL,'2025-08-05 22:41:09','2025-08-05 22:41:09'),
(2361,'default','login',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-05 22:41:50','2025-08-05 22:41:50'),
(2362,'default','logout',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-05 23:02:00','2025-08-05 23:02:00'),
(2363,'default','login',46,'App\\User',NULL,16,46,'App\\User','[]',NULL,'2025-08-05 23:02:36','2025-08-05 23:02:36'),
(2364,'default','logout',46,'App\\User',NULL,16,46,'App\\User','[]',NULL,'2025-08-05 23:04:18','2025-08-05 23:04:18'),
(2365,'default','login',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-05 23:07:51','2025-08-05 23:07:51'),
(2366,'default','logout',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-05 23:15:36','2025-08-05 23:15:36'),
(2367,'default','login',46,'App\\User',NULL,16,46,'App\\User','[]',NULL,'2025-08-05 23:15:50','2025-08-05 23:15:50'),
(2368,'default','added',1472,'App\\Transaction',NULL,14,30,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2025-08-06 07:14:15','2025-08-06 07:14:15'),
(2369,'default','sell_deleted',1472,'App\\Transaction',NULL,14,30,'App\\User','{\"id\":1472,\"invoice_no\":\"0001\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"180.0000\"}}',NULL,'2025-08-06 07:21:59','2025-08-06 07:21:59'),
(2370,'default','added',1473,'App\\Transaction',NULL,14,30,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2025-08-06 07:22:23','2025-08-06 07:22:23'),
(2371,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-08-06 04:30:07','2025-08-06 04:30:07'),
(2372,'default','login',46,'App\\User',NULL,16,46,'App\\User','[]',NULL,'2025-08-06 06:32:32','2025-08-06 06:32:32'),
(2373,'default','added',1474,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-06 06:37:08','2025-08-06 06:37:08'),
(2374,'default','added',1475,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-06 06:42:27','2025-08-06 06:42:27'),
(2375,'default','added',1476,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-06 06:50:59','2025-08-06 06:50:59'),
(2376,'default','added',1477,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-06 06:57:13','2025-08-06 06:57:13'),
(2377,'default','added',1478,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-06 06:58:48','2025-08-06 06:58:48'),
(2378,'default','added',1479,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-06 07:22:15','2025-08-06 07:22:15'),
(2379,'default','added',1480,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17}}',NULL,'2025-08-06 07:23:50','2025-08-06 07:23:50'),
(2380,'default','added',1481,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-06 07:32:36','2025-08-06 07:32:36'),
(2381,'default','added',1482,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 07:38:44','2025-08-06 07:38:44'),
(2382,'default','added',1483,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-06 07:39:25','2025-08-06 07:39:25'),
(2383,'default','added',1484,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12}}',NULL,'2025-08-06 07:43:13','2025-08-06 07:43:13'),
(2384,'default','login',41,'App\\User',NULL,16,41,'App\\User','[]',NULL,'2025-08-06 07:45:14','2025-08-06 07:45:14'),
(2385,'default','added',1485,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-06 07:56:09','2025-08-06 07:56:09'),
(2386,'default','added',1486,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-06 08:03:59','2025-08-06 08:03:59'),
(2387,'default','added',1487,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 08:05:00','2025-08-06 08:05:00'),
(2388,'default','added',1488,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 08:25:04','2025-08-06 08:25:04'),
(2389,'default','added',1489,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":73}}',NULL,'2025-08-06 08:35:46','2025-08-06 08:35:46'),
(2390,'default','added',1490,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-06 08:40:18','2025-08-06 08:40:18'),
(2391,'default','added',1491,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2}}',NULL,'2025-08-06 08:43:18','2025-08-06 08:43:18'),
(2392,'default','added',1492,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-06 08:43:49','2025-08-06 08:43:49'),
(2393,'default','added',1493,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-06 09:01:22','2025-08-06 09:01:22'),
(2394,'default','added',1494,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-06 09:10:54','2025-08-06 09:10:54'),
(2395,'default','added',1495,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-06 09:13:17','2025-08-06 09:13:17'),
(2396,'default','added',1496,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-06 09:30:38','2025-08-06 09:30:38'),
(2397,'default','added',1497,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33}}',NULL,'2025-08-06 09:32:32','2025-08-06 09:32:32'),
(2398,'default','added',1498,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2}}',NULL,'2025-08-06 09:40:38','2025-08-06 09:40:38'),
(2399,'default','added',1499,'App\\Transaction',NULL,14,30,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":780}}',NULL,'2025-08-06 12:13:32','2025-08-06 12:13:32'),
(2400,'default','added',1500,'App\\Transaction',NULL,14,30,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4830}}',NULL,'2025-08-06 12:15:12','2025-08-06 12:15:12'),
(2401,'default','added',1501,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":71}}',NULL,'2025-08-06 09:55:19','2025-08-06 09:55:19'),
(2402,'default','added',53,'App\\Contact',NULL,14,30,'App\\User','[]',NULL,'2025-08-06 12:34:16','2025-08-06 12:34:16'),
(2403,'default','added',1502,'App\\Transaction',NULL,14,30,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":180}}',NULL,'2025-08-06 12:37:23','2025-08-06 12:37:23'),
(2404,'default','added',1503,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-06 10:08:11','2025-08-06 10:08:11'),
(2405,'default','purchase_deleted',1502,'App\\Transaction',NULL,14,30,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":\"180.0000\"}}',NULL,'2025-08-06 12:38:22','2025-08-06 12:38:22'),
(2406,'default','added',1504,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-06 10:09:00','2025-08-06 10:09:00'),
(2407,'default','added',1505,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7}}',NULL,'2025-08-06 10:10:26','2025-08-06 10:10:26'),
(2408,'default','added',1506,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 10:16:46','2025-08-06 10:16:46'),
(2409,'default','added',1507,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 10:19:10','2025-08-06 10:19:10'),
(2410,'default','added',1508,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 10:25:07','2025-08-06 10:25:07'),
(2411,'default','added',1509,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}',NULL,'2025-08-06 10:37:25','2025-08-06 10:37:25'),
(2412,'default','added',1510,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12}}',NULL,'2025-08-06 10:39:28','2025-08-06 10:39:28'),
(2413,'default','added',1511,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-06 10:42:39','2025-08-06 10:42:39'),
(2414,'default','added',1512,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 11:07:56','2025-08-06 11:07:56'),
(2415,'default','added',1513,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-06 11:12:53','2025-08-06 11:12:53'),
(2416,'default','added',1514,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-06 11:16:43','2025-08-06 11:16:43'),
(2417,'default','added',1515,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-06 11:31:26','2025-08-06 11:31:26'),
(2418,'default','added',1516,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":62}}',NULL,'2025-08-06 11:51:24','2025-08-06 11:51:24'),
(2419,'default','added',1517,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":41}}',NULL,'2025-08-06 11:59:25','2025-08-06 11:59:25'),
(2420,'default','added',1518,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-06 12:00:22','2025-08-06 12:00:22'),
(2421,'default','added',1519,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-06 12:15:36','2025-08-06 12:15:36'),
(2422,'default','added',1520,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-06 12:17:23','2025-08-06 12:17:23'),
(2423,'default','added',1521,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-06 12:19:36','2025-08-06 12:19:36'),
(2424,'default','added',1522,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-06 12:25:34','2025-08-06 12:25:34'),
(2425,'default','added',1523,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-06 12:36:30','2025-08-06 12:36:30'),
(2426,'default','added',1524,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33}}',NULL,'2025-08-06 12:48:53','2025-08-06 12:48:53'),
(2427,'default','added',1525,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-06 13:02:55','2025-08-06 13:02:55'),
(2428,'default','added',1526,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-06 13:08:39','2025-08-06 13:08:39'),
(2429,'default','added',1527,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45}}',NULL,'2025-08-06 13:29:28','2025-08-06 13:29:28'),
(2430,'default','logout',46,'App\\User',NULL,16,46,'App\\User','[]',NULL,'2025-08-06 14:27:51','2025-08-06 14:27:51'),
(2431,'default','login',46,'App\\User',NULL,16,46,'App\\User','[]',NULL,'2025-08-06 14:28:47','2025-08-06 14:28:47'),
(2432,'default','logout',46,'App\\User',NULL,16,46,'App\\User','[]',NULL,'2025-08-06 14:29:04','2025-08-06 14:29:04'),
(2433,'default','login',43,'App\\User',NULL,16,43,'App\\User','[]',NULL,'2025-08-06 14:29:52','2025-08-06 14:29:52'),
(2434,'default','login',34,'App\\User',NULL,16,34,'App\\User','[]',NULL,'2025-08-06 14:32:06','2025-08-06 14:32:06'),
(2435,'default','added',1528,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-06 14:40:43','2025-08-06 14:40:43'),
(2436,'default','added',1529,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-06 14:43:35','2025-08-06 14:43:35'),
(2437,'default','added',1530,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-06 14:44:13','2025-08-06 14:44:13'),
(2438,'default','added',1531,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 14:44:55','2025-08-06 14:44:55'),
(2439,'default','added',1532,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 14:49:03','2025-08-06 14:49:03'),
(2440,'default','login',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-06 15:02:50','2025-08-06 15:02:50'),
(2441,'default','added',1533,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43}}',NULL,'2025-08-06 15:03:21','2025-08-06 15:03:21'),
(2442,'default','added',1534,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-06 15:05:49','2025-08-06 15:05:49'),
(2443,'default','logout',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-06 15:05:52','2025-08-06 15:05:52'),
(2444,'default','login',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-06 15:06:32','2025-08-06 15:06:32'),
(2445,'default','added',1535,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-06 15:07:22','2025-08-06 15:07:22'),
(2446,'default','added',1536,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 15:15:40','2025-08-06 15:15:40'),
(2447,'default','added',1537,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 15:19:39','2025-08-06 15:19:39'),
(2448,'default','added',1538,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49}}',NULL,'2025-08-06 15:22:51','2025-08-06 15:22:51'),
(2449,'default','added',1539,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-06 15:26:33','2025-08-06 15:26:33'),
(2450,'default','added',1540,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43}}',NULL,'2025-08-06 15:26:50','2025-08-06 15:26:50'),
(2451,'default','sell_deleted',1533,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1533,\"invoice_no\":\"0275\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"43.0000\"}}',NULL,'2025-08-06 15:28:04','2025-08-06 15:28:04'),
(2452,'default','sell_deleted',1535,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1535,\"invoice_no\":\"0277\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"21.0000\"}}',NULL,'2025-08-06 15:28:08','2025-08-06 15:28:08'),
(2453,'default','sell_deleted',1540,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1540,\"invoice_no\":\"0282\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"43.0000\"}}',NULL,'2025-08-06 15:28:11','2025-08-06 15:28:11'),
(2454,'default','sell_deleted',1538,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1538,\"invoice_no\":\"0280\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"49.0000\"}}',NULL,'2025-08-06 15:28:13','2025-08-06 15:28:13'),
(2455,'default','added',1541,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17}}',NULL,'2025-08-06 15:28:25','2025-08-06 15:28:25'),
(2456,'default','added',1542,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-06 15:36:20','2025-08-06 15:36:20'),
(2457,'default','added',1543,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2}}',NULL,'2025-08-06 15:38:19','2025-08-06 15:38:19'),
(2458,'default','added',1544,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":67}}',NULL,'2025-08-06 15:38:28','2025-08-06 15:38:28'),
(2459,'default','added',1545,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 15:38:43','2025-08-06 15:38:43'),
(2460,'default','added',1546,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":86}}',NULL,'2025-08-06 15:39:02','2025-08-06 15:39:02'),
(2461,'default','added',1547,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-06 15:39:25','2025-08-06 15:39:25'),
(2462,'default','added',1548,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-06 15:40:23','2025-08-06 15:40:23'),
(2463,'default','added',1549,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43}}',NULL,'2025-08-06 15:44:52','2025-08-06 15:44:52'),
(2464,'default','added',1550,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-06 15:46:13','2025-08-06 15:46:13'),
(2465,'default','added',1551,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-06 15:47:18','2025-08-06 15:47:18'),
(2466,'default','added',1552,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-06 15:47:41','2025-08-06 15:47:41'),
(2467,'default','added',1553,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-06 15:49:09','2025-08-06 15:49:09'),
(2468,'default','added',1554,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-06 15:50:08','2025-08-06 15:50:08'),
(2469,'default','added',1555,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-06 15:50:20','2025-08-06 15:50:20'),
(2470,'default','added',1556,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 15:50:47','2025-08-06 15:50:47'),
(2471,'default','added',1557,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":65}}',NULL,'2025-08-06 15:53:23','2025-08-06 15:53:23'),
(2472,'default','added',1558,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39}}',NULL,'2025-08-06 15:54:12','2025-08-06 15:54:12'),
(2473,'default','added',1559,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39}}',NULL,'2025-08-06 15:55:40','2025-08-06 15:55:40'),
(2474,'default','added',1560,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43}}',NULL,'2025-08-06 15:57:34','2025-08-06 15:57:34'),
(2475,'default','added',1561,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43}}',NULL,'2025-08-06 15:58:54','2025-08-06 15:58:54'),
(2476,'default','added',1562,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26}}',NULL,'2025-08-06 16:00:29','2025-08-06 16:00:29'),
(2477,'default','login',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-06 16:00:44','2025-08-06 16:00:44'),
(2478,'default','added',1563,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-06 16:05:11','2025-08-06 16:05:11'),
(2479,'default','added',1564,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-06 16:05:42','2025-08-06 16:05:42'),
(2480,'default','added',1565,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-06 16:08:04','2025-08-06 16:08:04'),
(2481,'default','login',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-06 16:14:57','2025-08-06 16:14:57'),
(2482,'default','added',1566,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-06 16:17:50','2025-08-06 16:17:50'),
(2483,'default','added',1567,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 16:26:21','2025-08-06 16:26:21'),
(2484,'default','added',1568,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-06 16:26:53','2025-08-06 16:26:53'),
(2485,'default','added',1569,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-06 16:28:16','2025-08-06 16:28:16'),
(2486,'default','added',1570,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-06 16:28:54','2025-08-06 16:28:54'),
(2487,'default','added',1571,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-06 16:45:36','2025-08-06 16:45:36'),
(2488,'default','added',1572,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36}}',NULL,'2025-08-06 16:46:43','2025-08-06 16:46:43'),
(2489,'default','added',1573,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-06 16:49:29','2025-08-06 16:49:29'),
(2490,'default','added',1574,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":72}}',NULL,'2025-08-06 16:52:39','2025-08-06 16:52:39'),
(2491,'default','added',1575,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 16:53:28','2025-08-06 16:53:28'),
(2492,'default','added',1576,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-06 17:02:29','2025-08-06 17:02:29'),
(2493,'default','added',1577,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":31}}',NULL,'2025-08-06 17:03:45','2025-08-06 17:03:45'),
(2494,'default','added',1578,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 17:10:00','2025-08-06 17:10:00'),
(2495,'default','added',1579,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-06 17:13:02','2025-08-06 17:13:02'),
(2496,'default','added',1580,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14}}',NULL,'2025-08-06 17:23:56','2025-08-06 17:23:56'),
(2497,'default','added',1581,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-06 17:24:30','2025-08-06 17:24:30'),
(2498,'default','added',1582,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12}}',NULL,'2025-08-06 17:26:38','2025-08-06 17:26:38'),
(2499,'default','added',1583,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12}}',NULL,'2025-08-06 17:26:57','2025-08-06 17:26:57'),
(2500,'default','added',1584,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22}}',NULL,'2025-08-06 17:29:59','2025-08-06 17:29:59'),
(2501,'default','added',1585,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 17:31:28','2025-08-06 17:31:28'),
(2502,'default','added',1586,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 17:40:02','2025-08-06 17:40:02'),
(2503,'default','added',1587,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-06 17:59:02','2025-08-06 17:59:02'),
(2504,'default','added',1588,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36}}',NULL,'2025-08-06 18:03:51','2025-08-06 18:03:51'),
(2505,'default','added',1589,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 18:04:24','2025-08-06 18:04:24'),
(2506,'default','added',1590,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 18:05:17','2025-08-06 18:05:17'),
(2507,'default','added',1591,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-06 18:11:07','2025-08-06 18:11:07'),
(2508,'default','added',1592,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":27}}',NULL,'2025-08-06 18:13:29','2025-08-06 18:13:29'),
(2509,'default','added',1593,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22}}',NULL,'2025-08-06 18:14:59','2025-08-06 18:14:59'),
(2510,'default','added',1594,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":115}}',NULL,'2025-08-06 18:17:58','2025-08-06 18:17:58'),
(2511,'default','added',1595,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":48}}',NULL,'2025-08-06 18:22:43','2025-08-06 18:22:43'),
(2512,'default','added',1596,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-06 18:30:31','2025-08-06 18:30:31'),
(2513,'default','added',1597,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29}}',NULL,'2025-08-06 18:32:42','2025-08-06 18:32:42'),
(2514,'default','added',1598,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-06 18:34:00','2025-08-06 18:34:00'),
(2515,'default','added',1599,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26}}',NULL,'2025-08-06 18:36:27','2025-08-06 18:36:27'),
(2516,'default','added',1600,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-06 18:37:55','2025-08-06 18:37:55'),
(2517,'default','added',1601,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 18:38:14','2025-08-06 18:38:14'),
(2518,'default','added',1602,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-06 18:38:39','2025-08-06 18:38:39'),
(2519,'default','added',1603,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-06 18:44:19','2025-08-06 18:44:19'),
(2520,'default','added',1604,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29}}',NULL,'2025-08-06 18:46:22','2025-08-06 18:46:22'),
(2521,'default','added',1605,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-06 18:46:46','2025-08-06 18:46:46'),
(2522,'default','added',1606,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23}}',NULL,'2025-08-06 18:47:42','2025-08-06 18:47:42'),
(2523,'default','added',1607,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-06 18:48:36','2025-08-06 18:48:36'),
(2524,'default','added',1608,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 18:50:22','2025-08-06 18:50:22'),
(2525,'default','added',1609,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-06 18:53:20','2025-08-06 18:53:20'),
(2526,'default','added',1610,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 18:57:33','2025-08-06 18:57:33'),
(2527,'default','added',1611,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43}}',NULL,'2025-08-06 18:58:57','2025-08-06 18:58:57'),
(2528,'default','added',1612,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-06 19:01:57','2025-08-06 19:01:57'),
(2529,'default','added',1613,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-06 19:03:06','2025-08-06 19:03:06'),
(2530,'default','added',1614,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":135}}',NULL,'2025-08-06 19:04:40','2025-08-06 19:04:40'),
(2531,'default','added',1615,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 19:05:50','2025-08-06 19:05:50'),
(2532,'default','added',1616,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-06 19:06:30','2025-08-06 19:06:30'),
(2533,'default','added',1617,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22}}',NULL,'2025-08-06 19:07:29','2025-08-06 19:07:29'),
(2534,'default','added',1618,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-06 19:08:35','2025-08-06 19:08:35'),
(2535,'default','added',1619,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":108}}',NULL,'2025-08-06 19:11:20','2025-08-06 19:11:20'),
(2536,'default','added',1620,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2}}',NULL,'2025-08-06 19:11:53','2025-08-06 19:11:53'),
(2537,'default','added',1621,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 19:12:29','2025-08-06 19:12:29'),
(2538,'default','added',1622,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":34}}',NULL,'2025-08-06 19:13:53','2025-08-06 19:13:53'),
(2539,'default','added',1623,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-06 19:15:14','2025-08-06 19:15:14'),
(2540,'default','added',1624,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-06 19:17:09','2025-08-06 19:17:09'),
(2541,'default','added',1625,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-06 19:21:11','2025-08-06 19:21:11'),
(2542,'default','added',1626,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-06 19:23:09','2025-08-06 19:23:09'),
(2543,'default','added',1627,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-06 19:25:15','2025-08-06 19:25:15'),
(2544,'default','added',1628,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 19:30:26','2025-08-06 19:30:26'),
(2545,'default','added',1629,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-06 19:35:43','2025-08-06 19:35:43'),
(2546,'default','added',1630,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2}}',NULL,'2025-08-06 19:37:52','2025-08-06 19:37:52'),
(2547,'default','added',1631,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-06 19:39:28','2025-08-06 19:39:28'),
(2548,'default','added',1632,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-06 19:40:11','2025-08-06 19:40:11'),
(2549,'default','added',1633,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 19:41:49','2025-08-06 19:41:49'),
(2550,'default','added',1634,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":98}}',NULL,'2025-08-06 19:44:11','2025-08-06 19:44:11'),
(2551,'default','added',47,'App\\User',NULL,16,34,'App\\User','{\"name\":\" Mohamed Refaat\"}',NULL,'2025-08-06 19:45:10','2025-08-06 19:45:10'),
(2552,'default','added',1635,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-06 19:47:12','2025-08-06 19:47:12'),
(2553,'default','added',48,'App\\User',NULL,16,34,'App\\User','{\"name\":\"MR Azab \"}',NULL,'2025-08-06 19:47:27','2025-08-06 19:47:27'),
(2554,'default','sell_deleted',1544,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1544,\"invoice_no\":\"0286\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"67.0000\"}}',NULL,'2025-08-06 19:48:26','2025-08-06 19:48:26'),
(2555,'default','sell_deleted',1558,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1558,\"invoice_no\":\"0300\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"39.0000\"}}',NULL,'2025-08-06 19:48:29','2025-08-06 19:48:29'),
(2556,'default','sell_deleted',1559,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1559,\"invoice_no\":\"0301\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"39.0000\"}}',NULL,'2025-08-06 19:48:31','2025-08-06 19:48:31'),
(2557,'default','sell_deleted',1557,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1557,\"invoice_no\":\"0299\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"65.0000\"}}',NULL,'2025-08-06 19:48:34','2025-08-06 19:48:34'),
(2558,'default','sell_deleted',1555,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1555,\"invoice_no\":\"0297\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6.0000\"}}',NULL,'2025-08-06 19:48:37','2025-08-06 19:48:37'),
(2559,'default','sell_deleted',1554,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1554,\"invoice_no\":\"0296\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6.0000\"}}',NULL,'2025-08-06 19:48:39','2025-08-06 19:48:39'),
(2560,'default','sell_deleted',1560,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1560,\"invoice_no\":\"0302\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"43.0000\"}}',NULL,'2025-08-06 19:48:43','2025-08-06 19:48:43'),
(2561,'default','sell_deleted',1561,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1561,\"invoice_no\":\"0303\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"43.0000\"}}',NULL,'2025-08-06 19:48:45','2025-08-06 19:48:45'),
(2562,'default','sell_deleted',1553,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1553,\"invoice_no\":\"0295\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15.0000\"}}',NULL,'2025-08-06 19:48:48','2025-08-06 19:48:48'),
(2563,'default','sell_deleted',1549,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1549,\"invoice_no\":\"0291\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"43.0000\"}}',NULL,'2025-08-06 19:48:51','2025-08-06 19:48:51'),
(2564,'default','sell_deleted',1548,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1548,\"invoice_no\":\"0290\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"21.0000\"}}',NULL,'2025-08-06 19:48:54','2025-08-06 19:48:54'),
(2565,'default','sell_deleted',1546,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1546,\"invoice_no\":\"0288\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"86.0000\"}}',NULL,'2025-08-06 19:48:56','2025-08-06 19:48:56'),
(2566,'default','added',49,'App\\User',NULL,16,34,'App\\User','{\"name\":\"Mr Kamal Ali\"}',NULL,'2025-08-06 19:51:51','2025-08-06 19:51:51'),
(2567,'default','edited',36,'App\\User',NULL,16,34,'App\\User','{\"name\":\"Mr Ahmed Mohamed\"}',NULL,'2025-08-06 19:52:24','2025-08-06 19:52:24'),
(2568,'default','added',1636,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28}}',NULL,'2025-08-06 19:52:57','2025-08-06 19:52:57'),
(2569,'default','added',1637,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-06 19:54:42','2025-08-06 19:54:42'),
(2570,'default','added',1638,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-06 19:58:02','2025-08-06 19:58:02'),
(2571,'default','added',1639,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17}}',NULL,'2025-08-06 20:00:00','2025-08-06 20:00:00'),
(2572,'default','added',1640,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26}}',NULL,'2025-08-06 20:01:20','2025-08-06 20:01:20'),
(2573,'default','added',1641,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-06 20:01:44','2025-08-06 20:01:44'),
(2574,'default','added',1642,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 20:02:15','2025-08-06 20:02:15'),
(2575,'default','added',1643,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 20:06:50','2025-08-06 20:06:50'),
(2576,'default','added',1644,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-06 20:08:01','2025-08-06 20:08:01'),
(2577,'default','added',1645,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 20:10:50','2025-08-06 20:10:50'),
(2578,'default','added',1646,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 20:11:58','2025-08-06 20:11:58'),
(2579,'default','added',1647,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":46}}',NULL,'2025-08-06 20:14:30','2025-08-06 20:14:30'),
(2580,'default','added',1648,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-06 20:14:54','2025-08-06 20:14:54'),
(2581,'default','added',1649,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":42}}',NULL,'2025-08-06 20:15:48','2025-08-06 20:15:48'),
(2582,'default','login',49,'App\\User',NULL,16,49,'App\\User','[]',NULL,'2025-08-06 20:18:01','2025-08-06 20:18:01'),
(2583,'default','added',1650,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-06 20:18:21','2025-08-06 20:18:21'),
(2584,'default','added',1651,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":93}}',NULL,'2025-08-06 20:25:03','2025-08-06 20:25:03'),
(2585,'default','added',1652,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9}}',NULL,'2025-08-06 20:25:35','2025-08-06 20:25:35'),
(2586,'default','added',1653,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":31}}',NULL,'2025-08-06 20:27:16','2025-08-06 20:27:16'),
(2587,'default','added',1654,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-06 20:28:32','2025-08-06 20:28:32'),
(2588,'default','added',1655,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":89}}',NULL,'2025-08-06 20:29:26','2025-08-06 20:29:26'),
(2589,'default','added',1656,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 20:29:52','2025-08-06 20:29:52'),
(2590,'default','added',1657,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-06 20:30:48','2025-08-06 20:30:48'),
(2591,'default','added',1658,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-06 20:31:58','2025-08-06 20:31:58'),
(2592,'default','added',1659,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-06 20:32:23','2025-08-06 20:32:23'),
(2593,'default','added',1660,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-06 20:32:39','2025-08-06 20:32:39'),
(2594,'default','added',1661,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28}}',NULL,'2025-08-06 20:34:59','2025-08-06 20:34:59'),
(2595,'default','added',1662,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-06 20:38:55','2025-08-06 20:38:55'),
(2596,'default','added',1663,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4}}',NULL,'2025-08-06 20:39:22','2025-08-06 20:39:22'),
(2597,'default','added',1664,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-06 20:40:13','2025-08-06 20:40:13'),
(2598,'default','added',1665,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-06 20:42:25','2025-08-06 20:42:25'),
(2599,'default','added',1666,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-06 20:44:03','2025-08-06 20:44:03'),
(2600,'default','added',1667,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26}}',NULL,'2025-08-06 20:48:58','2025-08-06 20:48:58'),
(2601,'default','added',1668,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 20:49:36','2025-08-06 20:49:36'),
(2602,'default','added',1669,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22}}',NULL,'2025-08-06 20:51:41','2025-08-06 20:51:41'),
(2603,'default','login',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-06 20:53:51','2025-08-06 20:53:51'),
(2604,'default','added',1670,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2025-08-06 20:53:52','2025-08-06 20:53:52'),
(2605,'default','added',1671,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-06 20:55:48','2025-08-06 20:55:48'),
(2606,'default','added',1672,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-06 20:56:16','2025-08-06 20:56:16'),
(2607,'default','added',1673,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-06 20:57:39','2025-08-06 20:57:39'),
(2608,'default','added',1674,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":54}}',NULL,'2025-08-06 21:01:04','2025-08-06 21:01:04'),
(2609,'default','added',1675,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 21:02:33','2025-08-06 21:02:33'),
(2610,'default','added',1676,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 21:03:15','2025-08-06 21:03:15'),
(2611,'default','added',1677,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33}}',NULL,'2025-08-06 21:06:03','2025-08-06 21:06:03'),
(2612,'default','added',1678,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36}}',NULL,'2025-08-06 21:11:53','2025-08-06 21:11:53'),
(2613,'default','added',1679,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14}}',NULL,'2025-08-06 21:13:36','2025-08-06 21:13:36'),
(2614,'default','added',1680,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-06 21:14:25','2025-08-06 21:14:25'),
(2615,'default','added',1681,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2025-08-06 21:19:56','2025-08-06 21:19:56'),
(2616,'default','added',1682,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28}}',NULL,'2025-08-06 21:25:10','2025-08-06 21:25:10'),
(2617,'default','added',1683,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-06 21:25:46','2025-08-06 21:25:46'),
(2618,'default','added',1684,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-06 21:29:02','2025-08-06 21:29:02'),
(2619,'default','added',1685,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2025-08-06 21:39:19','2025-08-06 21:39:19'),
(2620,'default','added',1686,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2025-08-06 21:41:19','2025-08-06 21:41:19'),
(2621,'default','added',1687,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-06 21:45:51','2025-08-06 21:45:51'),
(2622,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-08-06 19:48:00','2025-08-06 19:48:00'),
(2623,'default','added',1688,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-06 21:52:33','2025-08-06 21:52:33'),
(2624,'default','added',1689,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-06 21:53:29','2025-08-06 21:53:29'),
(2625,'default','logout',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-06 21:55:17','2025-08-06 21:55:17'),
(2626,'default','login',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-06 21:57:06','2025-08-06 21:57:06'),
(2627,'default','logout',43,'App\\User',NULL,16,43,'App\\User','[]',NULL,'2025-08-06 22:02:53','2025-08-06 22:02:53'),
(2628,'default','login',43,'App\\User',NULL,16,43,'App\\User','[]',NULL,'2025-08-06 22:04:15','2025-08-06 22:04:15'),
(2629,'default','added',1690,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 22:33:54','2025-08-06 22:33:54'),
(2630,'default','added',1691,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-06 22:35:17','2025-08-06 22:35:17'),
(2631,'default','added',1692,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-06 22:36:01','2025-08-06 22:36:01'),
(2632,'default','added',1693,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-06 22:36:58','2025-08-06 22:36:58'),
(2633,'default','added',1694,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-06 22:37:36','2025-08-06 22:37:36'),
(2634,'default','added',1695,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-06 22:37:59','2025-08-06 22:37:59'),
(2635,'default','added',1696,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-06 22:38:49','2025-08-06 22:38:49'),
(2636,'default','added',1697,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":64}}',NULL,'2025-08-06 22:44:00','2025-08-06 22:44:00'),
(2637,'default','added',1698,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 22:44:34','2025-08-06 22:44:34'),
(2638,'default','added',1699,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-06 22:44:47','2025-08-06 22:44:47'),
(2639,'default','added',1700,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-06 22:46:00','2025-08-06 22:46:00'),
(2640,'default','login',47,'App\\User',NULL,16,47,'App\\User','[]',NULL,'2025-08-06 22:59:51','2025-08-06 22:59:51'),
(2641,'default','logout',43,'App\\User',NULL,16,43,'App\\User','[]',NULL,'2025-08-06 23:43:15','2025-08-06 23:43:15'),
(2642,'default','login',46,'App\\User',NULL,16,46,'App\\User','[]',NULL,'2025-08-06 23:43:25','2025-08-06 23:43:25'),
(2643,'default','login',46,'App\\User',NULL,16,46,'App\\User','[]',NULL,'2025-08-07 04:17:40','2025-08-07 04:17:40'),
(2644,'default','added',1701,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28}}',NULL,'2025-08-07 04:27:12','2025-08-07 04:27:12'),
(2645,'default','added',1702,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-07 06:36:31','2025-08-07 06:36:31'),
(2646,'default','added',1703,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-07 06:39:01','2025-08-07 06:39:01'),
(2647,'default','added',1704,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-07 06:41:27','2025-08-07 06:41:27'),
(2648,'default','added',1705,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-07 06:42:54','2025-08-07 06:42:54'),
(2649,'default','added',1706,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 06:54:32','2025-08-07 06:54:32'),
(2650,'default','added',1707,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 06:55:23','2025-08-07 06:55:23'),
(2651,'default','added',1708,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 07:03:35','2025-08-07 07:03:35'),
(2652,'default','added',1709,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12}}',NULL,'2025-08-07 07:11:09','2025-08-07 07:11:09'),
(2653,'default','added',1710,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 07:23:33','2025-08-07 07:23:33'),
(2654,'default','added',1711,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-07 07:24:59','2025-08-07 07:24:59'),
(2655,'default','added',1712,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-07 07:33:17','2025-08-07 07:33:17'),
(2656,'default','added',1713,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 07:35:47','2025-08-07 07:35:47'),
(2657,'default','added',1714,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 07:43:35','2025-08-07 07:43:35'),
(2658,'default','login',48,'App\\User',NULL,16,48,'App\\User','[]',NULL,'2025-08-07 07:43:36','2025-08-07 07:43:36'),
(2659,'default','added',1715,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-07 07:49:54','2025-08-07 07:49:54'),
(2660,'default','added',1716,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-07 07:53:29','2025-08-07 07:53:29'),
(2661,'default','added',1717,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-07 07:55:52','2025-08-07 07:55:52'),
(2662,'default','added',1718,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-07 07:56:44','2025-08-07 07:56:44'),
(2663,'default','added',1719,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 08:02:41','2025-08-07 08:02:41'),
(2664,'default','added',1720,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-07 08:07:54','2025-08-07 08:07:54'),
(2665,'default','added',1721,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7}}',NULL,'2025-08-07 08:08:19','2025-08-07 08:08:19'),
(2666,'default','added',1722,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 08:08:46','2025-08-07 08:08:46'),
(2667,'default','added',1723,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-07 08:13:17','2025-08-07 08:13:17'),
(2668,'default','added',1724,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-07 08:13:43','2025-08-07 08:13:43'),
(2669,'default','added',1725,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-07 08:14:20','2025-08-07 08:14:20'),
(2670,'default','added',1726,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14}}',NULL,'2025-08-07 08:17:04','2025-08-07 08:17:04'),
(2671,'default','added',1727,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-07 08:19:42','2025-08-07 08:19:42'),
(2672,'default','added',1728,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-07 08:21:16','2025-08-07 08:21:16'),
(2673,'default','added',1729,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-07 08:31:15','2025-08-07 08:31:15'),
(2674,'default','login',48,'App\\User',NULL,16,48,'App\\User','[]',NULL,'2025-08-07 08:34:36','2025-08-07 08:34:36'),
(2675,'default','added',1730,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-07 08:55:20','2025-08-07 08:55:20'),
(2676,'default','login',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-07 08:55:40','2025-08-07 08:55:40'),
(2677,'default','added',1731,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-07 09:00:14','2025-08-07 09:00:14'),
(2678,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-08-07 07:05:40','2025-08-07 07:05:40'),
(2679,'default','added',1732,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12}}',NULL,'2025-08-07 09:10:16','2025-08-07 09:10:16'),
(2680,'default','added',1733,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-07 09:13:59','2025-08-07 09:13:59'),
(2681,'default','added',1734,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49}}',NULL,'2025-08-07 09:17:20','2025-08-07 09:17:20'),
(2682,'default','added',1735,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-07 09:24:56','2025-08-07 09:24:56'),
(2683,'default','added',1736,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 09:26:09','2025-08-07 09:26:09'),
(2684,'default','added',1737,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12}}',NULL,'2025-08-07 09:28:45','2025-08-07 09:28:45'),
(2685,'default','added',1738,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28}}',NULL,'2025-08-07 09:35:17','2025-08-07 09:35:17'),
(2686,'default','added',1739,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 09:42:41','2025-08-07 09:42:41'),
(2687,'default','added',1740,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-07 09:44:31','2025-08-07 09:44:31'),
(2688,'default','added',1741,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-07 09:49:40','2025-08-07 09:49:40'),
(2689,'default','added',1742,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-07 09:59:38','2025-08-07 09:59:38'),
(2690,'default','logout',48,'App\\User',NULL,16,48,'App\\User','[]',NULL,'2025-08-07 10:08:28','2025-08-07 10:08:28'),
(2691,'default','added',1743,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-07 10:10:50','2025-08-07 10:10:50'),
(2692,'default','added',1744,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-07 10:23:20','2025-08-07 10:23:20'),
(2693,'default','added',1745,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-07 10:34:21','2025-08-07 10:34:21'),
(2694,'default','added',1746,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-07 10:35:24','2025-08-07 10:35:24'),
(2695,'default','added',1747,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26}}',NULL,'2025-08-07 10:36:32','2025-08-07 10:36:32'),
(2696,'default','added',1748,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-07 10:39:59','2025-08-07 10:39:59'),
(2697,'default','login',48,'App\\User',NULL,16,48,'App\\User','[]',NULL,'2025-08-07 10:40:40','2025-08-07 10:40:40'),
(2698,'default','added',1749,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-07 10:48:22','2025-08-07 10:48:22'),
(2699,'default','added',1750,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-07 10:49:00','2025-08-07 10:49:00'),
(2700,'default','added',1751,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-07 10:49:37','2025-08-07 10:49:37'),
(2701,'default','added',1752,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14}}',NULL,'2025-08-07 10:57:02','2025-08-07 10:57:02'),
(2702,'default','login',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-07 11:10:29','2025-08-07 11:10:29'),
(2703,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-08-07 09:24:12','2025-08-07 09:24:12'),
(2704,'default','added',1753,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 11:39:16','2025-08-07 11:39:16'),
(2705,'default','added',1754,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-07 11:39:35','2025-08-07 11:39:35'),
(2706,'default','added',1755,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-07 11:43:49','2025-08-07 11:43:49'),
(2707,'default','added',1756,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-07 11:44:54','2025-08-07 11:44:54'),
(2708,'default','added',1757,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-07 11:56:08','2025-08-07 11:56:08'),
(2709,'default','added',1758,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-07 11:57:54','2025-08-07 11:57:54'),
(2710,'default','added',1759,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-07 12:04:44','2025-08-07 12:04:44'),
(2711,'default','added',1760,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":56}}',NULL,'2025-08-07 12:21:05','2025-08-07 12:21:05'),
(2712,'default','sell_deleted',1760,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1760,\"invoice_no\":\"0502\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"56.0000\"}}',NULL,'2025-08-07 12:22:55','2025-08-07 12:22:55'),
(2713,'default','added',1761,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-07 13:11:38','2025-08-07 13:11:38'),
(2714,'default','added',1762,'App\\Transaction',NULL,16,39,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":156}}',NULL,'2025-08-07 13:13:44','2025-08-07 13:13:44'),
(2715,'default','added',1763,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-07 13:58:41','2025-08-07 13:58:41'),
(2716,'default','added',1764,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":34}}',NULL,'2025-08-07 14:01:46','2025-08-07 14:01:46'),
(2717,'default','added',1765,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":99}}',NULL,'2025-08-07 14:05:03','2025-08-07 14:05:03'),
(2718,'default','added',1766,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39}}',NULL,'2025-08-07 14:06:12','2025-08-07 14:06:12'),
(2719,'default','sell_deleted',1766,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1766,\"invoice_no\":\"0508\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"39.0000\"}}',NULL,'2025-08-07 14:08:21','2025-08-07 14:08:21'),
(2720,'default','sell_deleted',1765,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1765,\"invoice_no\":\"0507\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"99.0000\"}}',NULL,'2025-08-07 14:08:26','2025-08-07 14:08:26'),
(2721,'default','sell_deleted',1762,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1762,\"invoice_no\":\"0504\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"156.0000\"}}',NULL,'2025-08-07 14:08:49','2025-08-07 14:08:49'),
(2722,'default','added',1767,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-07 14:09:05','2025-08-07 14:09:05'),
(2723,'default','added',1768,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-07 14:23:41','2025-08-07 14:23:41'),
(2724,'default','added',1769,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 14:36:54','2025-08-07 14:36:54'),
(2725,'default','logout',46,'App\\User',NULL,16,46,'App\\User','[]',NULL,'2025-08-07 14:58:45','2025-08-07 14:58:45'),
(2726,'default','login',43,'App\\User',NULL,16,43,'App\\User','[]',NULL,'2025-08-07 14:58:57','2025-08-07 14:58:57'),
(2727,'default','added',1770,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-07 15:00:09','2025-08-07 15:00:09'),
(2728,'default','added',1771,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36}}',NULL,'2025-08-07 15:03:25','2025-08-07 15:03:25'),
(2729,'default','added',1772,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-07 15:04:03','2025-08-07 15:04:03'),
(2730,'default','added',1773,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-07 15:06:01','2025-08-07 15:06:01'),
(2731,'default','added',1774,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 15:06:40','2025-08-07 15:06:40'),
(2732,'default','added',1775,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-07 15:14:01','2025-08-07 15:14:01'),
(2733,'default','added',1776,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":76}}',NULL,'2025-08-07 15:18:35','2025-08-07 15:18:35'),
(2734,'default','added',1777,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":79}}',NULL,'2025-08-07 15:21:52','2025-08-07 15:21:52'),
(2735,'default','added',1778,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26}}',NULL,'2025-08-07 15:22:32','2025-08-07 15:22:32'),
(2736,'default','login',49,'App\\User',NULL,16,49,'App\\User','[]',NULL,'2025-08-07 15:22:41','2025-08-07 15:22:41'),
(2737,'default','added',1779,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":34}}',NULL,'2025-08-07 15:34:49','2025-08-07 15:34:49'),
(2738,'default','added',1780,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 15:35:25','2025-08-07 15:35:25'),
(2739,'default','added',1781,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-07 15:39:42','2025-08-07 15:39:42'),
(2740,'default','added',1782,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-07 15:45:14','2025-08-07 15:45:14'),
(2741,'default','added',1783,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-07 15:45:49','2025-08-07 15:45:49'),
(2742,'default','added',1784,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":64}}',NULL,'2025-08-07 15:57:17','2025-08-07 15:57:17'),
(2743,'default','added',1785,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-07 15:57:50','2025-08-07 15:57:50'),
(2744,'default','added',1786,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-07 16:01:52','2025-08-07 16:01:52'),
(2745,'default','added',1787,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-07 16:04:37','2025-08-07 16:04:37'),
(2746,'default','added',1788,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-07 16:11:18','2025-08-07 16:11:18'),
(2747,'default','added',1789,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-07 16:19:25','2025-08-07 16:19:25'),
(2748,'default','added',1790,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-07 16:27:25','2025-08-07 16:27:25'),
(2749,'default','added',1791,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":54}}',NULL,'2025-08-07 16:34:13','2025-08-07 16:34:13'),
(2750,'default','added',1792,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-07 16:35:13','2025-08-07 16:35:13'),
(2751,'default','added',1793,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-07 16:35:34','2025-08-07 16:35:34'),
(2752,'default','added',1794,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-07 16:36:53','2025-08-07 16:36:53'),
(2753,'default','added',1795,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29}}',NULL,'2025-08-07 16:43:59','2025-08-07 16:43:59'),
(2754,'default','added',1796,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-07 16:45:54','2025-08-07 16:45:54'),
(2755,'default','added',1797,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-07 16:48:16','2025-08-07 16:48:16'),
(2756,'default','added',1798,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-07 16:55:36','2025-08-07 16:55:36'),
(2757,'default','added',1799,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":62}}',NULL,'2025-08-07 16:58:24','2025-08-07 16:58:24'),
(2758,'default','added',1800,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29}}',NULL,'2025-08-07 17:00:09','2025-08-07 17:00:09'),
(2759,'default','added',1801,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":99}}',NULL,'2025-08-07 17:08:43','2025-08-07 17:08:43'),
(2760,'default','added',1802,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17}}',NULL,'2025-08-07 17:10:48','2025-08-07 17:10:48'),
(2761,'default','added',1803,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":80}}',NULL,'2025-08-07 17:11:50','2025-08-07 17:11:50'),
(2762,'default','sell_deleted',1801,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":1801,\"invoice_no\":\"0543\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"99.0000\"}}',NULL,'2025-08-07 17:15:44','2025-08-07 17:15:44'),
(2763,'default','added',1804,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-07 17:17:00','2025-08-07 17:17:00'),
(2764,'default','login',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-07 17:17:14','2025-08-07 17:17:14'),
(2765,'default','added',1805,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-07 17:19:08','2025-08-07 17:19:08'),
(2766,'default','added',1806,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":56}}',NULL,'2025-08-07 17:21:50','2025-08-07 17:21:50'),
(2767,'default','added',1807,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-07 17:29:32','2025-08-07 17:29:32'),
(2768,'default','added',1808,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9}}',NULL,'2025-08-07 17:31:06','2025-08-07 17:31:06'),
(2769,'default','added',1809,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33}}',NULL,'2025-08-07 17:34:59','2025-08-07 17:34:59'),
(2770,'default','added',1810,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26}}',NULL,'2025-08-07 17:37:26','2025-08-07 17:37:26'),
(2771,'default','added',1811,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":55}}',NULL,'2025-08-07 17:38:13','2025-08-07 17:38:13'),
(2772,'default','added',1812,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-07 17:38:44','2025-08-07 17:38:44'),
(2773,'default','added',1813,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-07 17:39:45','2025-08-07 17:39:45'),
(2774,'default','added',1814,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-07 17:40:17','2025-08-07 17:40:17'),
(2775,'default','added',1815,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 17:41:37','2025-08-07 17:41:37'),
(2776,'default','added',1816,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-07 17:42:53','2025-08-07 17:42:53'),
(2777,'default','added',1817,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-07 17:43:59','2025-08-07 17:43:59'),
(2778,'default','added',1818,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-07 17:44:19','2025-08-07 17:44:19'),
(2779,'default','added',1819,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28}}',NULL,'2025-08-07 17:44:57','2025-08-07 17:44:57'),
(2780,'default','added',1820,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-07 17:46:00','2025-08-07 17:46:00'),
(2781,'default','added',1821,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 17:51:26','2025-08-07 17:51:26'),
(2782,'default','added',1822,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-07 17:55:55','2025-08-07 17:55:55'),
(2783,'default','added',1823,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":37}}',NULL,'2025-08-07 17:57:12','2025-08-07 17:57:12'),
(2784,'default','added',1824,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-07 17:58:52','2025-08-07 17:58:52'),
(2785,'default','added',1825,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69}}',NULL,'2025-08-07 18:00:18','2025-08-07 18:00:18'),
(2786,'default','added',1826,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-07 18:01:11','2025-08-07 18:01:11'),
(2787,'default','added',1827,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-07 18:01:41','2025-08-07 18:01:41'),
(2788,'default','added',1828,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-07 18:06:09','2025-08-07 18:06:09'),
(2789,'default','added',1829,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-07 18:06:24','2025-08-07 18:06:24'),
(2790,'default','added',1830,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2025-08-07 18:06:59','2025-08-07 18:06:59'),
(2791,'default','added',1831,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-07 18:10:29','2025-08-07 18:10:29'),
(2792,'default','added',1832,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-07 18:10:59','2025-08-07 18:10:59'),
(2793,'default','added',1833,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2025-08-07 18:25:07','2025-08-07 18:25:07'),
(2794,'default','added',1834,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-07 18:25:43','2025-08-07 18:25:43'),
(2795,'default','added',1835,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23}}',NULL,'2025-08-07 18:29:11','2025-08-07 18:29:11'),
(2796,'default','added',1836,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-07 18:32:48','2025-08-07 18:32:48'),
(2797,'default','added',1837,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-07 18:35:17','2025-08-07 18:35:17'),
(2798,'default','added',1838,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-07 18:38:37','2025-08-07 18:38:37'),
(2799,'default','added',1839,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43}}',NULL,'2025-08-07 18:42:15','2025-08-07 18:42:15'),
(2800,'default','added',1840,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17}}',NULL,'2025-08-07 18:42:49','2025-08-07 18:42:49'),
(2801,'default','added',1841,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-07 18:45:24','2025-08-07 18:45:24'),
(2802,'default','added',1842,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-07 18:45:51','2025-08-07 18:45:51'),
(2803,'default','added',1843,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-07 18:47:25','2025-08-07 18:47:25'),
(2804,'default','added',1844,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-07 18:49:38','2025-08-07 18:49:38'),
(2805,'default','added',1845,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-07 18:55:22','2025-08-07 18:55:22'),
(2806,'default','added',1846,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28}}',NULL,'2025-08-07 19:00:09','2025-08-07 19:00:09'),
(2807,'default','added',1847,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-07 19:04:56','2025-08-07 19:04:56'),
(2808,'default','added',1848,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-07 19:08:53','2025-08-07 19:08:53'),
(2809,'default','added',1849,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}',NULL,'2025-08-07 19:13:46','2025-08-07 19:13:46'),
(2810,'default','added',1850,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12}}',NULL,'2025-08-07 19:14:25','2025-08-07 19:14:25'),
(2811,'default','added',1851,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9}}',NULL,'2025-08-07 19:14:40','2025-08-07 19:14:40'),
(2812,'default','added',1852,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-07 19:15:53','2025-08-07 19:15:53'),
(2813,'default','added',1853,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-07 19:16:23','2025-08-07 19:16:23'),
(2814,'default','added',1854,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":47}}',NULL,'2025-08-07 19:17:32','2025-08-07 19:17:32'),
(2815,'default','added',1855,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":55}}',NULL,'2025-08-07 19:28:09','2025-08-07 19:28:09'),
(2816,'default','added',1856,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":72}}',NULL,'2025-08-07 19:32:44','2025-08-07 19:32:44'),
(2817,'default','added',1857,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43}}',NULL,'2025-08-07 19:34:13','2025-08-07 19:34:13'),
(2818,'default','added',1858,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":61}}',NULL,'2025-08-07 19:38:32','2025-08-07 19:38:32'),
(2819,'default','added',1859,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-07 19:39:30','2025-08-07 19:39:30'),
(2820,'default','added',1860,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28}}',NULL,'2025-08-07 19:40:42','2025-08-07 19:40:42'),
(2821,'default','added',1861,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28}}',NULL,'2025-08-07 19:42:26','2025-08-07 19:42:26'),
(2822,'default','added',1862,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-07 19:45:05','2025-08-07 19:45:05'),
(2823,'default','added',1863,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-07 19:46:28','2025-08-07 19:46:28'),
(2824,'default','added',1864,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-07 19:47:48','2025-08-07 19:47:48'),
(2825,'default','added',1865,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-07 19:48:34','2025-08-07 19:48:34'),
(2826,'default','added',1866,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-07 19:52:45','2025-08-07 19:52:45'),
(2827,'default','added',1867,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-07 19:54:04','2025-08-07 19:54:04'),
(2828,'default','added',1868,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-07 19:54:18','2025-08-07 19:54:18'),
(2829,'default','added',1869,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-07 19:57:13','2025-08-07 19:57:13'),
(2830,'default','added',1870,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":46}}',NULL,'2025-08-07 19:58:37','2025-08-07 19:58:37'),
(2831,'default','added',1871,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2025-08-07 19:59:16','2025-08-07 19:59:16'),
(2832,'default','added',1872,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 19:59:47','2025-08-07 19:59:47'),
(2833,'default','added',1873,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-07 20:00:26','2025-08-07 20:00:26'),
(2834,'default','added',1874,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-07 20:02:39','2025-08-07 20:02:39'),
(2835,'default','added',1875,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-07 20:03:15','2025-08-07 20:03:15'),
(2836,'default','added',1876,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 20:04:52','2025-08-07 20:04:52'),
(2837,'default','added',1877,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-07 20:05:50','2025-08-07 20:05:50'),
(2838,'default','added',1878,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":48}}',NULL,'2025-08-07 20:06:48','2025-08-07 20:06:48'),
(2839,'default','added',1879,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-07 20:17:59','2025-08-07 20:17:59'),
(2840,'default','added',1880,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-07 20:18:31','2025-08-07 20:18:31'),
(2841,'default','added',1881,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14}}',NULL,'2025-08-07 20:19:24','2025-08-07 20:19:24'),
(2842,'default','added',1882,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 20:21:19','2025-08-07 20:21:19'),
(2843,'default','added',1883,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 20:21:44','2025-08-07 20:21:44'),
(2844,'default','added',1884,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":72}}',NULL,'2025-08-07 20:22:24','2025-08-07 20:22:24'),
(2845,'default','added',1885,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-07 20:26:08','2025-08-07 20:26:08'),
(2846,'default','added',1886,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-07 20:26:37','2025-08-07 20:26:37'),
(2847,'default','added',1887,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-07 20:27:22','2025-08-07 20:27:22'),
(2848,'default','added',1888,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-07 20:28:24','2025-08-07 20:28:24'),
(2849,'default','added',1889,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-07 20:28:56','2025-08-07 20:28:56'),
(2850,'default','added',1890,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":26}}',NULL,'2025-08-07 20:29:36','2025-08-07 20:29:36'),
(2851,'default','added',1891,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":52}}',NULL,'2025-08-07 20:31:35','2025-08-07 20:31:35'),
(2852,'default','added',1892,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 20:32:13','2025-08-07 20:32:13'),
(2853,'default','added',1893,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":56}}',NULL,'2025-08-07 20:33:38','2025-08-07 20:33:38'),
(2854,'default','added',1894,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-07 20:35:21','2025-08-07 20:35:21'),
(2855,'default','added',1895,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-07 20:40:35','2025-08-07 20:40:35'),
(2856,'default','added',1896,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-07 20:41:01','2025-08-07 20:41:01'),
(2857,'default','added',1897,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":130}}',NULL,'2025-08-07 20:42:04','2025-08-07 20:42:04'),
(2858,'default','added',1898,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-07 20:47:03','2025-08-07 20:47:03'),
(2859,'default','added',1899,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":48}}',NULL,'2025-08-07 20:54:44','2025-08-07 20:54:44'),
(2860,'default','added',1900,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":57}}',NULL,'2025-08-07 20:55:39','2025-08-07 20:55:39'),
(2861,'default','added',1901,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 20:58:12','2025-08-07 20:58:12'),
(2862,'default','added',1902,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39}}',NULL,'2025-08-07 20:59:14','2025-08-07 20:59:14'),
(2863,'default','added',1903,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14}}',NULL,'2025-08-07 20:59:56','2025-08-07 20:59:56'),
(2864,'default','added',1904,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-07 21:00:23','2025-08-07 21:00:23'),
(2865,'default','added',1905,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":27}}',NULL,'2025-08-07 21:06:39','2025-08-07 21:06:39'),
(2866,'default','added',1906,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-07 21:07:17','2025-08-07 21:07:17'),
(2867,'default','added',1907,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-07 21:07:43','2025-08-07 21:07:43'),
(2868,'default','added',1908,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45}}',NULL,'2025-08-07 21:10:12','2025-08-07 21:10:12'),
(2869,'default','added',1909,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29}}',NULL,'2025-08-07 21:11:17','2025-08-07 21:11:17'),
(2870,'default','added',1910,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-07 21:11:52','2025-08-07 21:11:52'),
(2871,'default','added',1911,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 21:12:31','2025-08-07 21:12:31'),
(2872,'default','added',1912,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 21:12:59','2025-08-07 21:12:59'),
(2873,'default','added',1913,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-07 21:13:37','2025-08-07 21:13:37'),
(2874,'default','added',1914,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":25}}',NULL,'2025-08-07 21:16:06','2025-08-07 21:16:06'),
(2875,'default','added',1915,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-07 21:18:25','2025-08-07 21:18:25'),
(2876,'default','added',1916,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":26}}',NULL,'2025-08-07 21:21:29','2025-08-07 21:21:29'),
(2877,'default','added',1917,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":26}}',NULL,'2025-08-07 21:21:54','2025-08-07 21:21:54'),
(2878,'default','added',1918,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-07 21:23:25','2025-08-07 21:23:25'),
(2879,'default','added',1919,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-07 21:24:39','2025-08-07 21:24:39'),
(2880,'default','added',1920,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-07 21:29:29','2025-08-07 21:29:29'),
(2881,'default','added',1921,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":68}}',NULL,'2025-08-07 21:36:59','2025-08-07 21:36:59'),
(2882,'default','added',1922,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":42}}',NULL,'2025-08-07 21:43:27','2025-08-07 21:43:27'),
(2883,'default','added',1923,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 21:45:33','2025-08-07 21:45:33'),
(2884,'default','added',1924,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-07 21:47:36','2025-08-07 21:47:36'),
(2885,'default','added',1925,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39}}',NULL,'2025-08-07 21:48:28','2025-08-07 21:48:28'),
(2886,'default','added',1926,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":48}}',NULL,'2025-08-07 21:51:36','2025-08-07 21:51:36'),
(2887,'default','added',1927,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-07 21:52:51','2025-08-07 21:52:51'),
(2888,'default','added',1928,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-07 21:53:18','2025-08-07 21:53:18'),
(2889,'default','added',1929,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-07 21:54:09','2025-08-07 21:54:09'),
(2890,'default','added',1930,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":80}}',NULL,'2025-08-07 21:55:08','2025-08-07 21:55:08'),
(2891,'default','added',1931,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-07 22:01:06','2025-08-07 22:01:06'),
(2892,'default','added',1932,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-07 22:06:27','2025-08-07 22:06:27'),
(2893,'default','added',1933,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-07 22:15:50','2025-08-07 22:15:50'),
(2894,'default','added',1934,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2}}',NULL,'2025-08-07 22:23:24','2025-08-07 22:23:24'),
(2895,'default','added',1935,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-07 22:26:19','2025-08-07 22:26:19'),
(2896,'default','added',1936,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4}}',NULL,'2025-08-07 22:36:39','2025-08-07 22:36:39'),
(2897,'default','added',1937,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":31}}',NULL,'2025-08-07 22:44:53','2025-08-07 22:44:53'),
(2898,'default','added',1938,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36}}',NULL,'2025-08-07 23:33:20','2025-08-07 23:33:20'),
(2899,'default','login',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-07 23:44:14','2025-08-07 23:44:14'),
(2900,'default','logout',39,'App\\User',NULL,16,39,'App\\User','[]',NULL,'2025-08-07 23:47:17','2025-08-07 23:47:17'),
(2901,'default','login',46,'App\\User',NULL,16,46,'App\\User','[]',NULL,'2025-08-08 06:05:43','2025-08-08 06:05:43'),
(2902,'default','added',1939,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-08 06:40:26','2025-08-08 06:40:26'),
(2903,'default','added',1940,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-08 06:41:36','2025-08-08 06:41:36'),
(2904,'default','added',1941,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-08 06:52:10','2025-08-08 06:52:10'),
(2905,'default','added',1942,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-08 06:54:03','2025-08-08 06:54:03'),
(2906,'default','added',1943,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-08 07:52:10','2025-08-08 07:52:10'),
(2907,'default','added',1944,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-08 08:09:39','2025-08-08 08:09:39'),
(2908,'default','added',1945,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-08 08:19:22','2025-08-08 08:19:22'),
(2909,'default','added',1946,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-08 08:19:57','2025-08-08 08:19:57'),
(2910,'default','added',1947,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-08 08:35:42','2025-08-08 08:35:42'),
(2911,'default','added',1948,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-08 09:56:18','2025-08-08 09:56:18'),
(2912,'default','added',1949,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-08 09:57:05','2025-08-08 09:57:05'),
(2913,'default','added',1950,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-08 10:09:58','2025-08-08 10:09:58'),
(2914,'default','added',1951,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-08 10:16:45','2025-08-08 10:16:45'),
(2915,'default','added',1952,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-08 10:22:09','2025-08-08 10:22:09'),
(2916,'default','added',1953,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-08 10:34:50','2025-08-08 10:34:50'),
(2917,'default','added',1954,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-08 10:40:24','2025-08-08 10:40:24'),
(2918,'default','added',1955,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-08 10:41:25','2025-08-08 10:41:25'),
(2919,'default','added',1956,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-08 10:44:34','2025-08-08 10:44:34'),
(2920,'default','added',1957,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-08 10:48:45','2025-08-08 10:48:45'),
(2921,'default','added',1958,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-08 10:52:44','2025-08-08 10:52:44'),
(2922,'default','login',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-08 10:56:33','2025-08-08 10:56:33'),
(2923,'default','added',1959,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2}}',NULL,'2025-08-08 10:57:10','2025-08-08 10:57:10'),
(2924,'default','added',1960,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-08 10:58:49','2025-08-08 10:58:49'),
(2925,'default','added',1961,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2025-08-08 10:59:33','2025-08-08 10:59:33'),
(2926,'default','added',1962,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":35}}',NULL,'2025-08-08 11:00:18','2025-08-08 11:00:18'),
(2927,'default','added',1963,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9}}',NULL,'2025-08-08 11:23:27','2025-08-08 11:23:27'),
(2928,'default','added',1964,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-08 11:31:26','2025-08-08 11:31:26'),
(2929,'default','added',1965,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14}}',NULL,'2025-08-08 11:46:02','2025-08-08 11:46:02'),
(2930,'default','added',1966,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9}}',NULL,'2025-08-08 11:47:52','2025-08-08 11:47:52'),
(2931,'default','added',1967,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-08 11:54:02','2025-08-08 11:54:02'),
(2932,'default','added',1968,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12}}',NULL,'2025-08-08 11:56:40','2025-08-08 11:56:40'),
(2933,'default','added',1969,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":48}}',NULL,'2025-08-08 12:10:43','2025-08-08 12:10:43'),
(2934,'default','added',1970,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-08 12:19:02','2025-08-08 12:19:02'),
(2935,'default','added',1971,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-08 12:45:07','2025-08-08 12:45:07'),
(2936,'default','added',1972,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-08 13:06:22','2025-08-08 13:06:22'),
(2937,'default','added',1973,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-08 13:20:03','2025-08-08 13:20:03'),
(2938,'default','login',49,'App\\User',NULL,16,49,'App\\User','[]',NULL,'2025-08-08 13:29:25','2025-08-08 13:29:25'),
(2939,'default','added',1974,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-08 13:35:09','2025-08-08 13:35:09'),
(2940,'default','added',1975,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-08 13:36:43','2025-08-08 13:36:43'),
(2941,'default','added',1976,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22}}',NULL,'2025-08-08 13:51:17','2025-08-08 13:51:17'),
(2942,'default','added',1977,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-08 13:55:05','2025-08-08 13:55:05'),
(2943,'default','added',1978,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":50}}',NULL,'2025-08-08 13:57:12','2025-08-08 13:57:12'),
(2944,'default','added',1979,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-08 14:07:35','2025-08-08 14:07:35'),
(2945,'default','added',1980,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-08 14:09:54','2025-08-08 14:09:54'),
(2946,'default','added',1981,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-08 14:27:39','2025-08-08 14:27:39'),
(2947,'default','added',1982,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9}}',NULL,'2025-08-08 14:32:39','2025-08-08 14:32:39'),
(2948,'default','added',1983,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14}}',NULL,'2025-08-08 14:39:35','2025-08-08 14:39:35'),
(2949,'default','added',1984,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-08 14:48:17','2025-08-08 14:48:17'),
(2950,'default','added',1985,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-08 15:02:22','2025-08-08 15:02:22'),
(2951,'default','added',1986,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":26}}',NULL,'2025-08-08 15:05:15','2025-08-08 15:05:15'),
(2952,'default','added',1987,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-08 15:07:12','2025-08-08 15:07:12'),
(2953,'default','added',1988,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-08 15:07:35','2025-08-08 15:07:35'),
(2954,'default','added',1989,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2025-08-08 15:11:03','2025-08-08 15:11:03'),
(2955,'default','added',1990,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-08 15:20:04','2025-08-08 15:20:04'),
(2956,'default','added',1991,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-08 15:20:20','2025-08-08 15:20:20'),
(2957,'default','added',1992,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-08 15:24:51','2025-08-08 15:24:51'),
(2958,'default','added',1993,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":100}}',NULL,'2025-08-08 15:26:23','2025-08-08 15:26:23'),
(2959,'default','added',1994,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-08 15:29:48','2025-08-08 15:29:48'),
(2960,'default','added',1995,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-08 15:33:06','2025-08-08 15:33:06'),
(2961,'default','added',1996,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-08 15:35:46','2025-08-08 15:35:46'),
(2962,'default','added',1997,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-08 15:39:21','2025-08-08 15:39:21'),
(2963,'default','added',1998,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-08 15:40:09','2025-08-08 15:40:09'),
(2964,'default','added',1999,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-08 15:40:53','2025-08-08 15:40:53'),
(2965,'default','added',2000,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28}}',NULL,'2025-08-08 15:50:33','2025-08-08 15:50:33'),
(2966,'default','added',2001,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9}}',NULL,'2025-08-08 15:57:49','2025-08-08 15:57:49'),
(2967,'default','added',2002,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-08 16:02:37','2025-08-08 16:02:37'),
(2968,'default','added',2003,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-08 16:23:06','2025-08-08 16:23:06'),
(2969,'default','added',2004,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-08 16:26:27','2025-08-08 16:26:27'),
(2970,'default','added',2005,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":27}}',NULL,'2025-08-08 16:34:02','2025-08-08 16:34:02'),
(2971,'default','added',2006,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":56}}',NULL,'2025-08-08 16:39:13','2025-08-08 16:39:13'),
(2972,'default','added',2007,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-08 16:39:55','2025-08-08 16:39:55'),
(2973,'default','added',2008,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-08 16:41:10','2025-08-08 16:41:10'),
(2974,'default','added',2009,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-08 16:53:37','2025-08-08 16:53:37'),
(2975,'default','added',2010,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-08 16:54:06','2025-08-08 16:54:06'),
(2976,'default','added',2011,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-08 16:56:45','2025-08-08 16:56:45'),
(2977,'default','added',2012,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-08 16:57:10','2025-08-08 16:57:10'),
(2978,'default','added',2013,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-08 16:58:31','2025-08-08 16:58:31'),
(2979,'default','login',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-08 16:58:35','2025-08-08 16:58:35'),
(2980,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-08-08 14:59:25','2025-08-08 14:59:26'),
(2981,'default','added',2014,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22}}',NULL,'2025-08-08 17:05:58','2025-08-08 17:05:58'),
(2982,'default','added',2015,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-08 17:06:50','2025-08-08 17:06:50'),
(2983,'default','added',2016,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-08 17:11:34','2025-08-08 17:11:34'),
(2984,'default','added',2017,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-08 17:19:54','2025-08-08 17:19:54'),
(2985,'default','added',2018,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-08 17:21:44','2025-08-08 17:21:44'),
(2986,'default','added',2019,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-08 17:23:06','2025-08-08 17:23:06'),
(2987,'default','added',2020,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-08 17:23:48','2025-08-08 17:23:48'),
(2988,'default','added',2021,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49}}',NULL,'2025-08-08 17:28:43','2025-08-08 17:28:43'),
(2989,'default','added',2022,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22}}',NULL,'2025-08-08 17:29:57','2025-08-08 17:29:57'),
(2990,'default','added',2023,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-08 17:31:17','2025-08-08 17:31:17'),
(2991,'default','added',2024,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":182}}',NULL,'2025-08-08 17:34:40','2025-08-08 17:34:40'),
(2992,'default','added',2025,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-08 17:35:19','2025-08-08 17:35:19'),
(2993,'default','added',2026,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17}}',NULL,'2025-08-08 17:35:51','2025-08-08 17:35:51'),
(2994,'default','added',2027,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":83}}',NULL,'2025-08-08 17:37:47','2025-08-08 17:37:47'),
(2995,'default','added',2028,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26}}',NULL,'2025-08-08 17:38:36','2025-08-08 17:38:36'),
(2996,'default','added',2029,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-08 17:39:16','2025-08-08 17:39:16'),
(2997,'default','added',2030,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-08 17:39:39','2025-08-08 17:39:39'),
(2998,'default','added',2031,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45}}',NULL,'2025-08-08 17:40:23','2025-08-08 17:40:23'),
(2999,'default','added',2032,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-08 17:41:15','2025-08-08 17:41:15'),
(3000,'default','added',2033,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-08 17:43:22','2025-08-08 17:43:22'),
(3001,'default','added',2034,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-08 17:44:06','2025-08-08 17:44:06'),
(3002,'default','added',2035,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-08 17:44:33','2025-08-08 17:44:33'),
(3003,'default','added',2036,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-08 17:45:34','2025-08-08 17:45:34'),
(3004,'default','added',2037,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17}}',NULL,'2025-08-08 17:47:50','2025-08-08 17:47:50'),
(3005,'default','added',2038,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-08 17:51:12','2025-08-08 17:51:12'),
(3006,'default','added',2039,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":56}}',NULL,'2025-08-08 17:51:59','2025-08-08 17:51:59'),
(3007,'default','added',2040,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-08 17:52:34','2025-08-08 17:52:34'),
(3008,'default','added',2041,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-08 17:53:23','2025-08-08 17:53:23'),
(3009,'default','added',2042,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-08 17:56:42','2025-08-08 17:56:42'),
(3010,'default','added',2043,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-08 18:03:32','2025-08-08 18:03:32'),
(3011,'default','added',2044,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":64}}',NULL,'2025-08-08 18:05:02','2025-08-08 18:05:02'),
(3012,'default','added',2045,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":520}}',NULL,'2025-08-08 18:06:54','2025-08-08 18:06:54'),
(3013,'default','added',2046,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":120}}',NULL,'2025-08-08 18:08:52','2025-08-08 18:08:52'),
(3014,'default','added',2047,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23}}',NULL,'2025-08-08 18:10:34','2025-08-08 18:10:34'),
(3015,'default','added',2048,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-08 18:12:53','2025-08-08 18:12:53'),
(3016,'default','added',2049,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":130}}',NULL,'2025-08-08 18:14:29','2025-08-08 18:14:29'),
(3017,'default','added',2050,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-08 18:14:49','2025-08-08 18:14:49'),
(3018,'default','added',2051,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":18}}',NULL,'2025-08-08 18:15:45','2025-08-08 18:15:45'),
(3019,'default','added',2052,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":31}}',NULL,'2025-08-08 18:16:33','2025-08-08 18:16:33'),
(3020,'default','logout',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-08 18:22:54','2025-08-08 18:22:54'),
(3021,'default','login',29,'App\\User',NULL,13,29,'App\\User','[]',NULL,'2025-08-08 18:23:00','2025-08-08 18:23:00'),
(3022,'default','added',2053,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2025-08-08 18:26:08','2025-08-08 18:26:08'),
(3023,'default','added',2054,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-08 18:29:34','2025-08-08 18:29:34'),
(3024,'default','added',2055,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45}}',NULL,'2025-08-08 18:33:11','2025-08-08 18:33:11'),
(3025,'default','added',2056,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-08 18:34:15','2025-08-08 18:34:15'),
(3026,'default','added',2057,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-08 18:34:58','2025-08-08 18:34:58'),
(3027,'default','added',2058,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":59}}',NULL,'2025-08-08 18:36:27','2025-08-08 18:36:27'),
(3028,'default','added',2059,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-08 18:38:22','2025-08-08 18:38:22'),
(3029,'default','added',2060,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-08 18:39:02','2025-08-08 18:39:02'),
(3030,'default','added',2061,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-08 18:39:45','2025-08-08 18:39:45'),
(3031,'default','added',2062,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-08 18:44:08','2025-08-08 18:44:08'),
(3032,'default','added',2063,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-08 18:44:57','2025-08-08 18:44:57'),
(3033,'default','added',2064,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-08 18:47:38','2025-08-08 18:47:38'),
(3034,'default','added',2065,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-08 18:50:18','2025-08-08 18:50:18'),
(3035,'default','added',2066,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-08 18:51:06','2025-08-08 18:51:06'),
(3036,'default','added',2067,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":47}}',NULL,'2025-08-08 18:52:10','2025-08-08 18:52:10'),
(3037,'default','added',2068,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-08 18:52:58','2025-08-08 18:52:58'),
(3038,'default','added',2069,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-08 18:53:57','2025-08-08 18:53:57'),
(3039,'default','added',2070,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-08 18:54:27','2025-08-08 18:54:27'),
(3040,'default','added',2071,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-08 18:55:14','2025-08-08 18:55:14'),
(3041,'default','added',2072,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2025-08-08 18:56:54','2025-08-08 18:56:54'),
(3042,'default','added',2073,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36}}',NULL,'2025-08-08 18:58:24','2025-08-08 18:58:24'),
(3043,'default','added',2074,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-08 19:00:07','2025-08-08 19:00:07'),
(3044,'default','added',2075,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-08 19:00:49','2025-08-08 19:00:49'),
(3045,'default','added',2076,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-08 19:01:58','2025-08-08 19:01:58'),
(3046,'default','added',2077,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-08 19:04:37','2025-08-08 19:04:37'),
(3047,'default','added',2078,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29}}',NULL,'2025-08-08 19:05:18','2025-08-08 19:05:18'),
(3048,'default','added',2079,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26}}',NULL,'2025-08-08 19:05:53','2025-08-08 19:05:53'),
(3049,'default','added',2080,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-08 19:07:44','2025-08-08 19:07:44'),
(3050,'default','added',2081,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":210}}',NULL,'2025-08-08 19:15:20','2025-08-08 19:15:20'),
(3051,'default','added',2082,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":20}}',NULL,'2025-08-08 19:18:31','2025-08-08 19:18:31'),
(3052,'default','added',2083,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":41}}',NULL,'2025-08-08 19:19:22','2025-08-08 19:19:22'),
(3053,'default','added',2084,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22}}',NULL,'2025-08-08 19:20:57','2025-08-08 19:20:57'),
(3054,'default','added',2085,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":27}}',NULL,'2025-08-08 19:22:16','2025-08-08 19:22:16'),
(3055,'default','added',2086,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":42}}',NULL,'2025-08-08 19:23:44','2025-08-08 19:23:44'),
(3056,'default','added',2087,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":26}}',NULL,'2025-08-08 19:26:50','2025-08-08 19:26:50'),
(3057,'default','added',2088,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-08 19:27:29','2025-08-08 19:27:29'),
(3058,'default','added',2089,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":73}}',NULL,'2025-08-08 19:34:24','2025-08-08 19:34:24'),
(3059,'default','added',2090,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":44}}',NULL,'2025-08-08 19:36:50','2025-08-08 19:36:50'),
(3060,'default','added',2091,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-08 19:37:21','2025-08-08 19:37:21'),
(3061,'default','added',2092,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28}}',NULL,'2025-08-08 19:38:02','2025-08-08 19:38:02'),
(3062,'default','added',2093,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-08 19:38:59','2025-08-08 19:38:59'),
(3063,'default','added',2094,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23}}',NULL,'2025-08-08 19:43:09','2025-08-08 19:43:09'),
(3064,'default','added',2095,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33}}',NULL,'2025-08-08 19:44:03','2025-08-08 19:44:03'),
(3065,'default','added',2096,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25.82}}',NULL,'2025-08-08 19:49:26','2025-08-08 19:49:26'),
(3066,'default','added',2097,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":63.53}}',NULL,'2025-08-08 19:50:01','2025-08-08 19:50:01'),
(3067,'default','added',2098,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-08 19:50:04','2025-08-08 19:50:04'),
(3068,'default','added',2099,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":51}}',NULL,'2025-08-08 19:51:39','2025-08-08 19:51:39'),
(3069,'default','added',2100,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":35}}',NULL,'2025-08-08 19:52:36','2025-08-08 19:52:36'),
(3070,'default','added',2101,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-08 19:53:27','2025-08-08 19:53:27'),
(3071,'default','added',2102,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36}}',NULL,'2025-08-08 19:54:24','2025-08-08 19:54:24'),
(3072,'default','added',2103,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25.82}}',NULL,'2025-08-08 19:55:00','2025-08-08 19:55:00'),
(3073,'default','added',2104,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-08 19:57:05','2025-08-08 19:57:05'),
(3074,'default','added',2105,'App\\Transaction',NULL,16,34,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36}}',NULL,'2025-08-08 19:58:07','2025-08-08 19:58:07'),
(3075,'default','sell_deleted',2105,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":2105,\"invoice_no\":\"0844\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"36.0000\"}}',NULL,'2025-08-08 19:59:12','2025-08-08 19:59:12'),
(3076,'default','added',2106,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":35}}',NULL,'2025-08-08 19:59:17','2025-08-08 19:59:17'),
(3077,'default','sell_deleted',2102,'App\\Transaction',NULL,16,34,'App\\User','{\"id\":2102,\"invoice_no\":\"0842\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"36.0000\"}}',NULL,'2025-08-08 19:59:32','2025-08-08 19:59:32'),
(3078,'default','added',2107,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-08 20:03:52','2025-08-08 20:03:52'),
(3079,'default','added',2108,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-08 20:04:33','2025-08-08 20:04:33'),
(3080,'default','added',2109,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-08 20:05:31','2025-08-08 20:05:31'),
(3081,'default','added',2110,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":85}}',NULL,'2025-08-08 20:06:44','2025-08-08 20:06:44'),
(3082,'default','added',2111,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32}}',NULL,'2025-08-08 20:08:04','2025-08-08 20:08:04'),
(3083,'default','added',2112,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-08 20:09:01','2025-08-08 20:09:01'),
(3084,'default','added',2113,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-08 20:10:25','2025-08-08 20:10:25'),
(3085,'default','added',2114,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-08 20:11:14','2025-08-08 20:11:14'),
(3086,'default','added',2115,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-08 20:14:00','2025-08-08 20:14:00'),
(3087,'default','added',2116,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-08 20:14:50','2025-08-08 20:14:50'),
(3088,'default','added',2117,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-08 20:15:43','2025-08-08 20:15:43'),
(3089,'default','added',2118,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":34}}',NULL,'2025-08-08 20:16:40','2025-08-08 20:16:40'),
(3090,'default','added',2119,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39}}',NULL,'2025-08-08 20:17:06','2025-08-08 20:17:06'),
(3091,'default','added',2120,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-08 20:18:11','2025-08-08 20:18:11'),
(3092,'default','added',2121,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-08 20:18:56','2025-08-08 20:18:56'),
(3093,'default','added',2122,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":38}}',NULL,'2025-08-08 20:26:20','2025-08-08 20:26:20'),
(3094,'default','added',2123,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":105}}',NULL,'2025-08-08 20:34:51','2025-08-08 20:34:51'),
(3095,'default','added',2124,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-08 20:35:40','2025-08-08 20:35:40'),
(3096,'default','added',2125,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-08 20:36:06','2025-08-08 20:36:06'),
(3097,'default','added',2126,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45}}',NULL,'2025-08-08 20:37:14','2025-08-08 20:37:14'),
(3098,'default','added',2127,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-08 20:41:48','2025-08-08 20:41:48'),
(3099,'default','added',2128,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-08 20:42:36','2025-08-08 20:42:36'),
(3100,'default','added',2129,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-08 20:45:18','2025-08-08 20:45:18'),
(3101,'default','added',2130,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-08 20:46:17','2025-08-08 20:46:17'),
(3102,'default','added',2131,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-08 20:48:48','2025-08-08 20:48:48'),
(3103,'default','added',2132,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-08 20:52:19','2025-08-08 20:52:19'),
(3104,'default','added',2133,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17}}',NULL,'2025-08-08 20:53:35','2025-08-08 20:53:35'),
(3105,'default','added',2134,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":34}}',NULL,'2025-08-08 20:54:27','2025-08-08 20:54:27'),
(3106,'default','added',2135,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":185}}',NULL,'2025-08-08 20:58:51','2025-08-08 20:58:51'),
(3107,'default','added',2136,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45}}',NULL,'2025-08-08 20:59:51','2025-08-08 20:59:51'),
(3108,'default','added',2137,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-08 21:01:10','2025-08-08 21:01:10'),
(3109,'default','added',2138,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2025-08-08 21:02:15','2025-08-08 21:02:15'),
(3110,'default','added',2139,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-08 21:11:13','2025-08-08 21:11:13'),
(3111,'default','added',2140,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-08-08 21:18:57','2025-08-08 21:18:57'),
(3112,'default','added',2141,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-08 21:21:00','2025-08-08 21:21:00'),
(3113,'default','added',2142,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-08 21:22:06','2025-08-08 21:22:06'),
(3114,'default','added',2143,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-08 21:23:37','2025-08-08 21:23:37'),
(3115,'default','added',2144,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":41}}',NULL,'2025-08-08 21:26:28','2025-08-08 21:26:28'),
(3116,'default','added',2145,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-08 21:27:08','2025-08-08 21:27:08'),
(3117,'default','added',2146,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-08 21:27:57','2025-08-08 21:27:57'),
(3118,'default','added',2147,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-08 21:28:56','2025-08-08 21:28:56'),
(3119,'default','added',2148,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21}}',NULL,'2025-08-08 21:31:11','2025-08-08 21:31:11'),
(3120,'default','added',2149,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-08 21:33:31','2025-08-08 21:33:31'),
(3121,'default','added',2150,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":27}}',NULL,'2025-08-08 21:40:19','2025-08-08 21:40:19'),
(3122,'default','added',2151,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2025-08-08 21:42:25','2025-08-08 21:42:25'),
(3123,'default','added',2152,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-08 21:45:42','2025-08-08 21:45:42'),
(3124,'default','added',2153,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-08 21:46:17','2025-08-08 21:46:17'),
(3125,'default','added',2154,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-08 21:47:01','2025-08-08 21:47:01'),
(3126,'default','added',2155,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-08 21:48:42','2025-08-08 21:48:42'),
(3127,'default','added',2156,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2025-08-08 21:50:08','2025-08-08 21:50:08'),
(3128,'default','added',2157,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-08 21:50:41','2025-08-08 21:50:41'),
(3129,'default','added',2158,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-08 21:54:22','2025-08-08 21:54:22'),
(3130,'default','added',2159,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-08 21:57:33','2025-08-08 21:57:33'),
(3131,'default','added',2160,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-08 21:58:27','2025-08-08 21:58:27'),
(3132,'default','added',2161,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-08 22:01:03','2025-08-08 22:01:03'),
(3133,'default','added',2162,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-08 22:01:50','2025-08-08 22:01:50'),
(3134,'default','added',2163,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2}}',NULL,'2025-08-08 22:02:22','2025-08-08 22:02:22'),
(3135,'default','added',2164,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":28}}',NULL,'2025-08-08 22:03:50','2025-08-08 22:03:50'),
(3136,'default','added',2165,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-08 22:04:24','2025-08-08 22:04:24'),
(3137,'default','added',2166,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-08 22:07:08','2025-08-08 22:07:08'),
(3138,'default','added',2167,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-08 22:07:34','2025-08-08 22:07:34'),
(3139,'default','added',2168,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-08 22:14:27','2025-08-08 22:14:27'),
(3140,'default','added',2169,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-08 22:17:42','2025-08-08 22:17:42'),
(3141,'default','added',2170,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-08 22:18:07','2025-08-08 22:18:07'),
(3142,'default','added',2171,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-08 22:27:19','2025-08-08 22:27:19'),
(3143,'default','added',2172,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":74}}',NULL,'2025-08-08 22:30:53','2025-08-08 22:30:53'),
(3144,'default','added',2173,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-08 22:32:19','2025-08-08 22:32:19'),
(3145,'default','added',2174,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-08 22:37:36','2025-08-08 22:37:36'),
(3146,'default','added',2175,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":20}}',NULL,'2025-08-08 22:43:02','2025-08-08 22:43:02'),
(3147,'default','added',2176,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":26}}',NULL,'2025-08-08 22:43:39','2025-08-08 22:43:39'),
(3148,'default','added',2177,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-08 22:47:46','2025-08-08 22:47:46'),
(3149,'default','added',2178,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-08 22:56:01','2025-08-08 22:56:01'),
(3150,'default','added',2179,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-08 22:58:43','2025-08-08 22:58:43'),
(3151,'default','logout',46,'App\\User',NULL,16,46,'App\\User','[]',NULL,'2025-08-08 23:07:06','2025-08-08 23:07:06'),
(3152,'default','login',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-09 02:32:52','2025-08-09 02:32:52'),
(3153,'default','login',46,'App\\User',NULL,16,46,'App\\User','[]',NULL,'2025-08-09 04:26:26','2025-08-09 04:26:26'),
(3154,'default','added',2180,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-09 04:28:33','2025-08-09 04:28:33'),
(3155,'default','added',2181,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4}}',NULL,'2025-08-09 05:05:15','2025-08-09 05:05:15'),
(3156,'default','added',2182,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-09 05:49:40','2025-08-09 05:49:40'),
(3157,'default','added',2183,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-09 06:02:41','2025-08-09 06:02:41'),
(3158,'default','added',2184,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-09 06:07:17','2025-08-09 06:07:17'),
(3159,'default','added',2185,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2}}',NULL,'2025-08-09 06:49:09','2025-08-09 06:49:09'),
(3160,'default','added',2186,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7}}',NULL,'2025-08-09 06:55:14','2025-08-09 06:55:14'),
(3161,'default','added',2187,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-09 06:58:00','2025-08-09 06:58:00'),
(3162,'default','added',2188,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-09 07:13:23','2025-08-09 07:13:23'),
(3163,'default','added',2189,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-09 07:26:15','2025-08-09 07:26:15'),
(3164,'default','added',2190,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7}}',NULL,'2025-08-09 07:40:17','2025-08-09 07:40:17'),
(3165,'default','added',2191,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-09 08:03:50','2025-08-09 08:03:50'),
(3166,'default','added',2192,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-09 08:14:22','2025-08-09 08:14:22'),
(3167,'default','added',2193,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-09 08:33:20','2025-08-09 08:33:20'),
(3168,'default','login',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-09 08:44:42','2025-08-09 08:44:42'),
(3169,'default','added',2194,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5}}',NULL,'2025-08-09 09:08:09','2025-08-09 09:08:09'),
(3170,'default','login',34,'App\\User',NULL,16,34,'App\\User','[]',NULL,'2025-08-09 09:08:24','2025-08-09 09:08:24'),
(3171,'default','added',2195,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-09 09:09:54','2025-08-09 09:09:54'),
(3172,'default','added',2196,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-09 09:12:49','2025-08-09 09:12:49'),
(3173,'default','added',2197,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-09 09:14:22','2025-08-09 09:14:22'),
(3174,'default','added',2198,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-09 09:16:41','2025-08-09 09:16:41'),
(3175,'default','added',2199,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":15}}',NULL,'2025-08-09 09:52:03','2025-08-09 09:52:03'),
(3176,'default','login',48,'App\\User',NULL,16,48,'App\\User','[]',NULL,'2025-08-09 09:58:25','2025-08-09 09:58:25'),
(3177,'default','added',2200,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2025-08-09 10:15:00','2025-08-09 10:15:00'),
(3178,'default','added',2201,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-09 10:18:33','2025-08-09 10:18:33'),
(3179,'default','added',2202,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-09 10:30:06','2025-08-09 10:30:06'),
(3180,'default','added',2203,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-09 10:31:00','2025-08-09 10:31:00'),
(3181,'default','added',2204,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-09 10:31:21','2025-08-09 10:31:21'),
(3182,'default','added',2205,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-09 10:33:02','2025-08-09 10:33:02'),
(3183,'default','added',2206,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2}}',NULL,'2025-08-09 10:38:02','2025-08-09 10:38:02'),
(3184,'default','added',2207,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-09 10:41:08','2025-08-09 10:41:08'),
(3185,'default','added',2208,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4}}',NULL,'2025-08-09 10:42:30','2025-08-09 10:42:30'),
(3186,'default','added',2209,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-09 10:44:13','2025-08-09 10:44:13'),
(3187,'default','added',2210,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-09 10:48:42','2025-08-09 10:48:42'),
(3188,'default','added',2211,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33}}',NULL,'2025-08-09 11:02:20','2025-08-09 11:02:20'),
(3189,'default','added',2212,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":25}}',NULL,'2025-08-09 11:07:51','2025-08-09 11:07:51'),
(3190,'default','added',2213,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-09 11:09:23','2025-08-09 11:09:23'),
(3191,'default','added',2214,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-09 11:09:54','2025-08-09 11:09:54'),
(3192,'default','added',2215,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39}}',NULL,'2025-08-09 11:11:25','2025-08-09 11:11:25'),
(3193,'default','added',2216,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6}}',NULL,'2025-08-09 11:12:13','2025-08-09 11:12:13'),
(3194,'default','added',2217,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":26}}',NULL,'2025-08-09 11:14:54','2025-08-09 11:14:54'),
(3195,'default','added',2218,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9}}',NULL,'2025-08-09 11:20:51','2025-08-09 11:20:51'),
(3196,'default','added',2219,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-09 11:43:28','2025-08-09 11:43:28'),
(3197,'default','added',2220,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2025-08-09 12:04:06','2025-08-09 12:04:06'),
(3198,'default','added',2221,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33}}',NULL,'2025-08-09 12:20:04','2025-08-09 12:20:04'),
(3199,'default','added',2222,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-09 12:32:35','2025-08-09 12:32:35'),
(3200,'default','added',2223,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17}}',NULL,'2025-08-09 12:38:23','2025-08-09 12:38:23'),
(3201,'default','added',2224,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-09 12:40:57','2025-08-09 12:40:57'),
(3202,'default','added',2225,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-09 12:49:52','2025-08-09 12:49:52'),
(3203,'default','added',2226,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-09 13:01:53','2025-08-09 13:01:53'),
(3204,'default','added',2227,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-09 13:17:31','2025-08-09 13:17:31'),
(3205,'default','added',2228,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-09 13:25:45','2025-08-09 13:25:45'),
(3206,'default','added',2229,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":35}}',NULL,'2025-08-09 13:29:29','2025-08-09 13:29:29'),
(3207,'default','login',45,'App\\User',NULL,16,45,'App\\User','[]',NULL,'2025-08-09 13:29:42','2025-08-09 13:29:42'),
(3208,'default','added',2230,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-09 13:31:17','2025-08-09 13:31:17'),
(3209,'default','added',2231,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22}}',NULL,'2025-08-09 13:34:41','2025-08-09 13:34:41'),
(3210,'default','added',2232,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-09 13:40:18','2025-08-09 13:40:18'),
(3211,'default','added',2233,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-08-09 13:47:33','2025-08-09 13:47:33'),
(3212,'default','added',2234,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-09 13:54:28','2025-08-09 13:54:28'),
(3213,'default','added',2235,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7}}',NULL,'2025-08-09 13:55:27','2025-08-09 13:55:27'),
(3214,'default','added',2236,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-09 13:57:10','2025-08-09 13:57:10'),
(3215,'default','added',2237,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-08-09 14:01:28','2025-08-09 14:01:28'),
(3216,'default','added',2238,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-09 14:03:13','2025-08-09 14:03:13'),
(3217,'default','added',2239,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11}}',NULL,'2025-08-09 14:08:09','2025-08-09 14:08:09'),
(3218,'default','added',2240,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2025-08-09 12:08:30','2025-08-09 12:08:30'),
(3219,'default','added',2241,'App\\Transaction',NULL,13,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25.82}}',NULL,'2025-08-09 14:11:51','2025-08-09 14:11:51'),
(3220,'default','added',2242,'App\\Transaction',NULL,16,46,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-09 14:12:58','2025-08-09 14:12:58'),
(3221,'default','logout',46,'App\\User',NULL,16,46,'App\\User','[]',NULL,'2025-08-09 14:16:00','2025-08-09 14:16:00'),
(3222,'default','login',43,'App\\User',NULL,16,43,'App\\User','[]',NULL,'2025-08-09 14:16:10','2025-08-09 14:16:10'),
(3223,'default','logout',43,'App\\User',NULL,16,43,'App\\User','[]',NULL,'2025-08-09 14:16:10','2025-08-09 14:16:10'),
(3224,'default','login',43,'App\\User',NULL,16,43,'App\\User','[]',NULL,'2025-08-09 14:16:53','2025-08-09 14:16:53'),
(3225,'default','added',2243,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-09 14:25:12','2025-08-09 14:25:12'),
(3226,'default','added',2244,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-08-09 14:31:36','2025-08-09 14:31:36'),
(3227,'default','added',2245,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":48}}',NULL,'2025-08-09 14:48:28','2025-08-09 14:48:28'),
(3228,'default','added',2246,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16}}',NULL,'2025-08-09 14:48:44','2025-08-09 14:48:44'),
(3229,'default','added',2247,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2025-08-09 14:48:58','2025-08-09 14:48:58'),
(3230,'default','added',2248,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":54}}',NULL,'2025-08-09 14:59:18','2025-08-09 14:59:18'),
(3231,'default','added',2249,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2025-08-09 15:02:04','2025-08-09 15:02:04'),
(3232,'default','added',2250,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2025-08-09 15:15:08','2025-08-09 15:15:08'),
(3233,'default','added',2251,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2025-08-09 15:29:31','2025-08-09 15:29:31'),
(3234,'default','added',2252,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2025-08-09 15:31:13','2025-08-09 15:31:13'),
(3235,'default','added',2253,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28}}',NULL,'2025-08-09 15:31:45','2025-08-09 15:31:45'),
(3236,'default','added',2254,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-09 15:33:31','2025-08-09 15:33:31'),
(3237,'default','added',2255,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15}}',NULL,'2025-08-09 15:36:32','2025-08-09 15:36:32'),
(3238,'default','added',2256,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":25}}',NULL,'2025-08-09 15:39:16','2025-08-09 15:39:16'),
(3239,'default','added',2257,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}',NULL,'2025-08-09 15:40:57','2025-08-09 15:40:57'),
(3240,'default','added',2258,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":35}}',NULL,'2025-08-09 15:44:19','2025-08-09 15:44:19'),
(3241,'default','added',2259,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7}}',NULL,'2025-08-09 15:45:23','2025-08-09 15:45:23'),
(3242,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-08-09 14:03:45','2025-08-09 14:03:45'),
(3243,'default','added',2260,'App\\Transaction',NULL,16,43,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17}}',NULL,'2025-08-09 16:06:08','2025-08-09 16:06:08');
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `width` double(22,4) DEFAULT NULL,
  `height` double(22,4) DEFAULT NULL,
  `paper_width` double(22,4) DEFAULT NULL,
  `paper_height` double(22,4) DEFAULT NULL,
  `top_margin` double(22,4) DEFAULT NULL,
  `left_margin` double(22,4) DEFAULT NULL,
  `row_distance` double(22,4) DEFAULT NULL,
  `col_distance` double(22,4) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_continuous` tinyint(1) NOT NULL DEFAULT 0,
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES
(1,'20 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 4\" x 1\", Labels per sheet: 20',4.0000,1.0000,8.5000,11.0000,0.5000,0.1250,0.0000,0.1875,2,0,0,20,NULL,'2017-12-18 12:13:44','2017-12-18 12:13:44'),
(2,'30 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2.625\" x 1\", Labels per sheet: 30',2.6250,1.0000,8.5000,11.0000,0.5000,0.1880,0.0000,0.1250,3,0,0,30,NULL,'2017-12-18 12:04:39','2017-12-18 12:10:40'),
(3,'32 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1.25\", Labels per sheet: 32',2.0000,1.2500,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,32,NULL,'2017-12-18 11:55:40','2017-12-18 11:55:40'),
(4,'40 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1\", Labels per sheet: 40',2.0000,1.0000,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,40,NULL,'2017-12-18 11:58:40','2017-12-18 11:58:40'),
(5,'50 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 1.5\" x 1\", Labels per sheet: 50',1.5000,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.0000,5,0,0,50,NULL,'2017-12-18 11:51:10','2017-12-18 11:51:10'),
(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm, Gap: 3.18mm',1.2500,1.0000,1.2500,0.0000,0.1250,0.0000,0.1250,0.0000,1,0,1,NULL,NULL,'2017-12-18 11:51:10','2017-12-18 11:51:10');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` varchar(191) NOT NULL,
  `booking_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  KEY `bookings_table_id_index` (`table_id`),
  KEY `bookings_waiter_id_index` (`waiter_id`),
  KEY `bookings_location_id_index` (`location_id`),
  KEY `bookings_booking_status_index` (`booking_status`),
  KEY `bookings_correspondent_id_index` (`correspondent_id`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
INSERT INTO `bookings` VALUES
(1,7,NULL,NULL,4,4,4,'2024-08-25 11:00:00','2024-08-25 11:00:00',4,'waiting',NULL,'2024-08-25 14:54:12','2024-08-25 14:57:43'),
(2,7,6,1,4,4,4,'2024-08-26 15:47:00','2024-08-27 15:48:00',4,'booked',NULL,'2024-08-26 20:48:07','2024-08-26 20:48:07'),
(3,13,12,4,12,8,8,'2024-11-03 11:30:00','2024-11-03 12:30:00',11,'booked','Need QuicK','2024-11-03 17:30:43','2024-11-03 17:31:55'),
(4,13,12,5,12,8,8,'2024-11-03 13:34:00','2024-11-03 15:34:00',11,'booked',NULL,'2024-11-03 17:35:15','2024-11-03 17:35:15');
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES
(1,7,'test brand',NULL,9,NULL,'2024-10-02 04:41:36','2024-10-02 04:41:36'),
(2,2,'MOST-ENA',NULL,2,NULL,'2024-10-06 21:53:22','2024-10-06 21:53:22'),
(15,2,'MST-ENA',NULL,2,NULL,'2024-10-08 17:33:40','2024-10-08 17:33:40'),
(56,8,'A','HIGH QUALITY',35,NULL,'2025-07-26 11:45:49','2025-07-26 11:45:49'),
(57,8,'PAPER H Q','HIGH QUALITY',35,NULL,'2025-07-26 12:13:30','2025-07-26 12:13:30');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) DEFAULT NULL,
  `tax_label_1` varchar(10) DEFAULT NULL,
  `tax_number_2` varchar(100) DEFAULT NULL,
  `tax_label_2` varchar(10) DEFAULT NULL,
  `code_label_1` varchar(191) DEFAULT NULL,
  `code_1` varchar(191) DEFAULT NULL,
  `code_label_2` varchar(191) DEFAULT NULL,
  `code_2` varchar(191) DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT 0.00,
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT 1,
  `accounting_method` enum('fifo','lifo','avco') NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(5,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') NOT NULL DEFAULT 'includes',
  `logo` varchar(191) DEFAULT NULL,
  `sku_prefix` varchar(191) DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `expiry_type` enum('add_expiry','add_manufacturing') NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT 1,
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT 1.000,
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT 30,
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT 30,
  `keyboard_shortcuts` text DEFAULT NULL,
  `pos_settings` text DEFAULT NULL,
  `manufacturing_settings` text DEFAULT NULL,
  `woocommerce_api_settings` text DEFAULT NULL,
  `woocommerce_skipped_orders` text DEFAULT NULL,
  `woocommerce_wh_oc_secret` varchar(191) DEFAULT NULL,
  `woocommerce_wh_ou_secret` varchar(191) DEFAULT NULL,
  `woocommerce_wh_od_secret` varchar(191) DEFAULT NULL,
  `woocommerce_wh_or_secret` varchar(191) DEFAULT NULL,
  `essentials_settings` longtext DEFAULT NULL,
  `weighing_scale_setting` text NOT NULL COMMENT 'used to store the configuration of weighing scale',
  `enable_brand` tinyint(1) NOT NULL DEFAULT 1,
  `enable_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT 1,
  `enable_purchase_status` tinyint(1) DEFAULT 1,
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT 0,
  `default_unit` int(11) DEFAULT NULL,
  `enable_sub_units` tinyint(1) NOT NULL DEFAULT 0,
  `enable_racks` tinyint(1) NOT NULL DEFAULT 0,
  `enable_row` tinyint(1) NOT NULL DEFAULT 0,
  `enable_position` tinyint(1) NOT NULL DEFAULT 0,
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT 1,
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT 1,
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT 1,
  `currency_symbol_placement` enum('before','after') NOT NULL DEFAULT 'before',
  `enabled_modules` text DEFAULT NULL,
  `date_format` varchar(191) NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') NOT NULL DEFAULT '24',
  `currency_precision` tinyint(4) NOT NULL DEFAULT 2,
  `quantity_precision` tinyint(4) NOT NULL DEFAULT 2,
  `ref_no_prefixes` text DEFAULT NULL,
  `theme_color` char(20) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `accounting_settings` text DEFAULT NULL,
  `enable_rp` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `rp_name` varchar(191) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `amount_for_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `max_rp_per_order` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `redeem_amount_per_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_redeem` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `max_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_period` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_type` enum('month','year') NOT NULL DEFAULT 'year' COMMENT 'rp is the short form of reward points',
  `email_settings` text DEFAULT NULL,
  `sms_settings` text DEFAULT NULL,
  `custom_labels` text DEFAULT NULL,
  `common_settings` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES
(1,'OdoMee ERP',37,'2024-08-01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,1,'Europe/London',1,'fifo',0.00,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\",\"account\",\"tables\",\"modifiers\",\"service_staff\",\"booking\",\"kitchen\",\"subscription\",\"types_of_service\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_requisition\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}','primary',NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"use_superadmin_settings\":\"1\",\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":\"OdoMee ERP\"}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null,\"custom_field_11\":null,\"custom_field_12\":null,\"custom_field_13\":null,\"custom_field_14\":null,\"custom_field_15\":null,\"custom_field_16\":null,\"custom_field_17\":null,\"custom_field_18\":null,\"custom_field_19\":null,\"custom_field_20\":null},\"product_cf_details\":{\"1\":{\"type\":null,\"dropdown_options\":null},\"2\":{\"type\":null,\"dropdown_options\":null},\"3\":{\"type\":null,\"dropdown_options\":null},\"4\":{\"type\":null,\"dropdown_options\":null},\"5\":{\"type\":null,\"dropdown_options\":null},\"6\":{\"type\":null,\"dropdown_options\":null},\"7\":{\"type\":null,\"dropdown_options\":null},\"8\":{\"type\":null,\"dropdown_options\":null},\"9\":{\"type\":null,\"dropdown_options\":null},\"10\":{\"type\":null,\"dropdown_options\":null},\"11\":{\"type\":null,\"dropdown_options\":null},\"12\":{\"type\":null,\"dropdown_options\":null},\"13\":{\"type\":null,\"dropdown_options\":null},\"14\":{\"type\":null,\"dropdown_options\":null},\"15\":{\"type\":null,\"dropdown_options\":null},\"16\":{\"type\":null,\"dropdown_options\":null},\"17\":{\"type\":null,\"dropdown_options\":null},\"18\":{\"type\":null,\"dropdown_options\":null},\"19\":{\"type\":null,\"dropdown_options\":null},\"20\":{\"type\":null,\"dropdown_options\":null}},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"default_credit_limit\":null,\"default_datatable_page_entries\":\"25\"}',1,'2024-08-23 20:45:18','2025-06-24 22:10:06'),
(2,'Mostwda3',35,'2024-08-01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,2,'Africa/Cairo',8,'fifo',0.00,'includes','1734803208_mostwda32.png',NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\",\"account\"]','m/d/Y','12',2,2,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_requisition\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}',NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":\"PO No.\",\"custom_field_2\":\"CODE\",\"custom_field_3\":\"MAN-\",\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null,\"custom_field_11\":null,\"custom_field_12\":null,\"custom_field_13\":null,\"custom_field_14\":null,\"custom_field_15\":null,\"custom_field_16\":null,\"custom_field_17\":null,\"custom_field_18\":null,\"custom_field_19\":null,\"custom_field_20\":null},\"product_cf_details\":{\"1\":{\"type\":\"text\",\"dropdown_options\":null},\"2\":{\"type\":\"text\",\"dropdown_options\":null},\"3\":{\"type\":\"text\",\"dropdown_options\":null},\"4\":{\"type\":null,\"dropdown_options\":null},\"5\":{\"type\":null,\"dropdown_options\":null},\"6\":{\"type\":null,\"dropdown_options\":null},\"7\":{\"type\":null,\"dropdown_options\":null},\"8\":{\"type\":null,\"dropdown_options\":null},\"9\":{\"type\":null,\"dropdown_options\":null},\"10\":{\"type\":null,\"dropdown_options\":null},\"11\":{\"type\":null,\"dropdown_options\":null},\"12\":{\"type\":null,\"dropdown_options\":null},\"13\":{\"type\":null,\"dropdown_options\":null},\"14\":{\"type\":null,\"dropdown_options\":null},\"15\":{\"type\":null,\"dropdown_options\":null},\"16\":{\"type\":null,\"dropdown_options\":null},\"17\":{\"type\":null,\"dropdown_options\":null},\"18\":{\"type\":null,\"dropdown_options\":null},\"19\":{\"type\":null,\"dropdown_options\":null},\"20\":{\"type\":null,\"dropdown_options\":null}},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":\"PO No.\",\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":\"Purchase Order No.\",\"custom_field_2\":\"Expected Delivery\",\"custom_field_3\":\"Order SKUs\",\"is_custom_field_3_required\":\"1\",\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"default_credit_limit\":null,\"default_datatable_page_entries\":\"25\"}',1,'2024-08-23 22:12:54','2025-07-03 12:36:34'),
(3,'DirectLine Limited For Trading and Services',97,'2024-08-01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,3,'Asia/Qatar',1,'fifo',NULL,'includes','1724487637_DirectLine-Logo.webp',NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,1,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2024-08-24 18:50:37','2024-08-24 18:50:37'),
(4,'Cafe100',97,'1970-01-01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,4,'Africa/Cairo',1,'fifo',0.00,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"enable_transaction_date\":\"1\",\"inline_service_staff\":\"1\",\"show_invoice_layout\":\"1\",\"show_pricing_on_product_sugesstion\":\"1\",\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\",\"account\",\"tables\",\"service_staff\",\"booking\",\"kitchen\",\"types_of_service\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_requisition\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}',NULL,1,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":\"Number of Hours\",\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null,\"custom_field_11\":null,\"custom_field_12\":null,\"custom_field_13\":null,\"custom_field_14\":null,\"custom_field_15\":null,\"custom_field_16\":null,\"custom_field_17\":null,\"custom_field_18\":null,\"custom_field_19\":null,\"custom_field_20\":null},\"product_cf_details\":{\"1\":{\"type\":\"text\",\"dropdown_options\":null},\"2\":{\"type\":null,\"dropdown_options\":null},\"3\":{\"type\":null,\"dropdown_options\":null},\"4\":{\"type\":null,\"dropdown_options\":null},\"5\":{\"type\":null,\"dropdown_options\":null},\"6\":{\"type\":null,\"dropdown_options\":null},\"7\":{\"type\":null,\"dropdown_options\":null},\"8\":{\"type\":null,\"dropdown_options\":null},\"9\":{\"type\":null,\"dropdown_options\":null},\"10\":{\"type\":null,\"dropdown_options\":null},\"11\":{\"type\":null,\"dropdown_options\":null},\"12\":{\"type\":null,\"dropdown_options\":null},\"13\":{\"type\":null,\"dropdown_options\":null},\"14\":{\"type\":null,\"dropdown_options\":null},\"15\":{\"type\":null,\"dropdown_options\":null},\"16\":{\"type\":null,\"dropdown_options\":null},\"17\":{\"type\":null,\"dropdown_options\":null},\"18\":{\"type\":null,\"dropdown_options\":null},\"19\":{\"type\":null,\"dropdown_options\":null},\"20\":{\"type\":null,\"dropdown_options\":null}},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"default_credit_limit\":null,\"default_datatable_page_entries\":\"25\"}',1,'2024-08-25 15:20:05','2024-10-28 11:15:20'),
(7,'Decor Center',35,'1970-01-01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,9,'Africa/Cairo',1,'fifo',0.00,'includes','1727814150_logo-14.webp',NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,'{\"woocommerce_app_url\":\"https:\\/\\/decorecentre.com\",\"woocommerce_consumer_key\":\"ck_afb48721a39a7284ac9d72afc908b72a3fec26ec\",\"woocommerce_consumer_secret\":\"cs_e167217b3912c901190e8c8705003cb728551d64\",\"location_id\":\"7\",\"enable_auto_sync\":\"1\",\"default_tax_class\":null,\"product_tax_type